<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module Text shortcode.
 */
function ux_cb_module_text_shortcode($atts, $content=false) {
	$moduleID = 'text';
	
	$atts = shortcode_atts( array(
		'unique' => false,
		'col' => '12',
		'width' => '12/12',
		'style' => ''
	), $atts, 'ux_cb_text' );
	
	$html = ux_cb_get_module_template($moduleID, $atts, $content);
	return $html;
}
add_shortcode('ux_cb_text', 'ux_cb_module_text_shortcode');

/**
 * UX Content Builder Module Text container.
 */
function ux_cb_module_text_container($module, $moduleUnique, $content=false) {
	$html = '';
	
	$post_id = ux_cb_get_the_module_post_id($moduleUnique);
	
	//background 
	$background = false;
	$bgColor = false;
	$bgImg = false;
	$background = get_post_meta($post_id, '__ux_cb_module_text_background', true);
	$bgColor = get_post_meta($post_id, '__ux_cb_module_text_bg_color', true);
	$bgImg = get_post_meta($post_id, '__ux_cb_module_text_bg_image', true);
	$thumbBlank = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';
	$bgVideoSrc = 'data-src';
	if ( ! $module['is_frontend'] ) {
		$bgVideoSrc = 'src';
	}
	
	//background color style
	$bgColorStyle = '';
	if($bgColor && $background =='background_color'){
		$bgColorStyle = 'background-color: ' .esc_attr($bgColor). ';';
	}

	//background image style
	$bgImgStyle = '';
	$bgImageSrc = '';
	$dataImgSrc = '';

	if ( $bgImg ) {
		$bgImageSrc = wp_get_attachment_image_src($bgImg, 'full');
		if ( $background == 'background_image' || $background == 'hosted_video') {
			$bgImgStyle = 'background-image:url('.esc_url($bgImageSrc[0]).');';
		}
	}
	
	$moduleClass = 'text_block ux-mod-nobg';
	if ( $background && $background != 'none'){
		$moduleClass = 'text_block withbg '.$background ;
	}

	//centered width
	$centeredWidth = false;
	$enable_centerWidthClass = false;
	if ( $centeredWidth = get_post_meta($post_id, '__ux_cb_module_text_center_width', true ) ) { 
		$enable_centerWidthClass = 'text_block_centered_enable_width';
	}
	
	//container height
	$containerHeightClass = false;
	if ( $containerHeight = get_post_meta($post_id, '__ux_cb_module_text_container_height', true ) ) {
		if ( $containerHeight == 'fullscreen-ux'){
			$containerHeightClass = ' fullscreen-wrap';
		}
	}
	
	//content
	if ( isset($_POST['action'] ) ) {
		if ( !$content && $_POST['action'] == 'ux_cb_ajax_save_module_fields'){
			$content = get_post_meta($post_id, '__ux_cb_module_content', true);
		}
	}

	//Background video 
	$background_mp4 = false;
	$background_mp4 = get_post_meta($post_id, '__ux_cb_module_embed_video_mp4', true);
	$background_ogg = false;
	$background_ogg = get_post_meta($post_id, '__ux_cb_module_embed_video_ogg', true);
	$background_webm = false;
	$background_webm = get_post_meta($post_id, '__ux_cb_module_embed_video_webm', true);
	
	//Color for Video
	$blendStyle = array();
	$blendClass = false;
	$blendWrapClass = false;
	
	//background image and video effect
	$imgVideoEffect = 'standard';
	$imgMaskClass = '';
	$imgMaskBgImageStyle = '';
	$blendWrapBefore = false; $blendWrapAfter = false;

	if ( $background == 'hosted_video' || $background == 'background_image' ) {
		
		if ( $background == 'hosted_video' ) {

			$imgVideoEffect = get_post_meta( $post_id, '__ux_cb_module_text_img_video_effect', true );

			if ( $imgVideoEffect != 'standard' ) {
				$blendWrapClass = 'background-blend';
				$blendStyle['mix-blend-mode'] = 'mix-blend-mode: screen;';
				$blendStyle['background-color'] = 'background-color: #ffffff;';
				$blendClass = 'enable-mask';
				if ( $imgVideoEffect == 'standard-to-mask' ) {
					$blendClass = 'disable-mask';
				}
				if($imgVideoEffect === 'standard-to-mask'){
					$blendStyle['background-color'] = '';
				}
			}

		} else {

			$imgVideoEffect = get_post_meta( $post_id, '__ux_cb_module_text_img_bgimage_effect', true );

			if ( $imgVideoEffect == 'mask' ) { 
				$imgMaskClass = 'bm-text-bgimg-mask';
				if ( $bgImg ) {
					//$dataImgSrc = 'data-imgurl='. esc_url( $bgImageSrc[0] );
					$imgMaskBgImageStyle = '--text-mask-background-image:url('.esc_url( $bgImageSrc[0] ).')';
					$blendStyle['background-image'] = '';
				}
			}

		}
		
		$blendWrapBefore = '<div class="'.sanitize_html_class($blendWrapClass).' ' .sanitize_html_class( $blendClass ). ' '.sanitize_html_class($imgMaskClass).'" style="' .sanitize_text_field( join( ' ', $blendStyle ) ). '">'; 
		$blendWrapAfter = '</div>';
		if($imgVideoEffect === 'standard'){
			$blendWrapBefore = false; $blendWrapAfter = false; $blendStyle = array(); $blendClass = false;
		}
	
	}

	//style
	if ( ! $module['is_frontend'] ) {
		$html .= '<style type="text/css">' .ux_cb_module_text_style( $post_id, $moduleUnique, $html ). '</style>';
	}

	//animation
	$animationClass = ux_cb_module_field_animation_class($module);
	$animationEnd = ux_cb_module_field_animation_end($module);
	
	$html .= '<div class="text_block_out ' .esc_attr($animationClass).'" data-animationend="' .esc_attr($animationEnd). '" data-effect="' .esc_attr( $imgVideoEffect ). '">';
	$html .= '<div class="' .esc_attr($moduleClass).esc_attr($containerHeightClass). '">';
	
	if ( $background == 'background_color' ) {
		$html .= '<div class="bm-background-color" style="background-color:'.esc_attr($bgColor).'"></div>';
	}
	if( ($background == 'background_image' && $imgVideoEffect != 'mask') || $background == 'hosted_video') {
		$html .= '<div class="bm-background-img" style="' .esc_attr( $bgImgStyle ). '"></div>';
	}
	if($background == 'hosted_video') {
		$html .= '<div class="background-video"><video class="lazy" loop autoplay muted playsinline poster="'.esc_attr($thumbBlank).'">';
		 
			if($background_mp4) {
				$html .= '<source '.esc_attr($bgVideoSrc).'="'.esc_url($background_mp4).'" type="video/mp4">';
			}
			if($background_ogg) {
				$html .= '<source '.esc_attr($bgVideoSrc).'="'.esc_url($background_ogg).'" type="video/ogg">';
			}
			if($background_webm) {
				$html .= '<source '.esc_attr($bgVideoSrc).'="'.esc_url($background_webm).'" type="video/webm">';
			}

			$html .= '</video></div>';

	}
	
	$html .= $blendWrapBefore;
	$html .= '<div class="text_block_inn">';
	$html .= '<div class="text_block_centered '.$enable_centerWidthClass.'" '.esc_attr($dataImgSrc).' style="'.esc_attr($imgMaskBgImageStyle). '">';
	
	if($module['is_frontend']){
		$html .= do_shortcode(convert_smilies(wptexturize($content)));
	}else{
		$html .= wpautop(convert_smilies(wptexturize($content)));
	}
	
	$html .= '</div>';
	$html .= '</div>';
	$html .= wp_kses_post($blendWrapAfter);
	
	
	$html .= '</div>';
	$html .= '</div>';
	
	return $html;
}
add_filter( 'ux_cb_module_container_text', 'ux_cb_module_text_container', 10, 3 );

/**
 * UX Content Builder Module Text frontend module class.
 */
function ux_cb_module_text_module_class( $moduleClass, $moduleID, $post_id ) {
	if ( $moduleID == 'text' ) {
		//text block container height
		if ( $containerHeight = get_post_meta( $post_id, '__ux_cb_module_text_container_height', true ) ) {
			if ( $containerHeight == 'fill-row-height' ) {
				//$moduleClass[] = 'bm-middle';
			}
		}
	}
	return $moduleClass;
}
add_filter( 'ux_cb_module_template_frontend_module_class', 'ux_cb_module_text_module_class', 10, 3 );

?>