<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module Embed shortcode.
 */
function ux_cb_module_embed_shortcode($atts, $content=false) {
	$moduleID = 'embed';
	
	$atts = shortcode_atts( array(
		'unique' => false,
		'col' => '12',
		'width' => '12/12',
		'style' => ''
	), $atts, 'ux_cb_embed' );
	
	$html = ux_cb_get_module_template($moduleID, $atts, $content);
	return $html;
}
add_shortcode('ux_cb_embed', 'ux_cb_module_embed_shortcode');

/**
 * UX Content Builder Module Embed container.
 */
function ux_cb_module_embed_container($module, $moduleUnique) {
	$html = '';
	
	$post_id = ux_cb_get_the_module_post_id($moduleUnique);

	//source
	$source = false;
	$source = get_post_meta($post_id, '__ux_cb_module_embed_source', true );


	//cover image
	$embedHasCoverImageClass = false;
	$embedCoverImage =  false;
	$embedCoverImage = get_post_meta( $post_id, '__ux_cb_module_embed_image', true );

	//If export data-src
	$dataSrcIf = false;
	if ( $embedCoverImage &&  ( $source === 'vimeo' || $source === 'youtube' ) ) {
		$dataSrcIf = true; 
	}

	//autoplay
	$autoplay = false;
	$autoplayTag = false;
	if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_embed_autoplay', true ) ) {
		if ( $source === 'vimeo' || $source === 'youtube' ) {
			$autoplay = true;
			$autoplayTag = true;
			$dataSrcIf = true;
		}
	} else {
		if ( $embedCoverImage &&  ( $source === 'vimeo' || $source === 'youtube' ) ) {
			
			$autoplayTag = true;
		}
	}

	//embed code
	$embedCode = false;

	switch ( $source ) {

		case 'youtube':
			$embed = get_post_meta( $post_id, '__ux_cb_module_embed_code_youtube', true );
		break;

		case 'vimeo':
			$embed = get_post_meta( $post_id, '__ux_cb_module_embed_code_vimeo', true );
		break;
		
		default:
			$embed = get_post_meta( $post_id, '__ux_cb_module_embed_code', true );
		break;
	}

	if ( $embed ) {
		if ( ! $module['is_frontend'] ) {
			$embedCode = ux_cb_embed_html( $embed, false, false );
		} else {
			$embedCode = ux_cb_embed_html( $embed, $dataSrcIf, $autoplayTag );
		}
	}
	
	//embed ratio
	$embedRatio = get_post_meta( $post_id, '__ux_cb_module_embed_ratio', true );
	if ( ! $embedRatio ) {
		$embedRatio = 'none';
	}
	
	//embed custom ratio
	$embedCustomRatioW = get_post_meta( $post_id, '__ux_cb_module_embed_custom_ratio_w', true );
	if ( !$embedCustomRatioW ) {
		$embedCustomRatioW = 0;
	}
	$embedCustomRatioH = get_post_meta( $post_id, '__ux_cb_module_embed_custom_ratio_h', true );
	if ( !$embedCustomRatioH ) {
		$embedCustomRatioH = 0;
	}
	
	//embed ratio class
	$embedRatioClass = false;
	if ( $embedRatio != 'none' ) {
		$embedRatioClass = 'embed-wrap-with-radio';
	}
	
	//cover image export
	$embedCoverImageAlt = get_the_title($module['postID']);
	$thumbBlank = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';
	if ( $embedCoverImage ) {
		if ( $embedCoverImage != ''){
			$embedCoverImagSrc = wp_get_attachment_image_src($embedCoverImage, 'full');
			$embedCoverImageUrl = $embedCoverImagSrc[0]; 
			$embedCoverImageSrc = $thumbBlank;
			if ( ! $module['is_frontend'] ) {
				$embedCoverImageSrc = esc_url( $embedCoverImageUrl );
			}
			$embedCoverImageAlt = get_the_title($embedCoverImage);
			$embedCoverImageSrcset = wp_get_attachment_image_srcset($embedCoverImage, 'full');
			$embedCoverImageSizes = wp_get_attachment_image_sizes($embedCoverImage, 'full');
			$embedCoverImage = '<div class="embed-video-cover"><img class="embed-video-cover-img lazy" src="'.esc_attr($embedCoverImageSrc).'" data-src="'.esc_url($embedCoverImageUrl).'" alt="'.esc_attr($embedCoverImageAlt).'" data-srcset="'.wp_kses_post($embedCoverImageSrcset).'" data-sizes="'.wp_kses_post($embedCoverImageSizes).'"><span class="fa fa-play video-play-btn"></span></div>';
			$embedHasCoverImageClass = 'embed-wrap-has-cover';
		}
	}

	//padding bottom
	$paddingBottom = false;
	if ( $embedRatio != 'none'){
		switch($embedRatio){
			case '16_9':
				$paddingBottom = 'padding-bottom:' .(9/16) * 100 .'%;';
			break;
			case '4_3':
				$paddingBottom = 'padding-bottom:' .(3/4) * 100 .'%;';
			break;
			case 'custom':
				if(intval($embedCustomRatioW) > 0 && intval($embedCustomRatioH) > 0){
					$paddingBottom = 'padding-bottom: ' . (intval(esc_attr($embedCustomRatioH)) / intval(esc_attr($embedCustomRatioW))) * 100 . '%;';
				}
			break;
		}
	}
	
	//animation
	$animationClass = ux_cb_module_field_animation_class($module);
	$animationEnd = ux_cb_module_field_animation_end($module);

	//style
	if ( ! $module['is_frontend'] ) {
		$html .= '<style type="text/css">' . sanitize_text_field( ux_cb_module_embed_style( $post_id, $moduleUnique, $html ) ). '</style>';
	}
	
	$html .= '<div class="embed-wrap ' .sanitize_html_class($embedRatioClass). ' ' .sanitize_html_class($embedHasCoverImageClass). ' ' .esc_attr($animationClass). '" style="' .esc_attr($paddingBottom). '" data-animationend="' .esc_attr($animationEnd). '">';
	if ( ! $autoplay ) {
		$html .= $embedCoverImage;
	}
	$html .= wp_kses( balanceTags( $embedCode, true ), ux_cb_kses_allowed_html() );
	$html .= '</div>';
	
	return $html;
}

add_filter( 'ux_cb_module_container_embed', 'ux_cb_module_embed_container', 10, 2 );

?>