<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Fonts Management google font languages.
 */
if ( ! function_exists( 'ux_cb_fonts_management_google_font_languages' ) ) {
	function ux_cb_fonts_management_google_font_languages( ) {
		$languages = array( );
		
		$languages['arabic'] = 'Arabic';
		$languages['bengali'] = 'Bengali';
		$languages['cyrillic'] = 'Cyrillic';
		$languages['cyrillic-ext'] = 'Cyrillic Extended';
		$languages['devanagari'] = '';
		$languages['greek'] = 'Greek';
		$languages['greek-ext'] = 'Greek Extended';
		$languages['gujarati'] = 'Gujarati';
		$languages['gurmukhi'] = 'Gurmukhi';
		$languages['hebrew'] = 'Hebrew';
		$languages['kannada'] = 'Kannada';
		$languages['khmer'] = 'Khmer';
		$languages['latin'] = 'Latin';
		$languages['latin-ext'] = 'Latin Extended';
		$languages['malayalam'] = 'Malayalam';
		$languages['myanmar'] = 'Myanmar';
		$languages['oriya'] = 'Oriya';
		$languages['sinhala'] = 'Sinhala';
		$languages['tamil'] = 'Tamil';
		$languages['telugu'] = 'Telugu';
		$languages['thai'] = 'Thai';
		$languages['vietnamese'] = 'Vietnamese';
		
		return $languages;
	}
}

/**
 * UX Content Builder Fonts Management adobe typekit languages.
 */
if ( ! function_exists( 'ux_cb_fonts_management_adobe_typekit_languages' ) ) {
	function ux_cb_fonts_management_adobe_typekit_languages( ) {
		$languages = array( );

		$languages['be'] = 'Belarusian';
		$languages['ca'] = 'Catalan';
		$languages['cs'] = 'Czech';
		$languages['da'] = 'Danish';
		$languages['nl'] = 'Dutch';
		$languages['en'] = 'English';
		$languages['fr'] = 'French';
		$languages['de'] = 'German';
		$languages['el'] = 'Greek';
		$languages['hu'] = 'Hungarian';
		$languages['it'] = 'Italian';
		$languages['mk'] = 'Macedonian';
		$languages['mt'] = 'Maltese';
		$languages['no'] = 'Norwegian';
		$languages['pl'] = 'Polish';
		$languages['pt'] = 'Portuguese';
		$languages['ru'] = 'Russian';
		$languages['sr'] = 'Serbian';
		$languages['sl'] = 'Slovenian';
		$languages['es'] = 'Spanish';
		$languages['sv'] = 'Swedish';
		$languages['tr'] = 'Turkish';
		$languages['uk'] = 'Ukrainian';
		$languages['vi'] = 'Vietnamese';
		
		return $languages;
	}
}

/**
 * UX Content Builder Fonts Management adobe typekit variation.
 */
if ( ! function_exists( 'ux_cb_fonts_management_adobe_typekit_variation' ) ) {
	function ux_cb_fonts_management_adobe_typekit_variation( ) {
		$variation = array( );
		
		$variation['n1'] = array( 'value' => 'font-weight: 100; font-style: normal; ', 'name' => 'Hairline' );
		$variation['i1'] = array( 'value' => 'font-weight: 100; font-style: italic; ', 'name' => 'Hairline Italic' );
		$variation['n2'] = array( 'value' => 'font-weight: 200; font-style: normal; ', 'name' => 'Thin' );
		$variation['i2'] = array( 'value' => 'font-weight: 200; font-style: italic; ', 'name' => 'Thin Italic' );
		$variation['n3'] = array( 'value' => 'font-weight: 300; font-style: normal; ', 'name' => 'Light' );
		$variation['i3'] = array( 'value' => 'font-weight: 300; font-style: italic; ', 'name' => 'Light Italic' );
		$variation['n4'] = array( 'value' => 'font-weight: 400; font-style: normal; ', 'name' => 'Regular' );
		$variation['i4'] = array( 'value' => 'font-weight: 400; font-style: italic; ', 'name' => 'Italic' );
		$variation['n5'] = array( 'value' => 'font-weight: 500; font-style: normal; ', 'name' => 'Medium' );
		$variation['i5'] = array( 'value' => 'font-weight: 500; font-style: italic; ', 'name' => 'Medium Italic' );
		$variation['n6'] = array( 'value' => 'font-weight: 600; font-style: normal; ', 'name' => 'Semibold' );
		$variation['i6'] = array( 'value' => 'font-weight: 600; font-style: italic; ', 'name' => 'Semibold Italic' );
		$variation['n7'] = array( 'value' => 'font-weight: 700; font-style: normal; ', 'name' => 'Bold' );
		$variation['i7'] = array( 'value' => 'font-weight: 700; font-style: italic; ', 'name' => 'Bold Italic' );
		$variation['n8'] = array( 'value' => 'font-weight: 800; font-style: normal; ', 'name' => 'Heavy' );
		$variation['i8'] = array( 'value' => 'font-weight: 800; font-style: italic; ', 'name' => 'Heavy Italic' );
		$variation['n9'] = array( 'value' => 'font-weight: 900; font-style: normal; ', 'name' => 'Black' );
		$variation['i9'] = array( 'value' => 'font-weight: 900; font-style: italic; ', 'name' => 'Black Italic' );
		

		return $variation;
	}
}

/**
 * UX Content Builder Fonts Management system fonts.
 */
if ( ! function_exists( 'ux_cb_fonts_management_system_fonts' ) ) {
	function ux_cb_fonts_management_system_fonts( ) {
		$fonts = array(
			'family' => array(
				'arial' => array( 'name' => 'Arial', 'value' => 'arial, helvetica, sans-serif' ),
				'helvetica' => array( 'name' => 'Helvetica', 'value' => 'helvetica, sans-serif' ),
				'times' => array( 'name' => 'Times', 'value' => '"Times Roman", times, serif' ),
				'times-new-roman' => array( 'name' => 'Times New Roman', 'value' => '"Times New Roman", "Times Roman", TimesNR, times, serif' )
			),
			'weight' => array( 'normal' => 'Normal', 'bold' => 'Bold' ),
			'style' => array( 'normal' => 'Normal', 'italic' => 'Italic' )
		 );
		
		return $fonts;
	}
}

/**
 * UX Content Builder Fonts Management custom upload mimes.
 */
if ( ! function_exists( 'ux_cb_fonts_custom_upload_mimes' ) ) {
	function ux_cb_fonts_custom_upload_mimes( $existing_mimes ) {
		$existing_mimes['otf'] = 'application/x-font-otf';
		$existing_mimes['woff'] = 'application/x-font-woff';
		$existing_mimes['woff2'] = 'application/x-font-woff2';
		$existing_mimes['ttf'] = 'application/x-font-ttf';
		$existing_mimes['svg'] = 'image/svg+xml';
		$existing_mimes['eot'] = 'application/vnd.ms-fontobject';
		return $existing_mimes;
	}
	add_filter( 'upload_mimes', 'ux_cb_fonts_custom_upload_mimes' );
}

/**
 * UX Content Builder Fonts Management custom upload mimes ext2type.
 */
if ( ! function_exists( 'ux_cb_fonts_custom_upload_mimes_ext2type' ) ) {
	function ux_cb_fonts_custom_upload_mimes_ext2type( $ext2type ) {
		$ext2type['image'][] = 'svg';
		$ext2type['image'][] = 'otf';
		$ext2type['image'][] = 'woff';
		$ext2type['image'][] = 'woff2';
		$ext2type['image'][] = 'ttf';
		$ext2type['image'][] = 'eot';
		
		return $ext2type;
	}
	add_filter( 'ext2type', 'ux_cb_fonts_custom_upload_mimes_ext2type' );
}

/**
 * UX Content Builder Fonts Management register front css.
 */
if ( ! function_exists( 'ux_cb_fonts_register_front_css' ) ) {
	function ux_cb_fonts_register_front_css( ) {
		$fontLists = get_option( 'ux-font-lists' );
		if ( $fontLists ) {
			foreach ( $fontLists as $fontItem ) {
				$unique = trim( $fontItem['value'] );
				$fontFields = get_option( 'ux-font-' .$unique );
				if ( $fontFields ) {
					switch( $fontFields[1]['value'] ) {
						case 'google-font':
							$fontFamily = false;
							$fontStyle = false;
							$fontSubset = array( );
							foreach ( $fontFields as $field ) {
								if ( $field['name'] == '__ux_cb_module_fonts_resource_google-font_family' ) {
									$fontFamily = $field['value'];
								}else if ( $field['name'] == '__ux_cb_module_fonts_resource_google-font_style' ) {
									$fontStyle = $field['value'];
								}else if ( $field['name'] == '__ux_cb_module_fonts_resource_google-font_subset' ) {
									$fontSubset[] = $field['value'];
								}
							}
							$fontSubset = join( ',', $fontSubset );
							wp_register_style( 'ux-font-' .$unique, 'https://fonts.googleapis.com/css?family=' .$fontFamily. ':' .$fontStyle. '&amp;subset=' .$fontSubset );
						break;
						
						case 'adobe-typekit':
							$kidID = '';
							foreach ( $fontFields as $field ) {
								if ( $field['name'] == '__ux_cb_module_fonts_resource_adobe-typekit-id' ) {
									$kidID = $field['value'];
								}
							}
							
							wp_register_style( 'ux-font-' .$unique, 'https://use.typekit.net/' .$kidID. '.css' );
						break;
					}
				}
			}
		}
	}
	add_action( 'ux_cb_base_register_front_css', 'ux_cb_fonts_register_front_css' );
}

/**
 * UX Content Builder Fonts Management enqueue scripts.
 */
if ( ! function_exists( 'ux_cb_fonts_enqueue_scripts' ) ) {
	function ux_cb_fonts_enqueue_scripts( ) {
		$moduleFields = apply_filters( 'ux_cb_module_fields', array() );
		$fontSelect = array( 'font', 'size', 'lineheight', 'letter_spacing', 'msize' );
		$itemNameArray = array( );
		if ( count( $moduleFields) ) {
			foreach ( $moduleFields as $module_id => $module ) {
				foreach ( $module['region'] as $num => $region ) {
					foreach ( $region['section'] as $num_section => $section ) {
						foreach ( $section['group'] as $num_group => $group ) {
							foreach ( $group['items'] as $item ) {
								if ( isset( $item['type'] ) ) {
									switch( $item['type'] ) {
										case 'selectFontsGroup': $itemNameArray[] = $item['name']. '_font'; break;
										case 'fonts-group': $itemNameArray[] = $item['name']. '_family'; break;
									}
								}
							}
						}
					}
				}
			}
		}
		
		//in module
		$post_id = ux_cb_get_the_post_id();
		$hasModules = get_post_meta( $post_id, 'modules', true );
		$moduleFontAssignment = array( );
		if ( $hasModules && is_array( $hasModules) ) {
			foreach ( $hasModules as $moduleUnique ) {
				$post_id = ux_cb_get_the_module_post_id( $moduleUnique );
				foreach ( $itemNameArray as $itemName ) {
					if ( $fontDefinition = get_post_meta( $post_id, $itemName, true) ) {
						$moduleFontAssignment[] = $fontDefinition;
					}
				}
			}
		}
		
		//in theme option
		$fontAssignment = get_option( 'ux-font-assignment' );
		if ( $fontAssignment ) {
			foreach ( $fontAssignment as $fontName => $fontValue ) {
				if ( isset( $fontValue['name'] ) ) {
					$fontValue = $fontValue['value'];
				}
				
				if ( $fontValue != '-1' ) {
					if ( is_array( $fontValue ) ) {
						foreach ( $fontValue as $fontValue ) {
							if ( $fontValue != '-1' ) {
								$moduleFontAssignment[] = $fontValue;
							}
						}
					} else {
						$moduleFontAssignment[] = $fontValue;
					}
				}
			}
		}
		
		$moduleFontAssignment = array_unique( $moduleFontAssignment );
		foreach ( $moduleFontAssignment as $unique ) {
			wp_enqueue_style( 'ux-font-' .trim( $unique ) );
		}
	}
	add_action( 'ux_cb_frontend_enqueue_scripts', 'ux_cb_fonts_enqueue_scripts' );
	add_action( 'ux_cb_backend_enqueue_scripts', 'ux_cb_fonts_enqueue_scripts' );
}

/**
 * UX Content Builder Fonts Management frontend enqueue scripts.
 */
if ( ! function_exists( 'ux_cb_fonts_inline_style' ) ) {
	function ux_cb_fonts_inline_style( $style ) {
		$fontLists = get_option( 'ux-font-lists' );
		if ( $fontLists ) {
			foreach ( $fontLists as $fontItem ) {
				$unique = trim( $fontItem['value'] );
				$fontFields = get_option( 'ux-font-' .$unique );
				if ( $fontFields ) {
					switch( $fontFields[1]['value'] ) {
						case 'upload-font':
							$style .= ' @font-face { ';
							foreach ( $fontFields as $field ) {
								if ( $field['name'] == '__ux_cb_module_fonts_style_name' ) {
									$style .= 'font-family: "ux-font-' .$unique. '"; ';
								}
								
								$fieldName = str_replace( '__ux_cb_module_fonts_resource_upload-font_', '', $field['name'] );
								if ( $fieldName == 'woff' || $fieldName == 'ttf' || $fieldName == 'eot' || $fieldName == 'svg' || $fieldName == 'woff2' ) {
									$extension = pathinfo( $field['value'], PATHINFO_EXTENSION );
									if ( $extension == $fieldName ) {
										switch( $fieldName ) {
											case 'woff2': $style .= 'src: url("' .$field['value']. '") format("woff2");'; break;
											case 'woff': $style .= 'src: url("' .$field['value']. '") format("woff");'; break;
											case 'ttf': $style .= 'src: url("' .$field['value']. '") format("truetype");'; break;
											// case 'eot':
											// 	$style .= 'src: url("' .$field['value']. '" );';
											// 	$style .= 'src: url("' .$field['value']. '?#iefix") format("embedded-opentype" );';
											// break;
											//case 'svg': $style .= 'src: url("' .$field['value']. '#svgFontName") format("svg" );'; break;
										}
									}
								}
							}
							$style .= '}';
						break;
					}
					//$style .= '.ux-font-' .$unique. ' { ' .ux_cb_fonts_load_font_data( $unique ). ' }';
				}
			}
		}
		return $style;
	}
	add_filter( 'ux_cb_module_inline_style_before', 'ux_cb_fonts_inline_style' );
}

/**
 * UX Content Builder Fonts Management load font data.
 */
if ( ! function_exists( 'ux_cb_fonts_load_font_data' ) ) {
	function ux_cb_fonts_load_font_data( $unique ) {
		$style = '';
		$unique = trim( $unique );
		$fontFields = get_option( 'ux-font-' .$unique );
		switch( $fontFields[1]['value'] ) {
			case 'google-font':
				foreach ( $fontFields as $field ) {
					$fieldName = str_replace( '__ux_cb_module_fonts_resource_google-font_', '', $field['name'] );
					switch( $fieldName ) {
						case 'family':
							$fontFamily = str_replace( '+', ' ', $field['value'] );
							$style .= 'font-family: ' .$fontFamily. '; ';
						break;
						case 'style': 
							if ( $field['value'] == 'regular' ) {
								$field['value'] = 'normal';
							}
							$style .= 'font-weight: ' .$field['value']. '; '; break;
					}
				}
			break;
			
			case 'upload-font':
				$style .= 'font-family: "ux-font-' .$unique. '"; ';
			break;
			
			case 'system-font':
				foreach ( $fontFields as $field ) {
					$fieldName = str_replace( '__ux_cb_module_fonts_resource_system-font_', '', $field['name'] );
					switch( $fieldName ) {
						case 'family':
							$systemfont = ux_cb_fonts_management_system_fonts( );
							$style .= 'font-family: ' .$systemfont['family'][$field['value']]['value']. '; ';
						break;
						case 'weight': $style .= 'font-weight: ' .$field['value']. '; '; break;
						case 'style': $style .= 'font-style: ' .$field['value']. '; ';
						break;
					}
				}
			break;
			
			case 'adobe-typekit':
				foreach ( $fontFields as $field ) {
					$fieldName = str_replace( '__ux_cb_module_fonts_resource_adobe-typekit_', '', $field['name'] );
					switch( $fieldName ) {
						case 'family':
							$kitID = $fontFields[2]['value'];
							if ( $fontFamily = get_option( 'ux_theme_typekit_font_' .$kitID. '_' .$field['value'] ) ) {
								$fontFamily = json_decode( $fontFamily );
								$style .= 'font-family: ' .$fontFamily->family->css_stack. '; ';
							}
						break;
						case 'style':
							$variations = ux_cb_fonts_management_adobe_typekit_variation( );
							$style .= $variations[$field['value']]['value'];
						break;
					}
				}
			
			break;
		}
		
		return $style;
	}
}


/**
 * UX Content Builder Fonts Management get assignment.
 */
if ( ! function_exists( 'ux_cb_fonts_get_font_assignment' ) ) {
	function ux_cb_fonts_get_font_assignment( $name, $key=false, $selector=false ) {
		$output = '';
		$switch = false;
		
		$fontAssignment = get_option( 'ux-font-assignment' );
		if ( $fontAssignment ) {
			$output .= $selector ? $selector. ' { ' : false;
			foreach ( $fontAssignment as $fontName => $fontValue ) {
				$typeName = $name. '_' .$key;
				
				if ( isset( $fontValue['name'] ) ) {
					$fontName = $fontValue['name'];
					$fontValue = $fontValue['value'];
				}
				
				if ( $fontName == $typeName ) {
					switch ( $key ) {
						case 'family': 
							if ( function_exists ( 'ux_cb_fonts_load_font_data' ) ) {
								$fontData = ux_cb_fonts_load_font_data( $fontValue );
								if ( $fontData != '' ) { 
									$output .= $fontData; 
									$switch = true;
								}
							}
						break;
						case 'size':
						if ( $fontValue && $fontValue != 'Size' ) { $output .= 'font-size: ' .$fontValue. '; '; $switch = true; } break;
						
						case 'spacing':
						if ( $fontValue && $fontValue !='Spacing' ) { $output .= 'letter-spacing: ' .$fontValue. '; '; $switch = true; }  break;
						
						case 'm-size':
						if ( $fontValue && $fontValue != 'Mobile Size' ) { $output .= '--fontsize'.$name.': ' .$fontValue. '; '; $switch = true; } break;
						
						case 'line_height':
						if ( $fontValue && $fontValue != 'Line Height' ) { $output .= 'line-height: ' .$fontValue. '; '; $switch = true; } break;
					}
				}
			}
			$output .= $selector ? "}\n" : false;
		}
		
		if ( $switch ) {
			return $output;
		}
	}
}
?>
