<?php
if ( ! function_exists( 'ux_cb_tools_export_posts' ) ) {
	/**
	 * export wp posts, pages, attachments
	 */
	function ux_cb_tools_export_posts( $wp_filesystem, $uq, $exportDir ) {
		$content = false;
		$exportData = sanitize_text_field( $_POST['exportData'] );
		
		if ( isset( $_POST['postId'] ) ) {
			$postId = sanitize_text_field( $_POST['postId'] );
			$post = get_post( $postId );
			
			if ( $exportData != 'theme-option' && $exportData != 'terms' ) {
				if ( $post ) {
					if ( ! $wp_filesystem->is_dir( $exportDir. '/' .$post->post_type ) ) {
						$wp_filesystem->mkdir( $exportDir. '/' .$post->post_type );
					}
					
					$isSticky = is_sticky( $post->ID ) ? 1 : 0;
					$post->is_sticky = $isSticky;
					
					if ( $post->post_type == 'post' ) {
						$format = get_post_format( $post->ID );
						if ( $format ) {
							$post->format = $format;
						}
					}
					
					if ( ! $wp_filesystem->is_dir( $exportDir. '/' .$post->post_type. '/' .$post->post_name ) ) {
						$wp_filesystem->mkdir( $exportDir. '/' .$post->post_type. '/' .$post->post_name );
					}
					
					if ( $post->post_type == 'attachment' ) {
						/*$attachment = wp_get_attachment_metadata( $post->ID );
						$uploadDir = wp_upload_dir();
						
						if ( isset( $attachment[ 'file' ] ) ) {
							$newImageFile = $exportDir. '/' .$post->post_type. '/' .$post->post_name . '/' .basename( $attachment[ 'file' ] );
							$wp_filesystem->copy( $uploadDir[ 'basedir' ]. '/' .$attachment[ 'file' ], $newImageFile );
						}*/
						
						if ( $attachment = get_attached_file( $post->ID ) ) {
							$newImageFile = $exportDir. '/' .$post->post_type. '/' .$post->post_name . '/' .basename( $attachment );
							$wp_filesystem->copy( $attachment, $newImageFile );
						}
					}
					
					$taxonomies = get_object_taxonomies( $post->post_type );
					if ( ! empty( $taxonomies ) ) {
						$termsData = array();
						foreach ( $taxonomies as $taxonomy ) {
							if ( $taxonomy != 'post_format' ) {
								$terms = get_the_terms( $post->ID, $taxonomy );
								if ( $terms && ! is_wp_error( $terms ) ) {
									$post_terms = array();
									foreach ( $terms as $term ) {
										array_push( $post_terms, $term->term_id );
									}
									$termsData[ $taxonomy ] = join( ',', $post_terms );
								}
							}
						}
						$post->terms = json_encode( $termsData );
					}
					
					$customFields = get_post_custom( $post->ID );
					$post_meta = array();
					foreach ( $customFields as $key => $value ) {
						$post_meta[ $key ] = get_post_meta( $post->ID, $key, true );
					}
					$post->post_meta = json_encode( $post_meta );
					
					$postComments = get_comments( 'post_id=' .$post->ID );
					if ( $postComments ) {
						$comments = array();
						foreach ( $postComments as $comment ) {
							$comment = json_encode( $comment );
							$comment = json_decode( $comment, true );
							array_push( $comments, $comment );
						}
						$post->comments = json_encode( $comments );
					}
					
					$filename = $exportDir. '/' .$post->post_type. '/' .$post->post_name. '/data.json';
					$content = json_encode( $post );
					if ( ! $wp_filesystem->put_contents( $filename, $content, FS_CHMOD_FILE ) ) {
						echo 'error';
					} else {
						echo 'ok';
					}
					
				} else {
					echo 'no post';
				}
			}
		}
	}
	add_action( 'ux_cb_tools_export_data', 'ux_cb_tools_export_posts', 10, 3 );
}

?>