<?php
/**
 * UX Content Builder Module Social Media Config.
 */

//social media config fields
function ux_cb_module_social_media_fields($fields){
	$fields['social-media'] = array(
		'id'           => 'social-media',
		'animation'    => true,
		'title'        => esc_html__('Social Media','bm-builder'),
		'shortcodeTag' => 'ux_cb_social_media', 
		'shortcode'    => '[ux_cb_social_media unique="" col="12"]',
		'region'       => array(
			array(
				'region-id' => 'general-settings',
				'title'     => esc_html__('General Settings','bm-builder'),
				'default'   => true,
				'name'      => '__ux_cb_module_general_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									array('title'   => esc_html__( 'Type', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_social_media_type',
										  'default' => 'social-share',
										  'fields'  => array( 
											  array( esc_html__( 'Social Share', 'bm-builder' ),  'social-share' ),
											  array( esc_html__( 'Social Link', 'bm-builder' ),  'social-link' )
										  ))
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_social_media_type,social-share',
								'items' => array(
									array('title'   => esc_html__('Social Share','bm-builder'),
										  'desc'    => '',
										  'type'    => 'checkbox-group',
										  'name'    => '__ux_cb_module_social_media_share',
										  'fields'  => array(
											  array(esc_html__('Facebook','bm-builder'), 'facebook'),
											  array(esc_html__('Twitter','bm-builder'), 'twitter'),
											  array(esc_html__('Pinterest','bm-builder'), 'pinterest'),
											  array(esc_html__('Digg','bm-builder'), 'digg'),
											  array(esc_html__('Reddit','bm-builder'), 'reddit'),
											  array(esc_html__('Linkedin','bm-builder'), 'linkedin'),
											  array(esc_html__('Stumbleupon','bm-builder'), 'stumbleupon'),
											  array(esc_html__('Tumblr','bm-builder'), 'tumblr'),
											  array(esc_html__('Mail','bm-builder'), 'mail')
										  ))
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_social_media_type,social-link',
								'items' => array(
									array('title' => esc_html__( 'Social Link', 'bm-builder' ),
										  'type' => 'items',
										  'item-text' => esc_html__( 'Link', 'bm-builder' ),
										  'name' => '__ux_cb_module_social_media_link_items',
										  'count' => 1 ),
		
									array('title'   => esc_html__( 'Show Social Name', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'default' => 'on',
										  'name'    => '__ux_cb_module_social_show_name' ),

									array('title'   => esc_html__( 'Social Name Font', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'selectFontsGroup',
										  'fontval' => array( 'family' => '', 'size' => '16px', 'lineheight' => '1.0', 'letter_spacing' => '', 'msize' => '14px' ), 
										  'name'    => '__ux_cb_module_social_name_font',
										  'ctrl'	=> '__ux_cb_module_social_show_name,on' ),

									array('title'   => esc_html__('Social Name Spacing from Icon','bm-builder'),
										  'desc'    => '',
										  'type'	=> 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_social_media_share_name_spacing',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'default' => array( '10', '10' ),
										  'place'   => array(
											  esc_html__('Desktop', 'bm-builder'),
											  esc_html__('Mobile',  'bm-builder')
										  ),
										  'ctrl'	=> '__ux_cb_module_social_show_name,on'
									),
									
								)
							),
							array(
								'items' => array(
									array('title'   => esc_html__('Arrange','bm-builder'),
										 'type'    => 'multipleSelect',
										  'desc'    => '',
										  'default' => 'ux-horizontal',
										  'name'    => '__ux_cb_module_social_media_share_arrange',
										  'fields'  => array(
											  array(esc_html__('Horizontal','bm-builder'), 'ux-horizontal'),
											  array(esc_html__('Vertical','bm-builder'), 'ux-vertical')
										  ),
										  'default' => array('ux-horizontal', 'ux-horizontal'),
										  'style'   => 'min-width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__('Desktop', 'bm-builder'),
											  esc_html__('Mobile',  'bm-builder')
										  )
									),
									array('title'   => esc_html__('Icons Size','bm-builder'),
										  'desc'    => '',
										  'type'	=> 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_social_media_share_icons_size',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__('Desktop', 'bm-builder'),
											  esc_html__('Mobile',  'bm-builder')
										  )
									),
									array('title'   => esc_html__('Icons Horizontal Spacing','bm-builder'),
										  'desc'    => '',
										  'type'	=> 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_social_media_share_space_h',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__('Desktop', 'bm-builder'),
											  esc_html__('Mobile',  'bm-builder')
										  )
									),
									array('title'   => esc_html__('Icons Vertical Spacing','bm-builder'),
										  'desc'    => '',
										  'type'	=> 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_social_media_share_space_v',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__('Desktop', 'bm-builder'),
											  esc_html__('Mobile',  'bm-builder')
										  )
									),
									array('title'   => esc_html__('Align','bm-builder'),
										 'type'    => 'multipleSelect',
										  'desc'    => '',
										  'name'    => '__ux_cb_module_social_media_share_align',
										  'fields'  => array(
											  array(esc_html__('Center','bm-builder'), 'ux-center'),
											  array(esc_html__('Left','bm-builder'), 'ux-left'),
											  array(esc_html__('Right','bm-builder'), 'ux-right')
										  ),
										  'default' => array('ux-center', 'ux-center'),
										  'style'   => 'min-width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__('Desktop', 'bm-builder'),
											  esc_html__('Mobile',  'bm-builder')
										  )
									)
								)
							),
						)
					)
				)
			),
			array(
				'region-id' => 'advanced-settings',
				'title'     => esc_html__( 'Advanced Settings', 'bm-builder' ),
				'default'   => false,
				'name'      => '__ux_cb_module_advanced_settings',
				'section'   => array(
					array(
						'group' => array()
					)
				)
			),
			array(
				'region-id' => 'item-settings',
				'title'     => esc_html__( 'Item Settings', 'bm-builder' ),
				'default'   => false,
				'hidden'    => true,
				'class'     => 'ux-cb-item-settings',
				'name'      => '__ux_cb_module_items_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									array('title'   => esc_html__( 'Social Media Name', 'bm-builder' ),
										  'type'    => 'text',
										  'name'    => '__ux_cb_module_social_media_item_name' ),
										  
									array('title'   => esc_html__( 'Social Media Link', 'bm-builder' ),
										  'type'    => 'text',
										  'inputType' => 'url',
										  'name'    => '__ux_cb_module_social_media_item_link' ),
										  
									array('title'   => esc_html__( 'Select Icon', 'bm-builder' ),
										  'type'    => 'selectIcons',
										  'name'    => '__ux_cb_module_social_media_item_select_icon' ),
									
									array('title'   => esc_html__( 'Open Link in New Tab', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_button_item_link_target'),
										  
									array('title'   => '',
										  'desc'    => '',
										  'class'   => 'item-save-button',
										  'type'    => 'button',
										  'target'  => '.ux-cb-module-field-items',
										  'text'    => esc_html__( 'Save Item', 'bm-builder' ),
										  'name'    => '__ux_cb_module_button_item_save' )
								 )
							)
						)
					)
				)
			)
		)
	);
	
	return $fields;
	
}
add_filter('ux_cb_module_fields', 'ux_cb_module_social_media_fields');

?>