<?php
/**
 * UX Content Builder Module Contact Form Config.
 */
 
//contact form config fields
function ux_cb_module_contact_form_fields($fields){
	$fields['contact-form'] = array(
		'id'           => 'contact-form',
		'animation'    => true,
		'title'        => esc_html__('Contact Form','bm-builder'),
		'content'      => '',
		'shortcodeTag' => 'ux_cb_contact_form', 
		'shortcode'    => '[ux_cb_contact_form unique="" col="12"]', 
		'region'       => array(
			array(
				'region-id' => 'general-settings',
				'title'     => esc_html__('General Settings','bm-builder'),
				'default'   => true,
				'name'      => '__ux_cb_module_general_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
												
									array('title'   => esc_html__('Recipient Email','bm-builder'),
										  'desc'    => esc_html__('Enter the email to receive the messages.','bm-builder'),
										  'type'    => 'text',
										  'name'    => '__ux_cb_module_contact_form_recipient_email'),

									array('title'   => esc_html__('Name Box placeholder','bm-builder'),
										  'desc'    => '',
										  'type'    => 'text',
										  'default' => esc_attr__('Name','bm-builder'),
										  'name'    => '__ux_cb_module_contact_form_name_placehold'),

									array('title'   => esc_html__('Email Box placeholder','bm-builder'),
										  'desc'    => '',
										  'type'    => 'text',
										  'default' => esc_attr__('Email','bm-builder'),
										  'name'    => '__ux_cb_module_contact_form_email_placehold'),
						
									array('title'   => esc_html__('Message Box placeholder','bm-builder'),
										  'desc'    => '',
										  'type'    => 'text',
										  'default' => esc_attr__('Your message','bm-builder'),
										  'name'    => '__ux_cb_module_contact_form_comment_placehold'),

									array('title'   => esc_html__('Sending Text','bm-builder'),
										  'desc'    => '',
										  'type'    => 'text',
										  'default' => esc_attr__('Sending','bm-builder'),
										  'name'    => '__ux_cb_module_contact_form_sending_text'),
						
									array('title'   => esc_html__('Sent Message Text','bm-builder'),
										  'desc'    => esc_html__('Enter the inform information you want to show after user send out the message.','bm-builder'),
										  'type'    => 'textarea',
										  'name'    => '__ux_cb_module_contact_form_message'),

									array('title'   => esc_html__('Input Box Border Width','bm-builder'),
										  'type'    => 'select', 
										  'name'    => '__ux_cb_module_contact_form_border',
										  'default' => '1',
										  'fields'  => array(
												array(esc_html__('1','bm-builder'), '1'),
												array(esc_html__('2','bm-builder'), '2'),
												array(esc_html__('3','bm-builder'), '3'),
												array(esc_html__('4','bm-builder'), '4'),
												array(esc_html__('5','bm-builder'), '5'),
												array(esc_html__('6','bm-builder'), '6'),
												array(esc_html__('7','bm-builder'), '7'),
												array(esc_html__('8','bm-builder'), '8'),
												array(esc_html__('9','bm-builder'), '9'),
												array(esc_html__('10','bm-builder'), '10')
										  )),

									array('title'   => esc_html__('Button Text','bm-builder'),
										  'desc'    => esc_html__('Enter the text you want to show on button.','bm-builder'),
										  'type'    => 'text',
										  'name'    => '__ux_cb_module_contact_form_button_text'),

									array('title'   => esc_html__('Button Width','bm-builder'),
											'desc'    => '',
											'type'    => 'select',
											'name'    => '__ux_cb_module_contact_form_button_width_type',
											'default' => 'left-right-padding', 
										  	'fields'  => array(
											  array(esc_html__('Fixed Width','bm-builder'),           'fixed-width'),
											  array(esc_html__('Padding on Left/Right','bm-builder'), 'left-right-padding')
										  	)),

									array('title'   => esc_html__('Button Width Value','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_contact_form_button_width_value', 
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ),
										  'ctrl'	=> '__ux_cb_module_contact_form_button_width_type,fixed-width'
										),
										  
									array('title'   => esc_html__('Button Padding on Left/Right','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_contact_form_button_leftright_padding',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'default' => array(40, 20),
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ),
										  'ctrl'	=> '__ux_cb_module_contact_form_button_width_type,left-right-padding'
									),

									array('title'   => esc_html__('Button Height Value','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_contact_form_button_height_value',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'default' => array(50, 40),
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									),

									array('title'   => esc_html__('Button Border Width','bm-builder'),
										  'type'    => 'numberGroup',
										  'name'    => '__ux_cb_module_contact_form_button_border_width',
										  'style'   => 'width: 80px;',
										  'default' => array(2, 2, 2, 2),
										  'place'   => array(
											  esc_html__('Top',    'bm-builder'),
											  esc_html__('Right',  'bm-builder'),
											  esc_html__('Bottom', 'bm-builder'),
											  esc_html__('Left',   'bm-builder')
										  )),
										  
									array('title'   => esc_html__('Button Border Width Mouseover','bm-builder'),
										  'type'    => 'numberGroup',
										  'name'    => '__ux_cb_module_contact_form_button_border_width_mouseover',
										  'style'   => 'width: 80px;',
										  'default' => array(2, 2, 2, 2),
										  'place'   => array(
											  esc_html__('Top',    'bm-builder'),
											  esc_html__('Right',  'bm-builder'),
											  esc_html__('Bottom', 'bm-builder'),
											  esc_html__('Left',   'bm-builder')
										  )),
										  
									array('title'   => esc_html__('Top Spacing','bm-builder'),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'desc'    => '',
										  'name'    => '__ux_cb_module_contact_form_button_spacing_top',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  )
									)
								)
							)
						)
					)
				)
			),
			array(
				'region-id' => 'advanced-settings',
				'title'     => esc_html__('Advanced Settings','bm-builder'),
				'default'   => false,
				'name'      => '__ux_cb_module_advanced_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									//Append a privacy policy message to contact forms?
									array('title'   => esc_html__( 'Append a privacy policy message to contact forms?', 'bm-builder' ),
										  'type'    => 'switch',
										  'default' => 'off',
										  'name'    => '__ux_cb_module_contact_form_privacy_policy' ),
								)
							),
							array(
								'group-ctrl' => '__ux_cb_module_contact_form_privacy_policy,on',
								'items' => array(
									//Message below template builder contact forms
									array('title'   => esc_html__( 'Message below template builder contact forms', 'bm-builder' ),
										  'desc'    => esc_html__( 'A short message that can be displayed below forms, along with a checkbox, that lets the user know that he has to agree to your privacy policy in order to send the form.', 'bm-builder' ),
										  'type'    => 'textarea',
										  'default' => __( 'I agree to the terms and conditions laid out in the <a href="the-privacy-page-url" target="_blank">Privacy Policy</a>', 'bm-builder' ),
										  'name'    => '__ux_cb_module_contact_form_privacy_policy_message'),
										
								)
							)
						)
					)
				)
			)	
		)
	);
	
	return $fields;
	
}
add_filter('ux_cb_module_fields', 'ux_cb_module_contact_form_fields');

?>