<?php
if ( has_post_thumbnail() ) {
	$thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' ); 
	$thumb_bg = $thumbnail[0];
}

$gallery_text_align = seatheme_get_post_meta( get_the_ID(), 'theme_meta_project_text_align' );
$enable_title_masking = seatheme_get_post_meta( get_the_ID(), 'theme_meta_project_title_masking') ;
$enable_title_masking_class = $enable_title_masking && has_post_thumbnail() ? ' title-masking' : false;
$enable_title_masking_bgimg = $enable_title_masking && has_post_thumbnail() ? 'style="background-image:url('.esc_url( $thumb_bg ). ');"' : false;

$hide_title = false;
$hide_title = seatheme_get_post_meta( get_the_ID(), 'theme_meta_project_hide_title' );
$hide_title_class = $hide_title ? 'hidden' : false;

?>

<div class="title-wrap <?php echo sanitize_html_class($hide_title_class); ?>">
	<div class="title-wrap-con">
		<h1 class="title-wrap-tit<?php echo esc_attr($enable_title_masking_class); ?>" <?php echo wp_kses( $enable_title_masking_bgimg,seatheme_shapeSpace_allowed_html() ); ?>><?php the_title(); ?></h1>
	</div>
</div>