<?php
$header_width = seatheme_get_option('theme_option_header_width') ? seatheme_get_option('theme_option_header_width') : false;
$header_width_class =  $header_width == 'fixed' ? 'container' : 'container-fluid';
$menu_panel_bottom_class = $header_width == 'fluid' ? 'container-fluid' : false;
$menu_align_panel_class = seatheme_get_option('theme_option_menu_align_on_expanded_menu_panel') ? seatheme_get_option('theme_option_menu_align_on_expanded_menu_panel') : false;
?>
<div id="menu-panel" class="menu-panel <?php echo sanitize_html_class($menu_align_panel_class); ?>">

    <div class="menu-panel-inn <?php echo sanitize_html_class($header_width_class); ?>">
     
        <nav id="navi">
            <?php wp_nav_menu(array(
				'theme_location'  => 'primary',
				'container_id' => 'navi-wrap',
				'items_wrap' => '<ul class="menu clearfix">%3$s</ul>'
			)); ?><!--End #navi_wrap-->
        </nav>
        <div id="menu-panel-bottom" class="menu-panel-bottom <?php echo sanitize_html_class($menu_panel_bottom_class); ?>"> 
            <div class="menu-panel-bottom-left col-md-3 col-sm-3 col-xs-5">
                <?php
                $expanded_show_search = seatheme_get_option('theme_option_show_search_on_expanded_menu_panel');
                $search_text = seatheme_get_option('theme_option_descriptions_search') ? seatheme_get_option('theme_option_descriptions_search') : esc_attr__('Type and Hit Enter','sea-theme');
                if($expanded_show_search){ ?>
                <div class="search-top-btn-class">
                    <span class="fa fa-search"></span>
                    <form class="search_top_form"  method="get" action="<?php echo esc_url(home_url('/')); ?>">
                        <input type="search" id="s" name="s" class="search_top_form_text" placeholder="<?php echo esc_attr($search_text); ?>">
                    </form>
                </div> 
                <?php
                } ?>
            </div>
            <div class="menu-panel-bottom-right col-md-9 col-sm-9 col-xs-7">
                <?php
                $expanded_show_social = seatheme_get_option('theme_option_show_social');
                if($expanded_show_social){ ?>
                <section class="socialmeida-mobile">
        
                    <?php //** Function Social
                    seatheme_interface_header_social(); ?>
        
                </section>
                <?php
                } ?>
            </div>
        </div>
    </div>	
</div>