<?php 
$social_medias = seatheme_get_option( 'theme_option_show_social_medias' );
$social_newtab = seatheme_get_option( 'theme_option_show_social_medias_new_tab' );
$target_blank = false;
$rel = 'nofollow ';
if ( $social_newtab ) {
    $target_blank = ' target="_blank"';
    $rel .= 'noopener noreferrer ';
}
$social_media_title = seatheme_get_option( 'theme_option_social_media_title' );
$social_media_descriptions = seatheme_get_option( 'theme_option_social_media_descriptions' );
	
if ( $social_medias && isset( $social_medias['icontype'] ) ) {
	$icon_type = $social_medias['icontype'];  ?>
    <ul class="socialmeida clearfix">						
        <?php foreach ( $icon_type as $num => $type ) {
            $icon = $social_medias['icon'][$num];
            $url = $social_medias['url'][$num];
            $tip = $social_medias['tip'][$num];  
            $tip_wrap =  $tip ? '<span class="socialmeida-text">'. esc_html( $tip ) .'</span>' : false; 
        ?>
            
            <li class="socialmeida-li">
                <a title="<?php echo esc_attr( $tip ); ?>" href="<?php echo esc_url( $url ); ?>" class="socialmeida-a" <?php echo sanitize_text_field( $target_blank ); ?> rel="<?php echo esc_attr( $rel ); ?>">
                    <?php
                    if( $icon ) { echo '<span class="' .esc_attr( $icon ). '"></span> '; } 
                    echo wp_kses_post( $tip_wrap ); ?></a>
            </li>
        <?php } ?>
    </ul>
<?php } ?>