<?php
$switch = true;

$excerpt = false;
$title = get_the_title();
$section_class = 'archive-title';
$search_text = seatheme_get_option('theme_option_descriptions_search') ? seatheme_get_option('theme_option_descriptions_search') : esc_attr__('Type and Hit Enter','sea-theme');
$content_width_class = false;

$blogListTitle = seatheme_get_option( 'theme_option_blog_list_blog_title' );
$blogListDesc = seatheme_get_option( 'theme_option_blog_list_blog_desc' );

if ( is_single() ) {
	$section_class = false;
	$sea_post_title_if = seatheme_get_post_meta(get_the_ID(), 'theme_meta_post_show_title');
	if(is_singular('ux-portfolio')){
		$switch = false;
	}
	$excerpt = get_the_excerpt();
	$title = get_the_title();
	if(has_post_format('image')) {
		if(!$sea_post_title_if) {
			$switch = false;
		}
	}

	$sidebar = seatheme_get_post_meta( get_the_ID(), 'theme_meta_sidebar' );
	$content_width = seatheme_get_post_meta( get_the_ID(), 'theme_meta_post_content_width' );
	$content_width_class = $sidebar == 'without-sidebar' && $content_width ? $content_width : false;
}

if ( is_front_page() && is_home() ) {
	// Default homepage
	$title = $blogListTitle ? $blogListTitle : esc_html__('Latest Posts','sea-theme'); 
	$excerpt = $blogListDesc;
} elseif ( is_home() ) {
	// blog page
	$title = $blogListTitle ? $blogListTitle : esc_html__('News','sea-theme');
	$excerpt = $blogListDesc;
}

if(is_404()){
	$excerpt = false;
	$title = false;
}

if(is_archive()){
	$excerpt = tag_description();
	$title = single_cat_title('', false);
	if(class_exists('Woocommerce')){
		if(is_shop()){
			$title = esc_html__('Shop','sea-theme');
		}
	}
	if ( is_post_type_archive() ) {
		$excerpt = get_the_post_type_description();
		$title = post_type_archive_title('', false);
	}
}

if ( is_tag() ) {
	$excerpt = tag_description();
	$title = single_cat_title('', false);
}

if ( is_author() ) {
	$excerpt = esc_html__('Author','sea-theme');
	$title = get_the_author();
}

if(is_category()){
	$excerpt = tag_description();
	$title = single_cat_title('', false);
}

if(class_exists('Woocommerce')){
	if(is_product_category()) {
		$title = single_cat_title('', false);
	}
}

if ( is_search() ) {
	$title = esc_html__( 'Search Results', 'sea-theme');
	$excerpt = esc_html__( 'Search for: ', 'sea-theme') . get_search_query();
}

if ( is_date() ) {
	$title = get_the_archive_title();
	$excerpt = get_the_archive_description();
}

if ( $switch ) { ?>

    <div class="<?php echo sanitize_html_class( $section_class ); ?> title-wrap">
        <div class="title-wrap-con">
            <h1 class="title-wrap-tit"><?php echo sanitize_text_field( $title ); ?></h1>
            <?php if ( is_archive() || is_home() ) { ?>
				<div class="archive-des">
					<?php 
					if ( $excerpt ) {
						echo $excerpt;
					} else {
						echo esc_html( $wp_query->found_posts ); 
						if( intval( $wp_query->found_posts ) > 1 ) {
							esc_html_e( ' items found','sea-theme' ); 
						} else {
							esc_html_e( ' item found','sea-theme' ); 
						}
					}
					
					?>
				</div>
			<?php }
			
			if ( is_single() ) { ?>
                <div class="article-meta clearfix"><?php seatheme_get_template_part('single/content', 'meta'); ?></div>
            <?php } 

            if ( is_search() ) { ?>
            	<div class="archive-des"><?php echo sanitize_text_field($excerpt); ?></div>
            	<form method="get" name="search" action="<?php echo esc_url( home_url('/') ); ?>" class="archive-search-form">
                    <input type="search" name="s" class="archive-search-input" placeholder="<?php echo esc_attr( $search_text ); ?>">
                </form>
            <?php } ?>
        </div>
    </div>    
<?php } ?>
