<?php
if ( have_posts() ) {
	
	$blogListColumnsClass = false;
	if ( $blogListColumns = seatheme_get_option( 'theme_option_blog_list_column_s' ) ) {
		if ( is_array( $blogListColumns ) ) {
			$blogListColumnsClass = join( ' ', $blogListColumns );
		} else {
			$blogListColumnsClass = $blogListColumns;
		}
	}
    $blogListItemLayout = false;
    if ( seatheme_get_option( 'theme_option_blog_list_item_layout' ) ) {
        $blogListItemLayout = seatheme_get_option( 'theme_option_blog_list_item_layout' );
    }
	
?>
	
	<div class="archive-list <?php echo esc_attr( $blogListColumnsClass ); ?> <?php echo sanitize_html_class( $blogListItemLayout ); ?>">
        
		<?php while ( have_posts() ) { 

            the_post(); 
        
            //** Post format
            $get_post_format = ( ! get_post_format() ) ? 'standard' : get_post_format();

            if ( $get_post_format === 'image' || $get_post_format === 'gallery' ) {
                $get_post_format = 'standard'; 
            }
            
            seatheme_get_template_part( 'archive/loop-item', $get_post_format );
            
            //** Template Archive loop item      
        }
        
        //** Do Hook Archive Pagination
        /**
         * @hooked  seatheme_interface_pagination - 10
         */
        do_action( 'seatheme_interface_archive_pagination', '', 3, 'pagenums' ); ?>

    </div>
    
<?php } else { ?>

    <div class="archive-nopost container"><?php esc_html_e( 'Sorry, no articles','sea-theme' );?> </div> 
    
<?php } ?>

