<?php 
//Emabed video
$video_embeded_code = seatheme_get_post_meta(get_the_ID(), 'theme_meta_video_embeded_code');
$video_ratio        = seatheme_get_post_meta(get_the_ID(), 'theme_meta_video_ratio', true);
$video_custom_ratio = seatheme_get_post_meta(get_the_ID(), 'theme_meta_video_custom_ratio', true);

$key_1      = false;
$key_2      = false;
$video_size = false;

switch($video_ratio){
    case '16:9': $video_size = 'video-16-9'; break;
    case '4:3': $video_size = 'video-4-3'; break;
    case 'custom':
        $key_1 = $video_custom_ratio && isset($video_custom_ratio[1]) ? $video_custom_ratio[1] : 4;
        $key_2 = $video_custom_ratio && isset($video_custom_ratio[2]) ? $video_custom_ratio[2] : 3;
        $video_size = false;
    break;
}

$key_1 = $key_1 ? $key_1 : 4;
$key_2 = $key_2 ? $key_2 : 3;
$video_size = $video_size ? $video_size : false;
    
$video_custom = $video_ratio == 'custom' && $video_custom_ratio ? 'padding-top:'.(intval($key_2) / intval($key_1)) * 100 .'%' : false;


//Featured image
$image_lazyload = seatheme_get_option( 'theme_option_enable_image_lazyload' );
$thumb_lazyclass = '';
if ( has_post_thumbnail() ) {    
    $thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
    $thumb_url = $thumb[0];
    $thumb_srcset = wp_get_attachment_image_srcset( get_post_thumbnail_id(), 'full' );
    $thumb_sizes = wp_get_attachment_image_sizes( get_post_thumbnail_id(), 'full' );
    $image_src = 'src="' .esc_url( $thumb_url ). '" srcset="'.wp_kses_post( $thumb_srcset ).'" sizes="'.wp_kses_post( $thumb_sizes ).'"';
    if ( $image_lazyload ) {
        $thumb_lazyclass = 'lazy'; 
        $image_src = 'src="' .esc_url( get_template_directory_uri() ). '/img/blank.gif" data-src="' .esc_url( $thumb_url ). '" data-srcset="'.wp_kses_post( $thumb_srcset ).'" data-sizes="'.wp_kses_post( $thumb_sizes ).'"';
    }
}
?>
<section <?php post_class('archive-item'); ?>>
    <h2 class="archive-tit"><a title="<?php esc_attr( the_title_attribute() ); ?>" href="<?php esc_url( the_permalink() ); ?>"><?php esc_html( the_title() ); ?></a></h2>
    
    <?php if($video_embeded_code){
        
    if(strstr($video_embeded_code, "youtu") && !(strstr($video_embeded_code, "iframe"))){ ?>
    
        <div class="archive-image videoWrapper video-wrap youtube <?php echo esc_attr($video_size); ?>" style=" <?php echo esc_attr($video_custom); ?>">
            <iframe src="https://www.youtube.com/embed/<?php echo esc_attr(seatheme_theme_get_youtube($video_embeded_code));?>?rel=0&controls=1&showinfo=0&theme=light&autoplay=0&wmode=transparent"></iframe>
        </div>
        
    <?php }elseif(strstr($video_embeded_code, "vimeo") && !(strstr($video_embeded_code, "iframe"))){ ?>
    
        <div class="archive-image videoWrapper video-wrap viemo <?php echo esc_attr($video_size); ?>" style=" <?php echo esc_attr($video_custom); ?>">
            <iframe src="https://player.vimeo.com/video/<?php echo esc_attr(seatheme_theme_get_vimeo($video_embeded_code)); ?>?title=0&amp;byline=0&amp;portrait=0&amp;autoplay=0" width="100%" height="auto" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
        </div>
        
    <?php }else{ ?>
    
        <div class="archive-image videoWrapper video-wrap <?php echo esc_attr($video_size); ?>" style=" <?php echo esc_attr($video_custom); ?>"><?php echo wp_kses($video_embeded_code,seatheme_shapeSpace_allowed_html()); ?></div>
        
    <?php
        }
    } else {
        if ( has_post_thumbnail() ) { ?>
        <a class="archive-image" title="<?php esc_attr( the_title_attribute() ); ?>" href="<?php esc_url( the_permalink() ); ?>">
            <img class="archive-img <?php echo sanitize_html_class( $thumb_lazyclass ); ?>" <?php echo sanitize_text_field( $image_src ); ?> alt="<?php esc_attr( the_title_attribute() ); ?>"/>
        </a>
    <?php }  
    } ?>
    
    <div class="arvhive-excerpt">
        <?php seatheme_get_template_part( 'archive/content', 'desc' );  ?>
    </div> 
    <div class="archive-meta clearfix">
		<?php seatheme_get_template_part('archive/content', 'meta'); ?>
    </div>
    <?php
	seatheme_get_template_part('archive/content', 'social'); 
	if ( ! seatheme_has_more_link( get_the_ID() ) ) { 
        seatheme_get_template_part('archive/readmore', false); 
    } ?>
</section>