<?php
$blogListItemShowSocialSwitch = true;
$blogListItemShowSocial = seatheme_get_option( 'theme_option_blog_list_item_social_share' );
if ( ! $blogListItemShowSocial ) {
	$blogListItemShowSocialSwitch = false;
}

if ( $blogListItemShowSocialSwitch ) {
	$shareButtons = seatheme_get_option( 'theme_option_share_buttons' ); ?>
	
	<div class="social-bar">
		<ul class="post_social post-meta-social">
			<?php
			if ( is_array( $shareButtons ) ) {

				$postLink = get_permalink();
				$postLinkPure = preg_replace( '#^https?://#', '', rtrim( $postLink, '/' ) );
		
				//facebook
				if ( in_array( 'facebook', $shareButtons ) ) { ?>

					<li class="post-meta-social-li">
						<a class="share postshareicon-facebook-wrap" href="javascript:void(0)" onclick="window.open('http://www.facebook.com/sharer.php?u=<?php echo esc_url( $postLink ); ?>','Facebook','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;">
						<span class="fa fa-facebook postshareicon-facebook"></span>
						</a>
					</li>

				<?php
				}

				//twitter
				if ( in_array( 'twitter', $shareButtons ) ) { ?>

					<li class="post-meta-social-li">
						<a class="share postshareicon-twitter-wrap" href="javascript:void(0)" onclick="window.open('http://twitter.com/share?url=<?php echo esc_url( $postLink ); ?>&amp;text=<?php echo esc_attr( get_the_title() ); ?>','Twitter share','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;" >
						<span class="fa fa-twitter postshareicon-twitter"></span>
						</a>
					</li>

				<?php
				}

				//pinterest
				if ( in_array( 'pinterest', $shareButtons ) ) {
					$image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' ); 
					$thumbnail = $image ? $image[0] : false; ?>

					<li class="post-meta-social-li">
						<a class="share postshareicon-pinterest-wrap" href="javascript:void(0)" onclick="javascript:window.open('http://pinterest.com/pin/create/bookmarklet/?url=<?php echo esc_url( $postLink ); ?>&amp;is_video=false&amp;media=<?php echo esc_url( $thumbnail ); ?>','', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">
						<span class="fa fa-pinterest  postshareicon-pinterest"></span>
						</a>
					</li>

				<?php
				}

				//Digg
				if ( in_array( 'digg', $shareButtons ) ) { ?>

					<li class="post-meta-social-li">
						<a class="share postshareicon-digg-wrap" href="javascript:void(0)" onclick="window.open('http://www.digg.com/submit?url=<?php echo esc_url( $postLink ); ?>','Digg','width=715,height=330,left='+(screen.availWidth/2-357)+',top='+(screen.availHeight/2-165)+''); return false;">
						<span class="fa fa-digg postshareicon-digg"></span>
						</a>
					</li>

				<?php
				}

				//Readdit
				if ( in_array( 'reddit', $shareButtons ) ) { ?>

					<li class="post-meta-social-li">
						<a class="share postshareicon-reddit-wrap" href="javascript:void(0)" onclick="window.open('http://reddit.com/submit?url=<?php echo esc_url( $postLink ); ?>&amp;title=<?php echo esc_attr( get_the_title() ); ?>','Reddit','width=617,height=514,left='+(screen.availWidth/2-308)+',top='+(screen.availHeight/2-257)+''); return false;">
						<span class="fa fa-reddit postshareicon-reddit"></span>
						</a>
					</li>

				<?php
				}

				//linkedin
				if ( in_array( 'linkedin', $shareButtons ) ) { ?>

					<li class="post-meta-social-li">
						<a class="share postshareicon-linkedin-wrap" href="javascript:void(0)" onclick="window.open('http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo esc_url( $postLink ); ?>','Linkedin','width=863,height=500,left='+(screen.availWidth/2-431)+',top='+(screen.availHeight/2-250)+''); return false;">
						<span class="fa fa-linkedin postshareicon-linkedin"></span>
						</a>
					</li>

				<?php
				}

				//stumbleupon
				if ( in_array( 'stumbleupon', $shareButtons ) ) { ?>

					<li class="post-meta-social-li">
						<a class="share postshareicon-stumbleupon-wrap" href="javascript:void(0)" onclick="window.open('http://www.stumbleupon.com/submit?url=<?php echo esc_url( $postLink ); ?>&amp;title=<?php echo esc_attr( get_the_title() ); ?>','Stumbleupon','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;">
						<span class="fa fa-stumbleupon postshareicon-stumbleupon"></span>
						</a>
					</li>

				<?php
				}

				//tumblr
				if ( in_array( 'tumblr', $shareButtons ) ) { ?>
					<li class="post-meta-social-li">
						<a class="share postshareicon-tumblr-wrap" href="javascript:void(0)" onclick="window.open('http://www.tumblr.com/share/link?url=<?php  echo esc_attr( $postLinkPure ); ?>&amp;name=<?php echo esc_attr( get_the_title() ); ?>','Tumblr','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;">
						<span class="fa fa-tumblr postshareicon-tumblr"></span>
						</a>
					</li>
				<?php
				}

				//mail
				if ( in_array( 'mail', $shareButtons ) ) {  ?>
					<li class="post-meta-social-li">
						<a class="share postshareicon-mail-wrap" href="mailto:?Subject=<?php echo esc_attr( str_replace( ' ', '-', get_the_title() ) ); ?>&amp;Body=<?php echo esc_url( $postLink ); ?>" >
						<span class="fa fa-envelope-o postshareicon-mail"></span>
						</a>
					</li>

				<?php
				}
			} ?>
		</ul>
	</div>
<?php } ?>
