<?php
//register script
function seatheme_theme_register_script(){
	$seatheme_theme_register_script = array(
		array(
			'handle'    => 'bootstrap',
			'src'       => SEA_THEME. '/js/bootstrap.min.js',
			'deps'      => array('jquery'),
			'ver'       => '3.0.2',
			'in_footer' => true,
		),
		array(
			'handle'    => 'seatheme-admin-bootstrap-switch',
			'src'       => SEA_THEME. '/js/bootstrap-switch.min.js',
			'deps'      => array('jquery'),
			'ver'       => '1.8',
			'in_footer' => true,
		),
		array(
			'handle'    => 'seatheme-admin-minicolors',
			'src'       => SEA_THEME. '/js/jquery.minicolors.min.js',
			'deps'      => array('jquery'),
			'ver'       => '2.1',
			'in_footer' => true,
		),
		array(
			'handle'    => 'seatheme-admin-icheck',
			'src'       => SEA_THEME. '/js/jquery.icheck.min.js',
			'deps'      => array('jquery'),
			'ver'       => '0.9.1',
			'in_footer' => true,
		),
		array(
			'handle'    => 'seatheme-admin-theme-script',
			'src'       => SEA_THEME. '/js/theme.js',
			'deps'      => array('jquery'),
			'ver'       => '1.0.0',
			'in_footer' => false,
		),
		array(
			'handle'    => 'seatheme-admin-theme-script-transition',
			'src'       => SEA_THEME. '/js/theme-transition.js',
			'deps'      => array('jquery'),
			'ver'       => '1.0.0',
			'in_footer' => true,
		)
	);
	$seatheme_theme_register_script = apply_filters('seatheme_theme_register_script', $seatheme_theme_register_script);
	
	foreach($seatheme_theme_register_script as $script){
		wp_register_script($script['handle'], $script['src'], $script['deps'], $script['ver'], $script['in_footer'] ); 
	}
}
add_action('init', 'seatheme_theme_register_script');

//register style
function seatheme_theme_register_style(){
	$seatheme_theme_register_style = array(
		array(
			'handle' => 'seatheme-admin-bootstrap',
			'src'    => SEA_THEME. '/css/bootstrap.css',
			'deps'   => array(),
			'ver'    => '3.0.2',
			'media'  => 'screen',
		),
		array(
			'handle' => 'seatheme-admin-bootstrap-theme',
			'src'    => SEA_THEME. '/css/bootstrap-theme.css',
			'deps'   => array('seatheme-admin-bootstrap'),
			'ver'    => '3.0.2',
			'media'  => 'screen',
		),
		array(
			'handle' => 'font-awesome',
			'src'    => SEA_THEME. '/css/font-awesome.css',
			'deps'   => array(),
			'ver'    => '4.7.0',
			'media'  => 'screen',
		),
		array(
			'handle' => 'seatheme-admin-bootstrap-switch',
			'src'    => SEA_THEME. '/css/bootstrap-switch.css',
			'deps'   => array(),
			'ver'    => '1.8',
			'media'  => 'screen',
		),
		array(
			'handle' => 'seatheme-admin-minicolors',
			'src'    => SEA_THEME. '/css/jquery.minicolors.css',
			'deps'   => array(),
			'ver'    => '2.1',
			'media'  => 'screen',
		),
		array(
			'handle' => 'seatheme-admin-icheck',
			'src'    => SEA_THEME. '/css/icheck/square/_all.css',
			'deps'   => array(),
			'ver'    => '0.9.1',
			'media'  => 'screen',
		),
		array(
			'handle' => 'seatheme-admin-gridstack',
			'src'    => SEA_THEME. '/css/gridstack.min.css',
			'deps'   => array(),
			'ver'    => '0.3.0',
			'media'  => 'screen',
		),
		array(
			'handle' => 'seatheme-admin-theme-style',
			'src'    => SEA_THEME. '/css/theme.css',
			'deps'   => array(),
			'ver'    => '1.0.0',
			'media'  => 'screen',
		) 
	);
	$seatheme_theme_register_style = apply_filters('seatheme_theme_register_style', $seatheme_theme_register_style);
	
	foreach($seatheme_theme_register_style as $style){
		wp_register_style($style['handle'], $style['src'], $style['deps'], $style['ver'], $style['media'] );
	}
}
add_action('init', 'seatheme_theme_register_style');

//register post type
function seatheme_theme_register_post_type(){
	$seatheme_theme_register_post_type = apply_filters('ux_theme_register_post_type', array());
	
	return $seatheme_theme_register_post_type;
}
add_action('init', 'seatheme_theme_register_post_type');

//register sidebar
function seatheme_theme_register_sidebar($key){
	//sidebars
	$sidebars = array(
		array('value' => 'sidebar_1', 'title' => esc_html__('Sidebar 1 for Post/Page','sea-theme')),
		array('value' => 'sidebar_2', 'title' => esc_html__('Sidebar 2 for Post/Page','sea-theme')),
		array('value' => 'sidebar_3', 'title' => esc_html__('Sidebar 3 for Post/Page','sea-theme')),
		array('value' => 'sidebar_4', 'title' => esc_html__('Sidebar 4 for Post/Page','sea-theme')),
		array('value' => 'sidebar_5', 'title' => esc_html__('Sidebar 5 for Post/Page','sea-theme')),
		array('value' => 'sidebar_6', 'title' => esc_html__('Sidebar 6 for Post/Page','sea-theme')),
		array('value' => 'sidebar_7', 'title' => esc_html__('Sidebar 7 for Post/Page','sea-theme')),
		array('value' => 'sidebar_8', 'title' => esc_html__('Sidebar 8 for Post/Page','sea-theme')),
		array('value' => 'sidebar_9', 'title' => esc_html__('Sidebar 9 for Post/Page','sea-theme')),
		array('value' => 'sidebar_10', 'title' => esc_html__('Sidebar 10 for Post/Page','sea-theme'))
	);
	
	foreach($sidebars as $num => $sidebar){
		register_sidebar(array(
			'name' => $sidebar['title'],
			'id' => $sidebar['value'],
			'description'   => esc_html__('widgets for sidebar','sea-theme'),
			'before_title' => '<h3 class="widget-title"><span class="widget-title-inn">',
			'after_title' => '</span></h3>',
			'before_widget' => '<li class="widget-container %2$s">',
			'after_widget' => '</li>',
			'class' => ''
		));
	}
	
	//footer widget
	$footer_widget = array(
		array('value' => 'footer_widget_1', 'title' => __('Footer 1 for Post/Page','sea-theme')),
		array('value' => 'footer_widget_2', 'title' => __('Footer 2 for Post/Page','sea-theme')),
		array('value' => 'footer_widget_3', 'title' => __('Footer 3 for Post/Page','sea-theme')),
		array('value' => 'footer_widget_4', 'title' => __('Footer 4 for Post/Page','sea-theme')),
		array('value' => 'footer_widget_5', 'title' => __('Footer 5 for Post/Page','sea-theme'))
	);
	
	foreach($footer_widget as $num => $sidebar){
		register_sidebar(array(
			'name' => $sidebar['title'],
			'id' => $sidebar['value'],
			'description'   => __('No more than 3 widgets could be shown','sea-theme'),
			'before_title' => '<h3 class="widget-title">',
			'after_title' => '</h3>',
			'before_widget' => '<section class="widget_footer_unit widget-container %2$s">',
			'after_widget' => '</section>',
			'class' => ''
		));
	}
	
	switch($key){
		case 'sidebars':        return $sidebars; break;
		case 'footer_widget':   return $footer_widget; break;
	}
	
	
}
add_action('widgets_init', 'seatheme_theme_register_sidebar');

function seatheme_theme_register_nav_menu(){
	register_nav_menus(array(
		'primary' => 'Primary Menu'
	));
}
add_action('init', 'seatheme_theme_register_nav_menu');
?>