<?php
//excerpt
function seatheme_excerpt_length( $length ) {
	return 10;
}
add_filter( 'excerpt_length', 'seatheme_excerpt_length', 999 );

//theme meta save
function seatheme_theme_meta_save($post_id) {  
    if(!isset($_POST['custom_meta_box_nonce'])){
		$post_nonce = '';
	}else{
		$post_nonce = $_POST['custom_meta_box_nonce'];
	}
	
	if (!wp_verify_nonce($post_nonce, ABSPATH))  
		return $post_id; 
	
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)  
        return $post_id;  
    
    if('page' == $_POST['post_type']){  
        if (!current_user_can('edit_page', $post_id))  
            return $post_id;  
        } elseif (!current_user_can('edit_post', $post_id)) {  
            return $post_id;  
    }
	 
	$old = get_post_meta($post_id, 'ux_theme_meta', true);
	$new = $_POST['ux_theme_meta'];  
	
	if ($new && $new != $old) {  
		update_post_meta($post_id, 'ux_theme_meta', $new);  
	} elseif ('' == $new && $old) {  
		delete_post_meta($post_id, 'ux_theme_meta', $old);  
	}
	
	//set_post_thumbnail
	$thumbnail_id = get_post_meta($post_id, '_thumbnail_id', true); 
	if($thumbnail_id){
		$thumbnail_crop = get_post_meta($thumbnail_id, '_thumbnail_crop', true);
		if(!$thumbnail_crop){
			seatheme_theme_option_process_generate_thumb($thumbnail_id);
		}
	}
	
	return $post_id;
}  
add_action('save_post', 'seatheme_theme_meta_save'); 

//theme enter title
function seatheme_theme_post_enter_title($post){
	$seatheme_theme_post_type = seatheme_theme_register_post_type();
	foreach($seatheme_theme_post_type as $slug => $post_type){
		if(get_post_type() == $slug){
			if(isset($post_type['enter_title'])){
				$post = $post_type['enter_title'];
			}
		}
	}
	
	return $post;
}
add_filter('enter_title_here', 'seatheme_theme_post_enter_title');

//theme sample permalink
function seatheme_theme_post_sample_permalink_html($return){
	$seatheme_theme_post_type = seatheme_theme_register_post_type();
	foreach($seatheme_theme_post_type as $slug => $post_type){
		if(get_post_type() == $slug){
			if(isset($post_type['sample_permalink'])){
				$return = $post_type['sample_permalink'];
			}
		}
	}
	return $return;
}
add_filter('get_sample_permalink_html', 'seatheme_theme_post_sample_permalink_html');

//theme get youtube id
function seatheme_theme_get_youtube($url){ 
	if(strstr($url, "youtube")){
		preg_match('#https?://(www\.)?youtube\.com/watch\?v=([A-Za-z0-9\-_]+)#s', $url, $matches);
		return $matches[2];
	}else{
		preg_match('#http://w?w?w?.?youtu.be/([A-Za-z0-9\-_]+)#s', $url, $matches);
		return $matches[1];
	}
}

//theme get vimeo id
function seatheme_theme_get_vimeo($url){
	$matches = parse_url($url);
	$matches = str_replace("/", "", $matches['path']);
	return $matches;
}

//Display navigation to next/previous comments when applicable.
if ( ! function_exists( 'seatheme_comment_nav' ) ) :
function seatheme_comment_nav() {
	if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
	?>
	<nav class="navigation comment-navigation" role="navigation">
		<h2 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'sea-theme' ); ?></h2>
		<div class="nav-links">
			<?php
				if ( $prev_link = get_previous_comments_link( esc_html__( 'Previous', 'sea-theme' ) ) ) :
					printf( '<div class="nav-previous">%s</div>', $prev_link );
				endif;

				if ( $next_link = get_next_comments_link( esc_html__( 'Next', 'sea-theme' ) ) ) :
					printf( '<div class="nav-next">%s</div>', $next_link );
				endif;
			?>
		</div>
	</nav>
	<?php
	endif;
}
endif;

//theme post meta default
function seatheme_theme_post_meta_default($key){
	$theme_post_meta_fields = seatheme_theme_post_meta_fields();
	$default = false;
	if(isset($theme_post_meta_fields[get_post_type()])){
		foreach($theme_post_meta_fields[get_post_type()] as $option){
			if(isset($option['section'])){
				foreach($option['section'] as $section){
					if(isset($section['item'])){
						foreach($section['item'] as $item){
							if(isset($item['name'])){
								if($item['name'] == $key){
									$default = isset($item['default']) ? $item['default'] : false;
									if($default == 'true'){
										$default = true;
									}elseif($default == 'false'){
										$default = false;
									}
								}else{
									if(isset($item['bind'])){
										foreach($item['bind'] as $bind){
											if($bind['name'] == $key){
												$default = isset($bind['default']) ? $bind['default'] : false;
												if($default == 'true'){
													$default = true;
												}elseif($default == 'false'){
													$default = false;
												}
											}
										}
									}
							}
							}
						}
					}
				}
			}
		}
	}
	return $default;
}

//require theme postmeta
require_once get_template_directory() . '/functions/theme/post/post-meta.php';

// Get container width from theme options
if(!function_exists('seatheme_get_container_width')){
    function seatheme_get_container_width(){
    	$container = esc_attr(seatheme_get_option('theme_option_main_width_style')) ? esc_attr(seatheme_get_option('theme_option_main_width_style')) : 'container';
    	return esc_attr($container);
    }
}
add_filter('ux-get-container-width','seatheme_get_container_width');

?>