<?php
//define
define('SEA_THEME', get_template_directory_uri(). '/functions/theme' );
define('SEA_THEME_OPTIONS', get_template_directory_uri(). '/functions/theme/options' );
define('SEA_THEME_WIDGET', get_template_directory_uri(). '/functions/theme/widget' );
define('SEA_THEME_CUSTOMIZE', get_template_directory_uri(). '/functions/theme/customize' );
define('SEA_LOCAL_URL', get_template_directory_uri());
define('INS_TPL_PLACEHOLD_DIR', get_template_directory(). '/placehold');

//theme scripts
function seatheme_theme_options_enqueue_scripts(){
	global $post_type;
	
	// New Media Library
	if(function_exists('wp_enqueue_media')){ wp_enqueue_media(); }

	// Load default WP resources
	wp_enqueue_script('thickbox');
	wp_enqueue_style('thickbox');
	wp_enqueue_script('jquery-ui-sortable');
	wp_enqueue_script('jquery-ui-slider');
	wp_enqueue_script('wp-pointer');
	wp_enqueue_style('wp-pointer');
	wp_enqueue_script('json2');
	
	
	wp_enqueue_script('jquery-ui-droppable');
	wp_enqueue_script('jquery-ui-draggable');
	
	if(!wp_script_is('bootstrap', 'enqueued')){
		wp_enqueue_script('bootstrap');
	}
	
	if(!wp_script_is('ux-admin-bootstrap-switch', 'enqueued')){
		wp_enqueue_script('seatheme-admin-bootstrap-switch');
	}
	
	if(!wp_script_is('ux-admin-icheck', 'enqueued')){
		wp_enqueue_script('seatheme-admin-icheck');
	}
	
	wp_enqueue_script('seatheme-admin-minicolors');
	wp_enqueue_script( 'seatheme-admin-theme-script' );
	
	if ( isset( $_GET['page'] ) ) {
		if ( $_GET['page'] == 'theme-option' ) {
			$themeConfigFields = apply_filters( 'seatheme_theme_options_config', array() );
			if ( count( $themeConfigFields ) > 0 ) {
				if ( isset( $themeConfigFields['general'] ) ) {
					wp_enqueue_script( 'seatheme-admin-theme-script-transition' );
					wp_dequeue_script( 'seatheme-admin-theme-script' );
				}
			}
		}
	}
	
	wp_enqueue_style('font-awesome');
	
	if(!wp_style_is('ux-admin-bootstrap', 'enqueued')){
		wp_enqueue_style('seatheme-admin-bootstrap');
	}
	
	if(!wp_style_is('ux-admin-bootstrap-theme', 'enqueued')){
		wp_enqueue_style('seatheme-admin-bootstrap-theme');
	}
	
	if(!wp_style_is('ux-admin-bootstrap-switch', 'enqueued')){
		wp_enqueue_style('seatheme-admin-bootstrap-switch');
	}
	
	if(!wp_style_is('ux-admin-icheck', 'enqueued')){
		wp_enqueue_style('seatheme-admin-icheck');
	}
	
	wp_enqueue_style('seatheme-admin-minicolors');
	
	wp_enqueue_style('seatheme-admin-theme-style'); 
	wp_add_inline_style('seatheme-admin-theme-style', seatheme_theme_custom_css_ce());
}
add_action('admin_enqueue_scripts','seatheme_theme_options_enqueue_scripts', 10);
add_editor_style( 'functions/theme/css/editor-style.css' );

//theme post type support
function seatheme_theme_support(){
	add_theme_support('title-tag');
	
	add_post_type_support('post', array('excerpt', 'comments'));
	add_post_type_support('page', 'excerpt');
	
	add_theme_support('post-formats', array('gallery', 'link', 'image', 'quote', 'audio', 'video'));
	add_theme_support('automatic-feed-links'); 
	add_theme_support('custom-background');
	add_theme_support('post-thumbnails');

	add_image_size('seatheme-standard-thumb', 650, 9999);
	add_image_size('seatheme-standard-thumb-medium', 1000, 9999);
	add_image_size('seatheme-standard-thumb-big', 2000, 9999);
	add_image_size('seatheme-thumb-169-normal', 800, 450, true);
	add_image_size('seatheme-thumb-11-normal', 650, 650, true);
	add_image_size('seatheme-thumb-43-big', 2000, 1500, true);
	add_image_size('seatheme-thumb-43-medium', 1000, 750, true); 
	
	if(!isset($content_width)) $content_width = 1220;
	
	$GLOBALS['ux_theme_fn_prefix'] = 'seatheme';
}
add_action('init','seatheme_theme_support');

//theme activated redirect
function seatheme_theme_init( $old_theme ) {
	global $pagenow;

	if ( 'themes.php' == $pagenow && isset( $_GET['activated'] ) ) {
		delete_option( 'UxThemeActivated' );
		wp_redirect( esc_url( admin_url( 'admin.php?page=theme-option-about' ) ) );
		exit;
	}
}
add_action('after_switch_theme', 'seatheme_theme_init');

// add featured thumbnail to admin post columns
function seatheme_add_thumbnail_columns( $columns ) { 
	
	$columns['featured_thumb'] = 'Thumbnail';
	
    return $columns;
}

function seatheme_add_thumbnail_columns_data( $column, $post_id ) {
    switch ( $column ) {
    case 'featured_thumb':
        echo '<a href="' . get_edit_post_link() . '">';
        echo the_post_thumbnail( 'thumbnail' );
        echo '</a>';
        break;
	}
}

if ( function_exists( 'add_theme_support' ) ) {
    add_filter( 'manage_ux-portfolio_posts_columns' , 'seatheme_add_thumbnail_columns' );
    add_action( 'manage_ux-portfolio_posts_custom_column' , 'seatheme_add_thumbnail_columns_data', 10, 2 ); 
}

//require theme register
require_once get_template_directory() . '/functions/theme/theme-register.php';

//require theme options
require_once get_template_directory() . '/functions/theme/theme-options.php';

//require theme post
require_once get_template_directory() . '/functions/theme/theme-post.php';

//require theme widget
require_once get_template_directory() . '/functions/theme/theme-widget.php';

//require theme ajax
require_once get_template_directory() . '/functions/theme/theme-ajax.php';

//require theme customize
require_once get_template_directory() . '/functions/theme/customize/customize-options.php';

//require theme content of builder style
require_once get_template_directory() . '/functions/theme/theme-ce-style.php';
?>