<?php

//theme meta select fields
function seatheme_theme_meta_select_fields($fields){
	$fields['theme_meta_sidebar'] = array(
		array('title' => esc_html__('Right Sidebar','sea-theme'),                         'value' => 'right-sidebar'),
		array('title' => esc_html__('Left Sidebar','sea-theme'),                          'value' => 'left-sidebar'),
		array('title' => esc_html__('Without Sidebar','sea-theme'),                       'value' => 'without-sidebar')
	);
	$fields['theme_meta_post_content_width'] = array(
		array('title' => esc_html__('100%','sea-theme'),                         'value' => 'bm-width-100'),
		array('title' => esc_html__('90%','sea-theme'),                          'value' => 'bm-width-90'),
		array('title' => esc_html__('80%','sea-theme'),                       	'value' => 'bm-width-80'),
		array('title' => esc_html__('70%','sea-theme'),                       	'value' => 'bm-width-70'),
		array('title' => esc_html__('60%','sea-theme'),                       	'value' => 'bm-width-60'),
		array('title' => esc_html__('50%','sea-theme'),                       	'value' => 'bm-width-50')
	);
	$fields['theme_meta_audio_type'] = array(
		array('title' => esc_html__('Self Hosted Audio','sea-theme'),                     'value' => 'self-hosted-audio'),
		array('title' => esc_html__('Soundcloud','sea-theme'),                            'value' => 'soundcloud')
	);
	$fields['theme_meta_video_ratio'] = array(
		array('title' => esc_html__('4:3','sea-theme'),                                   'value' => '4:3'),
		array('title' => esc_html__('16:9','sea-theme'),                                  'value' => '16:9'),
		array('title' => esc_html__('Custom','sea-theme'),                                'value' => 'custom')
	);
	
	$fields['theme_meta_sidebar_widgets'] = seatheme_theme_register_sidebar('sidebars');
	
	$fields['theme_meta_enable_portfolio_list_layout_builder'] = array(
		array('title' => esc_html__('Layout 1','sea-theme'),                              'value' => 'list_layout_1'),
		array('title' => esc_html__('Layout 2','sea-theme'),                              'value' => 'list_layout_2'),
		array('title' => esc_html__('Layout 3','sea-theme'),                              'value' => 'list_layout_3'),
		array('title' => esc_html__('Layout 4','sea-theme'),                              'value' => 'list_layout_4'),
		array('title' => esc_html__('Layout Text','sea-theme'),                           'value' => 'list_layout_5')
	);
	
	$fields['theme_meta_page_template'] = array(
	array('title' => esc_html__('No Template','sea-theme'),                               'value' => 'none-template'),
	array('title' => esc_html__('Fullscreen Slider Template','sea-theme'),                'value' => 'fullscreen-slider-template')
	);
	
	$fields['theme_meta_page_logo_color_header'] = array(
	array('title' => esc_html__('Default Color','sea-theme'),                                      'value' => 'default-logo'),
	array('title' => esc_html__('Alternative Color','sea-theme'),                                     'value' => 'alt-logo')
	);

	$fields['theme_meta_page_menu_color_header'] = array(
	array('title' => esc_html__('Default Color','sea-theme'),                                      'value' => 'default-menu'),
	array('title' => esc_html__('Alternative Color','sea-theme'),                                     'value' => 'alt-menu')
	);

	$fields['theme_meta_page_logo_menu_color_expand'] = array(
	array('title' => esc_html__('Default Color','sea-theme'),                                      'value' => 'default-logo-menu-expand'),
	array('title' => esc_html__('Alternative Color','sea-theme'),                                     'value' => 'alt-logo-menu-expand')
	);

	$fields['theme_meta_page_logo_menu_color_mobile'] = array(
	array('title' => esc_html__('Default Color','sea-theme'),                                      'value' => 'default-logo-menu-mobile'),
	array('title' => esc_html__('Alternative Color','sea-theme'),                                     'value' => 'alt-logo-menu-mobile')
	);

	$fields['theme_meta_portfolio_logo_color'] = array(
	array('title' => esc_html__('Default Color','sea-theme'),                                      'value' => 'default-logo'),
	array('title' => esc_html__('Alternative Color','sea-theme'),                                     'value' => 'alt-logo')
	);

	$fields['theme_meta_portfolio_menu_color'] = array(
	array('title' => esc_html__('Default Color','sea-theme'),                                      'value' => 'default-menu'),
	array('title' => esc_html__('Alternative Color','sea-theme'),                                     'value' => 'alt-menu')
	);

	$fields['theme_meta_portfolio_logo_menu_color_expand'] = array(
	array('title' => esc_html__('Default Color','sea-theme'),                                      'value' => 'default-logo-menu-expand'),
	array('title' => esc_html__('Alternative Color','sea-theme'),                                     'value' => 'alt-logo-menu-expand')
	);

	$fields['theme_meta_portfolio_logo_menu_color_mobile'] = array(
	array('title' => esc_html__('Default Color','sea-theme'),                                      'value' => 'default-logo-menu-mobile'),
	array('title' => esc_html__('Alternative Color','sea-theme'),                                     'value' => 'alt-logo-menu-mobile')
	);
	
	$fields['theme_meta_page_background'] = array(
	array('title' => esc_html__('None','sea-theme'),                                      'value' => 'none'),
	array('title' => esc_html__('Static Color','sea-theme'),                              'value' => 'static-color')
	);
	
	//project config
	$fields['theme_meta_project_template'] = array(
	array('title' => esc_html__('No Template','sea-theme'),                               'value' => 'none'), 
	array('title' => esc_html__('Gallery on Left','sea-theme'),                           'value' => 'on_left'),
	array('title' => esc_html__('Gallery on Right','sea-theme'),                          'value' => 'on_right')
	);
	
	$fields['theme_meta_project_col_width'] = array(
	array('title' => esc_html__('1/2','sea-theme'),                                       'value' => '1/2'),
	array('title' => esc_html__('3/5','sea-theme'),                                       'value' => '3/5'),
	array('title' => esc_html__('2/3','sea-theme'),                                       'value' => '2/3'),
	array('title' => esc_html__('3/4','sea-theme'),                                       'value' => '3/4')
	);
	
	$fields['theme_meta_project_style'] = array(
	array('title' => esc_html__('Standard','sea-theme'),                                  'value' => 'standard'),
	array('title' => esc_html__('Filled','sea-theme'),                                    'value' => 'filled')
	);
	
	$fields['theme_meta_project_video_ratio'] = array(
		array('title' => esc_html__('4:3','sea-theme'),                                   'value' => '4:3'),
		array('title' => esc_html__('16:9','sea-theme'),                                  'value' => '16:9'),
		array('title' => esc_html__('Custom','sea-theme'),                                'value' => 'custom')
	);
	
	$fields['theme_meta_project_video_position'] = array(
		array('title' => esc_html__('Top of Gallery','sea-theme'),                        'value' => 'top'),
		array('title' => esc_html__('Bottom of Gallery','sea-theme'),                     'value' => 'bottom')
	);
	
	$fields['theme_meta_project_image_spacing'] = array(
	array('title' => esc_html__('0','sea-theme'),                                         'value' => '0'),
	array('title' => esc_html__('2','sea-theme'),                                         'value' => '2'),
	array('title' => esc_html__('10','sea-theme'),                                        'value' => '10'),
	array('title' => esc_html__('20','sea-theme'),                                        'value' => '20'),
	array('title' => esc_html__('40','sea-theme'),                                        'value' => '40'),
	array('title' => esc_html__('60','sea-theme'),                                        'value' => '60'),
	array('title' => esc_html__('80','sea-theme'),                                        'value' => '80')
	);

	$fields['theme_meta_featured_img_width'] = array( 
	array('title' => esc_html__('100%','sea-theme'),                                       'value' => '100%'),
	array('title' => esc_html__('90%','sea-theme'),                                        'value' => '90%'),
	array('title' => esc_html__('80%','sea-theme'),                                        'value' => '80%'),
	array('title' => esc_html__('70%','sea-theme'),                                        'value' => '70%'),
	array('title' => esc_html__('60%','sea-theme'),                                        'value' => '60%')
	);

	$fields['theme_meta_page_gallery_caption_align'] = array( 
	array('title' => esc_html__('Left','sea-theme'),                                      'value' => ''),
	array('title' => esc_html__('Center','sea-theme'),                                    'value' => 'center'),
	array('title' => esc_html__('Right','sea-theme'),                                     'value' => 'right')
	);

	$fields['theme_meta_portfolio_thumb_on_list'] = array( 
	array('title' => esc_html__('Featured Image','sea-theme'),                            'value' => 'none'),
	array('title' => esc_html__('Embed Video','sea-theme'),   						  	  'value' => 'embeded-video'), 
	array('title' => esc_html__('Hosted Video','sea-theme'),                              'value' => 'hosted-video')
	);

	$fields['theme_meta_portfolio_video_howplay'] = array( 
	array('title' => esc_html__('Play in List','sea-theme'),                     		  'value' => ''),
	array('title' => esc_html__('Play in Lightbox','sea-theme'),   					  	  'value' => 'lightbox')
	//array('title' => esc_html__('Autoplay','sea-theme'),   								   'value' => 'autoplay')
	);

	$fields['theme_meta_portfolio_video_howplay_hosted'] = array( 
	array('title' => esc_html__('Play in List','sea-theme'),                     		   'value' => ''),
	array('title' => esc_html__('Autoplay','sea-theme'),   								   'value' => 'autoplay'),
	array('title' => esc_html__('Play in Lightbox','sea-theme'),   					   	   'value' => 'lightbox')
	);
	
	return $fields;
}
add_filter('theme_config_select_fields', 'seatheme_theme_meta_select_fields');

//theme meta fields
function seatheme_theme_post_meta_fields(){
	$seatheme_theme_post_meta_fields = array(
		
		// Page
		'page' => array(
			array(
				'id'      => 'page-settings',
				'title'   => esc_html__('Settings','sea-theme'),
				'title_hidden' => false,
				'section' => array(
					array(
						'title' => esc_html__('Title','sea-theme'),
						'item'  => array(
						
							// Show Title
							array('title'       => esc_html__('Show Title Wrap','sea-theme'),
								  'description' => '',
								  'type'        => 'switch',
								  'name'        => 'theme_meta_page_show_title',
								  'default'     => 'true'),
						
							// Show Excerpt
							array('title'       => esc_html__('Show Excerpt','sea-theme'),
								  'description' => '',
								  'type'        => 'switch',
								  'name'        => 'theme_meta_page_show_excerpt',
								  'default'     => 'false',
								  'control'     => array('name'  => 'theme_meta_page_show_title',
														 'value' => 'true')),
								  
						)
					),
					array( 'item'  => array( array('type' => 'divider') ) ),
					array(
						'title' => esc_html__('Header & Footer','sea-theme'),
						'item'  => array(
						
							// Show Header
							array('title'       => esc_html__('Show Header','sea-theme'),
								  'description' => '',
								  'type'        => 'switch',
								  'name'        => 'theme_meta_page_show_header',
								  'default'     => 'true'),
								  
							array('title'       => esc_html__('Show Header when Scroll Down','sea-theme'),
								  'description' => '',
								  'type'        => 'switch',
								  'name'        => 'theme_meta_page_show_header_when_scroll_down',
								  'default'     => 'false',
								  'control'     => array('name'  => 'theme_meta_page_show_header',
														 'value' => 'true')),
								  
							array('title'       => esc_html__('Scroll Down Height to Activate Header','sea-theme'),
								  'description' => '',
								  'type'        => 'text',
								  'name'        => 'theme_meta_page_scroll_down_height',
								  'default'     => '400',
								  'col_size'	=> 'width:100px;',
								  'control'     => array('name'  => 'theme_meta_page_show_header_when_scroll_down',
														 'value' => 'true')),

							array('title'       => esc_html__('Transparent Header Background','sea-theme'),
								  'description' => '',
								  'type'        => 'switch',
								  'name'        => 'theme_meta_page_transparent_header_bg',
								  'default'     => 'false',
								  'control'     => array('name'  => 'theme_meta_page_show_header',
														 'value' => 'true')),

							array('title'       => esc_html__('Content From Page Top','sea-theme'),
								  'description' => '',
								  'type'        => 'switch',
								  'name'        => 'theme_meta_page_from_page_top',
								  'default'     => 'false'),

							array('title'       => esc_html__('Logo Color','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_page_logo_color_header',
								  'default'     => 'default-logo',
								  'col_size'    => 'width:200px;',
								  'control'     => array('name'  => 'theme_meta_page_show_header',
														 'value' => 'true')),

							array('title'       => esc_html__('Menu Color','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_page_menu_color_header',
								  'default'     => 'default-menu',
								  'col_size'    => 'width:200px;',
								  'control'     => array('name'  => 'theme_meta_page_show_header',
														 'value' => 'true')),

							array('title'       => esc_html__('Menu & Logo Color on Expanded Panel','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_page_logo_menu_color_expand',
								  'default'     => 'default-logo-menu-expand',
								  'col_size'    => 'width:200px;',
								  'control'     => array('name'  => 'theme_meta_page_show_header',
														 'value' => 'true')),

							array('title'       => esc_html__('Menu & Logo Color on Mobile','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_page_logo_menu_color_mobile',
								  'default'     => 'default-logo-menu-mobile',
								  'col_size'    => 'width:200px;',
								  'control'     => array('name'  => 'theme_meta_page_show_header',
														 'value' => 'true')),
						
							// Show Footer
							array('title'       => esc_html__('Show Footer','sea-theme'),
								  'description' => '',
								  'type'        => 'switch',
								  'name'        => 'theme_meta_page_show_footer',
								  'default'     => 'true'),
								  
						)
					),
					array( 'item'  => array( array('type' => 'divider') ) ),
					array(
						'title' => esc_html__('Background','sea-theme'),
						'item'  => array(
						
							// Background
							array('title'       => esc_html__('Background','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_page_background',
								  'col_size'	=> 'width:200px;',
								  'default'     => 'none'),
														 
							// Background Colour					 
							array('title'       => __('Background Colour','sea-theme'),
								  'description' => '',
								  'type'        => 'switch-color',
								  'name'        => 'theme_meta_page_background_color',
								  'default'     => '#ffffff',
								  'control'     => array('name'  => 'theme_meta_page_background',
														 'value' => 'static-color')),
														 
							// Text Colour					 
							array('title'       => __('Text Colour','sea-theme'),
								  'description' => '',
								  'type'        => 'switch-color',
								  'name'        => 'theme_meta_page_text_color',
								  'default'     => '#ffffff',
								  'control'     => array('name'  => 'theme_meta_page_background',
														 'value' => 'static-color')),
								  
						)
					),
				)
			),
			array(
				'id'      => 'page-template',
				'title'   => esc_html__('Template','sea-theme'),
				'title_hidden' => true,
				'section' => array(
					array(
						'item' => array(
						
							// Page Template
							array('title'       => esc_html__('Page Template','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_page_template',
								  'default'     => 'none-template')
						)
					)
				)
			),
		),
		
		// Single Post
		'post' => array(
			
			/* Select Images */
			array(
				'id'      => 'gallery-settings',
				'title'   => esc_html__('Gallery Setting','sea-theme'),
				'format'  => 'gallery',
				'section' => array(
					
					array(/* Format Gallery */
						'item' => array(
							
							// gallery
							array('title'       => esc_html__('Select Images','sea-theme'),
								  'type'        => 'gallery',
								  'description' => '',
								  'name'        => 'theme_meta_portfolio'),
								  
							array('type'        => 'divider'),
							
							

							))
				)
			),
			
			
			/* Audio Settings */
			array(
				'id'      => 'audio-settings',
				'title'   => esc_html__('Audio Settings','sea-theme'),
				'format'  => 'audio',
				'section' => array(
					
					array(/* Format Audio */
						'item' => array(
						
							// Audio Type
							array('title'       => esc_html__('Audio Type','sea-theme'),
								  'description' => '',
								  'type'        => 'image-select',
								  'size'        => '106:43',
								  'default'     => 'self-hosted-audio',
								  'name'        => 'theme_meta_audio_type'),
								  
							array('type'        => 'divider'),
							
							// Artist
							array('title'       => esc_html__('Artist','sea-theme'),
								  'description' => '',
								  'type'        => 'text',
								  'name'        => 'theme_meta_audio_artist',
								  'control'     => array('name'  => 'theme_meta_audio_type',
														 'value' => 'self-hosted-audio')),
								  
							// MP3
							array('title'       => esc_html__('MP3','sea-theme'),
								  'description' => '',
								  'type'        => 'social-medias',
								  'name'        => 'theme_meta_audio_mp3',
								  'special'     => 'mp3',
								  'placeholder' => array(esc_html__('Title','sea-theme'), esc_html__('URL','sea-theme')),
								  'control'     => array('name'  => 'theme_meta_audio_type',
														 'value' => 'self-hosted-audio')),
								  
							// Code for WP
							array('title'       => esc_html__('Code for WP','sea-theme'),
								  'type'        => 'textarea',
								  'name'        => 'theme_meta_audio_soundcloud',
								  'description' => esc_html__('*Format: https://soundcloud.com/imam-lepast-konyol/maher-zain-always-be-there-1','sea-theme'),
								  'control'     => array('name'  => 'theme_meta_audio_type',
														 'value' => 'soundcloud'))))
				)
			),
			
			/* Video Settings */
			array(
				'id'      => 'video-settings',
				'title'   => esc_html__('Video Settings','sea-theme'),
				'format'  => 'video',
				'section' => array(
					
					array(/* Format Video */
						'item' => array(
							
							// Description
							array('description' => esc_html__('You could find the embed code on the source video page.','sea-theme').'<div class="show-hide-guide-wrap"><a href="http://www.uiueux.com/forums/topic/how-to-insert-video-embed-code/" target="_blank"><span>?</span></a></div>',
								  'type'        => 'description'),
								  
							// Embeded Code
							array('title'       => esc_html__('Embed Code','sea-theme'),
								  'description' => '',
								  'type'        => 'textarea',
								  'name'        => 'theme_meta_video_embeded_code'),
								  
							// Ratio	  
							array('title'       => esc_html__('Ratio','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_video_ratio',
								  'default'     => '4:3'),
								  
							// Custom Ratio	  
							array('type'        => 'ratio',
								  'name'        => 'theme_meta_video_custom_ratio',
								  'description' => '',
								  'control'     => array('name'  => 'theme_meta_video_ratio',
														 'value' => 'custom'))))
				)
			),
			
			/* Quote Settings */
			array(
				'id' => 'quote-settings',
				'title' => esc_html__('Quote Settings','sea-theme'),
				'format' => 'quote',
				'section' => array(
				
					array(/* Format Quote */
						'item' => array(
							
							// The Quote
							array('title'       => esc_html__('The Quote','sea-theme'),
								  'description' => esc_html__('Write your quote in this field.','sea-theme'),
								  'type'        => 'textarea',
								  'name'        => 'theme_meta_quote'),
							
							// Cite 
							array('title'       => esc_html__('Cite','sea-theme'),
								  'description' => '',
								  'type'        => 'textarea',
								  'name'        => 'theme_meta_quote_cite')))
				)
			),
			
			/* Link Settings */
			array(
				'id' => 'link-settings',
				'title' => esc_html__('Link Settings','sea-theme'),
				'format' => 'link',
				'section' => array(
					
					array(/* Format Link */
						'item' => array(
						
							// Link Item
							array('title'       => esc_html__('Link Item','sea-theme'),
								  'description' => '',
								  'type'        => 'social-medias',
								  'name'        => 'theme_meta_link_item',
								  'special'     => 'mp3',
								  'placeholder' => array(esc_html__('Title','sea-theme'), esc_html__('URL','sea-theme'))),

							array('title'       => esc_html__('Opened in New Tab or Window','sea-theme'),
								  'description' => '',
								  'type'        => 'switch',
								  'name'        => 'theme_meta_link_item_target_blank', 
								  'default'     => 'false',
								  'col_size'    => 'width:50%;'),

							array('title'       => esc_html__('nofollow','sea-theme'),
								  'description'    => esc_html__('It is necessary to enable it if the URL is an external link. ','sea-theme') . esc_html__('Learn more','sea-theme').' https://en.wikipedia.org/wiki/Nofollow',
								  'type'        => 'switch',
								  'name'        => 'theme_meta_link_item_nofollow', 
								  'default'     => 'false',
								  'col_size'    => 'width:50%;'),
						)
					)
				)
			),	

			/* General Post Options */
			array(
				'id'      => 'post-options', 
				'title'   => esc_html__('General Options','sea-theme'),  
				'section' => array( 

					array(/* Sidebar */
						'item' => array(
							
							// Sidebar
							array('title'       => esc_html__('Sidebar','sea-theme'),
								  'description' => '',
								  'type'        => 'image-select',
								  'name'        => 'theme_meta_sidebar',
								  'size'        => '126:80',
								  'default'     => 'none',
								  'bind'        => array(
									  array('type'     => 'select',
											'name'     => 'theme_meta_sidebar_widgets',
											'col_size' => 'width:200px;',
											'position' => 'after'))),

							//Content Container Width
							array('title'       => esc_html__('Content Container Width','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_post_content_width', 
								  'default'     => '100%',
								  'col_size'    => 'width:50%;',
								  'control'     => array('name'  => 'theme_meta_sidebar',
															 'value' => 'without-sidebar')),
							
							array('title'       => esc_html__('Show Title Wrap','sea-theme'),
								  'description' => '',
								  'type'        => 'switch',
								  'name'        => 'theme_meta_post_show_title',
								  'format'      => 'image',
								  'default'     => 'true',
								  'col_size'    => 'width:50%;'),

							array('title'       => esc_html__('Show Featured Image','sea-theme'),
								  'description' => '',
								  'type'        => 'switch',
								  'name'        => 'theme_meta_featured_img_if',
								  // 'format'      => 'image',
								  'default'     => 'true',
								  'col_size'    => 'width:50%;'),

							array('title'       => esc_html__('Featured Image Width','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_featured_img_width',
								  // 'format'      => 'image',
								  'default'     => '100%',
								  'col_size'    => 'width:50%;',
								  'control'     => array('name'  => 'theme_meta_featured_img_if',
														 'value' => 'true')),
						)
					)
				)

			),
		),
		
		/* portfolio meta */
		'ux-portfolio' => array(

			/* Post Options */
			array(
				'id'      => 'post-options',
				'title'   => esc_html__('Layout Options','sea-theme'),
				'section' => array(
				
					array(
						'item' => array(
							
							// Layout Template
							array('title'       => esc_html__('Layout Template','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_project_template',
								  'col_size'    => 'width:50%;',
								  'default'     => 'none'),
								
							

							)),
					array(
						'super-control' => array(
							'name'  => 'theme_meta_project_template',
							'value' => 'none'
						),
						'item' => array(
							// Show Title
							array('title'       => esc_html__('Show Title','sea-theme'),
								  'description' => '',
								  'type'        => 'switch',
								  'name'        => 'theme_meta_portfolio_show_title',
								  'default'     => 'false'),
						  
								// Show Header
								array('title'       => esc_html__('Show Header','sea-theme'),
									  'description' => '',
									  'type'        => 'switch',
									  'name'        => 'theme_meta_portfolio_show_header',
									  'default'     => 'true'),
									  
								array('title'       => esc_html__('Show Header when Scroll Down','sea-theme'),
									  'description' => '',
									  'type'        => 'switch',
									  'name'        => 'theme_meta_portfolio_show_header_when_scroll_down',
									  'default'     => 'false',
									  'control'     => array('name'  => 'theme_meta_portfolio_show_header',
															 'value' => 'true')),
									  
								array('title'       => esc_html__('Scroll Down Height to Activate Header','sea-theme'),
									  'description' => '',
									  'type'        => 'text',
									  'name'        => 'theme_meta_portfolio_scroll_down_height',
									  'default'     => '400',
									  'control'     => array('name'  => 'theme_meta_portfolio_show_header_when_scroll_down',
															 'value' => 'true')),

								array('title'       => esc_html__('Transparent Header Background','sea-theme'),
									  'description' => '',
									  'type'        => 'switch',
									  'name'        => 'theme_meta_portfolio_transparent_header_bg',
									  'default'     => 'false',
									  'control'     => array('name'  => 'theme_meta_portfolio_show_header',
															 'value' => 'true')),

								array('title'       => esc_html__('Content From Page Top','sea-theme'),
									  'description' => '',
									  'type'        => 'switch',
									  'name'        => 'theme_meta_portfolio_from_page_top',
									  'default'     => 'false')
							 ),
					),
					array(
						'super-control' => array(
							'name'  => 'theme_meta_project_template',
							'value' => 'on_left|on_right'
						),
						'item' => array(
								  
							array('type'        => 'divider'),

							// gallery
							array('title'       => esc_html__('Select Images','sea-theme'),
								  'type'        => 'gallery',
								  'description' => '',
								  'name'        => 'theme_meta_portfolio'),

							// Gallery Layout Builder
							array('title'       => esc_html__('Gallery Layout Builder','sea-theme'),
								  'description' => '',
								  'type'        => 'layout-builder',
								  'name'        => 'theme_meta_enable_portfolio_list_layout_builder',
								  'default'     => 'list_layout_1'),
								  
							// Show Video
							array('title'       => esc_html__('Show Video','sea-theme'),
								  'description' => '',
								  'type'        => 'switch',
								  'name'        => 'theme_meta_show_project_video',
								  'default'     => 'false'),
							
							// Description
							array('description' => esc_html__('You could find the embed code on the source video page.','sea-theme').'<div class="show-hide-guide-wrap"><a href="http://www.uiueux.com/forums/topic/how-to-insert-video-embed-code/" target="_blank"><span>?</span></a></div>',
								  'type'        => 'description',
								  'control'     => array('name'  => 'theme_meta_show_project_video',
														 'value' => 'true')),
								  
							// Embeded Code
							array('title'       => esc_html__('Embed Code','sea-theme'),
								  'description' => '',
								  'type'        => 'textarea',
								  'name'        => 'theme_meta_project_video_embeded_code',
								  'control'     => array('name'  => 'theme_meta_show_project_video',
														 'value' => 'true')),
								  
							// Ratio	  
							array('title'       => esc_html__('Ratio','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_project_video_ratio',
								  'default'     => '4:3',
								  'control'     => array('name'  => 'theme_meta_show_project_video',
														 'value' => 'true')),
								  
							// Custom Ratio	  
							array('type'        => 'ratio',
								  'name'        => 'theme_meta_project_video_custom_ratio',
								  'description' => '',
								  'control'     => array('name'  => 'theme_meta_project_video_ratio',
														 'value' => 'custom')),
								  
							// Video Position	  
							array('title'       => esc_html__('Video Position','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_project_video_position',
								  'default'     => 'top',
								  'control'     => array('name'  => 'theme_meta_show_project_video',
														 'value' => 'true')),

							// Gallery Col Width
							array('title'       => esc_html__('Gallery Width','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_project_col_width',
								  'col_size'    => 'width:50%;',
								  'default'     => '1/2'),
								  
							// Gallery Style
							array('title'       => esc_html__('Gallery Style','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_project_style',
								  'col_size'    => 'width:50%;',
								  'default'     => 'standard'),
								  
							// Image Spacing
							array('title'       => esc_html__('Image Spacing','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_project_image_spacing',
								  'default'     => '40',
								  'col_size'    => 'width:50%;'),

							// Show Caption
							array('title'       => esc_html__('Show Image Caption','sea-theme'),
								  'description' => '',
								  'type'        => 'switch',
								  'name'        => 'theme_meta_show_gallery_caption',
								  'default'     => 'false'),

							//Caption align
							array('title'       => esc_html__('Caption Align','sea-theme'),
								  'description' => '',
								  'type'        => 'select',
								  'name'        => 'theme_meta_page_gallery_caption_align',
								  'default'     => 'left',
								  'col_size'    => 'width:50%;',
								  'control'     => array('name'  => 'theme_meta_show_gallery_caption',
														 'value' => 'true')),
								  
							array('type'        => 'divider'),

							//Hide Title
							array('title'       => esc_html__('Hide Title','sea-theme'),
								  'description' => '',
								  'type'        => 'switch',
								  'name'        => 'theme_meta_project_hide_title',
								  'default'     => 'false'),
							
							// Title Masking
							array('title'       => esc_html__('Title Text Masking','sea-theme'),
								  'description' => esc_html__('The Cover Image need be set. For Webkit Browser only, like Chrome, Safari','sea-theme'),
								  'type'        => 'switch',
								  'name'        => 'theme_meta_project_title_masking',
								  'default'     => 'false',
								  'control'     => array('name'  => 'theme_meta_project_hide_title',
														 'value' => 'false'))
						)
					)
				)
			),
			/* Sinlge Portfolio General Setting */
			array(
				'id'      => 'general-setting',
				'title'   => esc_html__('General Setting','sea-theme'),
				'section' => array(
					
					array(
						'item' => array(
							// Show Footer
								array('title'       => esc_html__('Show Footer','sea-theme'),
									  'description' => '',
									  'type'        => 'switch',
									  'name'        => 'theme_meta_portfolio_show_footer',
									  'default'     => 'false'),

								array('title'       => esc_html__('Logo Color','sea-theme'),
									  'description' => '',
									  'type'        => 'select',
									  'name'        => 'theme_meta_portfolio_logo_color',
									  'default'     => 'default-logo',
									  'col_size'    => 'width:200px;'),

								array('title'       => esc_html__('Menu Color','sea-theme'),
									  'description' => '',
									  'type'        => 'select',
									  'name'        => 'theme_meta_portfolio_menu_color',
									  'default'     => 'default-menu',
									  'col_size'    => 'width:200px;'),

								array('title'       => esc_html__('Menu & Logo on Expanded Panel Color','sea-theme'),
									  'description' => '',
									  'type'        => 'select',
									  'name'        => 'theme_meta_portfolio_logo_menu_color_expand',
									  'default'     => 'default-logo-menu-expand',
									  'col_size'    => 'width:200px;'),

								array('title'       => esc_html__('Menu & Logo on Mobile','sea-theme'),
									  'description' => '',
									  'type'        => 'select',
									  'name'        => 'theme_meta_portfolio_logo_menu_color_mobile',
									  'default'     => 'default-logo-menu-mobile',
									  'col_size'    => 'width:200px;'),

								)
					),
					array(
						'item' => array(

							array('type'        => 'divider'),
							
							// thumbnail
							array('title'       => esc_html__('Thumbnail in Grid/Masonry Grid','sea-theme'),
								  'description' => esc_html__('It will be shown on Thumbnail of Grid/Masonry Grid of Content Builder','sea-theme'),
								  'type'        => 'select',
								  'name'        => 'theme_meta_portfolio_thumb_on_list',
								  'default'     => 'none',
								  'col_size'    => 'width:200px;'),
								
							)
					),
					array(
						'super-control' => array(
							'name'  => 'theme_meta_portfolio_thumb_on_list',
							'value' => 'embeded-video'
						),
						'item' => array(

								array('title'       => esc_html__('Embed Video URL','sea-theme'),
									  'description' => esc_html__('Please enter the YouTube or Vimeo video URL eg: https://vimeo.com/339906947 or https://www.youtube.com/watch?v=_nZ2MW4gPNw','sea-theme'),
									  'type'        => 'text',
									  'name'        => 'theme_meta_portfolio_thumb_embed_video',
									  'default'     => ''),

								// how to play  
								array('title'       => esc_html__('How to Play','sea-theme'),
									  'type'        => 'select',
								  	  'name'        => 'theme_meta_portfolio_video_howplay',
								  	  'description' => esc_html__('The video will be muted if select Autoplay','sea-theme'),
								  	  'col_size'    => 'width:200px;'),
						)
					),

					array(
						'super-control' => array(
							'name'  => 'theme_meta_portfolio_thumb_on_list',
							'value' => 'hosted-video'
						),
						'item' => array(

								array('title'       => esc_html__('MP4 Video URL','sea-theme'),
									  'type'        => 'text',
									  'name'        => 'theme_meta_portfolio_thumb_video_mp4',
									  'placeholder' => esc_html__('.mp4 or .m4v Video URL','sea-theme'),
									  'default'     => ''),

								array('title'       => esc_html__('WEBM Video URL','sea-theme'),
									  'type'        => 'text',
									  'name'        => 'theme_meta_portfolio_thumb_video_webm',
									  'placeholder' => esc_html__('.webm Video URL','sea-theme'),
									  'default'     => ''),

								array('title'       => esc_html__('OGG Video URL','sea-theme'),
									  'type'        => 'text',
									  'name'        => 'theme_meta_portfolio_thumb_video_ogg',
									  'placeholder' => esc_html__('.ogg or .ogv Video URL','sea-theme'),
									  'default'     => ''),

								// how to play  
								array('title'       => esc_html__('How to Play','sea-theme'),
									  'type'        => 'select',
								  	  'name'        => 'theme_meta_portfolio_video_howplay_hosted',
								  	  'description' => esc_html__('The video will be muted if select Autoplay','sea-theme'),
								  	  'col_size'    => 'width:200px;'),

								
			
						)
					),
					array(
						'super-control' => array(
							'name'  => 'theme_meta_portfolio_thumb_on_list',
							'value' => 'hosted-video|embeded-video'
						),
						'item' => array(
							// Custom Ratio	  
								array('title'       => esc_html__('Video Ratio','sea-theme'),
									  'type'        => 'ratio',
								  	  'name'        => 'theme_meta_portfolio_video_ratio',
								  	  'description' => esc_html__('The default is 16 and 9. You could enter the video width and height. How: ','sea-theme').' https://doc.seatheme.net/sea/portfolio/grid-masonry-grid-thumbnail-video/'
								),

						)
					)
	
				)
			)
		)
	);
	$seatheme_theme_post_meta_fields = apply_filters('ux_theme_post_meta_fields', $seatheme_theme_post_meta_fields);
	return $seatheme_theme_post_meta_fields;
}
$GLOBALS['ux_theme_post_meta_fields'] = seatheme_theme_post_meta_fields();

//require theme meta interface
require_once get_template_directory() . '/functions/theme/post/post-meta-interface.php';
?>