<div id="ux-option-interface-about" class="wrap ux-option-about">
    <div class="icon32" id="icon-themes"><br></div>
    <h3 class="ux-option-title"><?php esc_html_e( 'Welcome to SEA', 'sea-theme' ); ?></h3>
	<div class="ux-option-des">
		<?php esc_html_e( 'SEA theme is now installed and ready to use with your WordPress site.', 'sea-theme' ); ?>
		<?php $seaGetData = wp_get_theme(); ?>
		<div class="ux-option-version">
			<span class="ux-option-version-icon"></span>
			<?php esc_html_e( 'Version: ', 'sea-theme' ); echo esc_html( $seaGetData->get( 'Version' ) ); ?>
		</div>
	</div>
	
	<div class="ux-theme-box">
		<div class="ux-theme-tabs tabs-horizontal">
			<ul class="nav nav-tabs">
				<li class="active">
					<a href="#content-about" data-toggle="tab"><?php esc_html_e( 'What’s New', 'sea-theme' ); ?></a>
				</li>
				<li>
					<a href="<?php echo admin_url( 'admin.php?page=theme-option-help' ); ?>" data-toggle="tab" data-target="open"><?php esc_html_e( 'Help', 'sea-theme' ); ?></a>
				</li>
			</ul>

			<div class="tab-content">
				<div id="content-about" class="tab-pane active">
					<div class="theme-option-field-region">
						<?php
						$activeSwitch = false;
						if ( ! $UxThemeActivated = get_option( 'UxThemeActivated' ) ) {
							update_option( 'UxThemeActivated', 1 );
							$activeSwitch = true;
						}
						
						if ( $activeSwitch ) { ?>
							<div class="active-tips">
								<h3 class="">Thanks for choosing SEA theme!</h3>
								<p>Here are the first steps to setup the theme:</p>
								<ol>
									<li>Install and activate <strong>BM Content Builder</strong> by <a href="<?php echo admin_url( 'admin.php?page=tgmpa-install-plugins' ); ?>">clicking here</a></li>
									<li><a href="<?php echo admin_url( 'admin.php?page=ux-cb-tools' ); ?>"><strong>Import demo data</strong></a> (requires BM Content Builder activated)</li>
									<li>Configure <a href="<?php echo admin_url( 'admin.php?page=theme-option' ); ?>"><strong>theme options</strong></a> (logo, color, social, and etc)</li>
									<li>Refer to our theme <a href="https://doc.seatheme.net/theme/sea/" target="_blank">documentation</a> and learn how to setup SEA (recommended)</li>
								</ol>
							</div>
						<?php } ?>
						
						<div class="what-is-new">
							<h3><?php esc_html_e( 'What’s New?', 'sea-theme' ); ?></h3>
							<div>
								<?php esc_html_e( 'Version: ', 'sea-theme' ); echo esc_html( $seaGetData->get( 'Version' ) ); ?> -  Jan 8, 2020
							</div>
							<ul class="whatsnew-list">
								<li class="whatsnew-list-li">
									<div class="whatsnew-list-li-inn">
										<h5>Add: Post Navigation</h5>
										<div class="whatsnew-list-li-des">Added the "Post Navigation" module(<a href="https://sea.uiueux.com/creative/ux-portfolio/mon-choco/">check the demo</a>).</div>
									</div>
								</li>
								<li class="whatsnew-list-li">
									<div class="whatsnew-list-li-inn">
										<h5>Add: Bakkground Image</h5>
										<div class="whatsnew-list-li-des">Added the Background Image option in Customize panel.
										</div>
									</div>
								</li>
								 
								
							</ul>
							<p style="text-align:center;"><a class="ux-doc-link" href="https://www.uiueux.com/forums/topic/sea-wordpress-theme-update-log/">Check All Changelog</a></p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>