<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Theme Options field checkbox.
 */
if ( ! function_exists( 'seatheme_theme_options_field_checkbox' ) ) {
	function seatheme_theme_options_field_checkbox( $item, $key, $getValue ) {
		if ( $item['type'] == 'checkboxGroup' ) {
			$className = false;
			$number = 50;
			if ( $item['source'] != 'custom' ) {
				$item['fields'] = array();
				$terms = get_terms( $item['tax'], array(
					'hide_empty' => false,
					'number' => $number
				) );
				
				if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
					foreach ( $terms as $term ) {
						$item['fields'][] = array( $term->name, $term->term_id );
					}
				}

				$className = 'cate';
			}
			
			if ( ! is_array( $getValue ) ) { $getValue = array( $getValue ); }
			
			echo '<ul class="nav nav-pills ux-theme-checkbox-group ux-theme-checkbox-group-'.esc_attr( $className ).'">';
			
				foreach ( $item['fields'] as $field ) {
					$value = false;
					if ( in_array( $field[1], $getValue ) ) {
						$value = $field[1];
					}
					echo '<li>';
                    echo   '<input type="checkbox" name="' .esc_attr( $key. '[' .$item['name']. '][]' ). '" value="' .esc_attr( $field[1] ). '" ' .checked( $value, $field[1], false ). '>';
					echo   '<span class="pull-left">' .esc_html( $field[0] ). '</span>';
                    echo '</li>';
				}
				
				if ( $item['source'] != 'custom' ) {
					$countTerms = wp_count_terms( $item['tax'], array( 'hide_empty' => false ) );
						if ( $item['span'] && ( ! is_wp_error( $countTerms ) ) ) {
							if ( intval( $countTerms ) > $number ) {
								echo '<li><button type="button" class="more-categories" data-taxonomy="' .esc_attr( $item['tax'] ). '" data-count="' .esc_attr( $countTerms ). '" data-value="' .esc_attr( join( ',', $getValue ) ). '">' .esc_html( $item['span'] ). '</button></li>';
							}
						}
				}
			
			echo '</ul>';
		}
	}
	add_action( 'seatheme_theme_options_get_field', 'seatheme_theme_options_field_checkbox', 10, 3 );
}

?>