<?php
//layoutr setting config fields
if ( ! function_exists( 'seatheme_theme_options_layoutr_fields' ) ) {
	function seatheme_theme_options_layoutr_fields( $fields ) {
		$fields['layout'] = array(
			'id' => 'options-layout',
			'title' => esc_html__( 'Content', 'sea-theme' ),
			'region' => array(  
				array(
					'region-id' => 'layout-post-page',
					'title' => esc_html__( 'Page/Post', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										// Title top spacing
										array('title'   => esc_html__( 'Title Top Spacing for Single Post', 'sea-theme' ),
											  'desc'    => esc_html__( 'For single post', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_post_title_top_spacing',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),
				  
										// Title bottom spacing
										array('title'   => esc_html__( 'Title Bottom Spacing for Single Post', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_post_title_bottom_spacing',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),
				  
										//Title Indent
										array('title'   => esc_html__( 'Title Indent for Single Post', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_post_title_indent',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),
											 
										// Show Meta On Post Page
										array('title'   => esc_html__( 'Show Meta Info for Single Post', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_enable_meta_post_page',
											  'default' => 'true' )
									)
								),
								array(
									'group-ctrl' => 'theme_option_enable_meta_post_page,true',
									'items' => array(
				  
										array('type'    => 'checkboxGroup',
											  'source'  => 'custom',
											  'name'    => 'theme_option_posts_showmeta',
											  'default' => array( 'date', 'category', 'tag', 'author', 'comments' ),
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ),
											  'fields'  => array(
												  array( esc_html__( 'Date', 'sea-theme' ),     'date' ), 
												  array( esc_html__( 'Category', 'sea-theme' ), 'category' ), 
												  array( esc_html__( 'Tag', 'sea-theme' ),      'tag' ), 
												  array( esc_html__( 'Author', 'sea-theme' ),   'author' ),
												  array( esc_html__( 'Comments', 'sea-theme' ), 'comments' )
											  ) ),
				   
										array('title'   => esc_html__( 'Meta Info Bottom Spacing', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_post_meta_bottom_spacing',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) )
									)
								),
								array(
									'items' => array(
				  
										// Category to Hide on Page Post
										array('title'   => esc_html__( 'Category Name to Hide on Page/Post', 'sea-theme' ),
											  'type'    => 'checkboxGroup',
											  'source'  => 'term',
											  'name'    => 'theme_option_hide_category_on_post_page',
											  'default' => array(),
											  'tax'     => 'category',
											  'span'    => esc_html__( 'More categories', 'sea-theme' ) ),
				  
										// Category to Hide on Page Post
										array('title'   => esc_html__( 'Category Name to Hide on Portfolio post', 'sea-theme' ),
											  'type'    => 'checkboxGroup',
											  'source'  => 'term',
											  'name'    => 'theme_option_hide_ux-portfolio-cat_on_post_page',
											  'default' => array(),
											  'tax'     => 'ux-portfolio-cat',
											  'span'    => esc_html__( 'More categories', 'sea-theme' ) ),
				  
										// Category to Hide on Page Post
										array('title'   => esc_html__( 'Category Name to Hide on Product', 'sea-theme' ),
											  'type'    => 'checkboxGroup',
											  'source'  => 'term',
											  'name'    => 'theme_option_hide_product_cat_on_post_page',
											  'default' => array(),
											  'tax'     => 'product_cat',
											  'span'    => esc_html__( 'More categories', 'sea-theme' ) ),
				  
										// Enable Share Buttons for Other Post Format'
										array('title'   => esc_html__( 'Share Buttons On Normal Post', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_show_share_button_other',
											  'default' => 'true' ),
				  
										// Show Post (Previous/Next) Navigation On Normal Post
										array('title'   => esc_html__( 'Post Previous & Next On Normal Post', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_show_normal_post_navigation',
											  'default' => 'false' ),
											  
										// Show a Generic Section on Bottom of Single Project Page
										array('title'   => esc_html__( 'Show a Generic Section on Bottom of Single Project Page', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_show_generic_section_on_bottom',
											  'default' => 'false' )
									)
								),
								array(
									'group-ctrl' => 'theme_option_show_generic_section_on_bottom,true',
									'items' => array(
											  
										// Choose a Page for This Section
										array('title'   => esc_html__( 'Choose a Page for This Section', 'sea-theme' ),
											  'type'    => 'post',
											  'pType'   => 'page',
											  'name'    => 'theme_option_show_generic_section_on_bottom_page_id',
											  'default' => 0 )
									)
								)
							)
						)
					)
				),
  
				array(
					'region-id' => 'layout-lightbox',
					'title' => esc_html__( 'Lightbox', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										array('title'   => esc_html__( 'Disable Zoom button', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_lightbox_disable_zoom',
											  'default' => 'false' ),
									 
										array('title'   => esc_html__( 'Disable FullScreen button', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_lightbox_disable_fullscreen',
											  'default' => 'false' ),
				
										array('title'   => esc_html__( 'Disable Share and Download', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_lightbox_disable_share_download',
											  'default' => 'false' ),
				
										array('title'   => esc_html__( 'Disable Download Only', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_lightbox_disable_download',
											  'default' => 'false' ), 
									)
								)
							)
						)
					)
				)		
			)
		);
		
		return $fields;
	}
	add_filter( 'seatheme_theme_options_fields', 'seatheme_theme_options_layoutr_fields' );
}