<?php
//footer setting config fields
if ( ! function_exists( 'seatheme_theme_options_footer_fields' ) ) {
	function seatheme_theme_options_footer_fields( $fields ) {
		$fields['footer'] = array(
			'id' => 'options-footer',
			'title' => esc_html__( 'Footer', 'sea-theme' ),
			'region' => array(
				array(
					'region-id' => 'footer-layout',
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										// Footer Section Top/Bottom Padding
										array('title'   => esc_html__( 'Footer Section Top/Bottom Padding', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_footer_topbottom_spacing',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'default' => array( '40', '20' ),
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),
				
										// Footer Elements
										array('title'   => esc_html__( 'Footer Elements', 'sea-theme' ),
											  'type'    => 'items',
											  'name'    => 'theme_option_footer_elements', 
											  'default' => 'logo',
											  'fields'  => array(
												  array( esc_html__( 'Logo', 'sea-theme' ),          'logo' ),
												  array( esc_html__( 'Copyright', 'sea-theme' ),     'copyright' ),
												  array( esc_html__( 'Menu', 'sea-theme' ),          'menu' ),
												  array( esc_html__( 'Text', 'sea-theme' ),          'text' ),
												  array( esc_html__( 'Social Links', 'sea-theme' ),  'social' ),
												  array( esc_html__( 'WPML Switcher', 'sea-theme' ), 'language' ),
												  array( esc_html__( 'Widget', 'sea-theme' ),        'widget' )
											  ) ),
				
										// Footer Elements Align
										array('title'   => esc_html__( 'Footer Elements Arrange Direction', 'sea-theme' ),
											  'type'    => 'select',
											  'name'    => 'theme_option_footer_elements_align',
											  'style'   => 'width: 300px;',
											  'default' => 'horizon',
											  'fields'  => array(
												  array( esc_html__( 'Horizon', 'sea-theme' ),  'horizon' ),
												  array( esc_html__( 'Vertical', 'sea-theme' ), 'vertical' )
											  ) )
									)
								),
								array(
									'group-ctrl' => 'theme_option_footer_elements_align,horizon',
									'items' => array(
				
										// Footer Horizon Align
										array('title'   => esc_html__( 'Footer Elements Align', 'sea-theme' ),
											  'type'    => 'select',
											  'name'    => 'theme_option_footer_horizon_align',
											  'style'   => 'width: 300px;',
											  'default' => 'footer-horizon-left',
											  'fields'  => array(
												  array( esc_html__( 'Left', 'sea-theme' ),   'footer-horizon-left' ),
												  array( esc_html__( 'Center', 'sea-theme' ), 'footer-horizon-center' ),
												  array( esc_html__( 'Right', 'sea-theme' ),  'footer-horizon-right' ),
												  array( esc_html__( 'Equal', 'sea-theme' ),  'footer-horizon-equal' )
											  ) ),
				
										// Footer Horizon Spacing
										array('title'   => esc_html__( 'Footer Elements Horizon Spacing', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_footer_horizon_spacing',
											  'style'   => 'width: 102px;' )
									)
								),
								array(
									'group-ctrl' => 'theme_option_footer_elements_align,vertical',
									'items' => array(
				
										// Footer Vertical Align
										array('title'   => esc_html__( 'Footer Elements Align', 'sea-theme' ),
											  'type'    => 'select',
											  'name'    => 'theme_option_footer_vertical_align',
											  'style'   => 'width: 300px;',
											  'default' => 'footer-vertical-left',
											  'fields'  => array(
												  array( esc_html__( 'Left', 'sea-theme' ),   'footer-vertical-left' ),
												  array( esc_html__( 'Center', 'sea-theme' ), 'footer-vertical-center' ),
												  array( esc_html__( 'Right', 'sea-theme' ),  'footer-vertical-right' )
											  ) ),
				
										// Footer Vertical Spacing
										array('title'   => esc_html__( 'Footer Elements Vertical Spacing', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_footer_vertical_spacing',
											  'style'   => 'width: 102px;' )
									)
								),
								array(
									'items' => array(
				
										// Enable Back-Top Button
										array('title'   => esc_html__( 'Enable Back-To-Top Button', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_enable_backtop',
											  'default' => 'true' )
									)
								),
								array(
									'group-ctrl' => 'theme_option_enable_backtop,true',
									'items' => array(
				
										// Back To Top Icon 
										array('title'   => esc_html__( 'Icon for Back-To-Top Button ', 'sea-theme' ),
											  'type'    => 'upload',
											  'name'    => 'theme_option_top_back_icon_svg_code' ), 
				
										// Back To Top Icon Container
										array('title'   => esc_html__( 'Height for Back-To-Top Button', 'sea-theme' ),
											  'type'    => 'input',
											  'style'	=> 'width: 102px',
											  'name'    => 'theme_option_top_back_icon_height' ), 
				
										// Enable Back-Top Button
										array('title'   => esc_html__( 'Bottom Spacing for Back-To-Top Button', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_enable_backtop_spacing_bottom',
											  'default' => '72',
											  'style'   => 'width: 102px;' )
									)
								),
								array(
									'items' => array(
				
										//Horizontal Spacing for Footer Menu Items
										array('title'   => esc_html__( 'Horizontal Spacing for Footer Menu Items', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_horizon_spacing_footer_menuitem', 
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) )
				
									)
								)
							)
						)
					)
				),

				array(
					'region-id' => 'footer-layout-mobile',
					'title' => esc_html__( 'Footer on Mobile', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(

										// Footer Elements Align on Mobile
										array('title'   => esc_html__( 'Footer Elements Arrange Direction on Mobile', 'sea-theme' ),
											  'type'    => 'select',
											  'name'    => 'theme_option_footer_elements_align_mobile',
											  'style'   => 'width: 300px;',
											  'default' => 'horizon-mobile',
											  'fields'  => array(
												  array( esc_html__( 'Horizon', 'sea-theme' ),  'horizon-mobile' ),
												  array( esc_html__( 'Vertical', 'sea-theme' ), 'vertical-mobile' )
											  ) 
										),
										// Enable Back-Top Button
										array('title'   => esc_html__( 'Enable Back-To-Top Button on Mobile', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_enable_backtop_mobile',
											  'default' => 'false' 
										)
									)
								),
								array(
									'group-ctrl' => 'theme_option_footer_elements_align_mobile,horizon-mobile',
									'items' => array(
				
										// Footer Horizon Align on Mobile
										array('title'   => esc_html__( 'Footer Elements Align on Mobile', 'sea-theme' ),
											  'type'    => 'select',
											  'name'    => 'theme_option_footer_horizon_align_mobile',
											  'style'   => 'width: 300px;',
											  'default' => 'footer-horizon-left-mobile',
											  'fields'  => array(
												  array( esc_html__( 'Left', 'sea-theme' ),   'footer-horizon-left-mobile' ),
												  array( esc_html__( 'Center', 'sea-theme' ), 'footer-horizon-center-mobile' ),
												  array( esc_html__( 'Right', 'sea-theme' ),  'footer-horizon-right-mobile' ),
												  array( esc_html__( 'Equal', 'sea-theme' ),  'footer-horizon-equal-mobile' )
											  ) )
									)
								),
								array(
									'group-ctrl' => 'theme_option_footer_elements_align_mobile,vertical-mobile',
									'items' => array(
				
										// Footer Vertical Align on Mobile
										array('title'   => esc_html__( 'Footer Elements Align on Mobile', 'sea-theme' ),
											  'type'    => 'select',
											  'name'    => 'theme_option_footer_vertical_align_mobile',
											  'style'   => 'width: 300px;',
											  'default' => 'footer-vertical-left-mobile',
											  'fields'  => array(
												  array( esc_html__( 'Left', 'sea-theme' ),   'footer-vertical-left-mobile' ),
												  array( esc_html__( 'Center', 'sea-theme' ), 'footer-vertical-center-mobile' ),
												  array( esc_html__( 'Right', 'sea-theme' ),  'footer-vertical-right-mobile' )
											  ) )
									)
								),
								array(
									'group-ctrl' => 'theme_option_footer_elements_align_mobile,horizon-mobile',
									'items' => array(
				
										// Footer Horizon Spacing on Mobile
										array('title'   => esc_html__( 'Footer Elements Horizon Spacing on Mobile', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_footer_horizon_spacing_mobile',
											  'style'   => 'width: 102px;' )
									)
								),
								array(
									'group-ctrl' => 'theme_option_footer_elements_align_mobile,vertical-mobile',
									'items' => array(
				
										// Footer Vertical Spacing on Mobile
										array('title'   => esc_html__( 'Footer Elements Vertical Spacing on Mobile', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_footer_vertical_spacing_mobile',
											  'style'   => 'width: 102px;' )
									)
								)
							)
						)
					)
				)
			)
		);
		
		return $fields;
	}
	add_filter( 'seatheme_theme_options_fields', 'seatheme_theme_options_footer_fields' );
}