<?php
//cookies setting config fields
if ( ! function_exists( 'seatheme_theme_options_cookies_fields' ) ) {
	function seatheme_theme_options_cookies_fields( $fields ) {
		$fields['cookies'] = array(
			'id' => 'options-cookies',
			'title' => esc_html__( 'Privacy and Cookies', 'sea-theme' ),
			'region' => array(
				array(
					'region-id' => 'privacy-policy',
					'title' => esc_html__( 'Privacy Policy', 'sea-theme' ),
					'desc' => esc_html__( 'Append a privacy policy message for unregistered users to comment form?', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										// Message below comment form
										array('title'   => esc_html__( 'Message below comment form', 'sea-theme' ),
											  'desc'    => esc_html__( 'Check to append a message to the comment form for unregistered users. Commenting without consent is no longer possible', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_cookie_comment_message',
											  'default' => 'false' ),
									
										array('type'    => 'textarea',
											  'name'    => 'theme_option_cookie_comment_message_text',
											  'ctrl'	=> 'theme_option_cookie_comment_message,true',
											  'default' => esc_html__( 'I agree to the terms and conditions laid out in the <a href="http://the-privacy-page-url" target="_blank">Privacy Policy</a>', 'sea-theme' )  )
									)
								)
							)
						)
					)
				),
				array(
					'region-id' => 'cookie-message-bar',
					'title' => esc_html__( 'Cookie Consent Message Bar', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										// Enable cookie consent message bar
										array('title'   => esc_html__( 'Enable cookie consent message bar', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_cookie_consent_bar',
											  'default' => 'false' )
									)
								),
								array(
									'group-ctrl' => 'theme_option_cookie_consent_bar,true',
									'items' => array(
									
										array('title'   => esc_html__( 'Massage', 'sea-theme' ),
											  'type'    => 'textarea',
											  'default' => esc_html__( 'This site uses cookies. By continuing to browse the site, you are agreeing to our use of cookies.', 'sea-theme' ),	
											  'name'    => 'theme_option_cookie_consent_bar_massage',
											  'ctrl'	=> 'theme_option_cookie_consent_bar,true' ),
				
										// Text Color for message bar
										array('title'   => esc_html__( 'Text Color for message bar', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_cookie_consent_bar_text_color',
											  'style'   => 'width: 200px;',
											  'default' => '#313139' ),
				
										// BG Color for message bar
										array('title'   => esc_html__( 'BG Color for message bar', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_cookie_consent_bar_bg_color',
											  'style'   => 'width: 200px;',
											  'default' => '#f8f8f8' ),
				
										// Message bar position
										array('title'   => esc_html__( 'Message bar position', 'sea-theme' ),
											  'type'    => 'select',
											  'name'    => 'theme_option_cookie_consent_bar_position',
											  'style'   => 'width: 132px;',
											  'default' => 'bottom',
											  'fields'  => array(
												  array( esc_html__( 'Bottom', 'sea-theme' ), 'bottom' ),
												  array( esc_html__( 'Top', 'sea-theme' ), 'top'),
												  array( esc_html__( 'Bottom Left', 'sea-theme' ), 'bottom-left'),
												  array( esc_html__( 'Bottom Right', 'sea-theme' ), 'bottom-right'),
												  array( esc_html__( 'Top Left', 'sea-theme' ), 'top-left'),
												  array( esc_html__( 'Top Right', 'sea-theme' ), 'top-right')
											  ) ),

										array('title'   => esc_html__( 'Inner Padding', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_cookie_inner_padding', 
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'default' => array('15', '10'),
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),
										
										array('type' => 'divider')
									)
								),
								array(
									'title' => esc_html__( 'Buttons', 'sea-theme' ),
									'group-ctrl' => 'theme_option_cookie_consent_bar,true',
									'items' => array(

										// Buttons Height
										array('title'   => esc_html__( 'Buttons Height', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_cookie_button_height', 
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'default' => array('38', '28'),
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),

										// Button label for "Dismiss the message bar"
										array('title'   => esc_html__( 'Button Border Width', 'sea-theme' ),
											  'type'    => 'select',
											  'style'   => 'width: 100px;',
											  'name'    => 'theme_option_cookie_button_border_width',
											  'fields'  => array(
												  array( esc_html__( 'None', 'sea-theme' ),  'none' ),
												  array( esc_html__( '1px', 'sea-theme' ),   '1px' ),
												  array( esc_html__( '2px', 'sea-theme' ),   '2px' ),
												  array( esc_html__( '3px', 'sea-theme' ),   '3px' ),
												  array( esc_html__( '4px', 'sea-theme' ),   '4px' ),
												  array( esc_html__( '5px', 'sea-theme' ),   '5px' ),
												  array( esc_html__( '6px', 'sea-theme' ),   '6px' ),
												  array( esc_html__( '7px', 'sea-theme' ),   '7px' ),
												  array( esc_html__( '8px', 'sea-theme' ),   '8px' ),
												  array( esc_html__( '9px', 'sea-theme' ),   '9px' ),
												  array( esc_html__( '10px', 'sea-theme' ),  '10px' ),
											  ) ),

										// Button label for "Dismiss the message bar"
										array('title'   => esc_html__( 'Button label for "Dismiss the message bar"', 'sea-theme' ),
											  'type'    => 'input',
											  'style'   => 'width: 302px;',
											  'default' => esc_html__( 'OK', 'sea-theme' ),
											  'name'    => 'theme_option_cookie_button_dismiss_label' ),
				
										// Button label Color "Dismiss the message bar"
										array('title'   => esc_html__( 'Button label Color "Dismiss the message bar"', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_cookie_button_dismiss_label_color',
											  'style'   => 'width: 200px;',
											  'default' => '#ffffff' ),
				
										// Button BG Color "Dismiss the message bar"
										array('title'   => esc_html__( 'Button BG Color "Dismiss the message bar"', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_cookie_button_dismiss_label_bg_color',
											  'style'   => 'width: 200px;',
											  'default' => '#313139' ),

										// Button Border Color "Dismiss the message bar"
										array('title'   => esc_html__( 'Button Border Color "Dismiss the message bar"', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_cookie_button_dismiss_border_color',
											  'style'   => 'width: 200px;',
											  'default' => '#313139' ),
				
										// Button label for "Learn More"
										array('title'   => esc_html__( 'Button label for "Learn More"', 'sea-theme' ),
											  'type'    => 'input',
											  'style'   => 'width: 302px;',
											  'default' => esc_html__( 'Learn More', 'sea-theme' ),
											  'name'    => 'theme_option_cookie_button_more_label' ),
				
										// URL for "Learn More" Button
										array('title'   => esc_html__( 'URL for "Learn More" Button"', 'sea-theme' ),
											  'type'    => 'input',
											  'style'   => 'width: 302px;',
											  'name'    => 'theme_option_cookie_button_more_url' ),
				
										// Button label Color "Learn More"
										array('title'   => esc_html__( 'Button label Color "Learn More"', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_cookie_button_more_label_color',
											  'style'   => 'width: 200px;',
											  'default' => '#ffffff' ),
				
										// Button BG Color "Learn More"
										array('title'   => esc_html__( 'Button BG Color "Learn More"', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_cookie_button_more_label_bg_color',
											  'style'   => 'width: 200px;',
											  'default' => '#666666' ),

										// Button Border Color "Learn More"
										array('title'   => esc_html__( 'Button Border Color "Learn More"', 'sea-theme' ),
											  'type'    => 'switchColor',
											  'name'    => 'theme_option_cookie_button_more_border_color',
											  'style'   => 'width: 200px;',
											  'default' => '#666666' )
									)
								)
							)
						)
					)
				)
			)
		);
		return $fields;
		
	}
	add_filter( 'seatheme_theme_options_fields', 'seatheme_theme_options_cookies_fields' );
}