(function($){

  "use strict";
	
	var UxThemes                    = [];
	
	//window
	UxThemes.win                    = $(window);
	
	//document
	UxThemes.doc                    = $(document);
	
	//selector
	UxThemes.body                   = $('body');
	UxThemes.optionsFieldRegions    = $('.theme-option-field-region');
	UxThemes.optionsFieldSections   = $('.theme-option-field-section');
	UxThemes.optionsFieldGroups     = $('.theme-option-field-group');
	UxThemes.optionsFieldItems      = $('.theme-option-field-item');
	UxThemes.optionsFooterElItems   = $('.ux-theme-footer-element-item');
	UxThemes.optionsRestoreDefaults = $('.restore_defaults');
	UxThemes.optionsTabs            = $('.ux-theme-tabs');
	UxThemes.optionsForm            = $('form#ux-theme-option-form');
	UxThemes.optionsSocialMedias    = $('.ux-theme-new-social-medias');
	UxThemes.optionsSubmitButton    = $('.ux-theme-option-submit');
	
	//fn control container
	UxThemes.fnControlContainer = function(thisName, thisValue){
		var controlContainer = $('div[data-region-ctrl^="' +thisName+ '"], ' +
							  'table[data-section-ctrl^="' +thisName+ '"], ' +
							    'tbody[data-group-ctrl^="' +thisName+ '"], ' +
									'tr[data-item-ctrl^="' +thisName+ '"]');
		
		if(controlContainer.length){
			controlContainer.each(function() {
				var container = $(this);
				
				container.removeClass('hidden');
				if(!container.is('div[data-region-ctrl*="' +thisValue+ '"], ' +
							  'table[data-section-ctrl*="' +thisValue+ '"], ' +
								'tbody[data-group-ctrl*="' +thisValue+ '"], ' +
									'tr[data-item-ctrl*="' +thisValue+ '"]')){
					
					container.addClass('hidden');
				}
			});
		}
	}
	
	//fn footer elements
	UxThemes.fnFooterElements = function(row, mod){
		var thisParents = row.parents('.ux-theme-footer-elements'),
			thisAdd = row.find('.footer-element-add'),
			thisRemove = row.find('.footer-element-remove'),
			thisType = row.find('.ux-theme-footer-element-type'),
			thisMenu = row.find('.ux-theme-footer-element-menu'),
			thisText = row.find('.ux-theme-footer-element-text'),
			thisWidget = row.find('.ux-theme-footer-element-widget');
			
		if(mod == 'clone'){
			thisAdd.addClass('hidden');
			
//			var lastCloneType = row.find('.ux-theme-footer-element-type');
//			thisMenu.addClass('hidden');
//			
//			thisType.removeClass('hidden');
//			thisText.addClass('hidden');
//			
//			if(lastCloneType.val() != 'text'){
//				
//			}
		}
		
		thisAdd.on('click', function(){
			var lastElement = thisParents.find('.ux-theme-footer-element-item:last'),
				lastElementType = lastElement.find('.ux-theme-footer-element-type'),
				lastClone = lastElement.clone(),
				lastCloneType = lastClone.find('.ux-theme-footer-element-type');
			
			lastCloneType.val(lastElementType.val());
			UxThemes.fnFooterElements(lastClone, 'clone');
			thisParents.append(lastClone);
		});
		
		thisRemove.on('click', function(){
			row.remove();
		});
		
		thisType.change(function(){
			var typeVal = $(this).val();
			
			switch(typeVal){
				case 'menu': thisMenu.removeClass('hidden'); thisText.addClass('hidden'); thisWidget.addClass('hidden'); break;
				case 'text': thisMenu.addClass('hidden'); thisText.removeClass('hidden'); thisWidget.addClass('hidden'); break;
				case 'widget': thisMenu.addClass('hidden'); thisText.addClass('hidden'); thisWidget.removeClass('hidden'); break;
				default: thisMenu.addClass('hidden'); thisText.addClass('hidden'); thisWidget.addClass('hidden'); break;
			}
		});
	}
	
	//fn social media 
	UxThemes.fnSocialMedia = function(row, mod){
		var thisParents = row.parent(),
			thisAdd = row.find('.social-medias-add'),
			thisRemove = row.find('.social-medias-remove'),
			thisSelectIcon = row.find('.new-media-col-select-icon button'),
			thisIcon = row.find('.new-media-col-icon'),
			thisRel = row.attr('rel');
		
		if(mod == 'clone'){
			thisAdd.parent().addClass('hidden');
			thisRemove.parent().removeClass('hidden').css({'right': '40px'});
		}
		
		thisAdd.on('click', function(){
			var lastRow = thisParents.find('.ux-theme-social-medias:last'),
				lastRowRel = Number(lastRow.attr('rel')),
			    lastRowClone = lastRow.clone(),
				lastRowCloneRel = lastRowRel +1;
				
			UxThemes.fnSocialMedia(lastRowClone, 'clone');
			lastRowClone.attr('rel', lastRowCloneRel);
			thisParents.append(lastRowClone);
		});
		
		thisRemove.on('click', function(){
			row.remove();
		});
		
		thisIcon.on('click', function(){
			$(this).find('.icon-content').html('');
			$(this).find('input').val('');
		});
		
		thisSelectIcon.on('click', function(){
			var thisTitle = $(this).data('title'),
				thisType = '';
			
			$('#ux-theme-modal-title').text(thisTitle);
			
			if(thisParents.is('.ux-widget-social-network-icons')){
				thisType = $(this).parents('.widget').attr('id');
			}
			
			$('#ux-theme-modal-body').html('');
			$('#ux-theme-modal').modal('show');
			$('#ux-theme-modal .modal-footer').hide();
			
			$.post(ajaxurl, {
				'action': 'seatheme_theme_option_select_icons',
				'i': thisRel,
				'type': thisType
			}).done(function(content){
				$('#ux-theme-modal-body').html(content);
				
				$('#ux-theme-modal-body .ux-theme-option-select-icons').each(function(){
					var _this = $(this);
					var thisSelect = _this.find('select');
					var thisIcon = _this.find('a');
					var thisInput = _this.find('#ux-theme-option-icons-input');
					var thisRel = $('#ux-theme-social-medias-rel').val();
					var thisType = _this.data('type');
					
					if(thisType){
						var target = $('#' +thisType).find('.ux-theme-social-medias[rel=' + thisRel + ']');
					}else{
						var target = $('.ux-theme-social-medias[rel=' + thisRel + ']');
					}
					
					var targetIcon = target.find('.new-media-col-icon');
					
					thisSelect.change(function(){
						var selectVal = $(this).val();
						thisIcon.each(function(){
							if($(this).hasClass(selectVal)){
								$(this).fadeIn();
							}else{
								$(this).hide();
							}
						});
					});
					
					thisIcon.on('click' ,function(){
						if($(this).is('.fontawesome')){
							var icon = $(this).find('i');
							var iconVal = icon.attr('class');
							var iconType = 'fontawesome';
						}else{
							var icon = $(this).find('img');
							var iconVal = icon.attr('src');
							var iconType = 'user';
						}
						
						targetIcon.find('.icon-content').html(icon);
						targetIcon.find('.icon-content').next().val(iconVal);
						targetIcon.find('.icon-content').next().next().val(iconType);
						$('#ux-theme-modal').modal('hide');
						return false;
					});
				});
			});
		});
	}
	
	//document ready
	UxThemes.doc.ready(function(){
		//field items
		if(UxThemes.optionsFieldItems.length){
			UxThemes.optionsFieldItems.each(function() {
                var fieldItem = $(this),
					filedType = fieldItem.data('item-type')
				
				switch(filedType){
					case 'switch':
						var thisSwitch = fieldItem.find('.make-switch'),
							thisName = thisSwitch.find('[name]').data('name'),
							thisInput = thisSwitch.find('input[type=\"hidden\"]');
						
						thisSwitch.on('switch-change', function(e, data){
							UxThemes.fnControlContainer(thisName, data.value);
							thisInput.val(data.value).attr('data-value', data.value);
						});
					break;
					
					case 'switchColor':
						var switchColor = fieldItem.find('input.switch-color'),
							removeColor = fieldItem.find('.ux-theme-remove-color');
							
						switchColor.minicolors({
							theme: 'bootstrap',
							letterCase: 'uppercase',
							changeDelay: 200,
							change: function(hex, opacity) {
							}
						});
						
						removeColor.on('click', function(){
							var swatchColor = fieldItem.find('.minicolors-swatch-color'),
								picker = fieldItem.find('.minicolors-picker');
							
							switchColor.val(null);
							swatchColor.removeAttr('style');
							picker.css({left:0, top:0});
						});
					break;
					
					case 'imageSelect':
						var thisSelect = fieldItem.find('li > a'),
							thisName = fieldItem.find('.ux-theme-image-select').data('name');
						
						thisSelect.on('click', function(){
							var thisValue = $(this).attr('class'),
								thisParent = $(this).parent(),
								thisInput = fieldItem.find('input');
							
							fieldItem.find('li').removeClass('active');
							thisParent.addClass('active');
							thisInput.val(thisValue);
							UxThemes.fnControlContainer(thisName, thisValue);
							
							return false;
						});
					break;
					
					case 'select':
						var thisSelect = fieldItem.find('select'),
							thisName = thisSelect.data('name');
						
						thisSelect.change(function(){
							UxThemes.fnControlContainer(thisName, thisSelect.val());
						});
					break;
					
					case 'upload':
						var uploadImage = fieldItem.find('.ux-theme-upload-image'),
							removeImage = fieldItem.find('.ux-theme-remove-image'),
							inputImage = fieldItem.find('input'),
							frameTitle = uploadImage.data('title');
							
						fieldItem.delegate('.ux-theme-upload-image, input', 'click', function(){
							var frame = wp.media({
								title : frameTitle,
								multiple : false,
								library : { type : 'image'},
								button : { text : 'Insert' }
							});
							
							frame.on('select',function() {
								var first = frame.state().get('selection').first().toJSON();
								
								inputImage.val(first['url']);
							});
							
							frame.open();
						});
						
						removeImage.on('click', function(){
							inputImage.val('');
						});
					break;
					
					case 'checkboxGroup':
						var thisCheckbox = fieldItem.find('[type=\"checkbox\"]');
						
						thisCheckbox.iCheck({
							checkboxClass: 'icheckbox_square-blue',
							radioClass: 'iradio_square-blue',
							increaseArea: '20%' // optional
						});
					break;
					
					case 'socialMedias':
					
					break;
				}
            });
		}
		
		//footer element item
		if(UxThemes.optionsFooterElItems.length){
			UxThemes.optionsFooterElItems.each(function() {
                UxThemes.fnFooterElements($(this), false);
            });
		}
		
		//restore defaults
		UxThemes.optionsRestoreDefaults.on('click', function(){
			var btn = $(this),
				btnNotice = btn.data('notice');
			
			if(confirm(btnNotice)){
				btn.text('Restoring...');
				$.post(ajaxurl, {
					'action': 'seatheme_theme_option_restore'
				}).done(function(content){
					if(content == 'success'){
						window.location.href="admin.php?page=theme-option&message=restore"
					}
				});
			}
		});
		
		//tab
		if(UxThemes.optionsTabs.length){
			var formAction = UxThemes.optionsForm.attr('action'),
				hash = window.location.hash;
			
			if(hash){
				UxThemes.optionsTabs.find('.nav-tabs a[href=\"' +hash+ '\"]').tab('show');
			}
			
			UxThemes.optionsTabs.find('.nav-tabs a').on('click', function(){
				var tab = $(this),
					tabHref = tab.attr('href');
					
				UxThemes.optionsForm.attr('action', formAction + tabHref);
				
			});
		}
		
		//social medias
		if(UxThemes.optionsSocialMedias.length){
			UxThemes.optionsSocialMedias.each(function() {
                var socialMediaRow = $(this).find('.ux-theme-social-medias');
				
				socialMediaRow.each(function() {
					UxThemes.fnSocialMedia($(this), false);
                });
            });
		}

		// Toggle the SAVE button Fixed position 
		UxThemes.win.on('scroll', function(){
			if( UxThemes.win.scrollTop() > (UxThemes.doc.height() - UxThemes.win.height() -  100)) {
				if(!UxThemes.optionsSubmitButton.hasClass('submit-fixed')) {
					UxThemes.optionsSubmitButton.addClass('submit-fixed');
				}
			} else {
				if(UxThemes.optionsSubmitButton.hasClass('submit-fixed')) {
					UxThemes.optionsSubmitButton.removeClass('submit-fixed');
				}
			}
		});
	});
	
	//win load
	UxThemes.win.load(function(){
		
	});

})(jQuery);