<?php
/****************************************************************/
/*
/*SEA Theme Functions
/*
/****************************************************************/


//Function more...
function seatheme_continue_reading_link() {
	return '';
}
function seatheme_auto_excerpt_more( $more ) {
	return ' &hellip;' . seatheme_continue_reading_link();
}
add_filter( 'excerpt_more', 'seatheme_auto_excerpt_more' );
function seatheme_custom_excerpt_more( $output ) {
	if ( has_excerpt() && ! is_attachment() ) {
		$output .= seatheme_continue_reading_link();
	}
	return $output;
}
add_filter( 'get_the_excerpt', 'seatheme_custom_excerpt_more' );

// If has more tag
function seatheme_has_more_link( $post_id ) {
	$post = get_post( $post_id );
	$content = $post->post_content;
	$data_array = get_extended( $content );
	return '' !== $data_array['extended'];
}

//Function Web Title
function seatheme_interface_wp_title($title, $sep){
	global $paged, $page;

	if(is_feed() || is_search()){
		return $title;
	}

	$title .= get_bloginfo('name');

	$site_description = get_bloginfo('description', 'display');
	if($site_description &&(is_home() || is_front_page())){
		$title = "$title $sep $site_description";
	}

	if($paged >= 2 || $page >= 2){
		$title = "$title $sep " . sprintf(esc_html__('Page %s','sea-theme'), max($paged, $page));
	}

	return esc_attr($title);
}

//Function Web Head Viewport
function seatheme_interface_webhead_viewport(){
	$enable_responsive = seatheme_get_option('theme_option_mobile_enable_responsive');
	
	if($enable_responsive){ ?>
<meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
	<?php
	}
}

//function
function seatheme_interface_equiv_meta() { ?>
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
<?php 
}

//Function body class
if ( ! function_exists ( 'seatheme_interface_body_class' ) ) {
	function seatheme_interface_body_class( $classes ){
		$responsive = seatheme_get_option( 'theme_option_mobile_enable_responsive' ) ? 'responsive-ux' : false;
		$seatheme_header_layout = seatheme_get_option( 'theme_option_header_layout' ) ? seatheme_get_option( 'theme_option_header_layout' ) : '';
		$seatheme_header_layout_mobile = seatheme_get_option( 'theme_option_header_layout_mobile' ) ? seatheme_get_option( 'theme_option_header_layout_mobile' ) : false;
		$seatheme_menu_hover_layout = seatheme_get_option( 'theme_option_menu_hover_effect' ) ? seatheme_get_option( 'theme_option_menu_hover_effect' ) : false;
		$lightbox_skin_class = seatheme_get_option( 'theme_option_color_skin_lightbox' ) ? seatheme_get_option( 'theme_option_color_skin_lightbox' ) : false;
		$gallery_property = seatheme_get_post_meta(get_the_ID(), 'theme_meta_gallery_show_property' ) ? seatheme_get_post_meta(get_the_ID(), 'theme_meta_gallery_show_property' ) : false;
		$hide_menu = seatheme_get_option( 'theme_option_hide_menu' ); 
		$social_share_intro = seatheme_get_post_meta(get_the_ID(), 'theme_meta_project_show_share_intro_section' ) ? seatheme_get_post_meta(get_the_ID(), 'theme_meta_project_show_share_intro_section' ) : false;
		$social_share_slider = seatheme_get_post_meta(get_the_ID(), 'theme_meta_project_show_share_slider' ) ? seatheme_get_post_meta(get_the_ID(), 'theme_meta_project_show_share_slider' ) : false;		
		$ux_gallery_tempalte_class = false;
		$lightbox_disable_zoom = seatheme_get_option( 'theme_option_lightbox_disable_zoom' ) ? seatheme_get_option( 'theme_option_lightbox_disable_zoom' ) : false;
		$lightbox_zoom_class = $lightbox_disable_zoom ? 'lightbox-disable-zoom' : false;
		$lightbox_disable_fullscreen = seatheme_get_option( 'theme_option_lightbox_disable_fullscreen' ) ? seatheme_get_option( 'theme_option_lightbox_disable_fullscreen' ) : false;
		$lightbox_fullscreen_class = $lightbox_disable_fullscreen ? 'lightbox-disable-fullscreen' : false;
		$lightbox_disable_share = seatheme_get_option( 'theme_option_lightbox_disable_share_download' ) ? seatheme_get_option( 'theme_option_lightbox_disable_share_download' ) : false;
		$lightbox_share_class = $lightbox_disable_share ? 'lightbox-disable-share' : false; 
		$lightbox_disable_download = seatheme_get_option( 'theme_option_lightbox_disable_download' ) ? seatheme_get_option( 'theme_option_lightbox_disable_download' ) : false;
		$lightbox_download_class = $lightbox_disable_download ? 'lightbox-disable-download' : false;


		$header_layout_class = false;
		$hide_menu_class = $hide_menu && ( $seatheme_header_layout == 'horizon-menu-right' || $seatheme_header_layout == 'horizon-menu-center' || $seatheme_header_layout == 'logo-centered' ) ? 'ux-hide-menu' : false;
		switch ( $seatheme_header_layout ) {
			case 'horizon-menu-right': $header_layout_class = 'navi-show navi-show-h'; break; 
			case 'horizon-menu-center': $header_layout_class = 'navi-show navi-show-h navi-show-h-left'; break; 
			case 'show-menu-icon': $header_layout_class = 'navi-hide hide-menu-desktop'; break;
			case 'menu-icon-popup2': $header_layout_class = 'navi-hide navi-hide-pop2 hide-menu-desktop'; break;
			case 'menu-icon-horizon-menu': $header_layout_class = 'navi-hide navi-show-h navi-show-icon menu-icon-horizon-menu'; break;
			case 'logo-centered': $header_layout_class = 'navi-show navi-show-center'; break;
			case 'navi-justified': $header_layout_class = 'navi-show navi-show-h navi-justified'; break;
			case 'navi-corner': $header_layout_class = 'navi-show navi-show-h navi-corner'; break;
			default: $header_layout_class = 'navi-show navi-show-h'; break; 
		}

		$body_glalery_property_class = false;
		
		$top_class = false;
		$bottom_class = false;
		$page_from_top_class = false;
		$non_bg_header_class = false;
		$logo_Class = 'default-logo';
		$menu_Class = 'default-menu';
		$logo_menu_expand_class = 'default-logo-menu-expand';
		$logo_menu_mobile_class = 'default-logo-menu-mobile';
		$gallery_post_class  = false;
		$featured_img_color = '';
		$page_template_class = false;
		$header_sticky_class =  seatheme_get_option('theme_option_header_sticky') ? seatheme_get_option('theme_option_header_sticky') : false; 
		$page_hide_header_class = false;

		$body_social_share_class = false;

		if(is_page()){
			$page_template = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_template');
			$page_show_header = seatheme_get_post_meta(get_the_ID(),'theme_meta_page_show_header');
			$page_from_top = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_from_page_top');
			$page_from_top_class = $page_from_top ? 'page_from_top' : false; 
			$logo_Class = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_logo_color_header') && 'null' !== seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_logo_color_header') ? seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_logo_color_header') : 'default-logo';
			$menu_Class = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_menu_color_header') && 'null' !== seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_menu_color_header') ? seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_menu_color_header') : 'default-menu';
			$logo_menu_expand_class = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_logo_menu_color_expand') && 'null' !== seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_logo_menu_color_expand') ? seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_logo_menu_color_expand') : 'default-logo-menu-expand';
			$logo_menu_mobile_class = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_logo_menu_color_mobile') && 'null' !== seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_logo_menu_color_mobile') ? seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_logo_menu_color_mobile') : 'default-logo-menu-mobile';			
			$transparent_header_bg = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_transparent_header_bg');
			$page_hide_header = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_show_header_when_scroll_down');
			$page_hide_header_class = $page_show_header && $page_hide_header ? 'ux-header-hide-body' : false;

			if(class_exists('Woocommerce')){
				if(is_product()) {
					$top_class = 'show-top-space';
					$bottom_class = 'show-bottom-space';
				}
			} 

			if($page_show_header && $transparent_header_bg){
				$non_bg_header_class = 'non_bg_header'; 
			}

		} elseif ( is_single() ) {

			if ( is_singular('ux-portfolio') ) {
				
				$top_class = '';
				$ux_gallery_tempalte_class = 'ux-is-galllery-template-body';
				$show_featured_image = false;
				$gallery_template = seatheme_get_post_meta(get_the_ID(), 'theme_meta_project_template');
				$gallery_wrap_fill = seatheme_get_post_meta(get_the_ID(), 'theme_meta_project_style');
				$gallery_start_from = 'project_title';
				$portfolio_show_header = seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_show_header');
				$page_from_top = seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_from_page_top');
				$page_from_top_class = false;
				$transparent_header_bg = seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_transparent_header_bg');
				$portfolio_hide_header = seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_show_header_when_scroll_down');
				$page_hide_header_class = $portfolio_show_header && $portfolio_hide_header ? 'ux-header-hide-body' : false;
				$logo_Class = seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_logo_color') && 'null' !== seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_logo_color') ? seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_logo_color') : 'default-logo';
				$menu_Class = seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_menu_color') && 'null' !== seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_menu_color') ? seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_menu_color') : 'default-menu';
				$logo_menu_expand_class = seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_logo_menu_color_expand') && 'null' !== seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_logo_menu_color_expand') ? seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_logo_menu_color_expand') : 'default-logo-menu-expand';
				$logo_menu_mobile_class = seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_logo_menu_color_mobile') && 'null' !== seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_logo_menu_color_mobile') ? seatheme_get_post_meta(get_the_ID(), 'theme_meta_portfolio_logo_menu_color_mobile') : 'default-logo-menu-mobile';

				switch($gallery_template){
					
					case 'on_left':
						$gallery_post_class = 'single-portfolio-2c-body single-portfolio-gallery-left';
						//$logo_Class = $default_logo;
					break;
					
					case 'on_right':
						$gallery_post_class = 'single-portfolio-2c-body single-portfolio-gallery-right';
						//$logo_Class = $default_logo;
					break;
					 

					case 'none':
						$page_from_top_class = $page_from_top ? 'page_from_top' : false;
						$non_bg_header_class = $transparent_header_bg && $portfolio_show_header ? 'non_bg_header' : false;
					break;
				}

				$is_gallery_side_filled = false;

				if($gallery_template == 'on_left' || $gallery_template == 'on_right'){
					if($gallery_wrap_fill == 'filled') {
						$is_gallery_side_filled = true;
					}
				}

				if($show_featured_image || $is_gallery_side_filled){
					$page_from_top_class = 'page_from_top'; 
					$non_bg_header_class = 'non_bg_header'; 
				}

			}  

			if(has_post_format('gallery')){
				$show_featured_image = false;
				$gallery_template = seatheme_get_post_meta(get_the_ID(), 'theme_meta_gallery_template');
				$gallery_wrap_fill = seatheme_get_post_meta(get_the_ID(), 'theme_meta_gallery_style');
				$gallery_start_from = 'project_title';
				
				switch($gallery_template){
					case 'standard':
						$show_featured_image = seatheme_get_post_meta(get_the_ID(), 'theme_meta_gallery_show_feature_image');
					break;
				}

				$is_gallery_side_filled = false;
				
			}
		}

		$classes[] = sanitize_html_class( $ux_gallery_tempalte_class );
		$classes[] = esc_attr( $gallery_post_class );
		$classes[] = sanitize_html_class( $body_social_share_class );
		$classes[] = sanitize_html_class( $lightbox_skin_class );
		$classes[] = sanitize_html_class( $responsive );
		$classes[] = sanitize_html_class( $page_template_class );
		$classes[] = esc_attr( $header_layout_class );
		$classes[] = sanitize_html_class( $seatheme_header_layout_mobile );
		$classes[] = esc_attr( $seatheme_menu_hover_layout );
		$classes[] = sanitize_html_class( $top_class );
		$classes[] = sanitize_html_class( $bottom_class );
		$classes[] = sanitize_html_class( $page_from_top_class );
		$classes[] = sanitize_html_class( $non_bg_header_class );
		$classes[] = sanitize_html_class( $logo_Class );
		$classes[] = sanitize_html_class( $menu_Class );
		$classes[] = sanitize_html_class( $logo_menu_expand_class );
		$classes[] = sanitize_html_class( $logo_menu_mobile_class );
		$classes[] = sanitize_html_class( $header_sticky_class );
		$classes[] = sanitize_html_class( $body_glalery_property_class );
		$classes[] = sanitize_html_class( $hide_menu_class );
		$classes[] = sanitize_html_class( $lightbox_zoom_class );
		$classes[] = sanitize_html_class( $lightbox_fullscreen_class );
		$classes[] = sanitize_html_class( $lightbox_share_class );
		$classes[] = sanitize_html_class( $lightbox_download_class );
		$classes[] = sanitize_html_class( $page_hide_header_class );
		//$classes[] = 'preload';
		//$classes[] = 'ux-start-hide';
	
		return $classes;
	}
	add_filter( 'body_class', 'seatheme_interface_body_class' );
}

//Function post class
function seatheme_interface_post_class(){
	$article_class = array();
	$container_class = esc_attr( seatheme_get_option('theme_option_main_width_style')) ? esc_attr(seatheme_get_option('theme_option_main_width_style')) : 'container';
	
	if(is_single()){
		$sidebar = seatheme_get_post_meta(get_the_ID(), 'theme_meta_sidebar');

		if(is_singular('ux-portfolio')) {
			$project_template = seatheme_get_post_meta(get_the_ID(), 'theme_meta_project_template');
			$article_class[0] = $container_class;
			$article_class[1] = 'container-class';
		} else {
			if( $sidebar != 'without-sidebar' ) {
				$article_class = false;
			}
		}

	}  
	
	post_class(sanitize_html_class($article_class));
}

function seatheme_interface_container_class(){ 
	$container_class = seatheme_get_option('theme_option_main_width_style') ? seatheme_get_option('theme_option_main_width_style') : 'container';
	$container_class .= ' container-class';
	echo esc_attr($container_class);
}

//Function Logo
function seatheme_interface_logo($key = ''){
	$enable_text_logo   	= seatheme_get_option('theme_option_enable_text_logo');
	$text_logo          	= stripslashes(seatheme_get_option('theme_option_text_logo'));
	$text_logo          	= $text_logo ? '<span class="logo-text">' .esc_html($text_logo). '</span>' : '<span class="logo-text">'. esc_html(get_bloginfo('name')). '</span>';
	$custom_logo        	= seatheme_get_option('theme_option_custom_logo_default');
	$custom_logo        	= $custom_logo && ! $enable_text_logo ? '<img class="logo-image logo-image-default" src="' .esc_url($custom_logo). '" alt="' .esc_attr(get_bloginfo('name')). '" />' : '<span class="logo-text">'. esc_html(get_bloginfo('name')). '</span>';
	$custom_logo_mobile 	= seatheme_get_option('theme_option_custom_logo_default_mobile');
	$custom_logo_mobile 	= $custom_logo_mobile && ! $enable_text_logo ? '<img class="logo-image logo-image-default-mobile" src="' .esc_url($custom_logo_mobile). '" alt="' .esc_attr(get_bloginfo('name')). '" />' : false;
	$custom_logo_m_class	= $custom_logo_mobile && ! $enable_text_logo ? 'logo-has-set-mobile' : false;
	$foot_custom_logo   	= seatheme_get_option('theme_option_custom_footer_logo');
	$foot_custom_logo   	= $foot_custom_logo ? '<img class="logo-footer-img" src="' .esc_url($foot_custom_logo). '" alt="' .esc_attr(get_bloginfo('name')). '" />' : false;
	$custom_logo_alt    	= seatheme_get_option('theme_option_custom_logo_alt');
	$custom_logo_alt    	= $custom_logo_alt && $custom_logo && ! $enable_text_logo ? '<span class="logo-image-alt"><img class="logo-image" src="'.esc_url($custom_logo_alt).'" alt="' .esc_attr(get_bloginfo('name')). '" /></span>' : false;
 	$custom_logo_alt_mobile = seatheme_get_option('theme_option_custom_logo_alt_mobile');
 	$custom_logo_alt_mobile = $custom_logo_alt_mobile && $custom_logo_mobile && ! $enable_text_logo ? '<span class="logo-image-alt-mobile"><img class="logo-image" src="'.esc_url($custom_logo_alt_mobile).'" alt="' .esc_attr(get_bloginfo('name')). '" /></span>' : '';
 	$custom_load_logo   	= seatheme_get_option('theme_option_custom_logo_for_loading');
	$custom_load_logo   	= $custom_load_logo ? '<img src="' .esc_url($custom_load_logo). '" alt="' .esc_attr(get_bloginfo('name')). '" />' : false;
 	$home_url           	= esc_url(home_url('/'));
	$output             	= '';
	
	switch($key){

		case 'loading': 
			$output .= '<div class="site-loading-logo">';
			$output .= $enable_text_logo ? $text_logo : $custom_load_logo;
			$output .= '</div>';
		break; 

		case 'footer': 
			$output .= '<div id="logo-footer"><a href="' . esc_url($home_url) . '" title="' . esc_attr( get_bloginfo('name') ) . '">';
			$output .= $enable_text_logo ? $text_logo : $foot_custom_logo;
			$output .= '</a></div>';
		break; 
		
		default:       
			$output .= '<div class="logo '. sanitize_html_class($custom_logo_m_class). '" id="logo"><a class="logo-a" href="' . esc_url($home_url) . '" title="' . esc_attr( get_bloginfo('name') ) . '">';
			$output .= $enable_text_logo ? $text_logo : '<span class="logo-text logo-not-show-txt">' . esc_html( get_bloginfo('name') ) . '</span>'. wp_kses( $custom_logo, seatheme_shapeSpace_allowed_html() ) . wp_kses( $custom_logo_mobile, seatheme_shapeSpace_allowed_html() );
			$output .= wp_kses( $custom_logo_alt, seatheme_shapeSpace_allowed_html() ) . wp_kses( $custom_logo_alt_mobile, seatheme_shapeSpace_allowed_html() ) . '</a></div>';
		break;
		
	}
	
	echo  balanceTags(wp_kses($output, seatheme_shapeSpace_allowed_html()), true);
}

//Function theme get option
function seatheme_get_option($key){
	$get_option = get_option('ux_theme_option');
	$return = false;
	
	if($get_option){
		if(isset($get_option[$key])){
			if($get_option[$key] != ''){
				switch($get_option[$key]){
					case 'true': $return = true; break;
					case 'false': $return = false; break;
					default: $return = $get_option[$key]; break;
				}
			}
		}else{
			switch($key){
				case 'theme_option_enable_default_fonts': $return = true; break;
				case 'theme_option_enable_image_lazyload': $return = true; break;
				case 'theme_option_enable_meta_post_page': $return = true; break;
				case 'theme_option_posts_showmeta': $return = array(); break;
				case 'theme_option_mobile_enable_responsive': $return = true; break; 
				case 'theme_option_enable_share_buttons_for_posts': $return = true; break;
  	 			case 'theme_option_share_buttons': $return = array('facebook', 'twitter', 'google-plus', 'pinterest'); break;
				case 'theme_option_hide_category_on_post_page': $return = array(); break;
				case 'theme_option_hide_ux-portfolio-cat_on_post_page': $return = array(); break;
				case 'theme_option_hide_product_cat_on_post_page': $return = array(); break;
				case 'theme_option_enable_backtop': $return = true; break;
				case 'theme_option_woo_archive_show_tit': $return = true; break;
				case 'theme_option_descriptions_on': $return = esc_attr__('on:','sea-theme'); break;
				case 'theme_option_descriptions_by': $return = esc_attr__('by:','sea-theme'); break;
				case 'theme_option_descriptions_tags': $return = esc_attr__('tags:','sea-theme'); break;
				case 'theme_option_blog_list_item_meta': $return = array(); break;
				
			}
		}
	}else{
		$return = seatheme_theme_option_default($key);
		
		switch($key){
			case 'theme_option_enable_default_fonts': $return = true; break;
			case 'theme_option_enable_image_lazyload': $return = true; break;
			case 'theme_option_enable_meta_post_page': $return = true; break;
			case 'theme_option_enable_share_buttons_for_posts': $return = true; break;
  			case 'theme_option_share_buttons': $return = array('facebook', 'twitter', 'google-plus', 'pinterest'); break;
			case 'theme_option_posts_showmeta': $return = array('date', 'category', 'tag', 'author', 'comments'); break;
			case 'theme_option_mobile_enable_responsive': $return = true; break;
			case 'theme_option_hide_category_on_post_page': $return = array(); break;
			case 'theme_option_hide_ux-portfolio-cat_on_post_page': $return = array(); break;
			case 'theme_option_hide_product_cat_on_post_page': $return = array(); break;
			case 'theme_option_enable_backtop': $return = true; break;
			case 'theme_option_woo_archive_show_tit': $return = true; break;
			case 'theme_option_descriptions_on': $return = esc_attr__('on:','sea-theme'); break;
			case 'theme_option_descriptions_by': $return = esc_attr__('by:','sea-theme'); break;
			case 'theme_option_descriptions_tags': $return = esc_attr__('tags:','sea-theme'); break;
			case 'theme_option_blog_list_item_meta': $return = array( 'date', 'category', 'author' ); break;
		}
	}
	
	return $return;
}

//Function pagination
function seatheme_interface_pagination($pages = '', $range = 3, $type = 'pagenums'){
	global $wp_query, $wp_rewrite;
	$paginationNextText =  seatheme_get_option( 'theme_option_descriptions_pagination_next' ) ? seatheme_get_option( 'theme_option_descriptions_pagination_next' ) : esc_attr__('Next','sea-theme');
	$paginationPrevText =  seatheme_get_option( 'theme_option_descriptions_pagination_prev' ) ? seatheme_get_option( 'theme_option_descriptions_pagination_prev' ) : esc_attr__('Previous','sea-theme');
	$posts_per_page = intval(get_option('posts_per_page'));
	$wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;
	$container = false;
	if ( class_exists( 'Woocommerce' ) ) {
		if ( is_woocommerce() ) {
			$container = seatheme_get_option( 'theme_option_main_width_style' ) ? seatheme_get_option('theme_option_main_width_style') : 'container-fluid';
		}
	}
	
	if( $type == 'twitter' ){
		$archive_query = 'is_home_____';
		
		if(is_date()){
			$archive_query  = 'is_date_____';
		}elseif(is_tag()){
			$archive_query  = 'is_tag_____';
		}elseif(is_author()){
			$archive_query  = 'is_author_____';
		}elseif(is_category()){
			$archive_query  = 'is_category_____';
		}elseif(is_archive()){
			$archive_query  = 'is_archive_____';
		}
		
		foreach($wp_query->query as $name => $query){
			$archive_query .= '@__@' .$name. '@_@' .$query;
		}
		
		$archive_query = $archive_query;
		
	} else {
		
		echo '<div class="clearfix pagenums pagenums-default '.sanitize_html_class($container).'">';
		echo wp_kses_post(paginate_links( array(
			'base'      => @add_query_arg('paged','%#%'),
			'format'    => '',
			'current'   => $current,
			'prev_text' => esc_attr($paginationPrevText),
			'next_text' => esc_attr($paginationNextText),
			'total'     => $wp_query->max_num_pages,
			'mid_size'  => $range
		)));  
		echo '</div>';
		
	}
}

//Function Copyright
function seatheme_interface_copyright(){
	$footer_copyright = seatheme_get_option('theme_option_copyright');
	$footer_copyright = $footer_copyright ? $footer_copyright : esc_html__('Copyright Information.','sea-theme');
	
	echo wp_kses(stripslashes($footer_copyright),seatheme_shapeSpace_allowed_html());
}

//Function Language Flags
function seatheme_interface_language_flags(){
	if (function_exists('icl_get_languages')) {
		$languages = icl_get_languages('skip_missing=0&orderby=code');
		if(!empty($languages)){
			
				echo '<div class="wpml-translation">';
				echo '<ul class="wpml-language-flags clearfix">';
				foreach($languages as $l){
					echo '<li>';
					if($l['country_flag_url']){
						if(!$l['active']) {
							echo '<a href="'.esc_url($l['url']).'"><img src="'.esc_url($l['country_flag_url']).'" height="12" alt="'.esc_attr($l['language_code']).'" width="18" /><span class="languages-shortname">'.esc_attr($l['language_code']).'</span><span class="languages-name">'.esc_attr($l['native_name']).'</span></a>';
						} else {
							echo '<div class="current-language"><img src="'.esc_url($l['country_flag_url']).'" height="12" alt="'.esc_attr($l['language_code']).'" width="18" /><span class="languages-shortname">'.esc_attr($l['language_code']).'</span><span class="languages-name">'.esc_attr($l['native_name']).'</span></div>';
						}
					}
					echo '</li>';
				}
				echo '</ul>';
				echo '</div>';
			
		}
	} else {
		echo "<p class='wpml-tip'>". esc_attr__('WPML not installed and activated.','sea-theme') ."</p>";
	}
}

//Function Content wrap class
function seatheme_interface_content_class(){

	$output = '';
	
	if ( is_singular('post') ) {

		$seatheme_sidebar_class = 'col-md-9 col-sm-9';
		$sidebar = seatheme_get_post_meta(get_the_ID(), 'theme_meta_sidebar');
		
		switch($sidebar){
			case 'right-sidebar':   if ( seatheme_enable_sidebar() ) { $output = $seatheme_sidebar_class; } break;
			case 'left-sidebar':    if ( seatheme_enable_sidebar() ) { $output = $seatheme_sidebar_class. ' pull-right'; } break;
			case 'without-sidebar': $output = '';
			default :   if ( seatheme_enable_sidebar() ) { $output = $seatheme_sidebar_class; } break;
		}
	}
	
	echo 'class="' .esc_attr($output). '"';
	
}

//Function blog show meta
function seatheme_interface_blog_show_meta($meta, $container = false, $this_postid = false, $module_post = false){
	$showmeta = $showmeta = array('date', 'category', 'tag', 'author', 'continue-reading');
	$tag_text = seatheme_get_option('theme_option_descriptions_tags') ? '<span class="article-tag-label">'.seatheme_get_option('theme_option_descriptions_tags').'</span>' : false;

	$enable_showmeta = true;
	
	$post = get_post(get_the_ID());
	
	if(is_single()){
		$showmeta = seatheme_get_option('theme_option_posts_showmeta');
		$enable_showmeta = seatheme_get_option('theme_option_enable_meta_post_page');
	}
	
	if($module_post){ 
		$get_this_meta = get_post_meta($module_post, 'module_blog_posts_showmeta', true);
		$get_blog_type = get_post_meta($module_post, 'module_blog_type', true);
		
		if($get_blog_type == 'big_image_list'){
			$get_this_meta = get_post_meta($module_post, 'module_blog_show_meta_below_title_feature', true);
		}
		
		if(is_array($get_this_meta)){
			$showmeta = $get_this_meta;
		}else{
			$showmeta = array($get_this_meta);
		}
	}
	
	if(count($showmeta) && $enable_showmeta){
		$text_on = seatheme_get_option( 'theme_option_descriptions_on' ) ? '<span class="article-meta-date-label">'.seatheme_get_option( 'theme_option_descriptions_on' ).'</span>' : false;
		//date
		if($meta == 'date' && in_array($meta, $showmeta)){
			if($container == 'single'){
				echo '<span class="article-meta-unit article-meta-date">' .wp_kses_post( $text_on ).get_the_date(). '</span>';
			}elseif($container == 'title'){
				echo '<span class="title-wrap-meta-b-item article-meta-date">' .wp_kses_post( $text_on ).get_the_date(). '</span>';
			}elseif($container == 'article'){
				echo '<span class="article-meta-unit article-meta-date">'.wp_kses_post( $text_on ).get_the_date(). '</span>';
			}else{
				echo '<span class="article-meta-date">'. get_the_date(). '</span>';
			}
		}
		
		//category
		if($meta == 'category' && in_array($meta, $showmeta) && has_category()){
			if($container == 'single'){ ?>
				<span class="article-meta-unit article-meta-unit-cate">
			<?php 
				echo seatheme_get_the_category('  '); ?>
				</span>
			<?php }elseif($container == 'title'){
				seatheme_get_the_category(' ');
			}elseif($container == 'article'){ ?>
				<span class="article-meta-unit article-meta-unit-cate archive-meta-cate clearfix">
				<?php
				seatheme_get_the_category(' ');
				?>
				</span>
				<?php
			}else{
				?>
			<div class="gird-blog-meta">
			<?php 
				seatheme_get_the_category('  ', 'grid-meta-a');
			?>
			</div>
			<?php
			}
		}
		
		//tag
		if($meta == 'tag' && in_array($meta, $showmeta) && has_tag()){
			if($container == 'single'){
				echo '<div class="article-tag clearfix">'; the_tags( wp_kses_post( $tag_text ), ' '); echo '</div>';
			}elseif($container == 'title'){
				echo '<span class="title-wrap-meta-b-item">'; the_tags('/ '); echo '</span>';
			}elseif($container == 'article'){

				echo '<div class="article-tag archive-tag clearfix">'; the_tags( wp_kses_post( $tag_text ), ' '); echo '</div>';
			}
		}
		
		//author
		if($meta == 'author' && in_array($meta, $showmeta)){
			$text_by = seatheme_get_option( 'theme_option_descriptions_by' ) ? '<span class="article-meta-author-label">'.seatheme_get_option( 'theme_option_descriptions_by' ).'</span>' : false;
			if($container == 'single'){
				echo '<span class="article-meta-unit">' .wp_kses_post( $text_by ); the_author_meta('display_name', $post->post_author); echo '</span>';
			}elseif($container == 'title'){
				echo '<span class="title-wrap-meta-b-item">' .wp_kses_post( $text_by ); the_author_meta('display_name', $post->post_author); echo '</span>';
			}elseif($container == 'article'){
				echo '<span class="article-meta-unit">'.wp_kses_post( $text_by ); the_author_meta('display_name', $post->post_author); echo '</span>';
			}
		}
		
		//comments
		if ( $meta == 'comments' && in_array( $meta, $showmeta ) ) { ?>
			<span class="article-meta-unit">
			<?php
			$comments_number = 0;
			if ( have_comments() ) {
				$comments_number = get_comments_number();
			}
			if ( '1' === $comments_number ) { 
				esc_html_e( '1 Comment', 'sea-theme' );
			} else {
				printf( 
					_nx( '%1$s Comment', '%1$s Comments', $comments_number, 'comments number under title', 'sea-theme' ),
					number_format_i18n( $comments_number )
				);
			} ?>
			</span>
			<?php
		}
		
		//Continue Reading
		if($meta == 'continue-reading' && in_array($meta, $showmeta)){
			if($container == 'single'){
				echo '<div class="blog-unit-more"><a href="' .get_permalink(). '" class="blog-unit-more-a"><span class="blog-unit-more-txt">' .esc_html__('Continue Reading','sea-theme'). '</span> <span class="fa fa-long-arrow-right"></span></a></div>';
			}
		}		
	}
}

//Function video popup
function seatheme_interface_video_popup(){ ?>
    <div class="video-overlay modal">
        <span class="video-close"></span>
    </div><!--end video-overlay-->
<?php
}

//dynamic sidebar
function seatheme_dynamic_sidebar($index = 1, $count = 1){
	global $wp_registered_sidebars, $wp_registered_widgets;

	if(is_int($index)){
		$index = "sidebar-$index";
	}else{
		$index = sanitize_title($index);
		foreach((array) $wp_registered_sidebars as $key => $value){
			if(sanitize_title($value['name']) == $index){
				$index = $key;
				break;
			}
		}
	}

	$sidebars_widgets = wp_get_sidebars_widgets();
	if(empty($wp_registered_sidebars[ $index ]) || empty($sidebars_widgets[ $index ]) || ! is_array($sidebars_widgets[ $index ])){
		do_action('dynamic_sidebar_before', $index, false);
		do_action('dynamic_sidebar_after',  $index, false);
		return apply_filters('dynamic_sidebar_has_widgets', false, $index);
	}
	

	do_action('dynamic_sidebar_before', $index, true);
	$sidebar = $wp_registered_sidebars[$index];
	
	$widget_count = count((array) $sidebars_widgets[$index]);
	
	$col_class = 'col-md-4 col-sm-4';
	if($widget_count == 1){
		$col_class = 'col-md-12 col-sm-12';
	}elseif($widget_count == 2){
		$col_class = 'col-md-6 col-sm-6';
	}
	
	$did_one = false;
	foreach((array) $sidebars_widgets[$index] as $num => $id){
		
		if($num < $count){

			if(!isset($wp_registered_widgets[$id])) continue;
	
			$params = array_merge(
				array(array_merge($sidebar, array('widget_id' => $id, 'widget_name' => $wp_registered_widgets[$id]['name']))),
				(array) $wp_registered_widgets[$id]['params']
			);
	
			$classname_ = '';
			foreach((array) $wp_registered_widgets[$id]['classname'] as $cn){
				if(is_string($cn))
					$classname_ .= '_' . $cn;
				elseif(is_object($cn))
					$classname_ .= '_' . get_class($cn);
			}
			$classname_ = ltrim($classname_, '_');
			$params[0]['before_widget'] = sprintf($params[0]['before_widget'], $id, $classname_);
			
			$params = apply_filters('dynamic_sidebar_params', $params);
			
			$params[0]['before_widget'] = str_replace('col-md-4 col-sm-4', $col_class, $params[0]['before_widget']);
	
			$callback = $wp_registered_widgets[$id]['callback'];
	
			do_action('dynamic_sidebar', $wp_registered_widgets[ $id ]);
	
			if(is_callable($callback)){
				call_user_func_array($callback, $params);
				$did_one = true;
			}
		}
	}

	do_action('dynamic_sidebar_after', $index, true);

	$did_one = apply_filters('dynamic_sidebar_has_widgets', $did_one, $index);

	return $did_one;
}

//theme exclude category
function seatheme_theme_exclude_category($category){
	$hide_category = seatheme_get_option('theme_option_hide_category_on_post_page');
	if($category){
		$return = array();
		foreach($category as $cat){
			if(!in_array($cat, $hide_category)){
				array_push($return, $cat);
			}
		}
	}else{
		$return = false;
	}
	//return $return;
	return $category;
}

//theme hide category
function seatheme_theme_hide_category($terms){
	$hide_category = seatheme_get_option('theme_option_hide_category_on_post_page');
	if(!is_array($hide_category)){
		$hide_category = array();
	}
	
	$hide_ux_portfolio_cat = seatheme_get_option('theme_option_hide_ux-portfolio-cat_on_post_page');
	if(!is_array($hide_ux_portfolio_cat)){
		$hide_ux_portfolio_cat = array();
	}
	
	$hide_product_cat = seatheme_get_option('theme_option_hide_product_cat_on_post_page');
	if(!is_array($hide_product_cat)){
		$hide_product_cat = array();
	}
	
	$hide_cat = array_merge($hide_category, $hide_ux_portfolio_cat, $hide_product_cat);
	
	foreach($terms as $num => $term){
		if($hide_cat){
			foreach($hide_cat as $cat){
				if(intval($term->term_id) == intval($cat)){
					unset($terms[$num]);
				}
			}
		}
	}
	return $terms;
}
add_filter( 'get_the_terms', 'seatheme_theme_hide_category' );

//theme get_the_category
function seatheme_get_the_category($separator= '', $class='article-cate-a', $post_id=false){
	if(!$post_id){
		$post_id = get_the_ID();
	}
	
	$categories = get_the_category($post_id);
	$output = '';
	if($categories){
		foreach($categories as $category){
			$output .= '<a href="'. esc_url( get_category_link( $category->term_id ) ) .'" title="' . esc_attr( sprintf( esc_html__( "View all posts in %s", 'sea-theme' ), $category->name ) ) . '" class="' .sanitize_html_class($class). '">'.$category->cat_name.'</a>'.$separator;
		}
		echo trim($output, $separator);
	} 
}

//interface footer info elements
function seatheme_interface_footer_info_element($type, $menu=false, $text=false, $widget=false){
	switch($type){
		case 'menu':
			if($menu){
				wp_nav_menu(array(
					'menu' => $menu,
					'container' => 'div',
					'container_class' => 'footer-menu',
					'items_wrap' => '<ul>%3$s</ul>',
					'fallback_cb' => false
				));
			}
		break;
		
		case 'text':
			if($text){ ?>
                <div class="footer-text">
					<?php echo wp_kses_stripslashes($text); ?>
                </div>
			<?php
            }
		break;
		
		case 'copyright': ?>
			<div class="copyright">
				<?php seatheme_interface_copyright(); ?>
			</div>
		<?php
		break;
		
		case 'social':
			seatheme_interface_footer_social();
		break;

		case 'logo':
			seatheme_interface_logo('footer');
		break;

		case 'language':
			seatheme_interface_language_flags(); 
		break;
			
		case 'widget':
			if ( $widget ) {
				dynamic_sidebar( $widget );
			}
		break;
	}
}

//ux plugins
function seatheme_theme_exclude_category_all($category){
	return seatheme_theme_exclude_category($category);
} 

//portfolio template
function seatheme_interface_portfolio_template_layout($post_id, $col, $num=false){
	$post_id = intval($post_id);
	$col_class = 'list-layout-col1-item';
	$image_size = 'seatheme-standard-thumb-big';
	
	if($col == 'list_layout_5'){
		$layout_builder_content = seatheme_get_post_meta(get_the_ID(), 'layout-builder-content');
		if($layout_builder_content){
			if(isset($layout_builder_content[$num])){ ?>
                <div class="list-layout-text">
					<?php echo balanceTags(wp_kses($layout_builder_content[$num], seatheme_shapeSpace_allowed_html()), true ); ?>
                </div>
			<?php
            }
        }
    }else{
		switch($col){
			case 'list_layout_1': $col_class = 'list-layout-col1-item'; $image_size = 'full'; break;
			case 'list_layout_2': $col_class = 'list-layout-col2-item'; $image_size = 'seatheme-standard-thumb-big'; break;
			case 'list_layout_3': $col_class = 'list-layout-col3-item'; $image_size = 'seatheme-standard-thumb-big'; break;
			case 'list_layout_4': $col_class = 'list-layout-col4-item'; $image_size = 'seatheme-standard-thumb-medium'; break;
		}
		
		$image_post = get_post($post_id);
		$thumbnail_caption = $image_post ? $image_post->post_excerpt : '';
		$thumb = wp_get_attachment_image_src($post_id, $image_size);
		$thumb_srcset = wp_get_attachment_image_srcset($post_id, $image_size);
		$thumb_sizes = wp_get_attachment_image_sizes($post_id, $image_size);
		if(!$thumb){
			$thumb = wp_get_attachment_image_src($post_id, 'medium');
		}
		
		$thumb_full = wp_get_attachment_image_src($post_id, 'full');

		$thumb_padding_top = false;
		if($thumb[1] > 0 && $thumb[2] > 0) {
			$thumb_padding_top = 'padding-top: ' . (intval($thumb_full[2]) / intval($thumb_full[1])) * 100 . '%;';
		}
		$data_size = $thumb_full[1]. 'x' .$thumb_full[2];

		$image_lazyload = seatheme_get_option( 'theme_option_enable_image_lazyload' );
		$lazyClass = 'lazy';
		$image_lazyload_img_style = 'src="' .get_template_directory_uri(). '/img/blank.gif" data-src="' .esc_url($thumb[0]). '" data-srcset="'.wp_kses_post($thumb_srcset).'" data-sizes="'.wp_kses_post($thumb_sizes).'"';
		if(!$image_lazyload){
			$lazyClass = '';
			$image_lazyload_img_style = 'src="' .esc_url($thumb[0]). '" srcset="'.wp_kses_post($thumb_srcset).'" sizes="'.wp_kses_post($thumb_sizes).'"';
		}
		$show_caption = false;
		$show_caption = seatheme_get_post_meta(get_the_ID(), 'theme_meta_show_gallery_caption');
		$show_caption_align = false;
		$show_caption_align = seatheme_get_post_meta(get_the_ID(), 'theme_meta_page_gallery_caption_align');
		?>
		
		<div class="<?php echo sanitize_html_class($col_class); ?> list-layout-item" style="">
			<div class="list-layout-inside">
				<div class="single-image mouse-over" data-lightbox="true">
					<a title="<?php echo esc_attr($thumbnail_caption); ?>" class="lightbox-item" href="<?php echo esc_url($thumb_full[0]); ?>" data-size="<?php echo esc_attr($data_size); ?>">
						<span class="ux-lazyload-wrap" style=" <?php echo esc_attr($thumb_padding_top); ?>">
							<img alt="<?php echo esc_attr(get_the_title($post_id)); ?>" <?php echo sanitize_text_field($image_lazyload_img_style); ?> width="<?php echo esc_attr($thumb[1]); ?>" height="<?php echo esc_attr($thumb[2]); ?>" class="list-layout-img gallery-images-img <?php echo sanitize_html_class( $lazyClass ); ?>">
						</span>
					</a>
				</div>
				<?php if($show_caption && $thumbnail_caption) { ?>
				<div class="list-layout-inside-caption <?php echo sanitize_html_class($show_caption_align); ?>"><?php echo wp_kses_post($thumbnail_caption); ?></div>
				<?php } ?>
			</div><!--End list-layout-inside-->	
		</div><!--End list-layout-item-->
	<?php
	}
}

//wp get attachment image src
function seatheme_wp_get_attachment_image_src($image, $attachment_id, $size){
	if($size != 'full'){
		$image_pathinfo = pathinfo($image[0]);
		
		if(isset($image_pathinfo['extension'])){
			if($image_pathinfo['extension'] == 'gif'){
				$thumb = wp_get_attachment_image_src($attachment_id, 'full');
				
				$src = $thumb[0];
				$width = $thumb[1];
				$height = $thumb[2];
				$image = array( $src, $width, $height );
			}
		}
	}
	
	return $image;
}
add_filter('wp_get_attachment_image_src', 'seatheme_wp_get_attachment_image_src', 10, 3);

//wp get ux font assignment
function seatheme_get_font_assignment( $name, $key=false, $selector=false ) {
	$output = '';
	$switch = false;
	
	$fontAssignment = get_option( 'ux-font-assignment' );
	if ( $fontAssignment ) {
		$output .= $selector ? $selector. ' { ' : false;
		foreach ( $fontAssignment as $fontName => $fontValue ) {
			$typeName = $name. '_' .$key;
			
			if ( isset( $fontValue['name'] ) ) {
				$fontName = $fontValue['name'];
				$fontValue = $fontValue['value'];
			}
			
			if ( $fontName == $typeName ) {
				switch ( $key ) {
					case 'family': 
						if ( function_exists ( 'ux_cb_fonts_load_font_data' ) ) {
							$fontData = ux_cb_fonts_load_font_data( $fontValue );
							if ( $fontData != '' ) { 
								$output .= $fontData; 
								$switch = true;
							}
						}
					break;
					case 'size':
					if ( $fontValue && $fontValue != 'Size' ) { $output .= 'font-size: ' .$fontValue. '; '; $switch = true; } break;
					
					case 'spacing':
					if ( $fontValue && $fontValue !='Spacing' ) { $output .= 'letter-spacing: ' .$fontValue. '; '; $switch = true; }  break;
					
					case 'm-size':
					if ( $fontValue && $fontValue != 'Mobile Size' ) { $output .= '--fontsize'.$name.': ' .$fontValue. '; '; $switch = true; } break;
					
					case 'line_height':
					if ( $fontValue && $fontValue != 'Line Height' ) { $output .= 'line-height: ' .$fontValue. '; '; $switch = true; } break;
				}
			}
		}
		$output .= $selector ? "}\n" : false;
	}
	
	if ( $switch ) {
		return $output;
	}
}


function seatheme_shapeSpace_allowed_html() {

	$seatheme_allowed_tags = array(
		'a' => array(
			'class' => array(),
			'href'  => array(),
			'rel'   => array(),
			'title' => array(),
		),
		'abbr' => array(
			'title' => array(),
			'class' => array(),
		),
		'b' => array('class' => array(),),
		'blockquote' => array(
			'cite'  => array(),
			'class' => array(),
		),
		'br' => array(),
		'cite' => array(
			'title' => array(),
			'class' => array(),
		),
		'code' => array('class' => array(),),
		'del' => array(
			'datetime' => array(),
			'title' => array(),
		),
		'dd' => array(),
		'div' => array(
			'id'    => array(),
			'class' => array(),
			'title' => array(),
			'style' => array(),
			'data-bg' => array(),
		),
		'dl' => array(),
		'dt' => array(),
		'em' => array(),
		'form'=> array(
			'action' => array(),
			'method' => array(),
			'class' => array(),
		),
		'h1' => array('class' => array(),),
		'h2' => array('class' => array(),),
		'h3' => array('class' => array(),),
		'h4' => array('class' => array(),),
		'h5' => array('class' => array(),),
		'h6' => array('class' => array(),),
		'hr' => array('class' => array(),),
		'i' => array('class' => array(),),
		'iframe' => array(
			'width' => array(),
			'height' => array(),
			'src' => array(),
			'data-src' => array(),
			'class' => array(),
			'frameborder' => array(),
			'allowfullscreen' =>array(),
			'webkitallowfullscreen' =>array(),
			'mozallowfullscreen' =>array(),
		),
		'input' => array(
			'name' => array(),
			'id' => array(),
			'type' => array(),
			'size' => array(),
			'value' => array(),
		),
		'img' => array(
			'alt'    => array(),
			'class'  => array(),
			'height' => array(),
			'src'    => array(),
			'data-src' => array(),
			'width'  => array(),
		),
		'label' => array(
			'for'    => array(),
		),
		'li' => array(
			'class' => array(),
		),
		'ol' => array(
			'class' => array(),
		),
		'p' => array(
			'class' => array(),
		),
		'q' => array(
			'cite' => array(),
			'title' => array(),
		),
		'section' => array(
			'class' => array(),
		),
		'span' => array(
			'class' => array(),
			'title' => array(),
			'style' => array(),
		),
		'strike' => array(),
		'strong' => array(),
		'style' => array(),
		'table' => array(
			'class' => array(),
		),
		'tbody' => array(
			'class' => array(),
		),
		'thead' => array(
			'class' => array(),
		),
		'tfoot' => array(
			'class' => array(),
		),
		'tr' => array(
			'class' => array(),
		),
		'th' => array(
			'class' => array(),
		),
		'td' => array(
			'class' => array(),
		),
		'ul' => array(
			'class' => array(),
		),
		'svg' => array(
			'width' => array(),
			'height' => array(),
			'viewbox' => array(),
			'version' => array(),
			'xmlns' => array(),
			'xmlns:xlink' => array(),
		),
		'g' => array(
			'stroke' => array(),
			'stroke-width' => array(),
			'fill-rule' => array(),
		),
		'path' => array(
			'd' => array(),
			'id' => array(),
			'stroke' => array(),
			'stroke-width' => array(),
			'fill' => array()
		),
		'polyline' => array(
			'stroke' => array(),
			'stroke-width' => array(),
			'stroke-linejoin' => array(),
			'stroke-miterlimit' => array(),
			'points' => array(),
			'fill' => array()
		),
		'rect' => array(
			'x' => array(),
			'y' => array(),
			'stroke' => array(),
			'stroke-width' => array(),
			'width' => array(),
			'height' => array()
		),
		'video' => array(
			'class' => array(),
			'controls' => array(),
			'loop' => array(),
		),
		'source' => array(
			'src' => array(),
			'data-src' => array(),
			'type' => array(),
		),
		
	);
	
	return $seatheme_allowed_tags;
}

function seatheme_comments( $comment, $args, $depth ) {
    $GLOBALS['comment'] = $comment;
    switch ( $comment->comment_type ) :
        case 'pingback' :
        case 'trackback' :
        if ( 'div' == $args['style'] ) {
            $tag = 'div';
            $add_below = 'comment';
        } else {
            $tag = 'li';
            $add_below = 'div-comment';
        }
    ?>
    <li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
        <p><?php esc_html_e( 'Pingback:', 'sea-theme' ); ?> <?php comment_author_link(); ?> <?php edit_comment_link( esc_html__( '(Edit)', 'sea-theme' ), '<span class="edit-link">', '</span>' ); ?></p>
    <?php
            break;
        default :
        global $post;
    ?>
    <li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
        <div id="div-comment-<?php comment_ID(); ?>" class="comment-body">
        	<?php if ( 0 != $args['avatar_size'] ) echo get_avatar( $comment, $args['avatar_size'] ); ?>
            <div class="comment-main">
	            <div class="comment-meta">
	                <div class="comment-author vcard">
	                    <?php printf( wp_kses_post( '%s <span class="says">says:</span>' ), sprintf( '<b class="fn">%s</b>', get_comment_author_link() ) ); ?>
	                </div><!-- .comment-author -->

	                <div class="comment-metadata">
	                    <a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
	                        <time datetime="<?php comment_time( 'c' ); ?>">
	                            <?php printf( _x( '%1$s at %2$s', '1: date, 2: time', 'sea-theme' ), get_comment_date(), get_comment_time() ); ?>
	                        </time>
	                    </a>
	                    <?php edit_comment_link( esc_html__( 'Edit', 'sea-theme' ), '<span class="comment-edit-link">', '</span>' ); ?>
	                </div><!-- .comment-metadata -->

		            <?php comment_reply_link( array_merge( $args, array( 'add_below' => 'div-comment', 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>

	                <?php if ( '0' == $comment->comment_approved ) : ?>
	                <p class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'sea-theme' ); ?></p>
	                <?php endif; ?>
	            </div><!-- .comment-meta -->

	            <div class="comment-text">
	                <?php comment_text(); ?>
	            </div><!-- .comment-content -->

            </div><!-- .comment-main -->
        </div><!-- .comment-body -->
    <?php
        break;
    endswitch; 
}

function seatheme_interface_privacy_policy_message_html(){
	if ( ! is_user_logged_in() ) {
		$privacyPolicyMessageHtml = '';
		if ( $privacyPolicy = seatheme_get_option( 'theme_option_cookie_comment_message' ) ) {
			$privacyPolicyMessage = seatheme_get_option( 'theme_option_cookie_comment_message_text' );
			$privacyPolicyMessageHtml = '<div class="privacy-policy"><input type="checkbox" name="idi_privacy_policy" id="idi_privacy_policy_comment" /><label for="idi_privacy_policy_comment">' .wp_kses_post( stripslashes( $privacyPolicyMessage ) ). '</label></div>';
		}

		echo $privacyPolicyMessageHtml;
	}
}

?>