<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Embed html.
 */
if ( ! function_exists( 'ux_cb_embed_html' ) ) {
	/**
	 * UX CB Module Embed html.
	 */
	function ux_cb_embed_html( $embed, $dataSrcIf, $autoplay ) {
		$html = '';
		$src = 'src';
		$autoplayTag = 'autoplay=0';
		$lazyClass = false;
		if ( $autoplay ) {
			$autoplayTag = 'autoplay=1&mute=1&loop=1';
			$lazyClass = 'lazy';
		}
		if ( $dataSrcIf ) {
			$src = 'data-src';
		}
		if ( strstr( $embed, "iframe" ) ) {
			$html = $embed;
		} else {
			$url = esc_url( $embed );
			$url = str_replace('http', 'https', $url );
			
			if ( strstr( $embed, "youtube.com" ) ) {
				preg_match('#https?://(www\.)?youtube\.com/watch\?v=([A-Za-z0-9\-_]+)#s', $embed, $matches );
				$html = '<iframe class="'.esc_attr( $lazyClass ).'" '.esc_attr($src).'="//www.youtube.com/embed/' .$matches[2]. '?'.esc_attr( $autoplayTag ).'" allowfullscreen></iframe>';
			} else if ( strstr( $embed, "youtu.be" ) ) {
				preg_match('#https://w?w?w?.?youtu.be/([A-Za-z0-9\-_]+)#s', $embed, $matches );
				$html = '<iframe class="'.esc_attr( $lazyClass ).'" '.esc_attr($src).'="//www.youtube.com/embed/' .$matches[1]. '?'.esc_attr( $autoplayTag ).'" allowfullscreen></iframe>';
			} else if ( strstr( $embed, "vimeo" ) ) {
				$matches = parse_url( $url );
				$matches = str_replace( "/", "", $matches['path'] );
				if ( $autoplay ) {
					$autoplayTag = 'autoplay=1&muted=1&loop=1';
					$lazyClass = 'lazy';
				}
				$html = '<iframe class="'.esc_attr( $lazyClass ).'" '.esc_attr($src).'="//player.vimeo.com/video/' .$matches. '?title=0&amp;byline=0&amp;portrait=0&amp;'.esc_attr( $autoplayTag ).'" allowfullscreen></iframe>';
			} else if ( strstr( $embed, "soundcloud" ) ) {
				$html = '<iframe scrolling="no" frameborder="no" src="https://w.soundcloud.com/player/?url=' .$embed. '&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true"></iframe>';
			}
		}
		
		return $html;
	}
}

/**
 * UX Content Builder get svg html.
 */
if ( ! function_exists( 'ux_cb_get_svg_html' ) ) {
	/**
	 * UX CB Module get svg html.
	 */
	function ux_cb_get_svg_html( $mod = 'id', $svg ) {
		
		if ( ! function_exists( 'request_filesystem_credentials' ) ) {
			require_once( ABSPATH . 'wp-admin/includes/file.php' );
		
		}
		
		$method = 'direct';
		if ( false === ( $creds = request_filesystem_credentials( '', $method, false, false, false ) ) ) {
			return true;
		}
		
		if ( ! WP_Filesystem( $creds ) ) {
			request_filesystem_credentials( '', $method, true, false, false );
			return true;
		}
		
		$svgUrl = false;
		switch ( $mod ) {
			case 'id': $svgUrl = get_attached_file( $svg ); break;
			case 'url': $svgUrl = $svg; break;
		}
		
		if ( $svgUrl ) {
			global $wp_filesystem;
			if ( $svgfile = $wp_filesystem->get_contents( $svgUrl ) ) {
				return $svgfile;
			}
		}
	}
}


/**
 * UX Content Builder get fontawesome social fields.
 */
if ( ! function_exists( 'ux_cb_get_fontawesome_social_fields' ) ) {
	/**
	 * UX CB Module get fontawesome social fields.
	 */
	function ux_cb_get_fontawesome_social_fields(){

		// Fontawesome icons list
		$pattern = '/\.(fa-(?:\w+(?:-)?)+):before\s+{\s*content:\s*"(.+)";\s+}/';
		$fontawesomePath = ux_cb_path_dir( 'ASSETS_DIR', 'css/font-awesome-social.css' );
		if( file_exists( $fontawesomePath ) ) {
			$method = '';
			$url = wp_nonce_url( 'post.php' );
			if ( false === ( $creds = request_filesystem_credentials( $url, $method, false, false, false ) ) ) {
				return true;
			}

			if ( ! WP_Filesystem( $creds ) ) {
				request_filesystem_credentials( $url, $method, true, false, false );
				return true;
			}

			global $wp_filesystem;
			$subject = $wp_filesystem->get_contents( $fontawesomePath );
		}
		
		preg_match_all( $pattern, $subject, $matches, PREG_SET_ORDER );

		$icons = array();
		foreach ( $matches as $match ) {
			array_push( $icons, 'fa ' . $match[1] );
		}

		return $icons;
	}
}
?>