<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

// Check if this file is loaded in content builder
if ( ! defined( 'UX_CB_VERSION' ) ) {
	die( '-1' );
}

/**
 * Include template from templates dir.
 *
 * @since 1.0.0
 *
 * @param $template
 * @param array $variables - passed variables to the template.
 *
 * @param bool $once
 *
 * @return mixed
 */
function ux_cb_include_template( $template, $variables = array(), $once = false ) {
	is_array( $variables ) && extract( $variables );
	if ( $once ) {
		return require_once ux_cb_template( $template );
	} else {
		return require ux_cb_template( $template );
	}
}

//get theme meta
function ux_cb_get_theme_meta($post_id, $key){
	$get_post_meta = get_post_meta($post_id, 'ux_theme_meta', true);
	$return = false;
	
	if($get_post_meta){
		if(isset($get_post_meta[$key])){
			if($get_post_meta[$key] != ''){
				switch($get_post_meta[$key]){
					case 'true': $return = true; break;
					case 'false': $return = false; break;
					default: $return = $get_post_meta[$key]; break;
				}
			}
		}else{
			$return = 'null';
		}
	}
	
	return $return;
}