<?php
if ( ! function_exists( 'ux_cb_tools_import_process_post' ) ) {
	/**
	 * import process post
	 */
	function ux_cb_tools_import_process_post( $post, $importDir ) {
		global $ux_cb_import_home_url, $wp_filesystem;
		
		$return = array();
		
		$processed = get_option( 'ux_cb_tools_' .$post[ 'post_type' ]. '_' .$post[ 'ID' ] );
		$processedPost = get_post( $processed );
		if ( ! $processedPost ) {
			delete_option( 'ux_cb_tools_' .$post[ 'post_type' ]. '_' .$post[ 'ID' ] );
			$processed = false;
		}
		
		if ( ! $processed ) {
			$postExists = post_exists( $post[ 'post_title' ], '', $post[ 'post_date' ] );
			if ( $postExists && get_post_type( $postExists ) == $post[ 'post_type' ] ) {
				$return = $postExists;
			} else {
				$author = (int) get_current_user_id();
				$guid = str_replace( $ux_cb_import_home_url, home_url(), $post[ 'guid' ] );
				
				$postDataArray = array(
					'post_author'           => $author,
					'post_date'             => $post[ 'post_date' ],
					'post_date_gmt'         => $post[ 'post_date_gmt' ],
					'post_content'          => $post[ 'post_content' ],
					'post_content_filtered' => $post[ 'post_content_filtered' ],
					'post_excerpt'          => $post[ 'post_excerpt' ],
					'post_title'            => $post[ 'post_title' ],
					'post_name'             => $post[ 'post_name' ],
					'post_status'           => $post[ 'post_status' ],
					'comment_status'        => $post[ 'comment_status' ],
					'ping_status'           => $post[ 'ping_status' ],
					'to_ping'               => $post[ 'to_ping' ],
					'post_modified'         => $post[ 'post_modified' ],
					'post_modified_gmt'     => $post[ 'post_modified_gmt' ],
					'guid'                  => $guid,
					'post_parent'           => $post[ 'post_parent' ],
					'menu_order'            => $post[ 'menu_order' ],
					'post_type'             => $post[ 'post_type' ],
					'post_mime_type'        => $post[ 'post_mime_type' ],
					'post_password'         => $post[ 'post_password' ]
				);
				
				$originalPostID = $post[ 'ID' ];
				$postdata = wp_slash( $postDataArray );
				
				//attachment
				if ( $post[ 'post_type' ] == 'attachment' ) {
					if ( $wp_filesystem->is_dir( $importDir. '/attachment/' .$post[ 'post_name' ] ) ) {
						$image = false;
						$demoName = sanitize_text_field( $_POST['demoName'] );
						$themeUri = get_stylesheet_directory_uri(). '/demo-data/' .$demoName;
						
						if ( $postList = $wp_filesystem->dirlist( $importDir. '/attachment/' .$post[ 'post_name' ] ) ) {
							foreach ( $postList as $postSlug => $postFile ) {
								if ( $postSlug != 'data.json' ) {
									$image = $themeUri. '/attachment/' .$post[ 'post_name' ]. '/' .$postSlug;
									$extTypes = wp_get_ext_types();
									
									$imageTrue = ux_cb_remote_file_exist( $image );
									
									if ( $imageTrue ) {
									//if ( $wp_filesystem->get_contents( $image ) ) {
										$mimeType = wp_check_filetype( $image );
										
										if ( $mimeType['type'] == 'image/jpeg' || $mimeType['type'] == 'image/png' || $mimeType['type'] == 'image/svg+xml' ||
											 $mimeType['type'] == 'application/x-font-otf' || $mimeType['type'] == 'application/x-font-woff' || 
											 $mimeType['type'] == 'application/x-font-woff2' || $mimeType['type'] == 'application/x-font-ttf' || 
											 $mimeType['type'] == 'application/vnd.ms-fontobject' || $mimeType['type'] == 'video/mp4' ) {
											
											//if( in_array( $mimeType['ext'], $extTypes['image'] ) ){
												$upload = ux_cb_media_handle_upload( $image, $post[ 'post_parent' ] );
												if ( ! is_wp_error( $upload ) ) {
													$return = (int) $upload;
													
													unset( $postDataArray['guid'] );
													$postDataArray['ID'] = $return;
													$postdata = wp_slash( $postDataArray );
													
													wp_update_post( $postdata );
												}
											//}
										}
									}
								}
							}
						}
					}
				} else {
					$newPostID = wp_insert_post( $postdata, true );
					if ( ! is_wp_error( $newPostID ) ) {
						$return = $newPostID;
						
						if ( isset( $post[ 'format' ] ) ) {
							set_post_format( $newPostID, $post[ 'format' ] );
						}
						
						if ( isset( $post[ 'post_meta' ] ) ) {
							$postMeta = json_decode( $post[ 'post_meta' ], true );
							
							if ( $post[ 'post_type' ] == 'ux-cb-modules' ) {
								$moduleFields = apply_filters( 'ux_cb_module_fields', array() );
								if ( count( $moduleFields ) ) {
									foreach ( $moduleFields as $module_id => $module ) {
										if ( isset( $postMeta['module_id'] ) ) {
											if ( $module_id == $postMeta['module_id'] ) {
												foreach ( $module['region'] as $num => $region ) {
													foreach ( $region['section'] as $num_section => $section ) {
														foreach ( $section['group'] as $num_group => $group ) {
															foreach ( $group['items'] as $item ) {
																$item = wp_parse_args( $item, array(
																	'type' => '',
																	'name' => ''
																) );
																 
																switch ( $item['type'] ) {
																	case 'gallery':
																		if ( isset( $postMeta[ $item['name'] ] ) ) {
																			if ( ! is_array( $postMeta[ $item[ 'name' ] ] ) ) { $postMeta[ $item['name'] ] = array( $postMeta[ $item['name'] ] ); }
																			
																			foreach ( $postMeta[ $item[ 'name' ] ] as $num => $thumbnailID ) {
																				if ( $targetThumbnailID = ux_cb_tools_import_get_post( $thumbnailID, $importDir, 'attachment' ) ) {
																					$postMeta[ $item[ 'name' ] ][ $num ] = $targetThumbnailID;
																				}
																			}
																		}
																	break;
																	
																	case 'upload':
																		if ( isset( $postMeta[ $item['name'] ] ) ) {
																			if ( is_array( $postMeta[ $item['name'] ] ) ){
																				foreach ( $postMeta[ $item[ 'name' ] ] as $num => $thumbnailID ) {
																					if ( $targetThumbnailID = ux_cb_tools_import_get_post( $thumbnailID, $importDir, 'attachment' ) ) {
																						$postMeta[ $item[ 'name' ] ][ $num ] = $targetThumbnailID;
																						if ( isset( $postMeta[ $item[ 'name' ]. '-url' ][ $num ] ) ) {
																							$postMeta[ $item[ 'name' ]. '-url' ][ $num ] = wp_get_attachment_url( $targetThumbnailID );
																						}
																					}
																				}
																			} else {
																				$thumbnailID = $postMeta[ $item['name'] ];
																				if ( $targetThumbnailID = ux_cb_tools_import_get_post( $thumbnailID, $importDir, 'attachment' ) ) {
																					$postMeta[ $item[ 'name' ] ] = $targetThumbnailID;
																					if ( isset( $postMeta[ $item[ 'name' ]. '-url' ] ) ) {
																						$postMeta[ $item[ 'name' ]. '-url' ] = wp_get_attachment_url( $targetThumbnailID );
																					}
																				}
																			}
																		}
																	break;
																	
																	case 'items':
																		if ( isset( $postMeta[ $item['name'] ] ) ) {
																			if ( is_array( $postMeta[ $item['name'] ] ) ) {
																				foreach ( $postMeta[ $item['name'] ] as $fieldNum => $metaField ) {
																					if ( isset( $metaField['name'] ) ) {
																						$fieldName = $metaField['name'];
																						$fieldType = ux_cb_get_mod_config( $module_id, $fieldName, 'type' );
																						if ( $fieldType == 'upload' ) {
																							foreach ( $postMeta[ $item['name'] ] as $metaField ) {
																								if ( $metaField['name'] == $fieldName. '-url' ) {
																									$fieldUploadUrl = $fieldValue['value'];
																								}
																							}
																						}
																					} else {
																						if ( is_array( $metaField ) ) {
																							$metaFields = $metaField;
																							foreach ( $metaFields as $fieldSubNum => $metaField ) {
																								$fieldName = $metaField['name'];
																								$fieldType = ux_cb_get_mod_config( $module_id, $fieldName, 'type' );
																								if ( $fieldType == 'upload' ) {
																									$thumbnailID = $metaField['value'];
																									$targetThumbnailID = false;
																									if ( $targetThumbnailID = ux_cb_tools_import_get_post( $thumbnailID, $importDir, 'attachment' ) ) {
																										$postMeta[ $item[ 'name' ] ][ $fieldNum ][ $fieldSubNum ][ 'value' ] = $targetThumbnailID;
																									}
																									
																									foreach ( $postMeta[ $item['name'] ][ $fieldNum ] as $fieldSubNum => $metaField ) {
																										if ( $metaField['name'] == $fieldName. '-url' ) {
																											$fieldUploadUrl = $metaField['value'];
																											if ( $targetThumbnailID ) {
																												$postMeta[ $item[ 'name' ] ][ $fieldNum ][ $fieldSubNum ][ 'value' ] = wp_get_attachment_url( $targetThumbnailID );;
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	break;
																}
															}
														}
													}
												}
											}
										}
									}
								}
								//print_r($moduleFields);
							}
							
							foreach ( $postMeta as $key => $value) {
								update_post_meta( $newPostID, $key, $value );
							}
						}
						
						if ( isset( $post[ 'comments' ] ) ) {
							$comments = json_decode( $post[ 'comments' ], true );
							foreach ( $comments as $comment ) {
								$originalCommentID = $comment[ 'comment_ID' ];
								
								$data = array(
									'comment_post_ID'      => $newPostID,
									'comment_author'       => $comment[ 'comment_author' ],
									'comment_author_email' => $comment[ 'comment_author' ],
									'comment_author_url'   => $comment[ 'comment_author_url' ],
									'comment_content'      => $comment[ 'comment_content' ],
									'comment_type'         => $comment[ 'comment_type' ],
									'comment_parent'       => $comment[ 'comment_parent' ],
									'comment_author_IP'    => $comment[ 'comment_author_IP' ],
									'comment_agent'        => $comment[ 'comment_agent' ],
									'comment_date'         => $comment[ 'comment_date' ],
									'comment_date_gmt'     => $comment[ 'comment_date_gmt' ],
									'comment_approved'     => $comment[ 'comment_approved' ],
									'comment_karma'        => $comment[ 'comment_karma' ],
									'user_id'              => $author
								);
								
								if ( ! $newCommentID = wp_insert_comment( $data ) ) {
									update_option( 'ux_cb_tools_comments_' .$originalCommentID, $newCommentID );
								}
							}
							
							foreach ( $comments as $comment ) {
								$originalCommentID = $comment[ 'comment_ID' ];
								if ( (int) $comment[ 'comment_parent' ] != 0 ) {
									$originalCommentParent = $comment[ 'comment_parent' ];
									$getNewCommentID = get_option( 'ux_cb_tools_comments_' .$originalCommentID );
									$getNewCommentParent = get_option( 'ux_cb_tools_comments_' .$originalCommentParent );
									if ( $getNewCommentParent ) {
										$data = array(
											'comment_ID' => $getNewCommentID,
											'comment_parent' => $getNewCommentParent
										);
										wp_update_comment( $data );
									}
								}
							}
						}
					}
				}
			}
			
			if ( $return ) {
				if ( (int) $post[ 'is_sticky' ] == 1 ) {
					stick_post( $return );
				}
				update_post_meta( $return, 'importPostID', $post[ 'ID' ] );
				update_option( 'ux_cb_tools_' .$post[ 'post_type' ]. '_' .$post[ 'ID' ], $return );
			}
		} else {
			$return = $processed;
		}
		
		return $return;
	}
}

if ( ! function_exists( 'ux_cb_tools_import_process_set_post' ) ) {
	/**
	 * import process set post
	 */
	function ux_cb_tools_import_process_set_post( $post, $importDir, $fileSlug ) {
		global $wp_filesystem, $wpdb;
		
		$return = array();
		
		$postID = $post[ 'ID' ];
		if ( $processPost = ux_cb_tools_import_process_post( $post, $importDir ) ) {
			$postID = $processPost;
		}
		
		//post parent
		if ( (int) $post[ 'post_parent' ] != 0 && $post[ 'post_type' ] != 'nav_menu_item' ) {
			$postParent = $post[ 'post_parent' ];
			
			if ( $targetPostParent = ux_cb_tools_import_get_post( $post[ 'post_parent' ], $importDir, $fileSlug ) ) {
				$postParent = $targetPostParent;
			}
			
			if ( (int) $postParent != (int) $post[ 'post_parent' ] ) {
				if ( (int) $postID != (int) $post[ 'ID' ] ) {
					$postdata = array( 'ID' => $postID, 'post_parent' => $postParent );
					if ( ! $updatePost = wp_update_post( $postdata ) ) {
						$return[] = 'error can not set post parent: ' .$postID;
					}
				}
			}
		}
		
		//post term
		if ( ! empty( $post[ 'terms' ] ) ) { 
			$terms = json_decode( $post[ 'terms' ], true );
			foreach ( $terms as $taxonomy => $termIDs ) {
				$termIDs = explode( ',', $termIDs );
				$new_tt_ids[] = array();
				
				foreach ( $termIDs as $term_id ) {
					if ( (int) $term_id != 0 ) {
						if ( $termList = $wp_filesystem->dirlist( $importDir. '/terms' ) ) {
							foreach ( $termList as $termSlug => $termFile ) {
								if ( $term = $wp_filesystem->get_contents( $importDir. '/terms/' .$termSlug ) ) {
									$term = json_decode( $term, true );
									if ( $term[ 'term_id' ] == $term_id ) {
										if ( $processTerm = ux_cb_tools_import_process_term( $term ) ) {
											if ( $term = get_term( $processTerm ) ) {
												if ( ! $wpdb->get_var( $wpdb->prepare(
													"SELECT term_taxonomy_id 
													FROM $wpdb->term_relationships 
													WHERE object_id = %d 
													AND term_taxonomy_id = %d",
													$postID,
													$term->term_taxonomy_id ) ) ) {
													$wpdb->insert( $wpdb->term_relationships, array( 'object_id' => $postID, 'term_taxonomy_id' => $term->term_taxonomy_id ) );
												}
											}
											$new_tt_ids[] = $processTerm;
										}
									}
								}
							}
						}
					}
				}
				
				if ( $new_tt_ids ) {
					wp_update_term_count( $new_tt_ids, $taxonomy );
				}
			}
		}
		
		//post meta
		if ( $uxThemeMeta = get_post_meta( $postID, 'ux_theme_meta', true ) ) {
			if ( isset( $uxThemeMeta[ 'theme_meta_portfolio' ] ) ) {
				$portfolio = $uxThemeMeta[ 'theme_meta_portfolio' ];
				if ( ! is_array( $portfolio ) ) { $portfolio = array( $portfolio ); }
				foreach ( $portfolio as $num => $imageID ) {
					if ( $targetImage = ux_cb_tools_import_get_post( $imageID, $importDir, 'attachment') ) {
						$portfolio[ $num ] = $targetImage;
					}
				}
				$uxThemeMeta[ 'theme_meta_portfolio' ] = $portfolio;
				if ( ! $updateThemeMeta = update_post_meta( $postID, 'ux_theme_meta', $uxThemeMeta ) ) {
					$return[] = 'error can not update theme meta portfolio: ' .$postID;
				}
			}
			
			//bmslider fields
			if ( isset( $uxThemeMeta[ 'theme_bmslider_category' ] ) ) {
				if ( is_array( $uxThemeMeta[ 'theme_bmslider_category' ] ) ) {
					foreach ( $uxThemeMeta[ 'theme_bmslider_category' ] as $num => $category ) {
						if ( $getNewTermID = ux_cb_tools_import_get_term( $category, $importDir ) ) {
							$uxThemeMeta[ 'theme_bmslider_category' ][ $num ] = $getNewTermID;
						}
					}
				} else {
					$category = $uxThemeMeta[ 'theme_bmslider_category' ];
					if ( $getNewTermID = ux_cb_tools_import_get_term( $category, $importDir ) ) {
						$uxThemeMeta[ 'theme_bmslider_category' ] = $getNewTermID;
					}
				}
				if ( ! $updateThemeMeta = update_post_meta( $postID, 'ux_theme_meta', $uxThemeMeta ) ) {
					$return[] = 'error can not update theme meta bmslider category: ' .$postID;
				}
			}
			
			if ( isset( $uxThemeMeta[ 'theme_meta_select_bmslider' ] ) ) {
				if ( $getNewPostID = ux_cb_tools_import_get_post( $uxThemeMeta[ 'theme_meta_select_bmslider' ], $importDir, $fileSlug ) ) {
					$uxThemeMeta[ 'theme_meta_select_bmslider' ] = $getNewPostID;
				}
				if ( ! $updateThemeMeta = update_post_meta( $postID, 'ux_theme_meta', $uxThemeMeta ) ) {
					$return[] = 'error can not update theme meta bmslider select: ' .$postID;
				}
			}
		}
		
		//gallery shortcode
		if ( $targetPost = get_post( $postID ) ) {
			if ( $targetPost->post_content != '' ) {
				$pattern = get_shortcode_regex();
				if ( preg_match_all( '/'. $pattern .'/s', $targetPost->post_content, $matches ) ) {
					$targetPostContent = $targetPost->post_content;
					foreach ( $matches[ 2 ] as $num => $key ) {
						if( $key == 'gallery' ) {
							$shortcode = $matches[ 3 ][ $num ];
							preg_match_all( '/ids=\"([^\"]*)\"/', $shortcode, $ss );
							
							$ids = $ss[ 1 ][ 0 ];
							$imageIds = explode( ',', $ids );
							foreach ( $imageIds as $imageID ) {
								if ( $targetImage = ux_cb_tools_import_get_post( $imageID, $importDir, 'attachment' ) ) {
									$ids = str_replace( $imageID, $targetImage, $ids );
								}
							}
							$targetPostContent = str_replace( 'ids="' .$ss[ 1 ][ 0 ]. '"', 'ids="' .$ids. '"', $targetPostContent ); 
						}
					}
					$postdata = array( 'ID' => $postID, 'post_content' => $targetPostContent );
					if ( ! $updatePost = wp_update_post( $postdata ) ) {
						$return[] = 'error can not replace gallery shortcode: ' .$postID;
					}
				}
			}
		}
		
		//thumbnail id
		if ( $thumbnailID = get_post_meta( $postID, '_thumbnail_id', true ) ) {
			if ( $targetThumbnailID = ux_cb_tools_import_get_post( $thumbnailID, $importDir, 'attachment' ) ) {
				if ( ! $updateThumbnailID = update_post_meta( $postID, '_thumbnail_id', $targetThumbnailID ) ) {
					$return[] = 'error can not update thumbnail id: ' .$postID;
				}
			}
		}
		
		//nav menu item
		if ( $post[ 'post_type' ] == 'nav_menu_item' ) {
			$menuID = 0;
			
			if ( ! empty( $post[ 'terms' ] ) ) {
				$terms = json_decode( $post[ 'terms' ], true );
				foreach ( $terms as $taxonomy => $termIDs ) {
					if ( $taxonomy == 'nav_menu' ) {
						$termIDs = explode( ',', $termIDs );
						if ( isset( $termIDs[ 0 ] ) ) {
							$menuID = 0;
						}
					}
				}
			}
			
			$menuItemClasses = maybe_unserialize( get_post_meta( $postID, '_menu_item_classes', true ) );
			if ( is_array( $menuItemClasses ) ) {
				$menuItemClasses = implode( ' ', $menuItemClasses );
			}
		
			$menuItemObject = get_post_meta( $postID, '_menu_item_object', true );
			$menuItemMenuItemParent = get_post_meta( $postID, '_menu_item_menu_item_parent', true );
			$menuItemType = get_post_meta( $postID, '_menu_item_type', true );
			$menuItemUrl = get_post_meta( $postID, '_menu_item_url', true );
			$menuItemTarget = get_post_meta( $postID, '_menu_item_target', true );
			$menuItemXfn = get_post_meta( $postID, '_menu_item_xfn', true );
			$menuItemObjectID = get_post_meta( $postID, '_menu_item_object_id', true );
			
			$originalTitle = $post[ 'post_title' ];
			if ( 'custom' != $menuItemType ) {
				$menuItemUrl = '';
		
				$getNewID = false;
				$getNewParent = false;
				if ( 'taxonomy' == $menuItemType ) {
					if ( $getNewID = ux_cb_tools_import_get_term( $menuItemObjectID, $importDir ) ) {
						$menuItemObjectID = $getNewID;
					}
					if ( $getNewParent = ux_cb_tools_import_get_term( $menuItemMenuItemParent, $importDir ) ) {
						$menuItemMenuItemParent = $getNewParent;
					}
				} elseif ( 'post_type' == $menuItemType ) {
					if ( $getNewID = ux_cb_tools_import_get_post( $menuItemObjectID, $importDir, $menuItemObject ) ) {
						$menuItemObjectID = $getNewID;
					}
					if ( $getNewParent = ux_cb_tools_import_get_post( $menuItemMenuItemParent, $importDir, 'nav_menu_item' ) ) {
						$menuItemMenuItemParent = $getNewParent;
					}
				} elseif ( 'post_type_archive' == $menuItemType ) {
					$originalObject = get_post_type_object( $menuItemObject );
					if ( $originalObject ) {
						$originalTitle = $originalObject->labels->archives;
					}
				}
			}
			
			$args = array(
				'menu-item-object-id' => $menuItemObjectID,
				'menu-item-object' => $menuItemObject,
				'menu-item-parent-id' => $menuItemMenuItemParent,
				'menu-item-position' => intval( $post[ 'menu_order' ] ),
				'menu-item-type' => $menuItemType,
				'menu-item-title' => $originalTitle,
				'menu-item-url' => $menuItemUrl,
				'menu-item-description' => $post[ 'post_content' ],
				'menu-item-attr-title' => $post[ 'post_excerpt' ],
				'menu-item-target' => $menuItemTarget,
				'menu-item-classes' => $menuItemClasses,
				'menu-item-xfn' => $menuItemXfn,
				'menu-item-status' => $post[ 'post_status' ]
			);
			wp_update_nav_menu_item( $menuID, $postID, $args );
			
			wp_update_post( array(
				'ID' => $postID,
				'menu_order' => $post[ 'menu_order' ]
			) );
		}
		
		//ux-portfolio
		if ( $post[ 'post_type' ] == 'ux-portfolio' ) {
			$imageKey = array( '_alternative_featured_image', '_cover_image' );
			foreach ( $imageKey as $metaKey ) {
				if ( $imageID = get_post_meta( $postID, $metaKey, true ) ) {
					if ( $getNewImageID = ux_cb_tools_import_get_post( $imageID, $importDir, 'attachment' ) ) {
						if ( ! $updateImageID = update_post_meta( $postID, $metaKey, $getNewImageID ) ) {
							$return[] = 'error can not update ' .$metaKey. ': ' .$postID;
						}
					}
				}
			}
		}
		
		//cb module
		if ( $post[ 'post_type' ] == 'ux-cb-modules' ) {
			//single image
			$imageKey = array( '__ux_cb_module_embed_image', '__ux_cb_module_single_image_image' );
			foreach ( $imageKey as $metaKey ) {
				if ( $singleImage = get_post_meta( $postID, $metaKey, true ) ) {
					if ( $getNewImageID = ux_cb_tools_import_get_post( $singleImage, $importDir, 'attachment' ) ) {
						if ( ! $updateImageID = update_post_meta( $postID, $metaKey, $getNewImageID ) ) {
							$return[] = 'error can not update ' .$metaKey. ': ' .$postID;
						}
						
						
						if ( $metaKey == '__ux_cb_module_single_image_image' ) {
							$get_attached_file = get_attached_file( $getNewImageID );
							if ( ! $updateImageUrl = update_post_meta( $postID, $metaKey. '-url', $get_attached_file ) ) {
								$return[] = 'error can not update ' .$metaKey. '-url: ' .$postID;
							}
						}
					}
				}
			}
			
			//single category
			$postTypes = array( 'ux-portfolio', 'post', 'product' );
			$names = array( '__ux_cb_module_grid_category', '__ux_cb_module_masonry_grid_category' );
			foreach ( $names as $name ) {
				foreach ( $postTypes as $postType ) {
					$metaKey = $name. '_' .$postType;
					if ( $category = get_post_meta( $postID, $metaKey, true ) ) {
						//module layouts
						if ( $layouts = get_post_meta( $postID, '_ux_cb_module_layouts_' .$category, true ) ) {
							foreach ( $layouts as $num => $layout ) {
								if ( isset( $layout[ 'post_id' ] ) ) {
									if ( $getNewPostID = ux_cb_tools_import_get_post( $layout[ 'post_id' ], $importDir, $postType ) ) {
										$layouts[ $num ][ 'post_id' ] = $getNewPostID;
									}
								}
							}
						}
						
						if ( $getNewTermID = ux_cb_tools_import_get_term( $category, $importDir ) ) {
							if ( ! $updateCategory = update_post_meta( $postID, $metaKey, $getNewTermID ) ) {
								$return[] = 'error can not update ' .$metaKey. ': ' .$postID;
							}
							
							if ( ! $updateCategory = update_post_meta( $postID, '_ux_cb_module_layouts_' .$getNewTermID, $layouts ) ) {
								$return[] = 'error can not update _ux_cb_module_layouts_' .$getNewTermID. ': ' .$postID;
							}
						} else {
							if ( ! $updateCategory = update_post_meta( $postID, '_ux_cb_module_layouts_' .$category, $layouts ) ) {
								$return[] = 'error can not update _ux_cb_module_layouts_' .$category. ': ' .$postID;
							}
						}
					}
				}
			}
			
			//masonry grid layouts == -1
			if ( $layouts = get_post_meta( $postID, '_ux_cb_module_layouts_-1', true ) ) {
				foreach ( $layouts as $num => $layout ) {
					if ( isset( $layout[ 'post_id' ] ) ) {
						if ( $getNewPostID = ux_cb_tools_import_get_post( $layout[ 'post_id' ], $importDir, 'attachment' ) ) {
							$layouts[ $num ][ 'post_id' ] = $getNewPostID;
						}
					}
				}
				
				if ( ! $updateCategory = update_post_meta( $postID, '_ux_cb_module_layouts_-1', $layouts ) ) {
					$return[] = 'error can not update _ux_cb_module_layouts_-1: ' .$postID;
				}
			}
		}
		
		return $return;
	}
}

if ( ! function_exists( 'ux_cb_tools_import_get_post' ) ) {
	/**
	 * import get post
	 */
	function ux_cb_tools_import_get_post( $postID, $importDir, $fileSlug ) {
		global $wp_filesystem;
		
		$return = false;
		
		if ( $postList = $wp_filesystem->dirlist( $importDir. '/' .$fileSlug ) ) {
			foreach ( $postList as $postSlug => $postFile ) {
				if ( $targetPost = $wp_filesystem->get_contents( $importDir. '/' .$fileSlug. '/' .$postSlug. '/data.json' ) ) {
					$targetPost = json_decode( $targetPost, true );
					if ( $targetPost[ 'ID' ] == $postID ) {
						if ( $processPost = ux_cb_tools_import_process_post( $targetPost, $importDir ) ) {
							$return = $processPost;
						}
					}
				}
			}
		}
		
		return $return;
	}
	
}