<?php
if ( ! function_exists( 'ux_cb_tools_export_terms' ) ) {
	/**
	 * export wp terms
	 */
	function ux_cb_tools_export_terms( $wp_filesystem, $uq, $exportDir ) {
		$exportData = sanitize_text_field( $_POST['exportData'] );
		
		if ( $exportData == 'terms' ) { 
			$taxonomies = get_taxonomies();
			if ( $taxonomies ) {
				foreach ( $taxonomies as $taxonomy ) {
					if ( $taxonomy != 'post_format' ) {
						$terms = get_terms(array(
							'taxonomy' => $taxonomy,
							'hide_empty' => false
						));
						if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
							foreach ( $terms as $term ) {
								if ( ! $wp_filesystem->is_dir( $exportDir. '/terms' ) ) {
									$wp_filesystem->mkdir( $exportDir. '/terms' );
								}
								
								$filename = $exportDir. '/terms/' .$term->slug. '.json';
								$content = json_encode( $term );
								if ( ! $wp_filesystem->put_contents( $filename, $content, FS_CHMOD_FILE ) ) {
									echo 'error';
								} else {
									echo 'ok';
								}
							}
						}
					}
				}
			}
		}
		 
	}
	add_action( 'ux_cb_tools_export_data', 'ux_cb_tools_export_terms', 10, 3 );
}

if ( ! function_exists( 'ux_tools_export_taxonomies' ) ) {
	/**
	 * export wp taxonomies
	 */
	function ux_tools_export_taxonomies() {
		
	}
}

?>