<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module field animation.
 */
if ( ! function_exists( 'ux_cb_module_field_animation' ) ) {
	function ux_cb_module_field_animation() {
		$animation = array(
			array('title'   => esc_html__('Scroll in Animation','bm-builder'),
				  'desc'    => esc_html__('enable to select Scroll in animation effect','bm-builder'),
				  'type'    => 'switch',
				  'name'    => '__ux_cb_module_scroll_in_animation',
				  'default' => 'off'),
				  
			array('title'   => esc_html__('Scroll in Animation Effect','bm-builder'),
				  'desc'    => esc_html__('animation effect when the module enter the scene','bm-builder'),
				  'type'    => 'select',
				  'name'    => '__ux_cb_module_scroll_animation_base',
				  'fields'  => array(
					  array(esc_html__('Fade In','bm-builder'),             'fadein'),
					  array(esc_html__('Zoom In','bm-builder'),             'zoomin'),
					  array(esc_html__('Zoom Out','bm-builder'),            'zoomout'),
					  array(esc_html__('Fade In Left','bm-builder'),        'from-left-translate'),
					  array(esc_html__('Fade In Right','bm-builder'),       'from-right-translate'),
					  array(esc_html__('Fade In Top','bm-builder'),         'from-top-translate'),
					  array(esc_html__('Fade In Bottom','bm-builder'),      'from-bottom-translate'),
					  array(esc_html__('Bounce In Left','bm-builder'),      'bouncdein-left-translate'),
					  array(esc_html__('Bounce In Right','bm-builder'),     'bouncdein-right-translate'),
					  array(esc_html__('Bounce In Top','bm-builder'),       'bouncdein-top-translate'),
					  array(esc_html__('Bounce In Bottom','bm-builder'),    'bouncdein-bottom-translate'),
					  array(esc_html__('Flip X','bm-builder'),              'flip-x-translate'),
					  array(esc_html__('Flip Y','bm-builder'),              'flip-y-translate'),
					  array(esc_html__('Rotate In DownLeft','bm-builder'),  'rotate-downleft-translate'),
					  array(esc_html__('Rotate In DownRight','bm-builder'), 'rotate-downright-translate')
				  ),
				  'default' => 'fadein',
				  'ctrl'    => '__ux_cb_module_scroll_in_animation,on')
		);
		return $animation;
	}
}

/**
 * UX Content Builder Module field animation class
 */
if ( ! function_exists( 'ux_cb_module_field_animation_class' ) ) {
	function ux_cb_module_field_animation_class($module) {
		$post_id = ux_cb_get_the_module_post_id($module['unique']);
		$animation_class = false;
		if($post_id){
			$animation = false;
			if(get_post_meta($post_id, '__ux_cb_module_scroll_in_animation', true) == 'on'){
				$animation = true;
			}
			
			if($animation){
				if($animation_class = get_post_meta($post_id, '__ux_cb_module_scroll_animation_base', true)){
					$animation_class .= ' animation-default-ux';
					$animation_class .= ' animation-scroll-ux';
				}
			}
		}
		
		return $animation_class;
	}
	
}

/**
 * UX Content Builder Module field animation end.
 */
if ( ! function_exists( 'ux_cb_module_field_animation_end' ) ) {
	function ux_cb_module_field_animation_end($module){
		$post_id = ux_cb_get_the_module_post_id($module['unique']);
		$return = 'fadeined';
		$animation = 'fadein';
		
		if($post_id){
			if($animation_base = get_post_meta($post_id, '__ux_cb_module_scroll_animation_base', true)){
				$animation = $animation_base;
			}
		}
		
		switch($animation){
			case 'fadein':                     $return = 'fadeined'; break;
			case 'zoomin':                     $return = 'zoomined'; break;
			case 'zoomout':                    $return = 'zoomouted'; break;
			case 'from-left-translate':        $return = 'from-left-translated'; break;
			case 'from-right-translate':       $return = 'from-right-translated'; break;
			case 'from-top-translate':         $return = 'from-top-translated'; break;
			case 'from-bottom-translate':      $return = 'from-bottom-translated'; break;
			case 'bouncdein-left-translate':   $return = 'bouncdein-left-translated'; break;
			case 'bouncdein-right-translate':  $return = 'bouncdein-right-translated'; break;
			case 'bouncdein-top-translate':    $return = 'bouncdein-top-translated'; break;
			case 'bouncdein-bottom-translate': $return = 'bouncdein-bottom-translated'; break;
			case 'flip-x-translate':           $return = 'flip-x-translated'; break;
			case 'flip-y-translate':           $return = 'flip-y-translated'; break;
			case 'rotate-downleft-translate':  $return = 'rotate-downleft-translated'; break;
			case 'rotate-downright-translate': $return = 'rotate-downright-translated'; break;
		}
		return $return;
	}
}