<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder fonts_management add page menu.
 */
if ( ! function_exists( 'ux_cb_fonts_management_add_page_menu' ) ) {
	function ux_cb_fonts_management_add_page_menu( $menuFields ) {
		$menuFields[] = array(
			'page_title' => __( 'BM Font management', 'bm-builder' ),
			'menu_title' => __( 'BM Font management', 'bm-builder' ),
			'capability' => 'manage_options',
			'menu_slug' => 'ux-cb-fonts-definition',
			'function' => '',
			'icon_url' => 'dashicons-editor-textcolor',
			'position' => 26
		);
		
		return $menuFields;
	}
	add_filter( 'ux_cb_page_menu_fields', 'ux_cb_fonts_management_add_page_menu' );
}

/**
 * UX Content Builder fonts management add page submenu.
 */
if ( ! function_exists( 'ux_cb_fonts_management_add_page_submenu' ) ) {
	function ux_cb_fonts_management_add_page_submenu( $menuFields ) {
		$fields = ux_cb_fonts_management_fields( array() );
		foreach ( $fields as $menuSlug => $menu ) {
			$menuFields[] = array(
				'parent_slug' => $menu['parent_slug'],
				'page_title' => $menu['title'],
				'menu_title' => $menu['title'],
				'capability' => 'manage_options',
				'menu_slug' => $menuSlug,
				'function' => $menu['callback']
			);
		}
		
		return $menuFields;
	}
	add_filter( 'ux_cb_page_submenu_fields', 'ux_cb_fonts_management_add_page_submenu' );
}