<?php
/**
 * UX Content Builder Module Post Navigation Config.
 */

//post navi config fields
function ux_cb_module_post_navi_fields( $fields ) {
	$fields['post-navi'] = array(
		'id'           => 'post-navi',
		'title'        => esc_html__( 'Post Navigation', 'bm-builder' ),
		'shortcodeTag' => 'ux_cb_post_navi', 
		'shortcode'    => '[ux_cb_post_navi unique="" col="12"][/ux_cb_post_navi]', 
		'region'       => array(
			array(
				'region-id' => 'general-settings',
				'title'     => esc_html__( 'General Settings', 'bm-builder' ),
				'default'   => true,
				'name'      => '__ux_cb_module_general_settings',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array( 
									
									// Next or Previous
									array('title'   => esc_html__( 'Next or Previous', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_post_navi_next_previous',
										  'default' => 'next',
										  'fields'  => array( 
											  array( esc_html__( 'Show Next Items', 'bm-builder' ), 'next' ),
											  array( esc_html__( 'Show Previous Items', 'bm-builder' ), 'previous' )
										  ) ),
									
									// Source
									array('title'   => esc_html__( 'Source', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'source',
										  'name'    => '__ux_cb_module_post_navi_source',
										  'default' => 'ux-portfolio',
										  'current' => true,
										  'fields'  => array( 
											  array( esc_html__( 'Portfolio', 'bm-builder' ), 'ux-portfolio' ),
											  array( esc_html__( 'Post', 'bm-builder' ), 'post' )
										  ) ),
										  
									// ux-portfolio-cat
									array('title'   => esc_html__( 'Choose a Category', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'single-category',
										  'name'    => '__ux_cb_module_post_navi_category_ux-portfolio',
										  'current' => true,
										  'ptype'   => 'ux-portfolio-cat',
										  'ctrl'    => '__ux_cb_module_post_navi_source,ux-portfolio' ),
								
									// category
									array('title'   => esc_html__( 'Choose a Category', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'single-category',
										  'name'    => '__ux_cb_module_post_navi_category_post',
										  'current' => true,
										  'ptype'   => 'category',
										  'ctrl'    => '__ux_cb_module_post_navi_source,post' ), 
										  
									// Number of Items to Show
									array('title'   => esc_html__( 'Number of Items to Show', 'bm-builder' ),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'default' => 1,
										  'name'    => '__ux_cb_module_post_navi_items_show' ),
										  
									array('type'    => 'divide' ),
									
									// Align 
									array('title'   => esc_html__( 'Align', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_post_navi_align',
										  'default' => 'left',
										  'fields'  => array( 
											  array( esc_html__( 'Left', 'bm-builder' ), 'left' ),
											  array( esc_html__( 'Center', 'bm-builder' ), 'center' ),
											  array( esc_html__( 'Right', 'bm-builder' ), 'right' )
										  ) ),

									// Title Font
									array('title'   => esc_html__( 'Title Font', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'selectFontsGroup',
										  'name'    => '__ux_cb_module_post_navi_title_font',
										  'fontval' => array(
											  'family' => 'Poppins',
											  'weight' => 'normal',
											  'size' => '16px',
											  'lineheight' => '30px',
											  'letter_spacing' => 'normal',
											  'msize' => '14px'
										  ) ),
									
									// Title Font Color
									array('title'   => esc_html__( 'Title Font Color', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_post_navi_title_font_color' ),
									
									// Title Font Color Mouseover
									array('title'   => esc_html__( 'Title Font Color Mouseover', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_post_navi_title_font_color_hover' ),
										  
									// Underline for Title
									array('title'   => esc_html__( 'Underline for Title', 'bm-builder' ),
										  'desc'	=> '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_post_navi_title_underline',
										  'default' => 'off'),
										  
									// Underline for Title Mouseover
									array('title'   => esc_html__( 'Underline for Title Mouseover', 'bm-builder' ),
										  'desc'	=> '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_post_navi_title_underline_hover',
										  'default' => 'off'),
										  
									// Padding for Top/Bottom
									array('title'   => esc_html__( 'Padding for Top/Bottom', 'bm-builder' ),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_post_navi_padding',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'default' => array('90','40'),
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) ),
										  
									// Padding for Left
									array('title'   => esc_html__( 'Padding for Left', 'bm-builder' ),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_post_navi_padding_left',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) ),
										  
									// Padding for Right
									array('title'   => esc_html__( 'Padding for Right', 'bm-builder' ),
										  'type'    => 'multipleInput',
										  'inputType' => 'number',
										  'name'    => '__ux_cb_module_post_navi_padding_right',
										  'style'   => 'width: 12em; margin-right: 1em;',
										  'col'     => 2,
										  'place'   => array(
											  esc_html__( 'Desktop', 'bm-builder' ),
											  esc_html__( 'Mobile',  'bm-builder' )
										  ) ),
									
									// Show Image 
									array('title'   => esc_html__( 'Show Image', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_post_navi_show_image',
										  'default' => 'no-image',
										  'fields'  => array( 
											  array( esc_html__( 'No Image', 'bm-builder' ), 'no-image' ),
											  array( esc_html__( 'Image', 'bm-builder' ), 'image' ),
											  array( esc_html__( 'Background Image', 'bm-builder' ), 'bg-image' )
										  ) ),
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_post_navi_show_image,no-image',
								'items' => array(

									array('type'    => 'divide' ),
										  
									// Show Label
									array('title'   => esc_html__( 'Show Label', 'bm-builder' ),
										  'desc'	=> '',
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_post_navi_show_label',
										  'default' => 'off' ),
										  
									// Label Text
									array('title'   => esc_html__( 'Label Text', 'bm-builder' ),
										  'type'    => 'text',
										  'name'    => '__ux_cb_module_post_navi_label_text',
										  'ctrl'    => '__ux_cb_module_post_navi_show_label,on' ),

									// Label Font
									array('title'   => esc_html__( 'Label Font', 'bm-builder' ),
										  'desc'    => '',
										  'type'    => 'selectFontsGroup',
										  'name'    => '__ux_cb_module_post_navi_label_font',
										  'fontval' => array(
											  'family' => 'Poppins',
											  'weight' => 'normal',
											  'size' => '16px',
											  'lineheight' => '30px',
											  'letter_spacing' => 'normal',
											  'msize' => '14px'
										  ),
										  'ctrl'    => '__ux_cb_module_post_navi_show_label,on' ),
										  
									// Padding on Bottom 
									array('title'   => esc_html__( 'Padding on Bottom of Label', 'bm-builder' ),
										  'type'    => 'text',
										  'inputType' => 'number',
										  'default' => 20,
										  'name'    => '__ux_cb_module_post_navi_label_padding_bottom',
										  'ctrl'    => '__ux_cb_module_post_navi_show_label,on' ),
								)
							)


						)
					)
				)
			)
		)
	);
	
	return $fields;
	
}
add_filter( 'ux_cb_module_fields', 'ux_cb_module_post_navi_fields' );

?>