<?php
/**
 * UX Content Builder Module Embed Config.
 */

//embed config fields
function ux_cb_module_embed_fields($fields){
	$fields['embed'] = array(
		'id'           => 'embed',
		'animation'    => true,
		'title'        => esc_html__('Embed','bm-builder'),
		'shortcodeTag' => 'ux_cb_embed', 
		'shortcode'    => '[ux_cb_embed unique="" col="12"][/ux_cb_embed]', 
		'region'       => array(
			array(
				'region-id' => 'general-settings',
				'title'     => esc_html__('General Settings','bm-builder'),
				'default'   => true,
				'name'      => '__ux_cb_module_general_settings',
				'section'   => array(
					array(
						'group' => array(
							
							array(
								'items' => array(
									//Type
									array('title'   => esc_html__('Soruce','bm-builder'),
										  'desc'    => '',
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_embed_source',
										  'default' => 'youtube',
										  'fields'  => array(
											  array(esc_html__('Youtube','bm-builder'),   'youtube'),
											  array(esc_html__('Vimeo','bm-builder'),    'vimeo'),
											  array(esc_html__('SoundCloud','bm-builder'),   'soundCloud'),
											  array(esc_html__('Other','bm-builder'), 'other')
										  )),

									//Embed Code
									array('title'   => esc_html__('Embed Code','bm-builder'),
										  'desc'    => '',
										  'type'    => 'text',
										  'name'    => '__ux_cb_module_embed_code',
										  'ctrl'    => '__ux_cb_module_embed_source,soundCloud|other')
								)
							),
							array(
								'group-id'   => '',
								'group-ctrl' => '__ux_cb_module_embed_source,youtube|vimeo',
								'items'      => array(
									//Embed Code
									array('title'   => esc_html__('YouTube URL','bm-builder'),
										  'desc'    => esc_html__('e.g. https://www.youtube.com/watch?v=JBeEQjp8lKw or https://youtu.be/JBeEQjp8lKw','bm-builder'),
										  'type'    => 'text',
										  'name'    => '__ux_cb_module_embed_code_youtube',
										  'ctrl'    => '__ux_cb_module_embed_source,youtube'),

									//Embed Code
									array('title'   => esc_html__('Vimeo URL','bm-builder'),
										  'desc'    => esc_html__('e.g. https://vimeo.com/231986617','bm-builder'),
										  'type'    => 'text',
										  'name'    => '__ux_cb_module_embed_code_vimeo',
										  'ctrl'    => '__ux_cb_module_embed_source,vimeo'),

									//Autoplay
									array('title'   => esc_html__('Autoplay','bm-builder'),
										  'desc'	=> esc_html__('The video will muted by default if enable this option','bm-builder'),
										  'type'    => 'switch',
										  'name'    => '__ux_cb_module_embed_autoplay',
										  'default' => 'off'),

									//Cover image
									array('title'   => esc_html__('Video Cover Image','bm-builder'), 
										  'desc'    => esc_html__('It is optional','bm-builder'),
										  'type'    => 'upload',
										  'name'    => '__ux_cb_module_embed_image',
										  'ctrl'    => '__ux_cb_module_embed_autoplay,off'),

									//Play Button Color
									array('title'   => esc_html__('Video Play Button Color','bm-builder'),
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_embed_playbutton_color',
										  'ctrl'    => '__ux_cb_module_embed_autoplay,off'
									),

									//Play Button Color mouseover
									array('title'   => esc_html__('Video Play Button Color Mouseover','bm-builder'),
										  'type'    => 'colorPicker',
										  'name'    => '__ux_cb_module_embed_playbutton_color_mouseover',
										  'ctrl'    => '__ux_cb_module_embed_autoplay,off'
									),
								)
							),
							array(
								'items' => array(
									//Aspect Ratio (optional)
									array('title'   => esc_html__('Aspect Ratio','bm-builder'),
										  'desc'    => esc_html__('It is optional','bm-builder'),
										  'type'    => 'select',
										  'name'    => '__ux_cb_module_embed_ratio',
										  'default' => 'none',
										  'fields'  => array(
											  array(esc_html__('None','bm-builder'),   'none'),
											  array(esc_html__('4:3','bm-builder'),    '4_3'),
											  array(esc_html__('16:9','bm-builder'),   '16_9'),
											  array(esc_html__('Custom','bm-builder'), 'custom')
										  )
									),
										  
									//Aspect Ratio (optional)
									array('type'    => 'ratio',
										  'name'    => '__ux_cb_module_embed_custom_ratio',
										  'ctrl'    => '__ux_cb_module_embed_ratio,custom'
									)
								)
							)
						)
					)
				)
			),
			array(
				'region-id' => 'advanced-settings',
				'title'     => esc_html__('Advanced Settings','bm-builder'),
				'default'   => false,
				'name'      => '__ux_cb_module_advanced_settings',
				'section'   => array(
					array(
						'group' => array()
					)
				)
			)	
		)
	);
	
	return $fields;
	
}
add_filter('ux_cb_module_fields', 'ux_cb_module_embed_fields');

?>