<?php
/**
 * UX Content Builder Fonts management config fields.
 */
if ( ! function_exists( 'ux_cb_fonts_management_fields' ) ) {
	function ux_cb_fonts_management_fields($fields) {
		$fields['ux-cb-fonts-definition'] = array(
			'id'          => 'ux-cb-fonts-definition',
			'title'       => esc_html__( 'Fonts Definition', 'bm-builder' ),
			'parent_slug' => 'ux-cb-fonts-definition',
			'callback'    => 'ux_cb_page_option_interface',
			'disabled'    => true,
			'video'       => '//player.vimeo.com/video/343159692?title=0&amp;byline=0&amp;portrait=0&amp;autoplay=0&amp;mute=1',
			'region'      => array(
				array(
					'region-id' => 'general-settings',
					'title'     => esc_html__( 'All Fonts', 'bm-builder' ),
					'default'   => true,
					'name'      => '__ux_cb_module_general_settings',
					'section'   => array(
						array(
							'group' => array(
								array(
									'items' => array(
										array('title' => esc_html__( 'Add Font', 'bm-builder' ),
											  'type' => 'items',
											  'name' => '_ux_cb_module_fonts_items',
											  'count' => 0)
									)
								)
							)
						)
					)
				),
				array(
					'region-id' => 'item-settings',
					'title'     => esc_html__( 'Font Item', 'bm-builder' ),
					'default'   => false,
					'hidden'    => true,
					'class'     => 'ux-cb-item-settings',
					'name'      => '__ux_cb_module_items_settings',
					'section'   => array(
						array(
							'group' => array(
								array(
									'items' => array(
							
										array('title'   => esc_html__( 'Font Style Name', 'bm-builder' ),
											  'type'    => 'text',
											  'name'    => '__ux_cb_module_fonts_style_name'),
											  
										array('title'   => esc_html__( 'Font Source', 'bm-builder' ),
											  'type'    => 'select',
											  'name'    => '__ux_cb_module_fonts_resource',
											  'default' => 'none',
											  'fields'  => array(
												  array(esc_html__( 'Choose a Font Source', 'bm-builder' ), 'none'),
												  array(esc_html__( 'Google Font', 'bm-builder' ), 'google-font'),
												  array(esc_html__( 'Upload Font', 'bm-builder' ), 'upload-font'),
												  array(esc_html__( 'System Font', 'bm-builder' ), 'system-font'),
												  array(esc_html__( 'Adobe Font', 'bm-builder' ), 'adobe-typekit')
											  )),
											  
										array('type'    => 'button',
											  'text'    => esc_html__( 'Update to new Google Font Data', 'bm-builder' ),
											  'class'   => 'update-google-fonts',
											  'name'    => '__ux_cb_module_fonts_update_googlefonts',
											  'key'     => true,
											  'ctrl'    => '__ux_cb_module_fonts_resource,google-font'),
											  
										array('title'   => esc_html__( 'Choose Font Type', 'bm-builder' ),
											  'desc'    => esc_html__( 'To make loading speed faster, select the required language for your website', 'bm-builder' ),
											  'type'    => 'resource-wrap',
											  'name'    => '__ux_cb_module_fonts_resource_google-font',
											  'ctrl'    => '__ux_cb_module_fonts_resource,google-font'),
											  
										array('title'   => esc_html__( 'Upload Font', 'bm-builder' ),
											  'type'    => 'upload-font',
											  'name'    => '__ux_cb_module_fonts_resource_upload-font',
											  'ctrl'    => '__ux_cb_module_fonts_resource,upload-font',
											  'fields'  => array(
												  array(esc_html__( '.woff2 Super Modern Browsers, suggest strongly', 'bm-builder' ), 'woff2'),
												  array(esc_html__( '.woff Support Pretty Modern Browsers, suggest', 'bm-builder' ), 'woff'),
												  array(esc_html__( '.ttf Support Safari, Android, iOS', 'bm-builder' ), 'ttf')
											  )),
											  
										array('title'   => esc_html__( 'Choose Font Type', 'bm-builder' ),
											  'type'    => 'resource-wrap',
											  'name'    => '__ux_cb_module_fonts_resource_system-font',
											  'ctrl'    => '__ux_cb_module_fonts_resource,system-font'),
											  
										array('title'   => esc_html__( 'Enter Kit ID', 'bm-builder' ),
											  'desc' => __('Get the Kit ID <a target="_blank" href="https://fonts.adobe.com/my_fonts?browse_mode=all#web_projects-section">here</a>', 'bm-builder' ),
											  'type'    => 'adobe-typekit',
											  'name'    => '__ux_cb_module_fonts_resource_adobe-typekit-id',
											  'ctrl'    => '__ux_cb_module_fonts_resource,adobe-typekit'),
											  
										array('title'   => esc_html__( 'Enter Kit Token', 'bm-builder' ),
											  'desc' => __('Get the Kit Token <a target="_blank" href="https://fonts.adobe.com/account/tokens?ref=tk.com">here</a>', 'bm-builder' ),
											  'type'    => 'text',
											  'name'    => '__ux_cb_module_fonts_resource_adobe-typekit-token',
											  'ctrl'    => '__ux_cb_module_fonts_resource,adobe-typekit'),
											  
										array('title'   => esc_html__( 'Choose Font Type', 'bm-builder' ),
											  'desc'    => esc_html__( 'To make loading speed faster, select the required language for your website', 'bm-builder' ),
											  'type'    => 'resource-wrap',
											  'name'    => '__ux_cb_module_fonts_resource_adobe-typekit',
											  'ctrl'    => '__ux_cb_module_fonts_resource,adobe-typekit'),
											  
										array('title'   => '',
											  'desc'    => '',
											  'class'   => 'item-save-button',
											  'type'    => 'button',
											  'target'  => '.ux-cb-module-field-items',
											  'text'    => esc_html__( 'Save Item', 'bm-builder' ),
											  'name'    => '__ux_cb_module_button_item_save'),
											  
										/*array('title'   => '',
											  'desc'    => '',
											  'type'    => 'overlay',
											  'name'    => '__ux_cb_module_button_item_save')*/
									)
								)
							)
						)
					)
				)
			)
		);
		
		$fields['ux-cb-fonts-assignment'] = array(
			'id'          => 'ux-cb-fonts-assignment',
			'title'       => esc_html__( 'Fonts Assignment', 'bm-builder' ),
			'parent_slug' => 'ux-cb-fonts-definition',
			'callback'    => 'ux_cb_page_option_interface',
			'disabled'    => true,
			'video'       => '//player.vimeo.com/video/343159692?title=0&amp;byline=0&amp;portrait=0&amp;autoplay=0&amp;mute=1',
			'region'      => apply_filters( 'ux-cb-fonts-assignment-config', array() )
		);
		
		$fields['ux-cb-fonts-google-api-key'] = array(
			'id'          => 'ux-cb-fonts-google-api-key',
			'title'       => esc_html__( 'Google Api Key', 'bm-builder' ),
			'parent_slug' => 'ux-cb-fonts-definition',
			'callback'    => 'ux_cb_page_option_interface',
			'disabled'    => true,
			'video'       => '//player.vimeo.com/video/343159692?title=0&amp;byline=0&amp;portrait=0&amp;autoplay=0&amp;mute=1',
			'region'      => array(
				array(
					'region-id' => 'general-settings',
					'title'     => esc_html__( 'Google Api Settings', 'bm-builder' ),
					'default'   => true,
					'name'      => '__ux_cb_module_general_settings',
					'section'   => array(
						array(
							'group' => array(
								array(
									'items' => array(
										array('title'    => esc_html__( 'Please enter the Google Api Key', 'bm-builder' ),
											  'desc'     => sprintf('<a target="_blank" href="https://console.developers.google.com/apis">%s</a>', esc_html__( 'Get your Google Fonts Api Key here.', 'bm-builder' ) ),
											  'type'     => 'text',
											  'dataType' => 'option',
											  'default'  => '',
											  'name'     => '_ux_cb_module_fonts_google_api_key' )
									)
								)
							)
						)
					)
				)
			)
		);
		
		return $fields;
	}
	add_filter( 'ux_cb_module_fields', 'ux_cb_fonts_management_fields' );
}

/**
 * UX Content Builder Fonts management config fields (custom).
 */
if(!function_exists( 'ux_cb_fonts_management_fields_custom')){
	function ux_cb_fonts_management_fields_custom( $fonts_fields ) {
		if ( is_array( $fonts_fields ) ) {
			array_push( $fonts_fields, array(
				'region-id' => 'custom-font',
				'title'     => esc_html__('Custom','sea-theme'),
				'default'   => false,
				'name'      => '__ux_cb_module_custom_font',
				'section'   => array(
					array(
						'group' => array(
							array(
								'items' => array(
									array('wrap' => 'fullwidth',
										  'type'  => 'customFontsGroup',
										  'name'  => '__ux_cb_module_custom_font_group',
										  'group' => 'tag|family|size|spacing|m-size|line_height',
										  'default' => array( 
											  'size' => '28px',
											  'm-size' => '20px'
										  ),
										  'place' => array(
											  'container' => esc_html__( 'Please enter tag name', 'bm-builder' )
										  )
									)
								)
							)
						)
					)
				)
			) );
		}
		
		return $fonts_fields;
	}
	add_filter( 'ux-cb-fonts-assignment-config', 'ux_cb_fonts_management_fields_custom', 11 );
}
?>