<?php
/**
 * Content wrappers
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/wrapper-start.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
} 

$theme_option_main_width_style = esc_attr(seatheme_get_option('theme_option_main_width_style'));
$container = $theme_option_main_width_style ? $theme_option_main_width_style : 'container';

$archivePageLayout = seatheme_get_option( 'fieldWooArchivePageLayout' ); 

if ( is_singular( 'product' ) ) {
	$archivePageLayout = seatheme_get_option( 'fieldWooSingleProductLayout' );
}

$sidebarClass = ' two-cols-layout';
$layoutClass = 'sidebar-layout row';

if ( $archivePageLayout === 'without-sidebar' ) {
	$sidebarClass = ' fullwrap-layout';
	$layoutClass = 'fullwrap-layout-inn';
}

?>

<div id="main-wrap">
    
    <div id="main">

        <div id="content" class="ux-woo-wrap <?php echo sanitize_html_class( $container ); ?>">

            <div class="content_wrap_outer <?php echo esc_attr( $sidebarClass ); ?>">
            
                <div class="<?php echo esc_attr( $layoutClass ); ?>">