<?php
/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.8.0
 */

defined( 'ABSPATH' ) || exit; ?>

<div class="product-wrap">
    <?php
    wc_print_notices();
    
    do_action('woocommerce_before_cart'); ?>
    
    <form action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">

        <div class="cart-content clearfix">
        
            <?php do_action('woocommerce_before_cart_table'); ?>
            
            <table class="shop_table cart" cellspacing="0">
                <thead>
                    <tr>
                        <th class="product-thumbnail"><?php esc_html_e('Product', 'sea-theme'); ?></th>
                        <th class="product-name">&nbsp;</th>
                        <th class="product-price"><?php esc_html_e('Price', 'sea-theme'); ?></th>
                        <th class="product-quantity"><?php esc_html_e('Quantity', 'sea-theme'); ?></th>
                        <th class="product-subtotal"><?php esc_html_e('Subtotal', 'sea-theme'); ?></th>
                        <th class="product-remove">&nbsp;</th>
                    </tr>
                </thead>
                <tbody>
                    <?php do_action('woocommerce_before_cart_contents'); ?>
                    <?php
                    foreach( WC()->cart->get_cart() as $cart_item_key => $cart_item ){
                        $_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                        $product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
                        
                        if( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ){
                            $product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key ); ?>
                            <tr class="<?php echo esc_attr(apply_filters('woocommerce_cart_table_item_class', 'cart_table_item', $cart_item, $cart_item_key)); ?>">
        
                                <!-- The thumbnail -->
                                <td class="product-thumbnail">
                                    <?php
                                        $thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
        
                                        if ( ! $product_permalink ) {
                                           echo wp_kses_post($thumbnail);
                                        } else {
                                            printf( '<a href="%s">%s</a>', esc_url( $product_permalink ), wp_kses_post( $thumbnail ) );
                                        }
                                    ?>
                                </td>
    
                                <!-- Product Name -->
                                <td class="product-name" data-title="<?php esc_attr_e( 'Product', 'sea-theme' ); ?>">
                                    <?php
                                        if ( ! $product_permalink ) {
                                            echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key ) . '&nbsp;');
                                        } else {
                                            echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_name() ), $cart_item, $cart_item_key ));
                                        }

                                        do_action( 'woocommerce_after_cart_item_name', $cart_item, $cart_item_key );
        
                                        // Meta data
                                        echo wp_kses_post(wc_get_formatted_cart_item_data( $cart_item ));
        
                                        // Backorder notification
                                        if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) ) {
                                            echo wp_kses_post( apply_filters( 'woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__( 'Available on backorder', 'sea-theme' ) . '</p>' ) );
                                        }
                                    ?>
                                </td>
        
                                <!-- Product price -->
                                <td class="product-price" data-title="<?php esc_attr_e( 'Price', 'sea-theme' ); ?>">
                                    <?php
                                        echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
                                    ?>
                                </td>
        
                                <!-- Quantity inputs -->
                                <td class="product-quantity" data-title="<?php esc_attr_e( 'Quantity', 'sea-theme' ); ?>">
                                    <?php
                                        if ( $_product->is_sold_individually() ) {
                                            $product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
                                        } else {
                                           $product_quantity = woocommerce_quantity_input(
                                                array(
                                                    'input_name'   => "cart[{$cart_item_key}][qty]",
                                                    'input_value'  => $cart_item['quantity'],
                                                    'max_value'    => $_product->get_max_purchase_quantity(),
                                                    'min_value'    => '0',
                                                    'product_name' => $_product->get_name(),
                                                ),
                                                $_product,
                                                false
                                            );
                                        }
        
                                        echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item );
                                    ?>
                                </td>
        
                                <!-- Product subtotal -->
                                <td class="product-subtotal" data-title="<?php esc_attr_e( 'Subtotal', 'sea-theme' ); ?>">
                                    <?php
                                        echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key );
                                    ?>
                                </td>
                                
                                <!-- Remove from cart link -->
                                <td class="product-remove">
                                    <?php
                                       echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                            'woocommerce_cart_item_remove_link',
                                            sprintf(
                                                '<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
                                                esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
                                                esc_html__( 'Remove this item', 'woocommerce' ),
                                                esc_attr( $product_id ),
                                                esc_attr( $_product->get_sku() )
                                            ),
                                            $cart_item_key
                                        );
                                    ?>
                                </td>
                            </tr>
                        <?php
                        }
                    }
                    
                    do_action('woocommerce_cart_contents');
                    
                    do_action('woocommerce_after_cart_contents'); ?>
                    
                </tbody>
            </table>
            
            <?php do_action('woocommerce_after_cart_table'); ?>
        
            <?php if( wc_coupons_enabled() ){ ?>
            <div class="coupon">
                <input name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php esc_attr_e('Enter promotion code', 'sea-theme'); ?>" />
                <button type="submit" class="button apply-coupon" name="apply_coupon" value="<?php esc_attr_e('Apply', 'sea-theme'); ?>" ><?php esc_attr_e( 'Apply coupon', 'sea-theme' ); ?></button>

                <?php do_action('woocommerce_cart_coupon'); ?>

            </div>
            <?php } ?>

            <input type="submit" class="button" name="update_cart" value="<?php esc_attr_e( 'Update Cart', 'sea-theme' ); ?>" />
            <?php do_action( 'woocommerce_cart_actions' ); ?>
            <?php wp_nonce_field( 'woocommerce-cart', 'woocommerce-cart-nonce' ); ?>
        </div>
    
    </form> 

    <div class="cart-collaterals">

        <?php do_action( 'woocommerce_cart_collaterals' ); ?>
        <?php woocommerce_cart_totals(); ?>
        <div class="wc-proceed-to-checkout">
            <?php do_action('woocommerce_proceed_to_checkout'); ?>
            <?php wp_nonce_field( 'woocommerce-cart', 'woocommerce-cart-nonce' ); ?>
        </div>

    </div>
    
    <?php do_action('woocommerce_after_cart'); ?>
    
</div>