<?php
$footer_width = seatheme_get_option( 'theme_option_header_width' ) ? seatheme_get_option( 'theme_option_header_width' ) : false;
$footer_width_class =  $footer_width == 'fixed' ? 'container' : 'container-fluid';
$elements = seatheme_get_option( 'theme_option_footer_elements' );
$elements_arrange_direction = seatheme_get_option( 'theme_option_footer_elements_align' );
$elements_horizon_align = seatheme_get_option( 'theme_option_footer_horizon_align' ) && $elements_arrange_direction === 'horizon' ? seatheme_get_option( 'theme_option_footer_horizon_align' ) : false;
$elements_vertical_align = seatheme_get_option( 'theme_option_footer_vertical_align' ) && $elements_arrange_direction === 'vertical' ? seatheme_get_option( 'theme_option_footer_vertical_align' ) : false;
$elements_arrange_direction_mobile = seatheme_get_option( 'theme_option_footer_elements_align_mobile' );
$elements_horizon_align_mobile = seatheme_get_option( 'theme_option_footer_horizon_align_mobile' ) && $elements_arrange_direction_mobile === 'horizon-mobile' ? seatheme_get_option( 'theme_option_footer_horizon_align_mobile' ) : false;
$elements_vertical_align_mobile = seatheme_get_option( 'theme_option_footer_vertical_align_mobile' ) && $elements_arrange_direction_mobile === 'vertical-mobile' ? seatheme_get_option( 'theme_option_footer_vertical_align_mobile' ) : false;
$footer_item_class = $elements_arrange_direction === 'horizon' ? 'footer-cols-item' : 'footer-one-col-item';
$footer_item_class_mobile = $elements_arrange_direction_mobile === 'horizon-mobile' ? 'footer-cols-item-mobile' : 'footer-one-col-item-mobile';
?>
<div class="footer-info <?php echo sanitize_html_class( $elements_horizon_align ); echo sanitize_html_class( $elements_vertical_align ); ?> <?php echo sanitize_html_class( $elements_horizon_align_mobile ); echo sanitize_html_class( $elements_vertical_align_mobile ); ?>">
    <div class="<?php echo sanitize_html_class($footer_width_class); ?>">
        <?php
		if ( $elements && is_array( $elements ) ) {
			$types = $elements['type'];
			$menus = $elements['menu'];
			$texts = $elements['text'];
			$widgets = false;
			
			if ( isset( $elements['widget'] ) ) {
				$widgets = $elements['widget'];
			}
			
			$i = count( $types );
			
			$horizon_class = '';
			
			for ( $ii = 0; $ii < $i; $ii++ ) {
				$type = $types[$ii];
				$memu = $menus[$ii];
				$text = $texts[$ii];
				$widget = 'footer_widget_1';
				
				if ( $widgets ) {
					$widget = $widgets[$ii];
				}
				 
				echo '<div class="'.sanitize_html_class( $footer_item_class ).' '.sanitize_html_class( $footer_item_class_mobile ).'">';
				seatheme_interface_footer_info_element( $type, $memu, $text, $widget );
				echo '</div>';
			}
		} ?>
    </div>
</div>