<?php get_header(); 
$theme_option_main_width_style = esc_attr(seatheme_get_option('theme_option_main_width_style'));
$container = $theme_option_main_width_style ? $theme_option_main_width_style : 'container';
$layout_class = '';
$content_wrap_class = '';
$if_has_widget = false;

$blogListSidebarLayout = 'without-sidebar';
$blogListSidebarWidgetsSet = false;
$blogListSidebar = seatheme_get_option( 'theme_option_blog_list_sidebar' );
if ( $blogListSidebar ) {
	if ( $blogListSidebar != 'without-sidebar' ) {
		$if_has_widget = 'yes';
		$blogListSidebarWidgets = seatheme_get_option( 'theme_option_blog_list_sidebar_widgets' );
		if ( $blogListSidebarWidgets ) {
			if ( is_active_sidebar( $blogListSidebarWidgets ) ) {
				$blogListSidebarWidgetsSet = $blogListSidebarWidgets;
				$if_has_widget = 'yes';
				$layout_class = 'sidebar-layout row';
				$content_wrap_class = 'col-sm-9 col-md-9';
			}
		}
		
		if ( $blogListSidebar == 'left-sidebar' ) {
			$content_wrap_class .= ' pull-right';
		}
	} else {
		$blogListWidthClass = 'bm-width-100';
		if ( $blogListWidth = seatheme_get_option( 'theme_option_blog_list_width' ) ) {
			$blogListWidthClass = $blogListWidth;
		}
		$container .= ' ' .$blogListWidthClass;
	}
}

?>
    <div id="content">
    
        <?php //** Do Hook Archive before
		do_action('seatheme_interface_archive_before'); ?>
        
        <div class="content_wrap_outer <?php echo esc_attr( $container ); ?>">
			<?php 
			if ( $blogListTitleSwitch = seatheme_get_option( 'theme_option_blog_list_switch_title' ) ) {
				seatheme_get_template_part('global/content', 'titlewrap'); 
			}
			
			?>
        
            <div class="<?php echo esc_attr($layout_class); ?>">
                <div id="content_wrap" class="<?php echo esc_attr($content_wrap_class); ?>">

                    <?php
                    //** Do Hook Archive loop
                    /**
                     * @hooked  seatheme_interface_archive_loop - 10
                     */
                    do_action('seatheme_interface_archive_loop');
					
					if ( is_home() ) {
						global $wp_query;
						if ( $wp_query->is_posts_page ) {
							if ( $blogListShowCB = seatheme_get_option( 'theme_option_blog_list_show_cb' ) ) {
								$wp_version = get_bloginfo( 'version' );
								
								$postID = get_queried_object_id();
								$post = get_post( $postID );
								$content = '';
								$appendTo = false;
								
								if ( $post->post_content ) {
									$content .= $post->post_content;
								}
								
								if ( version_compare( $wp_version, '5.0', '>=' ) ) {
									if ( function_exists( 'has_blocks' ) ) {
										if (false === strpos( $content, 'ux_cb_wrap' ) ) {
											$appendTo = true;
										}
									}
								}
								
								if ( $appendTo ) {
									if ( $uxCbContent = get_post_meta( $postID, 'ux-cb-content', true ) ) {
										$content .= $uxCbContent;
									}
								}
								
								if ( $content != '' ) {
									echo do_shortcode( $content );
								}
							}
						}
					}
					
					?>
                    
                </div>
                
                <?php //** Do Hook Sidebar Widget
				if ( $if_has_widget === 'yes' ) { ?>
					<aside id="sidebar-widget" class="col-md-3 col-sm-3" >
						<ul class="sidebar_widget">
							<?php
							if ( $blogListSidebarWidgetsSet ) {
								dynamic_sidebar( $blogListSidebarWidgetsSet );
							} ?>
						</ul>
					</aside>
				<?php
                } ?>
                
            </div>
        </div>
        
    </div><!--End content-->
  
<?php get_footer(); ?>