<?php
//select icons
function seatheme_theme_option_select_icons(){
	$icons_fields = seatheme_theme_icons_fields();
	$get_value = get_option('ux_theme_option_icons_custom');
	$i = $_POST['i'];
	$type = $_POST['type']; ?>

    <div class="ux-theme-option-select-icons" data-type="<?php echo esc_attr( $type ); ?>">
        <div class="row">
            <div class="col-xs-4">
                <h5><strong><?php esc_html_e('Select Icon','sea-theme'); ?></strong></h5>
                <p class="text-muted"><?php esc_html_e('Choose a icon for this Icon Box','sea-theme'); ?></p>
            </div>
            
            <div class="col-xs-8">
                <select class="form-control">
					<option value="fontawesome"><?php esc_html_e('Font Awesome','sea-theme'); ?></option>
                    <?php if($get_value){ ?>
                        <option value="user-uploaded-icons"><?php esc_html_e('User Uploaded Icons','sea-theme'); ?></option>
                    <?php } ?>
                </select>
                <div class="ux-theme-option-icons">
					<?php foreach($icons_fields as $icon){  ?>
                        <a href="#" class="fontawesome"><i class="<?php echo esc_attr($icon); ?>"></i></a>
                    <?php }
					
					if($get_value){
						foreach($get_value as $portfolio){
							$image_src = wp_get_attachment_image_src($portfolio); ?>
                            <a href="#" class="user-uploaded-icons"><img src="<?php echo esc_url($image_src[0]); ?>" /></a>
						<?php
						}
					} ?>
                    <div class="clearfix"></div>
                    <input type="hidden" id="ux-theme-social-medias-rel" value="<?php echo sanitize_text_field($i); ?>" />
                    <input type="hidden" id="ux-theme-option-icons-input" value="" />
                </div>
            </div>
        </div>
    </div>
    
	<?php
	die('');
}
add_action('wp_ajax_seatheme_theme_option_select_icons', 'seatheme_theme_option_select_icons');

//theme restore defaults
function seatheme_theme_option_restore(){
	$delete = delete_option('ux_theme_option');
	echo (esc_html($delete)) ? 'success' : 'error';
	die('');
}
add_action('wp_ajax_seatheme_theme_option_restore', 'seatheme_theme_option_restore');

//load slider
function seatheme_theme_meta_slider_ajax(){
	$data = $_POST['data'];
	
	switch($data){
		case 'load-slider':
			$selected = (isset($_POST['selected'])) ? $_POST['selected'] : false; ?>
            
            <option value="-1" <?php selected(sanitize_text_field($selected), '-1'); ?>><?php esc_html_e('Select a slider','sea-theme'); ?></option>
            
			<?php $slider = $_POST['slider'];
			switch($slider){
				case 'zoomslider':
					$get_topslider = get_posts(array(
						'posts_per_page' => -1,
						'post_type' => 'zoomslider'
					));
					foreach($get_topslider as $zoomslider){ ?>
						<option value="<?php echo sanitize_text_field($zoomslider->post_name); ?>" <?php selected(sanitize_text_field($selected), sanitize_text_field($zoomslider->post_name)); ?>><?php echo esc_html($zoomslider->post_title); ?></option>
					<?php
					}
				break;
				
				case 'revolutionslider':
					global $wpdb;
					$table_revslider = $wpdb->prefix . "revslider_sliders";
					$revslidersliders = $wpdb->get_results($wpdb->prepare("
						SELECT * FROM $table_revslider
						ORDER BY id ASC
						", $table_revslider
					));
					
					if(count($revslidersliders)){
						$slider_revslider = array();
						foreach($revslidersliders as $num => $slider){
							$params = (array) json_decode($slider->params);
							if(isset($params['template'])){
								$template = $params['template'] == 'true' ? true : false;
								if(!$template){ ?>
									<option value="<?php echo sanitize_text_field($slider->alias); ?>" <?php selected(sanitize_text_field($selected), sanitize_text_field($slider->alias)); ?>><?php echo esc_html($slider->title); ?></option>
								<?php
								}
							}
                        }
					}
				break;
				
				case 'layerslider':
					global $wpdb;
					$table_layerslider = $wpdb->prefix . "layerslider";
					$layerslider = $wpdb->get_results($wpdb->prepare("
						SELECT * FROM %s
						WHERE flag_hidden = '0' AND flag_deleted = '0'
						ORDER BY id ASC
						", $table_layerslider
					));
					
					if(count($layerslider)){
						$slider_layerslider = array();
						foreach($layerslider as $num => $slider){
							$name = empty($slider->name) ? 'Unnamed' : $slider->name; ?>
                            <option value="<?php echo sanitize_text_field($slider->id); ?>" <?php selected(sanitize_text_field($selected), sanitize_text_field($slider->id)); ?>><?php echo esc_html($name); ?></option>
						<?php	
						}
					}
				break;
			}
			
		break;
	}
	die('');
}
add_action('wp_ajax_seatheme_theme_meta_slider_ajax', 'seatheme_theme_meta_slider_ajax');

//generate thumbs
function seatheme_theme_option_generate_thumbs_ajax(){
	$get_posts = get_posts(array(
		'posts_per_page' => -1,
		'post_type' => 'any'
	));
	
	if($get_posts){
		$thumbnails = array();
		
		foreach($get_posts as $post){
			if(has_post_thumbnail($post->ID)){
				$attachment_metadata = wp_get_attachment_metadata(get_post_thumbnail_id($post->ID));
				$thumbnail_crop = update_post_meta(get_post_thumbnail_id($post->ID), '_thumbnail_crop', true);
				if($attachment_metadata && !$thumbnail_crop){
					$thumbnails[get_post_thumbnail_id($post->ID)] = get_post_thumbnail_id($post->ID);
				}
			}
		}
		
		if(count($thumbnails)){
			foreach($thumbnails as $thumbs){ ?>
				<input class="generate_thumbs_progress_thumbnails" type="hidden" value="<?php echo sanitize_text_field($thumbs); ?>" />
			<?php } ?>
            <input id="generate_thumbs_progress_count" type="hidden" value="<?php echo sanitize_text_field(count($thumbnails)); ?>" />
            <div id="generate_thumbs_progress" class="progress">
                <div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">0/<?php echo esc_attr(count($thumbnails)); ?></div>
            </div>
		<?php
        }
	}else{
		echo 'error';
	}
	
	
	die('');
}
add_action('wp_ajax_seatheme_theme_option_generate_thumbs_ajax', 'seatheme_theme_option_generate_thumbs_ajax');

//more categories
function seatheme_theme_option_process_more_categories(){
	$taxonomy = $_POST['taxonomy'];
	$exclude = $_POST['exclude'];
	$name = $_POST['name'];
	$get_value = $_POST['value'];
	$get_value = explode(',', $get_value);
	
	$terms = get_terms( array(
		'taxonomy' => $taxonomy,
		'hide_empty' => false,
		'number' => 50,
		'exclude' => $exclude
	) );
	
	if($terms){
		foreach($terms as $term){
			if (is_object($term) && isset($term->name) && isset($term->term_id)) {
				$value = false;
				if(is_array($get_value)){
					$value = (in_array($term->term_id, $get_value)) ? $term->term_id : false;
				} ?>
				<li>
                    <input type="checkbox" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr($term->term_id); ?>" <?php checked(esc_attr($value), $term->term_id); ?>>
                    <span class="pull-left"><?php echo esc_html($term->name); ?></span>
                </li>
				
                <?php
			}
		}
	}
	
	die('');
}
add_action('wp_ajax_seatheme_theme_option_process_more_categories', 'seatheme_theme_option_process_more_categories');

//process generate thumbs size
function seatheme_theme_option_process_generate_thumbs_size($image_width, $image_height, $target_name, $target_width, $target_height, $crop){
	$thumbs_width = $target_width;
	$thumbs_height = $target_height;
	$thumbs_crop = $crop;
	
	if($image_width < $image_height){ //is long vertical image
		if($target_name == 'seatheme-thumb-11-normal'){ // target is square image
			if($image_width < $target_width){
				$thumbs_width = $image_width;
				$thumbs_height = $image_width;
			}
		}
		
		if($target_name == 'seatheme-standard-thumb' || $target_name == 'seatheme-standard-thumb-medium' || $target_name == 'seatheme-standard-thumb-big'){ // target is 9999 height
			$thumbs_crop = false;
			if($image_width < $target_width){
				$thumbs_width = $image_width;
			}
		}
		
		if($target_name == 'seatheme-thumb-169-normal' || $target_name == 'seatheme-thumb-43-big' || $target_name == 'seatheme-thumb-43-medium'){ // target is long horizontal image
			if($image_width < $target_width){
				$target_ratio = $target_height / $target_width;
				$thumbs_width = $image_width;
				$thumbs_height = $image_width * $target_ratio;
			}
		}
		
	}
	
	if($image_width > $image_height){ //is long horizontal image
		if($target_name == 'seatheme-thumb-11-normal'){ // target is square image
			if($image_height < $target_height){
				$thumbs_width = $image_height;
				$thumbs_height = $image_height;
			}
		}
		
		if($target_name == 'seatheme-standard-thumb' || $target_name == 'seatheme-standard-thumb-medium' || $target_name == 'seatheme-standard-thumb-big'){ // target is 9999 height
			$thumbs_crop = false;
			if($image_width < $target_width){
				$thumbs_width = $image_width;
			}
		}
		
		if($target_name == 'seatheme-thumb-169-normal' || $target_name == 'seatheme-thumb-43-big' || $target_name == 'seatheme-thumb-43-medium' ){ // target is long horizontal image
			if($image_height < $target_height){
				$target_ratio = $target_width / $target_height;
				$thumbs_height = $image_height;
				$thumbs_width = $image_height * $target_ratio;
				
				if($image_width < $thumbs_width){
					$target_ratio = $image_width /  $thumbs_width;
					$thumbs_width = $image_width;
					$thumbs_height = $image_height * $target_ratio;
				}
			}
			
			if($image_height > $target_height){
				$target_ratio = $target_height / $image_height;
				$thumbs_width = $image_width * $target_ratio;
				
				if($thumbs_width < $target_width){
					$target_ratio = $target_height / $target_width;
					$thumbs_width = $image_width;
					$thumbs_height = $image_width * $target_ratio;
				}
				
				if($thumbs_width > $target_width){
					$thumbs_width = $target_width;
					$thumbs_height = $target_height;
				}
			}
		}
		
	}
	
	if($image_width == $image_height){ //is square image
		if($target_name == 'seatheme-thumb-11-normal'){ // target is square image
			if($image_width < $target_width){
				$thumbs_width = $image_width;
				$thumbs_height = $image_height;
			}
		}
		
		if($target_name == 'seatheme-thumb-169-normal' || $target_name == 'seatheme-thumb-43-big' || $target_name == 'seatheme-thumb-43-medium' ){ // target is long horizontal image
			if($image_width < $target_width){
				$target_ratio = $target_height / $target_width;
				$thumbs_width = $image_width;
				$thumbs_height = $image_height * $target_ratio;
			}
		}
	}
	
	return array($thumbs_width, $thumbs_height, $thumbs_crop);
}

//process generate thumb
function seatheme_theme_option_process_generate_thumb($thumbnail_id){
	$return = false;
	$upload_dir = wp_upload_dir();
	$attachment_metadata = wp_get_attachment_metadata($thumbnail_id);
	$attachment_mime_type = get_post_mime_type($thumbnail_id);
	
	$custom_image_size = array(
		array('seatheme-standard-thumb', 650, 9999, true),
		array('seatheme-standard-thumb-medium', 1000, 9999, false),
		array('seatheme-standard-thumb-big', 2000, 9999, false),
		array('seatheme-thumb-169-normal', 800, 450, true),
		array('seatheme-thumb-11-normal', 650, 650, true),
		array('seatheme-thumb-43-big', 2000, 1500, true),
		array('seatheme-thumb-43-medium', 1000, 750, true)
	);
	
	if($attachment_metadata){
		$thumbnail_file = $upload_dir['basedir'] . '/' . $attachment_metadata['file'];
		$thumbnail_width = intval($attachment_metadata['width']);
		$thumbnail_height = intval($attachment_metadata['height']);
		$thumbnail_pathinfo = pathinfo($thumbnail_file);
		$thumbnail_extension = $thumbnail_pathinfo['extension'];
		$thumbnail_info = pathinfo(get_attached_file($thumbnail_id));
		$thumbnail_basename = str_replace('.' .$thumbnail_info['extension'], '' , $thumbnail_info['basename']);
		
		if($thumbnail_extension != 'gif'){
			foreach($custom_image_size as $image_size){
				$new_image = wp_get_image_editor($thumbnail_file);
				
				if(!is_wp_error($new_image)){
					$image_size_name = $image_size[0];
					$image_size_width = intval($image_size[1]);
					$image_size_height = intval($image_size[2]);
					$image_size_crop = $image_size[3];
					
					$final_size = seatheme_theme_option_process_generate_thumbs_size($thumbnail_width, $thumbnail_height, $image_size_name, $image_size_width, $image_size_height, $image_size_crop);
					$final_width = $final_size[0];
					$final_height = $final_size[1];
					$final_crop = $final_size[2];
	
					$new_image->resize($final_width, $final_height, $final_crop);
					$new_image_dir = $thumbnail_info['dirname'];
					
					$new_image_dir = str_replace('/' .$thumbnail_info['basename'], '', $new_image_dir);
					$new_image_file = $new_image_dir . '/' . $thumbnail_basename . '-' . $image_size_name . '-' . $new_image->get_suffix() . '.' . $thumbnail_extension;
					
					$result = @unlink($new_image_file); 
					$saved = $new_image->save($new_image_file, $attachment_mime_type);
					if($saved){
						$new_image_size = $new_image->get_size();
						$attachment_metadata['sizes'][$image_size_name] = array(
							'file' => $thumbnail_basename . '-' . $image_size_name . '-' . $new_image->get_suffix() . '.' . $thumbnail_extension,
							'width' => $new_image_size['width'],
							'height' => $new_image_size['height']
						);
						$new_image_update = wp_update_attachment_metadata($thumbnail_id, $attachment_metadata);
					}
				}
			}
		}
		
		$thumbnail_update = update_post_meta($thumbnail_id, '_thumbnail_crop', 'yes');
		if($thumbnail_update){
			$return = true;
		}
	}
	
	return $return;
}

//process generate thumbs
function seatheme_theme_option_process_generate_thumbs_ajax(){
	$thumbnail_id = $_POST['thumbnail_id'];
	if(seatheme_theme_option_process_generate_thumb($thumbnail_id)){
		echo 'success';
	}
	die('');
}
add_action('wp_ajax_seatheme_theme_option_process_generate_thumbs_ajax', 'seatheme_theme_option_process_generate_thumbs_ajax');

//process generate thumbs
function seatheme_theme_option_auto_select(){
	$keyword = $_POST['keyword'];
	
	if($keyword){
		$query = new WP_Query( array( 's' => $keyword ) );
		if($query->have_posts()){
			echo '<ul>';
			while($query->have_posts()){ $query->the_post();
				$title = str_replace($keyword, '<ins>' .$keyword. '</ins>', get_the_title()); ?>
				<li><a data-id="<?php the_ID(); ?>" href="<?php the_permalink(); ?>">#<?php the_ID(); ?> - <?php echo wp_kses_post($title); ?></a></li>
			<?php
            }
			echo '</ul>';
			wp_reset_postdata();
		}else{
			echo 'error';
		}
	}
	
	die('');
}
add_action('wp_ajax_seatheme_theme_option_auto_select', 'seatheme_theme_option_auto_select');
?>