<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Theme Options field social.
 */
if ( ! function_exists( 'seatheme_theme_options_field_social' ) ) {
	function seatheme_theme_options_field_social( $item, $key, $getValue ) {
		if ( $item['type'] == 'socialMedias' ) {
			echo '<div class="ux-theme-new-social-medias">';
			
				$count = 1;
				if ( $getValue ) {
					$count = count( $getValue['icontype'] );
				} else {
					$getValue = array( 'icontype' => array( '' ), 'icon' => array( '' ), 'url' => array( '' ), 'tip' => array( '' ) );
				}
				
				for ( $i=0; $i < $count; $i++ ) {
					$type = $getValue['icontype'][$i];
					$icon = $getValue['icon'][$i];
					$url = $getValue['url'][$i];
					$tip = $getValue['tip'][$i];
					$btnRemove = $i == 0 ? 'hidden' : false;
					$btnRemoveStyle = $i == 0 ? false : 'right: 40px;';
					$btnAdd = $i != 0 ? 'hidden' : false; 
					
					echo '<div class="ux-theme-social-medias" rel="' .esc_attr( $i ). '">';
					echo   '<div class="new-media-col-select-icon pull-left">';
					echo     '<button type="button" class="btn btn-default btn-sm" data-title="' .esc_attr__( 'Select Icon', 'sea-theme' ). '">';
					echo     '<i class="fa fa-ellipsis-h"></i></button>';
					echo   '</div>';
					echo   '<div class="new-media-col-icon pull-left">';
					echo     '<div class="icon-content">';
					
						if ( $type == 'fontawesome' ) {
							echo '<i class="' .esc_attr( $icon ). '"></i>';
                        } else if ( $type == 'user' ) { 
							echo '<img src="' .esc_url( $icon ). '" />';
						}
					
					echo     '</div>';
					echo     '<input type="hidden" name="' .esc_attr( $key. '[' .$item['name']. '][icon][]'). '" value="' .esc_attr( $icon ). '" />';
					echo     '<input type="hidden" name="' .esc_attr( $key. '[' .$item['name']. '][icontype][]'). '" value="' .esc_attr($type). '" />';
					echo   '</div>';
					echo   '<div class="new-media-col-url">';
					echo     '<input type="text" name="' .esc_attr( $key. '[' .$item['name']. '][url][]'). '" class="form-control input-sm pull-left" value="' .esc_url( $url ). '" placeholder="' .esc_attr__( 'Enter the social media url', 'sea-theme' ). '" />';
					echo     '<input type="text" name="' .esc_attr( $key. '[' .$item['name']. '][tip][]'). '" class="form-control input-sm pull-left" value="' .esc_attr( $tip ). '" placeholder="' .esc_attr__( 'Social media name', 'sea-theme' ). '" />';
					echo   '</div>';
					echo   '<div class="new-media-col-remove pull-right ' .esc_attr( $btnRemove ). '" style="' .esc_attr( $btnRemoveStyle ). '">';
					echo     '<button type="button" class="btn btn-danger btn-sm social-medias-remove"><span class="glyphicon glyphicon-remove"></span></button>';
					echo   '</div>';
					echo   '<div class="new-media-col-add pull-right ' .esc_attr( $btnAdd ). '">';
					echo     '<button type="button" class="btn btn-info btn-sm social-medias-add "><span class="glyphicon glyphicon-plus"></span></button>';
					echo   '</div>';
					echo   '<div class="clearfix"></div>';
					echo '</div>';
				}
				
			echo '</div>';
		}
	}
	add_action( 'seatheme_theme_options_get_field', 'seatheme_theme_options_field_social', 10, 3 );
}