<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Theme Options field items.
 */
if ( ! function_exists( 'seatheme_theme_options_field_items' ) ) {
	function seatheme_theme_options_field_items( $item, $key, $getValue ) {
		if ( $item['type'] == 'items' ) {
			echo '<div class="ux-theme-footer-elements">';
			
				$count = 1;
				
				if ( ! is_array( $getValue ) ) { $getValue = array( 'type' => array( $getValue ), 'menu' => array( '' ), 'text' => array( '' ), 'widge' => array( '' ) ); }
				if ( $getValue ) {
					$count = count( $getValue['type'] );
				} else {
					$getValue = array( 'type' => array( 'logo' ), 'menu' => array( '' ), 'text' => array( '' ), 'widge' => array( '' ) );
				}
				
				for ( $i=0; $i < $count; $i++ ) {
					$type = $getValue['type'][$i];
					$menu = $getValue['menu'][$i];
					$text = $getValue['text'][$i];
					$widget = 'footer_widget_1';
					
					if ( isset( $getValue['widget'] ) ) {
						$widget = $getValue['widget'][$i];
					}
					
					$menuHidden = $type == 'menu' ? false : 'hidden';
					$textHidden = $type == 'text' ? false : 'hidden';
					$widgetHidden = $type == 'widget' ? false : 'hidden';
					
					$btnAdd = $i == 0 ? false : 'hidden';
					$btnRemove = $i > 0 ? false : 'hidden';
					
					echo '<div class="ux-theme-footer-element-item row">';
					echo   '<div class="col-xs-10">';
					
							//type
							echo '<select class="form-control input-sm ux-theme-footer-element-type" name="' .esc_attr( $key. '[' .$item['name']. '][type][]'). '">';
								if ( $item['fields'] ) {
									foreach ( $item['fields'] as $field ) {
										echo '<option value="' .esc_attr( $field[1] ). '" ' .selected( $type, $field[1], false ). '>' .esc_html( $field[0] ). '</option>';
									}
								} else {
									echo '<option selected="selected" value="0">' .esc_html__( 'No options', 'sea-theme' ). '</option>';
								}
							echo '</select>';
							
							//menu
							echo '<select class="form-control input-sm ux-theme-footer-element-menu ' .esc_attr( $menuHidden ). '" name="' .esc_attr( $key. '[' .$item['name']. '][menu][]'). '">';
								if ( $menus = wp_get_nav_menus() ) {
									foreach ( $menus as $m ) {
										echo '<option value="' .esc_attr( $m->term_id ). '" ' .selected( $menu, $m->term_id, false ). '>' .esc_html( $m->name ). '</option>';
									}
								} else {
									echo '<option selected="selected" value="0">' .esc_html__( 'No Menus', 'sea-theme' ). '</option>';
								}
							echo '</select>';
					
							//widget
							echo '<select class="form-control input-sm ux-theme-footer-element-widget ' .esc_attr( $widgetHidden ). '" name="' .esc_attr( $key. '[' .$item['name']. '][widget][]'). '">';
								$footerWidget = array(
									array('value' => 'footer_widget_1', 'title' => __('Footer 1 for Post/Page','sea-theme')),
									array('value' => 'footer_widget_2', 'title' => __('Footer 2 for Post/Page','sea-theme')),
									array('value' => 'footer_widget_3', 'title' => __('Footer 3 for Post/Page','sea-theme')),
									array('value' => 'footer_widget_4', 'title' => __('Footer 4 for Post/Page','sea-theme')),
									array('value' => 'footer_widget_5', 'title' => __('Footer 5 for Post/Page','sea-theme'))
								);
					
								foreach ( $footerWidget as $thisWidget ) {
									echo '<option value="' .$thisWidget['value']. '" ' .selected( $widget, $thisWidget['value'], false ). '>' .$thisWidget['title']. '</option>';
								}
							echo '</select>';
							
							//text
							echo '<textarea rows="4" class="form-control ux-theme-footer-element-text ' .esc_attr( $textHidden ). '" name="' .esc_attr( $key. '[' .$item['name']. '][text][]'). '">' .stripslashes( $text ). '</textarea>';
							
					echo   '</div>';
					echo   '<div class="col-xs-2">';
					echo     '<button type="button" class="btn btn-info btn-sm footer-element-add ' .esc_attr( $btnAdd ). '"><span class="glyphicon glyphicon-plus"></span></button>';
					echo     '<button type="button" class="btn btn-danger btn-sm footer-element-remove ' .esc_attr( $btnRemove ). '"><span class="glyphicon glyphicon-remove"></span></button>';
					echo   '</div>';
					echo '</div>';
				}
			
			echo '</div>';
		}
	}
	add_action( 'seatheme_theme_options_get_field', 'seatheme_theme_options_field_items', 10, 3 );
}