<?php
//social setting config fields
if ( ! function_exists( 'seatheme_theme_options_social_fields' ) ) {
	function seatheme_theme_options_social_fields( $fields ) {
		$fields['social'] = array(
			'id' => 'options-social-networks',
			'title' => esc_html__( 'Social Networks', 'sea-theme' ),
			'region' => array(
				array(
					'region-id' => 'social-media-links',
					'title' => esc_html__( 'Your Social Media Links', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(

										// Social Medias
										array('title'   => esc_html__( 'Social Medias', 'sea-theme' ),
											  'type'    => 'socialMedias',
											  'name'    => 'theme_option_show_social_medias' ),
				
										array('title'   => esc_html__( 'Icon Size', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_social_icon_size',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),
				
										array('title'   => esc_html__( 'Icon Spacing', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_social_icon_spacing',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),
				
										array('title'   => esc_html__( 'Open in new window/tab', 'sea-theme' ),
											  'type'    => 'switch',
											  'default' => 'false',
											  'name'    => 'theme_option_show_social_medias_new_tab' )
									)
								)
							)
						)
					)
				),

				array(
					'region-id' => 'social-media-buttons',
					'title' => esc_html__( 'Share Buttons For Post', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
											 
										// Enable Share Buttons for Posts
										array('title'   => esc_html__( 'Enable Share Buttons for Posts', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_enable_share_buttons_for_posts',
											  'default' => 'true' )
									)
								),
								array(
									'group-ctrl' => 'theme_option_enable_share_buttons_for_posts,true',
									'items' => array(
																			
										array('type'    => 'checkboxGroup',
											  'name'    => 'theme_option_share_buttons',
											  'default' => array( 'facebook', 'twitter', 'google-plus', 'pinterest' ),
											  'fields'  => array(
												  array( esc_html__('Facebook','sea-theme'),    'facebook' ),
												  array( esc_html__('Twitter','sea-theme'),     'twitter' ),
												  array( esc_html__('Pinterest','sea-theme'),   'pinterest' ),
												  array( esc_html__('Digg','sea-theme'),        'digg' ),
												  array( esc_html__('Reddit','sea-theme'),      'reddit' ),
												  array( esc_html__('Linkedin','sea-theme'),    'linkedin' ),
												  array( esc_html__('Stumbleupon','sea-theme'), 'stumbleupon' ),
												  array( esc_html__('Tumblr','sea-theme'),      'tumblr' ),
												  array( esc_html__('Mail','sea-theme'),        'mail' ) ) ),
				
										array('title'   => esc_html__( 'Icon Size', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_social_share_icon_size',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),
				
										array('title'   => esc_html__( 'Icon Spacing', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_social_share_icon_spacing',
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),
									)
								)
							)
						)
					)
				)
			)
		);
		
		return $fields;
	}
	add_filter( 'seatheme_theme_options_fields', 'seatheme_theme_options_social_fields' );
}
		