<?php
//general setting config fields
if ( ! function_exists( 'seatheme_theme_options_general_fields' ) ) {
	function seatheme_theme_options_general_fields( $fields ) {
		$fields['general'] = array(
			'id' => 'options-general',
			'title' => esc_html__( 'General Settings', 'sea-theme' ),
			'region' => array(
				array(
					'region-id' => 'general-logo',
					'title' => esc_html__( 'Logo', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										// Enable Plain Text Logo
										array('title'   => esc_html__( 'Enable Plain Text Logo', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_enable_text_logo',
											  'default' => 'false' )
									)
								),
								array(
									'group-ctrl' => 'theme_option_enable_text_logo,true',
									'items' => array(
				
										// Logo Text
										array('title'   => esc_html__( 'Logo Text', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_text_logo' )
									
									)
								),
								array(
									'group-ctrl' => 'theme_option_enable_text_logo,false',
									'items' => array(
				
										// Default image Logo
										array('title'   => esc_html__( 'Default Image Logo', 'sea-theme' ),
											  'type'    => 'upload',
											  'name'    => 'theme_option_custom_logo_default' ),
				
										// Alt image Logo(light)
										array('title'   => esc_html__( 'Alternative Image Logo', 'sea-theme' ),
											  'type'    => 'upload',
											  'desc'    => esc_html__( 'It is optional.', 'sea-theme' ),
											  'name'    => 'theme_option_custom_logo_alt' ),

										// Default image Logo for Mobile
										array('title'   => esc_html__( 'Default Image Logo for Mobile', 'sea-theme' ),
											  'type'    => 'upload',
											  'desc'    => esc_html__( 'It is optional.', 'sea-theme' ),
											  'name'    => 'theme_option_custom_logo_default_mobile' ),
				
										// Alt image Logo(light) for Mobile
										array('title'   => esc_html__( 'Alternative Image Logo for Mobile', 'sea-theme' ),
											  'type'    => 'upload',
											  'desc'    => esc_html__( 'It is optional.', 'sea-theme' ),
											  'name'    => 'theme_option_custom_logo_alt_mobile' ),
				
										// Logo size
										array('title'   => esc_html__( 'Custom Logo Height', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_custom_logo_height', 
											  'desc'    => esc_html__( 'It is optional.', 'sea-theme' ),
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),
				
										// Custom Logo For Loader
										array('title'   => esc_html__( 'Logo For Page Loader', 'sea-theme' ),
											  'type'    => 'upload',
											  'name'    => 'theme_option_custom_logo_for_loading' ),

										array('title'   => esc_html__( 'Loader Logo Height', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_custom_loader_logo_height', 
											  'desc'    => esc_html__( 'It is optional.', 'sea-theme' ),
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) ),
				
										// Costom Footer Logo
										array('title'   => esc_html__( 'Logo For Footer', 'sea-theme' ),
											  'type'    => 'upload',
											  'name'    => 'theme_option_custom_footer_logo' ),
				
										// Costom Footer Logo size
										array('title'   => esc_html__( 'Footer Logo Height', 'sea-theme' ),
											  'type'    => 'multipleInput',
											  'name'    => 'theme_option_custom_foot_logo_height',
											  'desc'    =>  esc_html__( 'It is optional.', 'sea-theme' ),
											  'style'   => 'width: 102px; margin-right: 1em;',
											  'col'     => 2,
											  'place'   => array( esc_html__( 'Desktop', 'sea-theme' ), esc_html__( 'Mobile', 'sea-theme' ) ) )
									
									)
								)
							)
						)
					)
				),
				array(
					'region-id' => 'general-global',
					'title' => esc_html__( 'Global', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										// Main Container Type
										array('title'   => esc_html__( 'Main Container Type', 'sea-theme' ),
											  'type'    => 'select',
											  'name'    => 'theme_option_main_width_style',
											  'style'   => 'width: 132px;',
											  'default' => 'container',
											  'fields'  => array(
												  array( esc_html__( 'Fluid Width', 'sea-theme' ), 'container-fluid' ),
												  array( esc_html__( 'Fixed Width', 'sea-theme' ), 'container') 
											  ) )
									)
								),
								array(
									'group-ctrl' => 'theme_option_main_width_style,container',
									'items' => array(
				
										// Main Container Width
										array('title'   => esc_html__( 'Main Container Width (px)', 'sea-theme' ),
											  'type'    => 'select',
											  'name'    => 'theme_option_main_width',
											  'style'   => 'width: 102px;',
											  'default' => '1170',
											  'fields'  => array(
												  array( esc_html__( '1170', 'sea-theme' ), '1170' ),
												  array( esc_html__( '1070', 'sea-theme' ), '1070' ),
												  array( esc_html__( '970', 'sea-theme' ),  '970')
											  ) ),
											  
										// Main Container Width for Single Post and Portfolio
										array('title'   => esc_html__( 'Main Container Width for Single Post and Portfolio', 'sea-theme' ),
											  'type'    => 'select',
											  'name'    => 'theme_option_main_width_post',
											  'style'   => 'width: 102px;',
											  'default' => '1170',
											  'fields'  => array(
												  array( esc_html__( '1170', 'sea-theme' ), '1170' ),
												  array( esc_html__( '1070', 'sea-theme' ), '1070' ),
												  array( esc_html__( '970', 'sea-theme' ),  '970')
											  ) )
									)
								),
								array(
									'group-ctrl' => 'theme_option_main_width_style,container-fluid',
									'items' => array(
				
										// Header Fluid Padding
										array('title'   => esc_html__( 'Main Container Fluid Padding', 'sea-theme' ),
											  'desc'    => esc_html__( 'it is option, or enter a number', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_main_padding',
											  'style'   => 'width: 102px;' ),

										// Max Width
										array('title'   => esc_html__( 'Main Container Max Width', 'sea-theme' ),
											  'desc'    => esc_html__( 'it is option, please enter a number if you want to limit the container width', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_main_max_width',
											  'style'   => 'width: 102px;' ),
									)
								),
								array(
									'items' => array(
				
										// Enable  page loader
										array('title'   => esc_html__( 'Page Loader', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_enable_fadein_effect',
											  'default' => 'false' ),
				
										// Enable image lazyload
										array('title'   => esc_html__( 'Image LazyLoad', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_enable_image_lazyload',
											  'default' => 'true' ),

										// Enable default font
										array('title'   => esc_html__( 'Enable Default Font', 'sea-theme' ),
											  'desc'    => esc_html__( 'Please disable this option if you have set the Font settings.', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_enable_default_fonts',
											  'default' => 'true' )

									)
								)
							)
						)
					)
				),
				array(
					'region-id' => 'mobile-responsive',
					'title' => esc_html__( 'Mobile', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
						
										// Enable Mobile Layout
										array('title'   => esc_html__( 'Enable Mobile Layout', 'sea-theme' ),
											  'desc'    => esc_html__( 'disable this option if you want to display the same with desktop end', 'sea-theme' ),
											  'type'    => 'switch',
											  'name'    => 'theme_option_mobile_enable_responsive',
											  'default' => 'true')
									)
								)
							)
						)
					)
				),
				
				array(
					'region-id' => 'descriptions',
					'title' => esc_html__( 'Descriptions', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
									
										// Pagination Next Text
										array('title'   => esc_html__( 'Pagination Next(Archive page)', 'sea-theme' ),
											  'type'    => 'input',
											  'default' => '',
											  'name'    => 'theme_option_descriptions_pagination_next' ),
						
										// Pagination Previous Text
										array('title'   => esc_html__( 'Pagination Previous(Archive page)', 'sea-theme' ),
											  'type'    => 'input',
											  'default' => '',
											  'name'    => 'theme_option_descriptions_pagination_prev' ),
						
										// Comment Title
										array('title'   => esc_html__( 'Comment Title', 'sea-theme' ),
											  'desc'    => '',
											  'type'    => 'input',
											  'default' => '',
											  'name'    => 'theme_option_descriptions_comment_title' ),
										
										// Comment Box Name Placeholder
										array('title'   => esc_html__( 'Comment Box Name Placeholder', 'sea-theme' ),
											  'type'    => 'input',
											  'default' => '',
											  'name'    => 'theme_option_descriptions_comment_name' ),

										// Comment Box Email Placeholder
										array('title'   => esc_html__( 'Comment Box Email Placeholder', 'sea-theme' ),
											  'type'    => 'input',
											  'default' => '',
											  'name'    => 'theme_option_descriptions_comment_email' ),

										// Comment Box Website Placeholder
										array('title'   => esc_html__( 'Comment Box Website Placeholder', 'sea-theme' ),
											  'type'    => 'input',
											  'default' => '',
											  'name'    => 'theme_option_descriptions_comment_website' ),

										// Comment Box Placeholder
										array('title'   => esc_html__( 'Comment Box Placeholder', 'sea-theme' ),
											  'type'    => 'input',
											  'default' => '',
											  'name'    => 'theme_option_descriptions_your_message' ),
						
										// Comment Submit Button Name
										array('title'   => esc_html__( 'Comment Submit Button Name', 'sea-theme' ),
											  'type'    => 'input',
											  'default' => '',
											  'name'    => 'theme_option_descriptions_comment_submit' ),
						
										// Search
										array('title'   => esc_html__( 'Search', 'sea-theme' ),
											  'type'    => 'input',
											  'default' => '',
											  'name'    => 'theme_option_descriptions_search' ),
						
										// Readmore in Archive
										array('title'   => esc_html__( '"Readmore" in Archive', 'sea-theme' ),
											  'type'    => 'input',
											  'default' => '',
											  'name'    => 'theme_option_descriptions_readmore_more' ),
						
										// "On" before Date
										array('title'   => esc_html__( '"On" before Date', 'sea-theme' ),
											  'type'    => 'input',
											  'default' => '',
											  'name'    => 'theme_option_descriptions_on' ),
						
										// "By" before Autho
										array('title'   => esc_html__( '"By" before Author', 'sea-theme' ),
											  'type'    => 'input',
											  'default' => '',
											  'name'    => 'theme_option_descriptions_by' ),

										// "Tags" 
										array('title'   => esc_html__( '"Tags" lable text before Tags', 'sea-theme' ),
											  'type'    => 'input',
											  'default' => '',
											  'name'    => 'theme_option_descriptions_tags' ),
						
						
										// Post (Previous/Next) Navigation
										array('title'   => esc_html__( 'Previous(Post Navigation)', 'sea-theme' ),
											  'type'    => 'input',
											  'default' => '',
											  'name'    => 'theme_option_descriptions_prev' ),
						
										// Next(Post Navigation)
										array('title'   => esc_html__( 'Next(Post Navigation)', 'sea-theme' ),
											  'type'    => 'input',
											  'default' => '',
											  'name'    => 'theme_option_descriptions_next' )
									)
								)
							)
						)
					)
				),
				
				array(
					'region-id' => 'copyright',
					'title' => esc_html__( 'Copyright', 'sea-theme' ),
					'section' => array(
						array(
							'group' => array(
								array(
									'items' => array(
						
										// Copyright Information
										array('title'   => esc_html__( 'Copyright Information', 'sea-theme' ),
											  'desc'    => esc_html__( 'enter the copyright information, it would be placed on the bottom of the pages', 'sea-theme' ),
											  'type'    => 'input',
											  'name'    => 'theme_option_copyright',
											  'default' => 'Copyright Information.' )
									)
								)
							)
						)  
					)
				)
			)
		);
		
		return $fields;
		
	}
	add_filter( 'seatheme_theme_options_fields', 'seatheme_theme_options_general_fields' );
}
?>