<?php
//SEA Custom Style Function
if ( ! function_exists( 'seatheme_theme_custom_css' ) ) {
function seatheme_theme_custom_css(){
	$custom_css = '';
	
	// Global Color 

$custom_css .= 'body{';
	//  Body BG Color
	$seatheme_bg_page_post = esc_attr(seatheme_get_option('theme_option_bg_page_post'));
	if($seatheme_bg_page_post){
		$custom_css .= '
--color-bg:'.esc_attr($seatheme_bg_page_post).';';
	}

	//Header BGcolor
	$seatheme_header_bg = esc_attr(seatheme_get_option('theme_option_bg_header'));
	if ( $seatheme_header_bg ) {
		$custom_css .= '
--color-header-bg:'.esc_attr( $seatheme_header_bg ).';';
	}

	//Page loader BGcolor
	$seatheme_bg_page_loader = esc_attr(seatheme_get_option('theme_option_bg_page_loader'));
	if($seatheme_bg_page_loader){
		$custom_css .= '
--color-pageloader-bg:'.esc_attr($seatheme_bg_page_loader).';';
	}

	// Auxiliary Color
	$ux_color_second_auxiliary = seatheme_get_option('theme_option_color_second_auxiliary') ? esc_attr(seatheme_get_option('theme_option_color_second_auxiliary')) : '#f8f8f8';
	if($ux_color_second_auxiliary){   
		$custom_css .= '
--color-auxiliary: '.esc_attr($ux_color_second_auxiliary).';';
	}

	// Menu Color

	//Menu on Header Dark
	$seatheme_color_text_menu_icon = seatheme_get_option('theme_option_menu_icon_dark');
	if($seatheme_color_text_menu_icon ){
		$custom_css .= '
--color-menu:'.esc_attr($seatheme_color_text_menu_icon ).';';
	}

	//Menu on Header Alt(light)
	$seatheme_color_text_logo_menu_icon_alt =  esc_attr(seatheme_get_option('theme_option_menu_icon_alt'));
	if($seatheme_color_text_logo_menu_icon_alt ){
 
		$custom_css .= '
--color-alt-menu:'.esc_attr($seatheme_color_text_logo_menu_icon_alt).';';
	}

	// Default Menu Item Mouseover Color
	$seatheme_color_menu_mouseover = esc_attr(seatheme_get_option('theme_option_menu_mouseover_color'));
	if($seatheme_color_menu_mouseover){
		$custom_css .= '
--color-menu-hover:'.esc_attr($seatheme_color_menu_mouseover).';';
	}

	// Default Menu Current Item Color
	$seatheme_color_menu_current = esc_attr(seatheme_get_option('theme_option_menu_current_color'));
	if($seatheme_color_menu_current){
		$custom_css .= '
--color-menu-current:'.esc_attr($seatheme_color_menu_current).';';
	}

	// Alternative Menu Item Mouseover Color
	$seatheme_color_menu_mouseover_alt = esc_attr(seatheme_get_option('theme_option_menu_mouseover_color_alt'));
	if($seatheme_color_menu_mouseover_alt){
		$custom_css .= '
--color-menu-hover-alt:'.esc_attr($seatheme_color_menu_mouseover_alt).';';
	}

	// Alternative Menu Current Item Color
	$seatheme_color_menu_current_alt = esc_attr(seatheme_get_option('theme_option_menu_current_color_alt'));
	if($seatheme_color_menu_current_alt){
		$custom_css .= '
--color-menu-current-alt:'.esc_attr($seatheme_color_menu_current_alt).';';
	}
	
	// Posts & Pages Color
	
	// Title color 
	$theme_option_color_heading = esc_attr(seatheme_get_option('theme_option_color_heading'));
	if($theme_option_color_heading){
		$custom_css .= '
--color-title:'.esc_attr($theme_option_color_heading).';';
	}
	
	// Content text Color 
	$seatheme_color_content = esc_attr(seatheme_get_option('theme_option_color_content_text'));
	if($seatheme_color_content){
		$custom_css .= '
--color-content:'.esc_attr($seatheme_color_content).';';
	}

	//Content Linked text Color
	$seatheme_color_link_text = esc_attr(seatheme_get_option('theme_option_color_content_linked_text'));
	if($seatheme_color_link_text){
		$custom_css .= '
--color-content-linked:'.esc_attr($seatheme_color_link_text).';';
	}

	//Content Mouseover Color
	$seatheme_color_content_hover = esc_attr(seatheme_get_option('theme_option_color_content_hover_text'));
	if($seatheme_color_content_hover){
		$custom_css .= '
--color-content-hover:'.esc_attr($seatheme_color_content_hover).';';
	}
	
	//Meta text Color 
	$seatheme_color_auxiliary_content = esc_attr(seatheme_get_option('theme_option_color_auxiliary_content'));
	if($seatheme_color_auxiliary_content){
		$custom_css .= '
--color-meta:'.esc_attr($seatheme_color_auxiliary_content).';';
	}

	//Meta link text Color 
	$seatheme_color_meta_link = esc_attr(seatheme_get_option('theme_option_color_meta_link'));
	if($seatheme_color_meta_link){
		$custom_css .= '
--color-meta-link:'.esc_attr($seatheme_color_meta_link).';';
	}

	//Meta text mouseover Color 
	$seatheme_color_hover = esc_attr(seatheme_get_option('theme_option_color_meta_link_hover'));
	if($seatheme_color_hover){
		$custom_css .= '
--color-meta-hover:'.esc_attr($seatheme_color_hover).';';
	}

	// Image caption
	$seatheme_color_gallery_caption = esc_attr(seatheme_get_option('theme_option_color_gallery_caption'));
	if($seatheme_color_gallery_caption){
		$custom_css .= '
--color-single-portfolio-caption:'.esc_attr($seatheme_color_gallery_caption).';';
	}

	// Prev & Next
	$seatheme_color_post_navi = esc_attr(seatheme_get_option('theme_option_color_post_navi'));
	if($seatheme_color_post_navi){
		$custom_css .= '
--color-single-navi:'.esc_attr($seatheme_color_post_navi).';';
	}

	// Comment Title
	$seatheme_color_comment_tit = esc_attr(seatheme_get_option('theme_option_color_comment_tit'));
	if($seatheme_color_comment_tit){
		$custom_css .= '
--color-comment-tit:'.esc_attr($seatheme_color_comment_tit).';';
	}

	// Comment Content
	$seatheme_color_comment_con = esc_attr(seatheme_get_option('theme_option_color_comment_con'));
	if($seatheme_color_comment_con){
		$custom_css .= '
--color-comment-con:'.esc_attr($seatheme_color_comment_con).';';
	}

	// Comment Author
	$seatheme_color_comment_author = esc_attr(seatheme_get_option('theme_option_color_comment_author'));
	if($seatheme_color_comment_author){
		$custom_css .= '
 --color-comment-author:'.esc_attr($seatheme_color_comment_author).';';
	}

	// Archive item title mouseover
	$seatheme_color_archive_tit_hover = esc_attr(seatheme_get_option('theme_option_arvhive_tit_hover'));
	if($seatheme_color_archive_tit_hover){
		$custom_css .= '
 --color-archive-tit-hover:'.esc_attr($seatheme_color_archive_tit_hover).';';
	}

	//Selected Text Color
	$seatheme_color_selected_text = esc_attr(seatheme_get_option('theme_option_color_selected_text_font'));
	if($seatheme_color_selected_text){
		$custom_css .= '
--color-selection:'.esc_attr($seatheme_color_selected_text).';';
	}

	//Selected Text Bg Color
	$seatheme_color_selected_text_bg = esc_attr(seatheme_get_option('theme_option_color_selected_text_bg'));
	if($seatheme_color_selected_text_bg){
		$custom_css .= '
--color-selection-bg:'.esc_attr($seatheme_color_selected_text_bg).';';
	}

	// Text Logo 

	//Text Logo Color Dark (default)
	$seatheme_color_text_logo = esc_attr(seatheme_get_option('theme_option_color_logo'));
	if($seatheme_color_text_logo){
		$custom_css .= '
--color-logo:'.esc_attr($seatheme_color_text_logo).';';
	}

	//Text Logo Alt(Light) color
	$seatheme_color_text_logo_alt = esc_attr(seatheme_get_option('theme_option_logo_text_color_light'));
	if($seatheme_color_text_logo_alt){
		$custom_css .= '
--color-alt-logo:'.esc_attr($seatheme_color_text_logo_alt).';';
	}

	// Button Color
	// Button Text & Border Color
	$seatheme_color_button = esc_attr(seatheme_get_option('theme_option_color_button'));
	if($seatheme_color_button){
		$custom_css .= '
--color-button-text:'.esc_attr($seatheme_color_button).';';
	}

	// Button Text Mouseover Color
	$seatheme_color_button_mouseover = esc_attr(seatheme_get_option('theme_option_color_button_mouseover'));
	if($seatheme_color_button_mouseover){
		$custom_css .= '
--color-button-text-hover:'.esc_attr($seatheme_color_button_mouseover).';';
	}

	// Button BG Mouseover Color
	$seatheme_color_button_bg_mouseover = esc_attr(seatheme_get_option('theme_option_color_button_bg_mouseover'));
	if($seatheme_color_button_bg_mouseover){
		$custom_css .= '
--color-button-bg-hover:'.esc_attr($seatheme_color_button_bg_mouseover).';';
	}


	// Form Color
	// Text Input Box by Default
	$seatheme_color_form = esc_attr(seatheme_get_option('theme_option_color_form'));
	if($seatheme_color_form){
		$custom_css .= '
--color-input-text:'.esc_attr($seatheme_color_form).';';
	}

	// Text Input Box Focused
	$seatheme_color_form_focused = esc_attr(seatheme_get_option('theme_option_color_form_focused'));
	if($seatheme_color_form_focused){
		$custom_css .= '
--color-input-text-focus:'.esc_attr($seatheme_color_form_focused).';';
	}


	// Widget
	// Widget Title Text Color

	// Sidebar Widget Title Text Color
	$seatheme_color_widget_title_sidebar =  esc_attr(seatheme_get_option('theme_option_color_widget_title_sidebar'));
	if($seatheme_color_widget_title_sidebar){
		$custom_css .= '
--color-widget-tit:'.esc_attr($seatheme_color_widget_title_sidebar).';';
	}
	
	// Widget Content Text Color
	$seatheme_color_widget_con_color = esc_attr(seatheme_get_option('theme_option_color_widget_content_color'));
	if($seatheme_color_widget_con_color){
		$custom_css .= '
--color-widget:'.esc_attr($seatheme_color_widget_con_color).';';
	}

	// Widget Content Link Text Color
	$seatheme_color_widget_con_link_color = esc_attr(seatheme_get_option('theme_option_color_widget_content_link'));
	if($seatheme_color_widget_con_link_color){
		$custom_css .= '
--color-widget-link:'.esc_attr($seatheme_color_widget_con_link_color).';';
	}

	// Widget Content Link Mouseover Color
	$seatheme_color_widget_con_link_hover_color = esc_attr(seatheme_get_option('theme_option_color_widget_content_link_hover'));
	if($seatheme_color_widget_con_link_hover_color){
		$custom_css .= '
--color-widget-link-hover:'.esc_attr($seatheme_color_widget_con_link_hover_color).';';
	}



	//Footer
	//Footer bg Color
	$seatheme_color_footer_bg = esc_attr( seatheme_get_option( 'theme_option_footer_bg_color' ) );
	if ( $seatheme_color_footer_bg ) {
		$custom_css .= '
--color-footer-bg:'.esc_attr( $seatheme_color_footer_bg ).';';
	}

	//Footer Text Color
	$seatheme_color_footer_text = esc_attr(seatheme_get_option('theme_option_footer_text_color'));
	if($seatheme_color_footer_text){
		$custom_css .= '
--color-footer-text:'.esc_attr($seatheme_color_footer_text).';';
	}

	//Footer Text Link Color
	$seatheme_color_footer_link = esc_attr(seatheme_get_option('theme_option_footer_text_link_color'));
	if($seatheme_color_footer_link){
		$custom_css .= '
--color-footer-link:'.esc_attr( $seatheme_color_footer_link ).';';
	}

	//Footer Text Link Mouseover Color
	$seatheme_color_footer_link_hover = esc_attr( seatheme_get_option('theme_option_footer_text_link_hover_color') );
	if ( $seatheme_color_footer_link_hover ) {
		$custom_css .= '
--color-footer-link-hover:'.esc_attr( $seatheme_color_footer_link_hover ).';';
	}

$custom_css .= '}';

	// FONT  
	
	// Text LOGO
	//Text logo font Header font/size/spacing
	$custom_css .= "\n";
	foreach(array('family','size','spacing','line_height') as $key){
		$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_plain_text_header_logo', $key, '.logo-text'));
	}

	//Text logo font Footer font/size/spacing/mobile size
	foreach(array('family','size','spacing','line_height') as $key){
		$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_plain_text_footer_logo', $key, '#logo-footer .logo-text'));
	}

	// MENU 
	//Menu on Header font/size/spacing/mobile size
	foreach(array('family','size','spacing','line_height') as $key){
		$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_menu_header', $key, '.navi-header a,.header-bar-social .socialmeida-a,.menu li > a'));
	}
	//Sub Menu header
	$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_submenu_header', 'size', '.navi-header .sub-menu a'));

	//Menu on expanded font/size/spacing/mobile size
	foreach(array('family','size','spacing','line_height') as $key){
		$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_menu_expanded', $key, '#navi a'));
	}
	//Sub Menu on expanded
	$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_submenu_expanded', 'size', '#navi .sub-menu a'));

	// POST & PAGE
	//Post & page Title font/size/spacing/mobile size
	foreach(array('family','size','spacing','line_height') as $key){
		$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_post_page_title', $key, 'body.single .title-wrap-tit,.title-wrap-h1'));
	}

	//Post & page content font/spacing
	foreach(array('family','spacing','line_height') as $key){
		$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_post_page_content', $key, 'body'));
	}
	//Post & page content size/mobile size
	$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_post_page_content', 'size', 'body'));

	//Post & page content heading 1-6 font/size/spacing/mobile size
	$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_post_page_heading', 'family', 'h1,h2,h3,h4,h5,h6,.archive-grid-item-tit,.title-wrap-meta-a,.archive-grid-item-meta-item,product-caption-title'));
	for ($x=1; $x<=6; $x++) {
		foreach(array('size','spacing','line_height') as $key){
			$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_post_page_heading_' .$x, $key, 'h' .$x));
		}
	}

	//Font for WooComerce Pages
	if ( class_exists( 'Woocommerce' ) ) {

		if ( is_woocommerce() || is_shop() || is_product() || is_cart() || is_checkout() || is_product_category() || is_product_tag() ) {
			foreach ( array( 'family','size','spacing','line_height' ) as $key ) {
				$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_woo_single_price', $key, '.woocommerce div.product p.price, .woocommerce div.product span.price'));
				$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_woo_single_tit', $key, 'h1.product_title,.cart-collaterals .cross-sells h2,.woocommerce.woocommerce-cart table.shop_table thead, .entry .lined-heading, .entry .cart-summary h3, h3#order_review_heading, .entry #ship-to-different-address > label, .cart-empty, .entry h3#login-form-modal,.woocommerce-billing-fields>h3,.woocommerce-additional-fields>h3'));
				$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_woo_single_con', $key, 'body.single-product'));
				$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_woo_single_meta', $key, '.product-single .product_meta'));
			}
			$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_woo_single_price', 'm-size', 'body'));
			$custom_css .= sanitize_text_field( seatheme_get_font_assignment('_ux_cb_module_fonts_woo_single_tit', 'm-size', 'body'));
			$custom_css .= sanitize_text_field( seatheme_get_font_assignment('_ux_cb_module_fonts_woo_single_con', 'm-size', 'body'));
			$custom_css .= sanitize_text_field( seatheme_get_font_assignment('_ux_cb_module_fonts_woo_single_meta', 'm-size', '.body'));
			
			//Share icons on Woo
			$socialshare_size_woo_desktop = $socialshare_size_woo_mobile = 0;
			if ( $socialshare_size_woo =  seatheme_get_option( 'theme_option_social_share_icon_size_woo' ) ) {
				if ( ! is_array( $socialshare_size_woo ) ) { $socialshare_size_woo = array( $socialshare_size_woo, $socialshare_size_woo_mobile );  }
				if ( isset ( $socialshare_size_woo[0] ) ) { $socialshare_size_woo_desktop = intval( $socialshare_size_woo[0] ); }
				if ( isset ( $socialshare_size_woo[1] ) ) { $socialshare_size_woo_mobile = intval( $socialshare_size_woo[1] ); }
			}
			if( $socialshare_size_woo_desktop ) {
				$custom_css .= "
		.single-product-summary .fa{font-size: ".esc_attr($socialshare_size_woo_desktop)."px;}";
			}
			if( $socialshare_size_woo_mobile ) { 
				$custom_css .= "
		.single-product-summary{--size-socialshare-woo-m: ".esc_attr($socialshare_size_woo_mobile)."px;}";
			}
			//Share icons spacing on Woo
			$socialshare_spacing_woo_desktop = $socialshare_spacing_woo_mobile = 0;
			if ( $socialshare_spacing_woo = seatheme_get_option( 'theme_option_social_share_icon_spacing_woo' ) ) {
				if ( ! is_array( $socialshare_spacing_woo ) ) { $socialshare_spacing_woo = array( $socialshare_spacing_woo, $socialshare_spacing_woo_mobile );  }
				if ( isset ( $socialshare_spacing_woo[0] ) ) { $socialshare_spacing_woo_desktop = intval( $socialshare_spacing_woo[0] ); }
				if ( isset ( $socialshare_spacing_woo[1] ) ) { $socialshare_spacing_woo_mobile = intval( $socialshare_spacing_woo[1] ); }
			}
			if($socialshare_spacing_woo_desktop) {
				$custom_css .= "
		.single-product-summary .post-meta-social-li{margin-right:".esc_attr($socialshare_spacing_woo_desktop)."px;}";
			}
			if($socialshare_spacing_woo_mobile) {
				$custom_css .= "
		.single-product-summary{--spacing-socialshare-woo-m:".esc_attr( $socialshare_spacing_woo_mobile )."px;}";
			}
		
			foreach ( array( 'family','size','spacing','line_height' ) as $key ) {
				$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_woo_archive_item_tit', $key, '.main-list .product-caption-title'));
				$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_woo_archive_item_price', $key, '.main-list .price'));
				$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_woo_archive_item_add_cart', $key, '.main-list .product-caption a.button,.main-list .product-caption .added_to_cart'));
				$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_form', $key, ' .woocommerce select, .select2-container, .woocommerce input, .woocommerce textarea' ) );
			}
			$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_woo_archive_item_tit', 'm-size', 'body'));
			$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_woo_archive_item_price', 'm-size', 'body'));
			$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_woo_archive_item_add_cart', 'm-size', 'body'));
			$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_form', $key, 'body'));
			
		}
		
	}

	//Post & page meta font
	foreach(array('family','size') as $key){
		$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_post_page_meta', $key, '.article-meta, .comment-form .logged-in-as,.comment-meta,.archive-des,.archive-meta,.title-wrap-des, .entry-summary div[itemprop="description"] p'));
	}

	//Portfolio gallery caption
	foreach(array('family','size','spacing','line_height') as $key){
		$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_post_page_caption', $key, '.list-layout-inside-caption,figcaption'));
	}
	
	//Post Navi font
	if ( is_single() ) {
		foreach(array('family','size') as $key){
			$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_post_page_navi', $key, '.post-navi-single,.post-navi-unit-tit'));
		}
	}
	
	if ( class_exists( 'Woocommerce' ) ) {
		if ( is_product() ) {
			//Comments Title font on WooCommerce Product pages
			foreach(array('family','size') as $key){
				$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_post_page_comments_title', $key, '.woocommerce-Reviews-title,#tab-description>h2,.related h2'));
			}
		}
	}

	if ( have_comments() ) { 
		
		//Comments Title font (Medium Heading)
		foreach(array('family','size') as $key){
			$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_post_page_comments_title', $key, '.comment-reply-title,.comments-title'));
		}

		//Comments Content font
		foreach(array('family','size') as $key){
			$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_post_page_comments_content', $key, '.comment-list li,.commentlist li'));
		}

		//Comments Author Name Font Size
		$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_post_page_comments_author', 'size', 'li.comment .fn'));
	}

	if ( class_exists( 'Woocommerce' ) ) {
		//Comments Author Name Font Size on WooCommerce pages
		$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_post_page_comments_author', 'size', '.woocommerce-review__author'));
	}

	// Button
	// Button Font
	foreach(array('family','size','spacing') as $key){
		$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_button', $key, '.btn-mod-wrap .ux-btn, button, input[type="submit"]'));
	}
	if ( class_exists( 'Woocommerce' ) ) {
		foreach(array('family','size','spacing') as $key){
			$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_button', $key, '.woocommerce .button, .woocommerce a.added_to_cart'));
		}
	}

	// Form
	// Form Font
	foreach(array('family','size') as $key){
		$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_form', $key, 'textarea,input,input::placeholder,textarea::placeholder'));
	}

	// Archive
	// Archive Title Font
	if ( is_archive() || is_home() ) {
		foreach(array('family','size') as $key){
			$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_archive_title', $key, '.archive-title .title-wrap-tit'));
		}

		// Archive Posts Title Font
		foreach(array('family','size') as $key){
			$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_archive_posts_title', $key, '.archive-tit'));
		}
	}

	// Widgets
	if ( ! is_singular('ux-portfolio') && ! is_page() ) {
		// Widgets Title Font
		foreach(array('family','size') as $key){
			$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_widget_title', $key, '.widget-title'));
		}

		// Widget Content Font
		foreach(array('family','size') as $key){
			$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_widget_content', $key, '.widget-container'));
		}
	}

	// Footer Font
	foreach(array('family','size') as $key){
		$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_footer', $key, '.footer-info,.footer-info .menu li a'));
	}

	// Footer cookie bar Font
	foreach(array('family','size') as $key){
		$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_cookie_bar', $key, '.sea-cookieconsent-text'));
	}
	foreach(array('family','size') as $key){
		$custom_css .= sanitize_text_field(seatheme_get_font_assignment('_ux_cb_module_fonts_cookie_bar_btn', $key, '.sea-cookieconsent-btn.ux-btn'));
	}


	//Global

	//get header layout desktop
	$seatheme_header_layout = seatheme_get_option( 'theme_option_header_layout' );

	//Social meida icons
	$socialSizeDesktop = $socialSizeMobile = 0;
	if ( $socialSize = seatheme_get_option( 'theme_option_social_icon_size' ) ) {
		if ( ! is_array( $socialSize ) ) { $socialSize = array( $socialSize, $socialSizeMobile ); }
		if ( isset ( $socialSize[0] ) ) { $socialSizeDesktop = intval( $socialSize[0] ); }
		if ( isset ( $socialSize[1] ) ) { $socialSizeMobile = intval( $socialSize[1] ); }
	}
	if ( $socialSizeDesktop ) {
		$custom_css .= " 
.socialmeida-a .fa, .menu-panel .socialmeida-a .socialmeida-text{font-size:" .esc_attr( $socialSizeDesktop ). "px;}";
	}
	if ( $socialSizeMobile ) {
		$custom_css .= " 
.socialmeida-a {--size-socialmeida-m:".esc_attr( $socialSizeMobile )."px;}";
	}
	//Social meida icons sapcing
	$social_spacing_desktop = $social_spacing_mobile = 0;
	if ( $social_spacing = seatheme_get_option('theme_option_social_icon_spacing') ) {
		if ( ! is_array( $social_spacing ) ) { $social_spacing = array( $social_spacing, $social_spacing_mobile );  }
		if ( isset ( $social_spacing[0] ) ) { $social_spacing_desktop = intval( $social_spacing[0] ); }
		if ( isset ( $social_spacing[1] ) ) { $social_spacing_mobile = intval( $social_spacing[1] ); }
	}
	if ( $social_spacing_desktop ) {
		$custom_css .= "
.socialmeida-li{margin-left:".esc_attr( $social_spacing_desktop )."px;}
.socialmeida{margin-left:-".esc_attr( $social_spacing_desktop )."px;}";
	}
	if ( $social_spacing_mobile ) {
		$custom_css .= " 
.socialmeida{--spacing-socialmeida-m:".esc_attr( $social_spacing_mobile )."px;}";
	}
	//Share icons
	$socialshare_size_desktop = $socialshare_size_mobile = 0;
	if ( $socialshare_size =  seatheme_get_option( 'theme_option_social_share_icon_size' ) ) {
		if ( ! is_array( $socialshare_size ) ) { $socialshare_size = array( $socialshare_size, $socialshare_size_mobile );  }
		if ( isset ( $socialshare_size[0] ) ) { $socialshare_size_desktop = intval( $socialshare_size[0] ); }
		if ( isset ( $socialshare_size[1] ) ) { $socialshare_size_mobile = intval( $socialshare_size[1] ); }
	}
	if( $socialshare_size_desktop ) {
		$custom_css .= "
.post-meta-social-li .fa{font-size:".esc_attr($socialshare_size_desktop)."px;}";
	}
	if( $socialshare_size_mobile ) { 
		$custom_css .= "
.post-meta-social-li {--size-socialshare-m:".esc_attr($socialshare_size_mobile)."px;}";
	}
	//Share icons spacing 
	$socialshare_spacing_desktop = $socialshare_spacing_mobile = 0;
	if ( $socialshare_spacing = seatheme_get_option( 'theme_option_social_share_icon_spacing' ) ) {
		if ( ! is_array( $socialshare_spacing ) ) { $socialshare_spacing = array( $socialshare_spacing, $socialshare_spacing_mobile );  }
		if ( isset ( $socialshare_spacing[0] ) ) { $socialshare_spacing_desktop = intval( $socialshare_spacing[0] ); }
		if ( isset ( $socialshare_spacing[1] ) ) { $socialshare_spacing_mobile = intval( $socialshare_spacing[1] ); }
	}
	if($socialshare_spacing_desktop) {
		$custom_css .= "
.post-meta-social-li{margin-left:".esc_attr($socialshare_spacing_desktop)."px;}";
	}
	if($socialshare_spacing_mobile) {
		$custom_css .= "
.post-meta-social-li{--spacing-socialshare-m:".esc_attr( $socialshare_spacing_mobile )."px;}";
	}

	//Menu hover line
	$menu_hover_effect = seatheme_get_option( 'theme_option_menu_hover_effect' );

	if ( $menu_hover_effect === 'menu-hover-diagonalline' ) {
		$menu_hover_effect_diagonalline_color = esc_attr( seatheme_get_option( 'theme_option_menu_hover_effect_diagonalline_color' ) );
		if ( $menu_hover_effect_diagonalline_color ) {
			$custom_css .= "
body { --menu-hover-diagonalline-color:".esc_attr( $menu_hover_effect_diagonalline_color ).";}";
		}
		$menu_hover_effect_diagonalline_length_style = false;
		$menu_hover_effect_diagonalline_thickness_style = false;
		$menu_hover_effect_diagonalline_length = intval( seatheme_get_option( 'theme_option_menu_hover_effect_diagonalline_width' ) );
		$menu_hover_effect_diagonalline_thickness = intval( seatheme_get_option( 'theme_option_menu_hover_effect_diagonalline_border' ) );
		$menu_hover_effect_diagonalline_length_style = $menu_hover_effect_diagonalline_length ? "width:".esc_attr($menu_hover_effect_diagonalline_length)."px;" : false;
		$menu_hover_effect_diagonalline_thickness_style = $menu_hover_effect_diagonalline_thickness ? "height:".esc_attr($menu_hover_effect_diagonalline_thickness)."px;" : false;
		if ( $menu_hover_effect_diagonalline_length_style || $menu_hover_effect_diagonalline_thickness_style ) {
			$custom_css .="
.menu-hover-diagonalline .menu li>a::after{".esc_attr( $menu_hover_effect_diagonalline_length_style ) . esc_attr( $menu_hover_effect_diagonalline_thickness_style)."}";
		}
	}

	if ( $menu_hover_effect === 'menu-hover-underline1' ) {
		$menu_hover_effect_underline_distance_style = false;
		$menu_hover_effect_underline_distance = intval( seatheme_get_option( 'theme_option_menu_hover_effect_underline_distance' ) );
		$menu_hover_effect_underline_distance_style = $menu_hover_effect_underline_distance ? "bottom:-".esc_attr( $menu_hover_effect_underline_distance )."px;" : false;
		if ( $menu_hover_effect_underline_distance_style ) {
			$custom_css .= "
.menu-hover-underline1 .menu li>a::before{".esc_attr( $menu_hover_effect_underline_distance_style )."}";
		}
	}
	
	//cookie consent bar
	if ( $cookieConsentBar = seatheme_get_option( 'theme_option_cookie_consent_bar' ) ) {
		if ( $cookieConsentBarTextColor = seatheme_get_option( 'theme_option_cookie_consent_bar_text_color' ) ) {
			$custom_css .= "
.sea-cookieconsent-text { color: " .esc_attr( $cookieConsentBarTextColor ). "; }";
		}
		if ( $cookieConsentBarBgColor = seatheme_get_option( 'theme_option_cookie_consent_bar_bg_color' ) ) {
			$custom_css .= "
.sea-cookie-consent:after { background-color: " .esc_attr( $cookieConsentBarBgColor ). "; }";
		}
		//Inner padding
		$cookieBarPaddingD = $cookieBarPaddingM = 0; $cookieBarPaddingStyle = '';
		if ( $cookieBarPadding = seatheme_get_option( 'theme_option_cookie_inner_padding' ) ) {
			if ( is_array( $cookieBarPadding ) ) { 
				if ( isset ( $cookieBarPadding[0] ) ) { $cookieBarPaddingD = 'padding:'.intval( $cookieBarPadding[0] ).'px;'; }
				if ( isset ( $cookieBarPadding[1] ) ) { $cookieBarPaddingM = '--padding-cookiebar:'.intval( $cookieBarPadding[1] ).'px;'; }
			}
			if ( $cookieBarPaddingD || $cookieBarPaddingM ) { $cookieBarPaddingStyle .=  esc_attr( $cookieBarPaddingD ).esc_attr( $cookieBarPaddingM ) ; }
		}
		if ( $cookieBarPaddingStyle !='' ) {  $custom_css .= '
			.sea-cookie-consent{'.esc_attr( $cookieBarPaddingStyle ).'}';

		}
		//Button height
		$cookieBarButtonHeightD = $cookieBarButtonHeightM = 0; $cookieBarButtonStyle = '';
		if ( $cookieBarButtonHeight = seatheme_get_option( 'theme_option_cookie_button_height' ) ) {
			if ( is_array( $cookieBarButtonHeight ) ) { 
				if ( isset ( $cookieBarButtonHeight[0] ) ) { $cookieBarButtonHeightD = 'line-height:'.intval( $cookieBarButtonHeight[0] ).'px;'; }
				if ( isset ( $cookieBarButtonHeight[1] ) ) { $cookieBarButtonHeightM = '--line-height-cookiebar:'.intval( $cookieBarButtonHeight[1] ).'px;'; }
			}
			if ( $cookieBarButtonHeightD || $cookieBarButtonHeightM ) { $cookieBarButtonStyle .=  esc_attr( $cookieBarButtonHeightD ).esc_attr( $cookieBarButtonHeightM ) ; }
		}
		if ( $cookieBarButtonBorderWidth = seatheme_get_option( 'theme_option_cookie_button_border_width' ) ) {
			$cookieBarButtonStyle .= 'border-width:'.esc_attr($cookieBarButtonBorderWidth).';';
		}
		if ( $cookieBarButtonStyle != '' ) { $custom_css .= '
.sea-cookieconsent-btn.ux-btn{' .esc_attr( $cookieBarButtonStyle ). '}'; }

		//Button color
		$cookieButtonDismissLabelStyle = '';
		if ( $cookieButtonDismissLabelColor = seatheme_get_option( 'theme_option_cookie_button_dismiss_label_color' ) ) {
			$cookieButtonDismissLabelStyle .= 'color:'.esc_attr( $cookieButtonDismissLabelColor ).';';
		}
		if ( $cookieButtonDismissLabelColorBg = seatheme_get_option( 'theme_option_cookie_button_dismiss_label_bg_color' ) ) {
			$cookieButtonDismissLabelStyle .= 'background-color:'.esc_attr( $cookieButtonDismissLabelColorBg ).';';
		}
		if ( $cookieButtonDismissBorderColor = seatheme_get_option( 'theme_option_cookie_button_dismiss_border_color' ) ) {
			$cookieButtonDismissLabelStyle .= 'border-color:'.esc_attr( $cookieButtonDismissBorderColor ).';';
		}
		if ( $cookieButtonDismissLabelStyle ) { $custom_css .= '
span.sea-cookieconsent-btn.ux-btn{'.esc_attr( $cookieButtonDismissLabelStyle ).'}';
		}

		$cookieButtonMoreLabelStyle = '';
		if ( $cookieButtonMoreLabelColor = seatheme_get_option( 'theme_option_cookie_button_more_label_color' ) ) {
			$cookieButtonMoreLabelStyle .= 'color:'.esc_attr( $cookieButtonMoreLabelColor ).';';
		}
		if ( $cookieButtonMoreLabelColorBg = seatheme_get_option( 'theme_option_cookie_button_more_label_bg_color' ) ) {
			$cookieButtonMoreLabelStyle .= 'background-color:'.esc_attr( $cookieButtonMoreLabelColorBg ).';';
		}
		if ( $cookieButtonMoreBorderColor = seatheme_get_option( 'theme_option_cookie_button_more_border_color' ) ) {
			$cookieButtonMoreLabelStyle .= 'border-color:'.esc_attr( $cookieButtonMoreBorderColor ).';';
		}
		if ( $cookieButtonMoreLabelStyle ) { $custom_css .= '
a.sea-cookieconsent-btn.ux-btn{'.esc_attr( $cookieButtonMoreLabelStyle ).'}';

		}
		
	}

	//Logo Height
	$custom_css .= "
@media (min-width: 768px) {";

	//Header Logo height
	$seatheme_custom_logo_height_desktop = $seatheme_custom_logo_height_mobile = 0;
	if ( $seatheme_custom_logo_height = seatheme_get_option( 'theme_option_custom_logo_height' ) ) {
		if ( ! is_array( $seatheme_custom_logo_height ) ) { $seatheme_custom_logo_height = array( $seatheme_custom_logo_height, $seatheme_custom_logo_height_mobile ); }
		if ( isset ( $seatheme_custom_logo_height[0] ) ) { $seatheme_custom_logo_height_desktop = intval( $seatheme_custom_logo_height[0] ); }
		if ( isset ( $seatheme_custom_logo_height[1] ) ) { $seatheme_custom_logo_height_mobile = intval( $seatheme_custom_logo_height[1] ); }
	}
	if ( $seatheme_custom_logo_height_desktop ) {
		if ( class_exists( 'woocommerce' ) ) {
			$custom_css .= "
		.logo-image,.woocommerce .logo-image,.woocommerce-page .logo-image{max-height:none;max-width:none;height: ".esc_attr( $seatheme_custom_logo_height_desktop )."px!important;}";
		} else {
			$custom_css .= "
		.logo-image{max-height:none;max-width:none;height: ".esc_attr( $seatheme_custom_logo_height_desktop )."px!important;}";
		}
	}

	//Logo bottom spacing 
	if ( $seatheme_logo_bottom_spacing = intval( seatheme_get_option( 'theme_option_logo_bottom_spacing' ) ) ) {
		$custom_css .= "
	.navi-show-center .navi-logo { margin-bottom: ".esc_attr( $seatheme_logo_bottom_spacing )."px; }";
	}

	//Loader Logo Heihgt 
	$seatheme_loader_logo_height_desktop = $seatheme_loader_logo_height_mobile = 0;
	if ( $seatheme_loader_logo_height = seatheme_get_option( 'theme_option_custom_loader_logo_height' ) ) {
		if ( ! is_array( $seatheme_loader_logo_height ) ) { $seatheme_loader_logo_height = array( $seatheme_loader_logo_height, $seatheme_loader_logo_height_mobile ); }
		if ( isset ( $seatheme_loader_logo_height[0] ) ) { $seatheme_loader_logo_height_desktop = intval( $seatheme_loader_logo_height[0] ); }
		if ( isset ( $seatheme_loader_logo_height[1] ) ) { $seatheme_loader_logo_height_mobile = intval( $seatheme_loader_logo_height[1] ); }
	}
	if ( $seatheme_loader_logo_height_desktop ) {
		$custom_css .= "
.page-loading .site-loading-logo img {height:".esc_attr( $seatheme_loader_logo_height_desktop )."px;}";
	}

	//Footer Logo Heihgt 
	$seatheme_footer_logo_height_desktop = $seatheme_footer_logo_height_mobile = 0;
	if ( $seatheme_footer_logo_height = seatheme_get_option( 'theme_option_custom_foot_logo_height' ) ) {
		if ( ! is_array( $seatheme_footer_logo_height ) ) { $seatheme_footer_logo_height = array( $seatheme_footer_logo_height, $seatheme_footer_logo_height_mobile ); }
		if ( isset ( $seatheme_footer_logo_height[0] ) ) { $seatheme_footer_logo_height_desktop = intval( $seatheme_footer_logo_height[0] ); }
		if ( isset ( $seatheme_footer_logo_height[1] ) ) { $seatheme_footer_logo_height_mobile = intval( $seatheme_footer_logo_height[1] ); }
	}
	if ( $seatheme_footer_logo_height_desktop ) {
		$custom_css .= "
	.logo-footer-img,.woocommerce .logo-footer-img,.woocommerce-page .logo-footer-img{max-height:none; max-width:none; height: ".esc_attr( $seatheme_footer_logo_height_desktop )."px;}";
	}

	//Main Container width
	$theme_option_main_width_style = esc_attr(seatheme_get_option('theme_option_main_width_style')) ? esc_attr(seatheme_get_option('theme_option_main_width_style')) : 'container';
	$theme_option_main_padding = intval( esc_attr( seatheme_get_option( 'theme_option_main_padding' ) ) ) ? intval( esc_attr( seatheme_get_option( 'theme_option_main_padding'))) : '60';
	if($theme_option_main_width_style == 'container-fluid' && $theme_option_main_padding) {
		$custom_css .= "
	.container-fluid, .container-class.container-fluid .bm-builder .col-0.bm-wrap:not(.bm-force-full),.container-class.container-fluid .bm-builder .col-0:not(.bm-wrap):not(.bm-force-full) .filters-ul { padding-left: ".esc_attr($theme_option_main_padding)."px!important; padding-right: ".esc_attr($theme_option_main_padding)."px!important;}";		
	}
	$seatheme_color_max_width = intval( seatheme_get_option( 'theme_option_main_max_width' ) );

	if ( $theme_option_main_width_style == 'container-fluid' && $seatheme_color_max_width ) { 
		$custom_css .= "
	.container-fluid, .container-class.container-fluid .bm-builder .col-0.bm-wrap:not(.bm-force-full),.container-class.container-fluid .bm-builder .col-0:not(.bm-wrap):not(.bm-force-full) .filters-ul { max-width: ".esc_attr($seatheme_color_max_width)."px;}";
	}

	//Menu on corner padding left right
	$seatheme_menu_corner_padding_left_right = intval( esc_attr( seatheme_get_option( 'theme_option_corner_menu_padding_left_right' ) ) );
	if ( $seatheme_menu_corner_padding_left_right && $seatheme_header_layout === 'navi-corner' ) {
		$custom_css .= "
.navi-corner .navi-header>div>ul>li,.navi-corner .navi-logo{padding-right:".esc_attr( $seatheme_menu_corner_padding_left_right )."px;padding-left:".esc_attr( $seatheme_menu_corner_padding_left_right )."px;}";
	}
	//Menu on corner padding top
	$seatheme_menu_corner_padding_top = intval( esc_attr( seatheme_get_option( 'theme_option_corner_menu_padding_top' ) ) );
	if ( $seatheme_menu_corner_padding_top && $seatheme_header_layout === 'navi-corner' ) {
		$custom_css .= "
.navi-corner .navi-header>div>ul>li:first-child,.navi-corner .navi-logo,.navi-corner .header-bar-social{padding-top:".esc_attr( $seatheme_menu_corner_padding_top )."px;}";
	}
	//Menu on corner padding bottom
	$seatheme_menu_corner_padding_bottom = intval( esc_attr( seatheme_get_option( 'theme_option_corner_menu_padding_bottom' ) ) );
	if ( $seatheme_menu_corner_padding_bottom && $seatheme_header_layout === 'navi-corner' ) {
		$custom_css .= "
.navi-corner .navi-header>div>ul>li,.navi-corner .ux-woo-cart-wrap{padding-bottom:".esc_attr( $seatheme_menu_corner_padding_bottom )."px;}";
	}

	//Footer Elements Horizon Spacing
	$seatheme_footer_horizon_align = seatheme_get_option( 'theme_option_footer_horizon_align' );
	$seatheme_footer_horizon_align_mobile = seatheme_get_option( 'theme_option_footer_horizon_align_mobile' );
	$seatheme_footer_horizon_spacing = intval( esc_attr( seatheme_get_option( 'theme_option_footer_horizon_spacing' ) ) );
	$seatheme_footer_horizon_spacing_mobile = intval( esc_attr( seatheme_get_option( 'theme_option_footer_horizon_spacing_mobile' ) ) );
	if ( $seatheme_footer_horizon_align != 'footer-horizon-equal' ) {
		if ( $seatheme_footer_horizon_spacing ) {
			$custom_css .= "
	.footer-cols-item{margin-left:".esc_attr( $seatheme_footer_horizon_spacing )."px;}";	
		}
	}
	
	
	//Footer Elements vertical Spacing
	$seatheme_footer_vertical_spacing = intval( esc_attr( seatheme_get_option( 'theme_option_footer_vertical_spacing' ) ) );
	$seatheme_footer_vertical_spacing_mobile = intval( esc_attr( seatheme_get_option( 'theme_option_footer_vertical_spacing_mobile' ) ) );
	if ( $seatheme_footer_vertical_spacing ) {
		$custom_css .= "
	.footer-one-col-item{margin-top:".esc_attr( $seatheme_footer_vertical_spacing )."px;}";	
	}

	//Header options
	$seatheme_header_width = esc_attr(seatheme_get_option('theme_option_header_width'));
	$seatheme_header_padding = intval(esc_attr(seatheme_get_option('theme_option_header_padding')));

	if($seatheme_header_width == 'fluid' && $seatheme_header_padding) {

		$custom_css .= "
	.header-main.container-fluid,#footer .container-fluid { padding-left: ".esc_attr($seatheme_header_padding)."px; padding-right: ".esc_attr($seatheme_header_padding)."px;}";
	}

	//Header Height
	$seatheme_header_height_desktop = $seatheme_header_height_mobile = 0;
	if ( $seatheme_header_height = seatheme_get_option( 'theme_option_header_height' ) ) {
		if ( ! is_array( $seatheme_header_height ) ) { $seatheme_header_height = array( $seatheme_header_height, $seatheme_header_height_mobile ); }
		if ( isset ( $seatheme_header_height[0] ) ) { $seatheme_header_height_desktop = intval( $seatheme_header_height[0] ); }
		if ( isset ( $seatheme_header_height[1] ) ) { $seatheme_header_height_mobile = intval( $seatheme_header_height[1] ); }
	}
	if ( $seatheme_header_height_desktop ) {
		$custom_css .= "
	#wrap{min-height: calc(100vh - ".esc_attr( $seatheme_header_height_desktop )."px);} 
	.header-main{height: ".esc_attr( $seatheme_header_height_desktop )."px;}
	.logo-image{max-height: ".esc_attr( $seatheme_header_height_desktop )."px;}
	body:not(.page_from_top) .menu-panel{margin-top:-".esc_attr( $seatheme_header_height_desktop )."px;}
	.header-sticky:not(.page_from_top) #wrap-outer,.header-sticky-back:not(.page_from_top) #wrap-outer,
	.header-sticky-none:not(.page_from_top).ux-header-hide-body #wrap-outer,.page_from_top .portfolio-panel{padding-top:".esc_attr( $seatheme_header_height_desktop )."px;}";

	} 
	//Header Sticky Height
	$seatheme_header_sticky_height_desktop = $seatheme_header_sticky_height_mobile = 0;
	if ( $seatheme_header_sticky_height = seatheme_get_option( 'theme_option_header_sticky_height' ) ) {
		if ( ! is_array( $seatheme_header_sticky_height ) ) { $seatheme_header_sticky_height = array( $seatheme_header_sticky_height, $seatheme_header_sticky_height_mobile ); }
		if ( isset ( $seatheme_header_sticky_height[0] ) ) { $seatheme_header_sticky_height_desktop = intval( $seatheme_header_sticky_height[0] ); }
		if ( isset ( $seatheme_header_sticky_height[1] ) ) { $seatheme_header_sticky_height_mobile = intval( $seatheme_header_sticky_height[1] ); }
	}
	if ( $seatheme_header_sticky_height_desktop ) {
		$custom_css .= " 
	.header-scrolled .header-main{height: ".esc_attr( $seatheme_header_sticky_height_desktop )."px;}
	.header-scrolled .logo-image{max-height: ".esc_attr( $seatheme_header_sticky_height_desktop )."px;}";
 	} 

 	//Menu left spacing 
	$seatheme_menu_leftspacing = intval( seatheme_get_option( 'theme_option_menu_left_spacing' ) );
	if ( $seatheme_menu_leftspacing && $seatheme_header_layout ==='horizon-menu-center' ) {
		 $custom_css .= "
	.navi-show-h.navi-show-h-left .head-meta { margin-left:".esc_attr( $seatheme_menu_leftspacing )."px; }";
	}

	//Menu Item Spacing Horizontal
	$seatheme_menu_spacing_h = intval( seatheme_get_option( 'theme_option_menu_item_spacing_h_expand_panel' ) );
	if ( $seatheme_menu_spacing_h &&  $seatheme_header_layout === 'menu-icon-popup2' ) {
		$custom_css .= "
	.navi-hide-pop2 ul.menu>li:not(:first-child) { margin-left: ".esc_attr( $seatheme_menu_spacing_h )."px; }";
	} 
	 
$custom_css .= "
}"; //End @media min-width:768px

$custom_css .= "
@media (min-width: 1200px) {";
	$seatheme_color_main_width = esc_attr(seatheme_get_option('theme_option_main_width'));
	$seatheme_color_main_width_post = esc_attr(seatheme_get_option('theme_option_main_width_post'));
	if($theme_option_main_width_style == 'container') {
		if($seatheme_color_main_width == '1070') {
			$custom_css .= "
	.container,.container-class.container .bm-wrap.module.col-0:not(.bm-force-full) > .module-inside { width: 1070px!important; }";
		} else if($seatheme_color_main_width == '970') {
			$custom_css .= "
 	.container,.container-class.container .bm-wrap.module.col-0:not(.bm-force-full) > .module-inside { width: 970px!important; }";
		}
		if($seatheme_color_main_width_post == '1070') {
			$custom_css .= "
	body.single .container,body.single .container-class.container .bm-wrap.module.col-0:not(.bm-force-full) > .module-inside { width: 1070px!important; }";
		} else if($seatheme_color_main_width_post == '1070') {
			$custom_css .= "
	body.single .container,body.single .container-class.container .bm-wrap.module.col-0:not(.bm-force-full) > .module-inside { width: 970px!important; }";		
		}
	}
$custom_css .= "
}"; //End @media min-width:1200px

//Fluid when Max Width, fix the fullwidth group center issue
	if ( $theme_option_main_width_style == 'container-fluid' && $seatheme_color_max_width ) { 
		$seatheme_max_width_half = intval( $seatheme_color_max_width / 2 );
    	$custom_css .= "
@media(min-width: ".esc_attr( $seatheme_color_max_width )."px) {
.container-class.container-fluid .bm-builder .col-0.bm-wrap:not(.bm-force-full){margin-left:-".esc_attr($seatheme_max_width_half)."px;}
}";
	}
	//SVG Menu Icon size 
	$seatheme_menu_icon_height_desktop = $seatheme_menu_icon_height_mobile = 0;
	if ( $seatheme_menu_icon_height = seatheme_get_option( 'theme_option_menu_icon_height' ) ) {
		if ( ! is_array( $seatheme_menu_icon_height ) ) { $seatheme_menu_icon_height = array( $seatheme_menu_icon_height, $seatheme_menu_icon_height_mobile ); }
		if ( isset ( $seatheme_menu_icon_height[0] ) ) { $seatheme_menu_icon_height_desktop = intval( $seatheme_menu_icon_height[0] ); }
		if ( isset ( $seatheme_menu_icon_height[1] ) ) { $seatheme_menu_icon_height_mobile = intval( $seatheme_menu_icon_height[1] ); }
	}
	if ( $seatheme_menu_icon_height_desktop ) {
		$custom_css .= "
.navi-trigger, .navi-trigger-svg {height:".esc_attr( $seatheme_menu_icon_height_desktop )."px;line-height:".esc_attr( $seatheme_menu_icon_height_desktop )."px;}
.IE11 .navi-trigger-out{width:".esc_attr( $seatheme_menu_icon_height_desktop )."px;}";
	}
	if ( $seatheme_menu_icon_height_mobile ) {
		$custom_css .= "
header { --height-menuicon-m:".esc_attr( $seatheme_menu_icon_height_mobile )."px;}";
	}

	//SVG portfolio Icon(header icon) size
	$seatheme_header_icon_height_desktop = $seatheme_header_icon_height_mobile = 0;
	if ( $seatheme_header_icon_height = seatheme_get_option( 'theme_option_portfolio_icon_height' ) ) {
		if ( ! is_array( $seatheme_header_icon_height ) ) { $seatheme_header_icon_height = array( $seatheme_header_icon_height, $seatheme_header_icon_height_mobile ); }
		if ( isset ( $seatheme_header_icon_height[0] ) ) { $seatheme_header_icon_height_desktop = intval( $seatheme_header_icon_height[0] ); }
		if ( isset ( $seatheme_header_icon_height[1] ) ) { $seatheme_header_icon_height_mobile = intval( $seatheme_header_icon_height[1] ); }
	}
	if ( $seatheme_header_icon_height_desktop ) {
		$custom_css .= "
.portfolio-icon, .header-icon-svg{height:".esc_attr( $seatheme_header_icon_height_desktop )."px;line-height:".esc_attr( $seatheme_header_icon_height_desktop )."px;}
.IE11 .portfolio-icon{width:".esc_attr( $seatheme_header_icon_height_desktop )."px;}";
	}
	if ( $seatheme_header_icon_height_mobile ) {
		$custom_css .= "
header{--height-headericon-m:".esc_attr( $seatheme_menu_icon_height_mobile )."px;}";
	}

	//SVG Back-top-Top Icon size
	$seatheme_color_top_back_icon_size_height = seatheme_get_option('theme_option_top_back_icon_height');
	if($seatheme_color_top_back_icon_size_height) {
		$custom_css .= "
.back-top-svg .back-top-svg-img{height:".intval(esc_attr($seatheme_color_top_back_icon_size_height))."px;}";
	}

	//Menu Icon left spacing
	$seatheme_menuicon_leftspacing_desktop = $seatheme_menuicon_leftspacing_mobile = 0;
	if ( $seatheme_menuicon_leftspacing = seatheme_get_option( 'theme_option_menu_icon_left_spacing' ) ) {
		if ( ! is_array( $seatheme_menuicon_leftspacing ) ) { $seatheme_menuicon_leftspacing = array( $seatheme_menuicon_leftspacing, $seatheme_menuicon_leftspacing_mobile ); }
		if ( isset ( $seatheme_menuicon_leftspacing[0] ) ) { $seatheme_menuicon_leftspacing_desktop = intval( $seatheme_menuicon_leftspacing[0] ); }
		if ( isset ( $seatheme_menuicon_leftspacing[1] ) ) { $seatheme_menuicon_leftspacing_mobile = intval( $seatheme_menuicon_leftspacing[1] ); }
		if ( $seatheme_menuicon_leftspacing_desktop ) {
			$custom_css .= "
.navi-trigger-out{margin-left:".esc_attr( $seatheme_menuicon_leftspacing_desktop )."px;}";
		}
		if ( $seatheme_menuicon_leftspacing_mobile ) {
			$custom_css .= "
.navi-trigger-out{--marginleft-menuicon-m:".esc_attr( $seatheme_menuicon_leftspacing_mobile )."px;}";
		}
	}

	//Portfolio Icon left spacing
	$seatheme_headericon_leftspacing_desktop = $seatheme_headericon_leftspacing_mobile = 0;
	if ( $seatheme_headericon_leftspacing = seatheme_get_option( 'theme_option_portfolio_icon_left_spacing' ) ) {
		if ( ! is_array( $seatheme_headericon_leftspacing ) ) { $seatheme_headericon_leftspacing = array( $seatheme_headericon_leftspacing, $seatheme_headericon_leftspacing_mobile ); }
		if ( isset ( $seatheme_headericon_leftspacing[0] ) ) { $seatheme_headericon_leftspacing_desktop = intval( $seatheme_headericon_leftspacing[0] ); }
		if ( isset ( $seatheme_headericon_leftspacing[1] ) ) { $seatheme_headericon_leftspacing_mobile = intval( $seatheme_headericon_leftspacing[1] ); }
		if ( $seatheme_headericon_leftspacing_desktop ) {
			$custom_css .= "
.header-portfolio-icon{margin-left:".esc_attr( $seatheme_headericon_leftspacing_desktop )."px;}";
		}
		if ( $seatheme_headericon_leftspacing_mobile ) {
			$custom_css .= "
.header-portfolio-icon{--marginleft-headericon-m:".esc_attr( $seatheme_headericon_leftspacing_mobile )."px;}";
		}
	}

	//Social links left spacing
	$seatheme_social_links_leftspacing_desktop = $seatheme_social_links_leftspacing_mobile = 0;
	if ( $seatheme_social_links_leftspacing = seatheme_get_option( 'theme_option_social_links_left_spacing' ) ) {
		if ( ! is_array( $seatheme_social_links_leftspacing ) ) { $seatheme_social_links_leftspacing = array( $seatheme_social_links_leftspacing, $seatheme_social_links_leftspacing_mobile ); }
		if ( isset ( $seatheme_social_links_leftspacing[0] ) ) { $seatheme_social_links_leftspacing_desktop = intval( $seatheme_social_links_leftspacing[0] ); }
		if ( isset ( $seatheme_social_links_leftspacing[1] ) ) { $seatheme_social_links_leftspacing_mobile = intval( $seatheme_social_links_leftspacing[1] ); }
		if ( $seatheme_social_links_leftspacing_desktop ) {
			$custom_css .= "
.header-bar-social{margin-left:".esc_attr( $seatheme_social_links_leftspacing_desktop )."px;}";
		}
		if ( $seatheme_social_links_leftspacing_mobile ) {
			$custom_css .= "
.header-bar-social{--marginleft-sociallinks-m:".esc_attr( $seatheme_social_links_leftspacing_mobile )."px;}";
		}
	}

	//Cart(Woo) Icon size and  left spacing
	$seatheme_cart_icon = seatheme_get_option( 'theme_option_show_shopping_cart' );
	if ( $seatheme_cart_icon && class_exists( 'woocommerce' ) ) {
		$seatheme_cart_icon_height_desktop = $seatheme_cart_icon_height_mobile = 0;
		if ( $seatheme_cart_icon_height = seatheme_get_option( 'theme_option_woo_icon_height' ) ) {
			if ( ! is_array( $seatheme_cart_icon_height ) ) { $seatheme_cart_icon_height = array( $seatheme_cart_icon_height, $seatheme_cart_icon_height_mobile ); }
			if ( isset ( $seatheme_cart_icon_height[0] ) ) { $seatheme_cart_icon_height_desktop = intval( $seatheme_cart_icon_height[0] ); }
			if ( isset ( $seatheme_cart_icon_height[1] ) ) { $seatheme_cart_icon_height_mobile = intval( $seatheme_cart_icon_height[1] ); }
		}
		if ( $seatheme_cart_icon_height_desktop ) {
			$custom_css .= "
.ux-bag-svg,.ux-woocomerce-cart-a{height:".esc_attr( $seatheme_cart_icon_height_desktop )."px;line-height:".esc_attr( $seatheme_cart_icon_height_desktop )."px;}
.IE11 .ux-bag-svg{width:".esc_attr( $seatheme_cart_icon_height_desktop )."px;}";
		}
		if ( $seatheme_cart_icon_height_mobile ) {
			$custom_css .= "
header{--height-carticon-m:".esc_attr( $seatheme_cart_icon_height_mobile )."px;}";
		}
		$seatheme_carticon_leftspacing_desktop = $seatheme_carticon_leftspacing_mobile = 0;
		if ( $seatheme_carticon_leftspacing = seatheme_get_option( 'theme_option_cart_icon_left_spacing' ) ) {
			if ( ! is_array( $seatheme_carticon_leftspacing ) ) { $seatheme_carticon_leftspacing = array( $seatheme_carticon_leftspacing, $seatheme_carticon_leftspacing_mobile ); }
			if ( isset ( $seatheme_carticon_leftspacing[0] ) ) { $seatheme_carticon_leftspacing_desktop = intval( $seatheme_carticon_leftspacing[0] ); }
			if ( isset ( $seatheme_carticon_leftspacing[1] ) ) { $seatheme_carticon_leftspacing_mobile = intval( $seatheme_carticon_leftspacing[1] ); }
			if ( $seatheme_carticon_leftspacing_desktop ) {
				$custom_css .= "
.ux-woo-cart-wrap{margin-left:".esc_attr( $seatheme_carticon_leftspacing_desktop )."px;}";
			}
			if ( $seatheme_carticon_leftspacing_mobile ) {
				$custom_css .= "
.ux-woo-cart-wrap{--marginleft-carticon-m:".esc_attr( $seatheme_carticon_leftspacing_mobile )."px;}";
			}
		}
	}

	//Back-top-Top spacing bottom
	$switch_backtop = seatheme_get_option( 'theme_option_enable_backtop' );
	$switch_backtop_spacing = seatheme_get_option( 'theme_option_enable_backtop_spacing_bottom' );
	$switch_backtop_spacing = $switch_backtop_spacing ? $switch_backtop_spacing : '72';
	if ( $switch_backtop ) {
		$custom_css .= "
.back-top-wrap,.back-top-svg{bottom:".intval(esc_attr($switch_backtop_spacing))."px;}";		
	}

	//Menu Item Spacing vertical
	$seatheme_menuitem_spacingv_desktop = $seatheme_menuitem_spacingv_mobile = 0;
	if ( $seatheme_menuitem_spacingv = seatheme_get_option( 'theme_option_menu_item_spacing_v' ) ) {
		if ( ! is_array( $seatheme_menuitem_spacingv ) ) { $seatheme_menuitem_spacingv = array( $seatheme_menuitem_spacingv, $seatheme_menuitem_spacingv_mobile ); }
		if ( isset ( $seatheme_menuitem_spacingv[0] ) ) { $seatheme_menuitem_spacingv_desktop = intval( $seatheme_menuitem_spacingv[0] ); }
		if ( isset ( $seatheme_menuitem_spacingv[1] ) ) { $seatheme_menuitem_spacingv_mobile = intval( $seatheme_menuitem_spacingv[1] ); }
		if ( $seatheme_menuitem_spacingv_desktop ) {
			$custom_css .= "
.menu-panel #navi li{margin-top:".esc_attr( $seatheme_menuitem_spacingv_desktop )."px;}";
		}
		if ( $seatheme_menuitem_spacingv_mobile ) {
			$custom_css .= "
#navi{--margintop-menuitem-m:".esc_attr( $seatheme_menuitem_spacingv_mobile )."px;}";
		}
	}

	//Menu Item Spacing Horizontal
	$seatheme_menuitem_spacingh_desktop = $seatheme_menuitem_spacingh_mobile = 0;
	if ( $seatheme_menuitem_spacingh = seatheme_get_option( 'theme_option_menu_item_spacing_h' ) ) {
		if ( ! is_array( $seatheme_menuitem_spacingh ) ) { $seatheme_menuitem_spacingh = array( $seatheme_menuitem_spacingh, $seatheme_menuitem_spacingh_mobile ); }
		if ( isset ( $seatheme_menuitem_spacingh[0] ) ) { $seatheme_menuitem_spacingh_desktop = intval( $seatheme_menuitem_spacingh[0] ); }
		if ( isset ( $seatheme_menuitem_spacingh[1] ) ) { $seatheme_menuitem_spacingh_mobile = intval( $seatheme_menuitem_spacingh[1] ); }
		if ( $seatheme_menuitem_spacingh_desktop ) {
			if ( is_rtl() ) {
				$custom_css .= "
body:not(.navi-justified):not(.navi-corner) .navi-header>div>ul>li{margin-right:".esc_attr( $seatheme_menuitem_spacingh_desktop )."px;}";	
			} else {
				$custom_css .= "
body:not(.navi-justified):not(.navi-corner) .navi-header>div>ul>li{margin-left:".esc_attr( $seatheme_menuitem_spacingh_desktop )."px;}";
			}
		}
		if ( $seatheme_menuitem_spacingh_mobile ) {
			if ( is_rtl() ) {
				$custom_css .= "
.navi-header>div>ul>li{--marginright-menuitem-m:".esc_attr( $seatheme_menuitem_spacingh_mobile )."px;}";
			} else {
				$custom_css .= "
.navi-header>div>ul>li{--marginleft-menuitem-m:".esc_attr( $seatheme_menuitem_spacingh_mobile )."px;}";
			}
		}
	}

	//Footer Section Top/Bottom Padding
	$seatheme_footer_spacing_topbottom_desktop = $seatheme_footer_spacing_topbottom_mobile = 0;
	if ( $seatheme_footer_spacing_topbottom = seatheme_get_option('theme_option_footer_topbottom_spacing') ) {
		if ( ! is_array( $seatheme_footer_spacing_topbottom ) ) { $seatheme_footer_spacing_topbottom = array($seatheme_footer_spacing_topbottom, $seatheme_footer_spacing_topbottom_mobile ); }
		if ( isset ( $seatheme_footer_spacing_topbottom[0] ) ) { $seatheme_footer_spacing_topbottom_desktop = intval( $seatheme_footer_spacing_topbottom[0] ); }
		if ( isset ( $seatheme_footer_spacing_topbottom[1] ) ) { $seatheme_footer_spacing_topbottom_mobile = intval( $seatheme_footer_spacing_topbottom[1] ); }
	}
	if ( $seatheme_footer_spacing_topbottom_desktop ) {
		$custom_css .= "
	.footer-info{padding-top:".esc_attr($seatheme_footer_spacing_topbottom_desktop)."px;padding-bottom:".esc_attr($seatheme_footer_spacing_topbottom_desktop)."px; }";	
	}
	if ( $seatheme_footer_spacing_topbottom_mobile ) {
		$custom_css .= "
	.footer-info{--padding-topbottom-footer:".esc_attr($seatheme_footer_spacing_topbottom_mobile)."px;}";
	}

	//Horizontal Spacing for Footer Menu Items
	$seatheme_horizonal_spacing_foot_menuitem_desktop = $seatheme_horizonal_spacing_foot_menuitem_mobile = 0;
	if ( $seatheme_horizonal_spacing_foot_menuitem = seatheme_get_option('theme_option_horizon_spacing_footer_menuitem') ) {
		if ( ! is_array( $seatheme_horizonal_spacing_foot_menuitem ) ) { $seatheme_horizonal_spacing_foot_menuitem = array($seatheme_horizonal_spacing_foot_menuitem, $seatheme_horizonal_spacing_foot_menuitem_mobile ); }
		if ( isset ( $seatheme_horizonal_spacing_foot_menuitem[0] ) ) { $seatheme_horizonal_spacing_foot_menuitem_desktop = intval( $seatheme_horizonal_spacing_foot_menuitem[0] ); }
		if ( isset ( $seatheme_horizonal_spacing_foot_menuitem[1] ) ) { $seatheme_horizonal_spacing_foot_menuitem_mobile = intval( $seatheme_horizonal_spacing_foot_menuitem[1] ); }
	}
	if ( $seatheme_horizonal_spacing_foot_menuitem_desktop ) {
		$custom_css .= "
	.footer-menu>ul>li:not(:first-child){margin-left:".esc_attr($seatheme_horizonal_spacing_foot_menuitem_desktop)."px;}";	
	}
	if ( $seatheme_horizonal_spacing_foot_menuitem_mobile ) {
		$custom_css .= "
	.footer-info{--spacing-h-footer-menuitem:".esc_attr($seatheme_horizonal_spacing_foot_menuitem_mobile)."px;}";
	}

	//Post & page content heading 1-6 size for mobile
	$seatheme_enable_mobile = seatheme_get_option( 'theme_option_mobile_enable_responsive' );

	//Single Post title top spacing
	$seatheme_post_title_top_spacing_desktop = $seatheme_post_title_top_spacing_mobile = 0;
	if ( is_single() ) {
		$seatheme_post_title_top_spacing = seatheme_get_option( 'theme_option_post_title_top_spacing' );
		if ( ! is_array( $seatheme_post_title_top_spacing ) ) { $seatheme_post_title_top_spacing = array( $seatheme_post_title_top_spacing, $seatheme_post_title_top_spacing_mobile ); }
		if ( isset ( $seatheme_post_title_top_spacing[0] ) ) { $seatheme_post_title_top_spacing_desktop = intval( $seatheme_post_title_top_spacing[0] ); }
		if ( isset ( $seatheme_post_title_top_spacing[1] ) ) { $seatheme_post_title_top_spacing_mobile = intval( $seatheme_post_title_top_spacing[1] ); }

		if ( $seatheme_post_title_top_spacing_desktop ) {
			$custom_css .= "
body.single:not(.page_from_top) .content_wrap_outer{padding-top:".esc_attr( $seatheme_post_title_top_spacing_desktop )."px;}";
		}
		if ( $seatheme_post_title_top_spacing_mobile ) {
			$custom_css .= "
body{--margintop-post-title:".esc_attr( $seatheme_post_title_top_spacing_mobile )."px;}";
		}
	}

	//Single Post title bottom spacing
	$seatheme_post_title_bottom_spacing_desktop= $seatheme_post_title_bottom_spacing_mobile = 0;
	if ( is_single() ) {
		$seatheme_post_title_bottom_spacing = seatheme_get_option( 'theme_option_post_title_bottom_spacing' );
		if ( ! is_array( $seatheme_post_title_bottom_spacing ) ) { $seatheme_post_title_bottom_spacing = array( $seatheme_post_title_bottom_spacing, $seatheme_post_title_bottom_spacing_mobile ); }
		if ( isset ( $seatheme_post_title_bottom_spacing[0] ) ) { $seatheme_post_title_bottom_spacing_desktop = intval( $seatheme_post_title_bottom_spacing[0] ); }
		if ( isset ( $seatheme_post_title_bottom_spacing[1] ) ) { $seatheme_post_title_bottom_spacing_mobile = intval( $seatheme_post_title_bottom_spacing[1] ); }

		if ( $seatheme_post_title_bottom_spacing_desktop) {
			$custom_css .= "
body.single .title-wrap-tit{margin-bottom:".esc_attr( $seatheme_post_title_bottom_spacing_desktop)."px;}";
		}
		if ( $seatheme_post_title_bottom_spacing_mobile ) {
			$custom_css .= "
body{--marginbottom-post-title:".esc_attr( $seatheme_post_title_bottom_spacing_mobile )."px;}";
		}
	}

	//Single Post title indent
	$seatheme_post_title_indent_desktop= $seatheme_post_title_indent_mobile = 0;
	if ( is_single() ) {
		$seatheme_post_title_indent = seatheme_get_option( 'theme_option_post_title_indent' );
		if ( ! is_array( $seatheme_post_title_indent ) ) { $seatheme_post_title_indent = array( $seatheme_post_title_indent, $seatheme_post_title_indent_mobile ); }
		if ( isset ( $seatheme_post_title_indent[0] ) ) { $seatheme_post_title_indent_desktop = intval( $seatheme_post_title_indent[0] ); }
		if ( isset ( $seatheme_post_title_indent[1] ) ) { $seatheme_post_title_indent_mobile = intval( $seatheme_post_title_indent[1] ); }

		if ( $seatheme_post_title_indent_desktop) {
			$custom_css .= "
body.single .title-wrap{padding-left:".esc_attr( $seatheme_post_title_indent_desktop)."px;}";
		}
		if ( $seatheme_post_title_indent_mobile ) {
			$custom_css .= "
body{--paddingleft-post-title:".esc_attr( $seatheme_post_title_indent_mobile )."px;}";
		}
	}

	//Single Post meta bottom spacing
	$seatheme_post_meta_bottom_spacing_desktop= $seatheme_post_meta_bottom_spacing_mobile = 0;
	if ( is_single() ) {
		$seatheme_post_meta_bottom_spacing = seatheme_get_option( 'theme_option_post_meta_bottom_spacing' );
		if ( ! is_array( $seatheme_post_meta_bottom_spacing ) ) { $seatheme_post_meta_bottom_spacing = array( $seatheme_post_meta_bottom_spacing, $seatheme_post_meta_bottom_spacing_mobile ); }
		if ( isset ( $seatheme_post_meta_bottom_spacing[0] ) ) { $seatheme_post_meta_bottom_spacing_desktop = intval( $seatheme_post_meta_bottom_spacing[0] ); }
		if ( isset ( $seatheme_post_meta_bottom_spacing[1] ) ) { $seatheme_post_meta_bottom_spacing_mobile = intval( $seatheme_post_meta_bottom_spacing[1] ); }

		if ( $seatheme_post_meta_bottom_spacing_desktop) {
			$custom_css .= "
.article-meta{margin-bottom:".esc_attr( $seatheme_post_meta_bottom_spacing_desktop)."px;}";
		}
		if ( $seatheme_post_meta_bottom_spacing_mobile ) {
			$custom_css .= "
body{--marginbottom-post-meta:".esc_attr( $seatheme_post_meta_bottom_spacing_mobile )."px;}";
		}
	}

	//Blog list (archive)
	$arhcive_items_spacing_h_desktop = $arhcive_items_spacing_h_mobile = 0;
	if ( $arhcive_items_spacing_h = seatheme_get_option( 'theme_option_blog_list_items_spacing_h' ) ) {
		if ( ! is_array( $arhcive_items_spacing_h ) ) { $arhcive_items_spacing_h = array( $arhcive_items_spacing_h, $arhcive_items_spacing_h_mobile ); }
		if ( isset ( $arhcive_items_spacing_h[0] ) ) { $arhcive_items_spacing_h_desktop = intval( $arhcive_items_spacing_h[0] ); }
		if ( isset ( $arhcive_items_spacing_h[1] ) ) { $arhcive_items_spacing_h_mobile = intval( $arhcive_items_spacing_h[1] ); }
	}
	if ( $arhcive_items_spacing_h_desktop ) {
		$custom_css .= "
	.archive-list{margin-left:-".esc_attr( $arhcive_items_spacing_h_desktop )."px;}	
	.archive-item,.archive-list .pagenums{padding-left:".esc_attr( $arhcive_items_spacing_h_desktop )."px;}";
	}
	if ( $arhcive_items_spacing_h_mobile ) {
		$custom_css .= "
	.archive-list{--archiveitems-spacing-h:".esc_attr( $arhcive_items_spacing_h_mobile )."px;}";
	}
	
	$arhcive_items_spacing_v_desktop = $arhcive_items_spacing_v_mobile = 0;
	if ( $arhcive_items_spacing_v = seatheme_get_option( 'theme_option_blog_list_items_spacing_v' ) ) {
		if ( ! is_array( $arhcive_items_spacing_v ) ) { $arhcive_items_spacing_v = array( $arhcive_items_spacing_v, $arhcive_items_spacing_v_mobile ); }
		if ( isset ( $arhcive_items_spacing_v[0] ) ) { $arhcive_items_spacing_v_desktop = intval( $arhcive_items_spacing_v[0] ); }
		if ( isset ( $arhcive_items_spacing_v[1] ) ) { $arhcive_items_spacing_v_mobile = intval( $arhcive_items_spacing_v[1] ); }
	}
	if ( $arhcive_items_spacing_v_desktop ) {
		$custom_css .= "
	.archive-list{margin-top:-".esc_attr( $arhcive_items_spacing_v_desktop )."px;}	
	.archive-item{margin-top:".esc_attr( $arhcive_items_spacing_v_desktop )."px;}";
	}
	if ( $arhcive_items_spacing_v_mobile ) {
		$custom_css .= "
	.archive-list{--archiveitems-spacing-v:".esc_attr( $arhcive_items_spacing_v_mobile )."px;}";
	}

if ( $seatheme_enable_mobile ) {

	$custom_css .= '
@media(max-width:767px) {';
	if ( $seatheme_header_height_mobile ) {
		$custom_css .= "
	body{--header-height-mobile:". esc_attr( $seatheme_header_height_mobile )."px;}";
	}
	if ( $seatheme_header_sticky_height_mobile ) {
 		$custom_css .= "
 	body{--header-heightscrolled-mobile:".esc_attr( $seatheme_header_sticky_height_mobile )."px;}";
 	}
	if ( $seatheme_custom_logo_height_mobile ) {
		$custom_css .= "body{--logo-height-mobile:".esc_attr( $seatheme_custom_logo_height_mobile )."px;}";
	}
	//Logo bottom spacing mobile
	if ( $seatheme_logo_bottom_spacing_mobile = intval( seatheme_get_option( 'theme_option_logo_bottom_spacing_mobile' ) ) ) {
		$custom_css .= "
	.logo-centered-mobile .navi-logo{--marginbottom-logo-bottom:".esc_attr( $seatheme_logo_bottom_spacing_mobile )."px;}";
	}
	if ( $seatheme_loader_logo_height_mobile ) {
		$custom_css .= "body{--loaderlogo-height-mobile:".esc_attr( $seatheme_loader_logo_height_mobile )."px;}";
	}
	if ( $seatheme_footer_logo_height_mobile ) {
		$custom_css .= "body{--footerlogo-height-mobile:".esc_attr( $seatheme_footer_logo_height_mobile )."px;}";
	}
	if ( $seatheme_footer_horizon_align_mobile != 'footer-horizon-equal-mobile' ) {
		if( $seatheme_footer_horizon_spacing_mobile ) {
			$custom_css .= ".footer-cols-item-mobile{--marginleft-footer-item:".esc_attr( $seatheme_footer_horizon_spacing_mobile )."px;}";
		}
	}
	if ( $seatheme_footer_vertical_spacing_mobile ) {
		$custom_css .= ".footer-one-col-item-mobile{--margintop-footer-item:".esc_attr( $seatheme_footer_vertical_spacing_mobile )."px; }";
	}
	//Text logo size for mobile
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_plain_text_header_logo', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_plain_text_footer_logo', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_menu_header', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_submenu_header', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_menu_expanded', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_submenu_expanded', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_post_page_title', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_post_page_content', 'm-size', 'body'));
	for ($x=1; $x<=6; $x++) {
		$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_post_page_heading_' .$x, 'm-size', 'body'));
	}
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_post_page_meta', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_post_page_caption', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_post_page_navi', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_post_page_comments_title', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_post_page_comments_content', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_post_page_comments_author', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_button', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_form', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_archive_title', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_archive_posts_title', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_widget_title', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_widget_content', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_footer', 'm-size', 'footer'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_cookie_bar', 'm-size', 'body'));
	$custom_css .= sanitize_text_field( seatheme_get_font_assignment( '_ux_cb_module_fonts_cookie_bar_btn', 'm-size', 'body'));
$custom_css .= '
}';

} //end if $seatheme_enable_mobile

	return sanitize_text_field( $custom_css );

}}
?>