<?php

/*
============================================================================
	*
	* require functions theme 
	*
============================================================================	
*/
require_once get_template_directory() . '/functions/theme/theme-admin.php';

/*
============================================================================
	*
	* require class 
	*
============================================================================	
*/
require_once get_template_directory() . '/functions/class/class-admin.php';

/*
============================================================================
	*
	* require interface 
	*
============================================================================	
*/
require_once get_template_directory() . '/functions/interface/interface-admin.php';

/*
============================================================================
	*
	* require woocommerce 
	*
============================================================================	
*/

if(class_exists('Woocommerce')){
 	add_theme_support( 'woocommerce' );
	$archivePageLayout = seatheme_get_option( 'fieldWooSingleProductSlider' ); 
	if ( $archivePageLayout == 'wooCommerce' ) {
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );
	}
 	require_once get_template_directory() . '/woocommerce/sea-woocommerce.php';
}

/*
============================================================================
	*
	* require ux content builder 
	*
============================================================================	
*/

if(class_exists('UX_ContentBuilder')){
 	add_theme_support( 'ux-content-builder' );
 	require_once get_template_directory() . '/ux-content-builder/ux-content-builder.php';
}

remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );

/*
============================================================================
	*
	* forcing the "GD" library
	*
============================================================================	
*/

add_filter( 'wp_image_editors', 'seatheme_change_graphic_lib' );

function seatheme_change_graphic_lib($array) {
  return array( 'WP_Image_Editor_GD', 'WP_Image_Editor_Imagick' );
}

?>