<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module Single Image shortcode.
 */
function ux_cb_module_single_image_shortcode($atts) {
	$moduleID = 'single-image';
	
	$atts = shortcode_atts( array(
		'unique' => false,
		'col' => '12',
		'width' => '12/12',
		'style' => ''
	), $atts, 'ux_cb_single_image' );
	
	$html = ux_cb_get_module_template($moduleID, $atts);
	return $html;
}
add_shortcode('ux_cb_single_image', 'ux_cb_module_single_image_shortcode');

/**
 * UX Content Builder Module Single Image container.
 */
function ux_cb_module_single_image_container($module, $moduleUnique) {
	$html = '';
	
	$post_id = ux_cb_get_the_module_post_id($moduleUnique);
	
	//file type
	$fileType = get_post_meta($post_id, '__ux_cb_module_single_image_file_type', true);
	
	//image
	$imageUrl = ux_cb_asset_url( 'images/no-image.png');
	$imageSrc = array($imageUrl, 400, 400);
	$imageSize = '400x400';
	$imageSrcset = false;
	$imageSizes = false;
	$thumbCaption = '';

	$imageTitle = get_the_title($module['postID']);
	if($singleImage = get_post_meta($post_id, '__ux_cb_module_single_image_image', true)){
		if($singleImage != ''){
			$imageSrc = wp_get_attachment_image_src($singleImage, 'full');
			$imageUrl = $imageSrc[0];
			$imageSize = $imageSrc[1]. 'x' .$imageSrc[2] ;
			$imageTitle = get_the_title($singleImage);
			$imageSrcset = wp_get_attachment_image_srcset($singleImage, 'full');
			$imageSizes = wp_get_attachment_image_sizes($singleImage, 'full');
			$imageSizes = '(max-width: 480px) 320px,(max-width: 767px) 500px,'. $imageSizes;
			$thumbCaption = isset( get_post( $singleImage )->post_excerpt ) ? get_post( $singleImage )->post_excerpt : '';
		}
	}
	//thumb width height
	$thumbWH = false;
	$thumbPaddingTop = false;
	if($imageSrc[1] > 0 && $imageSrc[2] > 0){
		$thumbWH = 'width="' . intval($imageSrc[1]).'" height="'.intval($imageSrc[2]).'" ';
		$thumbPaddingTop = 'style="padding-top: ' . (intval($imageSrc[2]) / intval($imageSrc[1])) * 100 . '%;"';
	}
	$thumbBlank = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';

	//lightbox
	$lightboxBefore = '<div data-lightbox="true"><a '.sanitize_text_field( $thumbPaddingTop ).' class="lightbox-item ux-hover-wrap" href="' .esc_url( $imageUrl ). '" data-size="' .sanitize_text_field( $imageSize ). '" data-title="'.wp_kses_post( $thumbCaption ).'" title="' .esc_attr( $thumbCaption ). '">';
	$lightboxAfter = '</a></div>';
	$lightboxClass = 'lightbox-photoswipe';
	$lightboxSwitch = get_post_meta( $post_id, '__ux_cb_module_single_image_lightbox', true );
	if($lightboxSwitch != 'on'){
		$lightboxBefore = '<div class="ux-hover-wrap" '.sanitize_text_field( $thumbPaddingTop ).'>';
		$lightboxAfter = '</div>';
		$lightboxClass = false;
	}
	
	//click to do
	$clickToDo = get_post_meta( $post_id, '__ux_cb_module_single_image_click_to_do', true );
	
	//link
	$link = false;
	$linkBefore = false;
	$linkAfter = false;
	$linkTarget = false;
	$linkDataTag = array();
	$nofollow = false;
	$download = false;
	$linkRel = '';
	$downloadTag = '';

	//caption
	$caption = false;
	$captionAlign = '';

	if( $fileType == 'image' ) {
		$link = get_post_meta( $post_id, '__ux_cb_module_single_image_link', true );
		$linkTarget = get_post_meta( $post_id, '__ux_cb_module_single_image_link_target', true );
		$nofollow = get_post_meta( $post_id, '__ux_cb_module_single_image_link_nofollow', true );
		$download = get_post_meta( $post_id, '__ux_cb_module_single_image_link_download', true );
		$caption = get_post_meta( $post_id, '__ux_cb_module_single_image_caption', true );
		$captionAlign = get_post_meta( $post_id, '__ux_cb_module_single_image_caption_align', true );
	} elseif( $fileType == 'svg' ) {
		if ( $clickToDo == 'go-to-page' ) {
			$link = get_post_meta( $post_id, '__ux_cb_module_single_svg_link', true );
			$linkTarget = get_post_meta( $post_id, '__ux_cb_module_single_svg_link_target', true );
			$nofollow = get_post_meta( $post_id, '__ux_cb_module_single_svg_link_nofollow', true );
			$download = get_post_meta( $post_id, '__ux_cb_module_single_svg_link_download', true );
		} elseif ( $clickToDo == 'page-scrolling' ) {
			if ( $svgPageScroll = get_post_meta( $post_id, '__ux_cb_module_single_image_svg_page_scroll', true ) ) {
				$linkDataTag['data-scrolling'] = 'data-scrolling="' .esc_attr( $svgPageScroll ). '"';
			}
		}
	}
	
	if ( $link ) {
		$link = filter_var( $link, FILTER_SANITIZE_URL );
		if ( $linkTarget == 'on' ) {
			$linkDataTag['target'] = 'target="_blank"';
			$linkRel .= 'noopener noreferrer ';
		} else {
			$linkDataTag['target'] = 'target="_self"';
		}
		if ( $nofollow == 'on' ) {
			$linkRel .= 'nofollow ';
		}
		if ( $download == 'on' ) {
			$downloadTag = ' download';
		}
		$linkBefore = '<a class="ux-hover-wrap-a" href="' .esc_url( $link ). '" ' . sanitize_text_field( join( '', $linkDataTag ) ) . ' rel="'.esc_attr( $linkRel ).'"'.esc_attr( $downloadTag ).'>';
		$linkAfter = '</a>';
	} else {
		$linkBefore = '<span class="ux-hover-wrap-a" ' . sanitize_text_field( join( '', $linkDataTag ) ) . '>';
		$linkAfter = '</span>';
	}
	
	//if ( $fileType == 'image' ) {
		if ( $lightboxSwitch === 'on' ) {
			$linkBefore = false; $linkAfter = false;
		}
	//}

	
	//Image if full and align
	$fitImageFullClass = 'single-image-notfull';
	$fitImageFull = get_post_meta( $post_id, '__ux_cb_module_single_image_width_full', true );
	if ( $fitImageFull === 'on' ) {
		$fitImageFullClass = 'single-image-full';
	}
	
	$alignClass = false;
	if ( $align = get_post_meta( $post_id, '__ux_cb_module_single_image_align', true ) ) {
		if($fitImageFull != 'on') {
			$alignClass = $align;
		}
	}
	
	$widthStyle = '';
	if ( $width = get_post_meta( $post_id, '__ux_cb_module_single_image_width', true ) ) {
		$widthStyle = 'style="width: ' .intval( $width ). 'px;"';
	}
	
	//image style
	$shadowStyle = false;
	$shadowYoffsetStyle = '10';
	$shadowBlurStyle = '50';
	$shadowColorStyle = '#ccc';
	$imageStyle = get_post_meta($post_id, '__ux_cb_module_single_image_style', true);
	$shadowYoffset = intval( get_post_meta( $post_id, '__ux_cb_module_single_image_shadow_y', true ) );
	$shadowYoffsetStyle = $shadowYoffset;
	$shadowBlur = intval( get_post_meta( $post_id, '__ux_cb_module_single_image_shadow_blur', true ) );
	$shadowBlurStyle = $shadowBlur;
	
	if ( $shadowColor = esc_attr( get_post_meta( $post_id, '__ux_cb_module_single_image_shadow_color', true ) ) ) {
		$shadowColorStyle = $shadowColor;
	}

	if($imageStyle === 'shadow'){
		$shadowStyle = 'style="box-shadow:0 '.esc_attr( $shadowYoffsetStyle ).'px '.esc_attr( $shadowBlurStyle ).'px 0 '.esc_attr( $shadowColorStyle ).';"';
	}

	//mouseover
	$mouseoverClass = false;
	$grayEffect = false;
	$mouseover = get_post_meta( $post_id, '__ux_cb_module_single_image_effect', true );
	switch ($mouseover) {
		case 'zoomed': $mouseoverClass = 'bm-image-mouseover bm-image-zoomed'; break;
		case 'gray-to-colored': $mouseoverClass = 'bm-image-mouseover bm-gray-to-colored'; $grayEffect = 'grayscale'; break;
		case 'colored-to-gray': $mouseoverClass = 'bm-image-mouseover bm-colored-to-gray'; break;
		default: $mouseoverClass = false; break;
	}

	//animation
	$animationClass = ux_cb_module_field_animation_class($module);
	$animationEnd = ux_cb_module_field_animation_end($module);

	//disable lazyload
	$disable_lazyload = get_post_meta( $post_id, '__ux_cb_module_single_image_no_lazyload', true );

	//style
	if ( ! $module['is_frontend'] ) {
		$html .= '<style type="text/css">' . sanitize_text_field( ux_cb_module_single_image_style( $post_id, $moduleUnique, $html ) ). '</style>';
	}
	
	if ( $fileType == 'svg' ) {
		$singleImageClass = array();
		if ( $svgAlign = get_post_meta( $post_id, '__ux_cb_module_single_image_svg_align', true) ) {
			switch( $svgAlign ) {
				case 'left': $singleImageClass[] = 'align-left'; break;
				case 'right': $singleImageClass[] = 'right-ux'; break;
				case 'center': $singleImageClass[] = 'align-center'; break;
			}
		}
		
		$html .= '<div class="single-image-out single-image-svg">';
		$html .= '<div class="single-image ' .esc_attr( join( ' ', $singleImageClass ) ). '">';
		$html .=   wp_kses_post( $linkBefore );
		
		if ( $svgID = get_post_meta( $post_id, '__ux_cb_module_single_image_svg', true ) ) {
			if ( $svgURL = wp_get_attachment_url( $svgID ) ) {
				$embedDataTag = array();
				if ( $svgColor = get_post_meta( $post_id, '__ux_cb_module_single_image_svg_color', true ) ) {
					$embedDataTag[] = 'data-color="' .esc_attr( $svgColor ). '"';
				}
				if ( $svgColorFill = get_post_meta( $post_id, '__ux_cb_module_single_image_svg_color_fill', true ) ) {
					$embedDataTag[] = 'data-color-fill="' .esc_attr( $svgColorFill ). '"';
				}
				if ( $svgColorMouseover = get_post_meta( $post_id, '__ux_cb_module_single_image_svg_color_mouseover', true ) ) {
					$embedDataTag[] = 'data-color-mouseover="' .esc_attr( $svgColorMouseover ). '"';
				}
				if ( $svgColorMouseoverFill = get_post_meta( $post_id, '__ux_cb_module_single_image_svg_color_mouseover_fill', true ) ) {
					$embedDataTag[] = 'data-color-mouseover-fill="' .esc_attr( $svgColorMouseoverFill ). '"';
				}
				if ( $svgWidth = intval( get_post_meta( $post_id, '__ux_cb_module_single_image_svg_width', true ) ) ) {
					$embedDataTag[] = 'data-width="' .esc_attr( $svgWidth ). '"';
				}
				$html .= '<embed class="single-image-embed" style="width:'.esc_attr( $svgWidth ).'px;" datasrc="' .esc_url( $svgURL ). '" ' .sanitize_text_field( join( ' ', $embedDataTag ) ). ' type="image/svg+xml"></embed>';
			}
		}
		
		$html .=  wp_kses_post($linkAfter);
		$html .= '</div>';
		$html .= '</div>';
	} else {
		$html .= '<div class="single-image-out ' .esc_attr( $animationClass ). ' '.sanitize_html_class( $alignClass ).'" data-animationend="' .esc_attr( $animationEnd ). '">';
		$html .= '<figure class="single-image ' .sanitize_html_class( $lightboxClass ). ' ' .esc_attr( $mouseoverClass ). ' '.sanitize_html_class( $fitImageFullClass ).'" '.sanitize_text_field( $shadowStyle ).'>';
		$html .= $lightboxBefore;
		$html .= wp_kses_post($linkBefore);
		if ( $module['is_frontend'] ) {	
			if ( $disable_lazyload ) {
				$html .= '<img alt="'.esc_attr( $imageTitle ).'" class="single-image-img ' .sanitize_html_class( $grayEffect ). '" src="' .esc_url( $imageUrl ). '" srcset="'.wp_kses_post( $imageSrcset ).'" sizes="'.wp_kses_post( $imageSizes ).'" '.sanitize_text_field( $thumbWH ).' '.sanitize_text_field( $widthStyle ).' />';	
			} else {
				$html .= '<img alt="'.esc_attr( $imageTitle ).'" class="single-image-img lazy ' .sanitize_html_class( $grayEffect ). '" src="'.esc_attr( $thumbBlank ).'" data-src="' .esc_url( $imageUrl ). '" data-srcset="'.wp_kses_post( $imageSrcset ).'" data-sizes="'.wp_kses_post( $imageSizes ).'" '.sanitize_text_field( $thumbWH ).' '.sanitize_text_field( $widthStyle ).' />';
			}
		} else {
			$html .= '<img alt="'.esc_attr( $imageTitle ).'" class="single-image-img ' .sanitize_html_class( $grayEffect ). '"  src="' .esc_url( $imageUrl ). '" '.sanitize_text_field( $widthStyle ).' />';
		}
		$html .= wp_kses_post( $linkAfter );
		$html .= wp_kses_post( $lightboxAfter );
		if ( $caption == 'on' && $thumbCaption ) {
			$html .= '<figcaption class="single-image-caption '.sanitize_html_class( $captionAlign ).'">';
			$html .= wp_kses_post( $thumbCaption );
			$html .= '</figcaption>';
		}
		$html .= '</figure>';
		$html .= '</div>';
		
	}
	
	return $html;
}
add_filter( 'ux_cb_module_container_single-image', 'ux_cb_module_single_image_container', 10, 2 );