<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module Masonry Grid shortcode.
 */
function ux_cb_module_masonry_grid_shortcode($atts) {
	$moduleID = 'masonry-grid';
	
	$atts = shortcode_atts( array(
		'unique' => false,
		'col' => '12',
		'width' => '12/12',
		'style' => ''
	), $atts, 'ux_cb_masonry_grid' );
	
	$html = ux_cb_get_module_template($moduleID, $atts);
	return $html;
}
add_shortcode('ux_cb_masonry_grid', 'ux_cb_module_masonry_grid_shortcode');

/**
 * UX Content Builder Module Masonry Grid container.
 */
function ux_cb_module_masonry_grid_container($module=array(), $moduleUnique=false) {
	$html = '';
	
	$post_id = ux_cb_get_the_module_post_id($moduleUnique);
	$gridName = '__ux_cb_module_masonry_grid_';
	
	//source
	$source = get_post_meta($post_id, '__ux_cb_module_masonry_grid_source', true);
	if ( !$source ) {
		$source = 'ux-portfolio';
	}
	
	//taxonomy
	$taxonomy = get_post_meta($post_id, '__ux_cb_module_masonry_grid_category_' .$source. '_tax', true);
	if ( !$taxonomy ) {
		$taxonomy = 'ux-portfolio-cat';
	}
	
	//category
	$category = get_post_meta($post_id, '__ux_cb_module_masonry_grid_category_' .$source, true);
	if ( $category ) {
		if ( $category == '0' ) {
			$category = false;
		}
	}
	
	//per page
	$perPage = get_post_meta($post_id, '__ux_cb_module_masonry_grid_post_number_perpage', true);
	if ( !$perPage || $perPage == '' ) {
		$perPage = -1;
	}
	
	//post not in
	$post__not_in = array();
	
	$catID = $category;
	if ( $category == '' ) {
		$catID = '0';
	}
	$layouts = get_post_meta( $post_id, '_ux_cb_module_layouts_' .$catID, true );
	$oldLayouts = get_post_meta( $post_id, '__module_old_layouts', true );
	$originalFields = get_post_meta( $post_id, 'originalFields', true );
	$layoutMultiple = 1;
	
	if ( ! $oldLayouts ) {
		$layoutMultiple = 2;
	}
	
	//list layout
	$layout_array = array();
	if ( $layouts ) {
		$layout_array = $layouts;
		if ( $originalFields ) {
			$perPage = get_post_meta( $post_id, $gridName. 'post_number_perpage_o', true );
		}
	} else {
		if ( $originalFields ) {
			$oGridSource = 'attachment';
			if ( isset( $originalFields[$gridName. 'source'] ) ) {
				$oGridSource = $originalFields[$gridName. 'source'];
			}
			
			$oGridTax = 'ux-portfolio-cat';
			if ( isset( $originalFields[$gridName. 'category_' .$oGridSource. '_tax'] ) ) {
				$oGridTax = $originalFields[$gridName. 'category_' .$oGridSource. '_tax'];
			}
			
			$oGridCat = false;
			if ( isset( $originalFields[$gridName. 'category_' .$oGridSource] ) ) {
				$oGridCat = $originalFields[$gridName. 'category_' .$oGridSource];
			}
			
			if ( isset( $originalFields['_ux_cb_module_layouts_' .$oGridCat] ) ) {
				$layouts = $originalFields['_ux_cb_module_layouts_' .$oGridCat];
				if ( count($layouts) ) {
					$perPage = count( $layouts );
					update_post_meta( $post_id, $gridName. 'post_number_perpage_o', $perPage );
				}
			}
		}
	}
	
	//query
	$query_args = array(
		'posts_per_page' => $perPage,
		'post__not_in' => $post__not_in,
		'post_type' => $source,
		'meta_key' => '_thumbnail_id',
		'post_status' => 'publish'
	);
	
	if ( $category ) {
		$query_args['tax_query'] = array(
			array(
				'taxonomy' => $taxonomy,
				'field' => 'term_id',
				'terms' => intval($category),
			)
		);
	}
	
	$the_query = new WP_Query($query_args);
	
	$max_num_pages = intval($the_query->max_num_pages);
	$found_posts = intval($the_query->found_posts);
	
	//media query
	$media_query = false;
	if ( $source == 'attachment' ) {
		$media_query = get_post_meta($post_id, '_ux_cb_module_layouts_-1', true);
		if ( ! $media_query ) {
			$media_query = array();
		}
		$found_posts = count($media_query);
	}
	
	//what thumb
	$whatThumb = '';
	if ( $source == 'ux-portfolio' || $source == 'post' ) {
		$whatThumb = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_what_thumb_does', true);
	}elseif ( $source == 'attachment' ) {
		$whatThumb = get_post_meta($post_id, '__ux_cb_module_masonry_grid_attachment_what_thumb_does', true);
	}
	$open2ndLightbox = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_open_2nd_lighbox', true);

	//open in new window
	$openNewTabTarget = '';
	$rel = '';
	$openNewTab = get_post_meta($post_id, '__ux_cb_module_masonry_grid_what_thumb_does_new_tab', true); 
	if ( $whatThumb === 'open-the-portfolio-item' && $openNewTab === 'on' ) {
		$openNewTabTarget = 'target="_blank"';
		$rel .= 'noopener noreferrer';
	}
	if ( get_post_meta($post_id, '__ux_cb_module_masonry_grid_what_thumb_does_nofollow', true) == 'on' ) {
		$rel .= ' nofollow';
	}
	//image style
	$imageStyle = get_post_meta($post_id, '__ux_cb_module_masonry_grid_item_style', true);
	
	//mouseover effect
	$mouseoverEffect = false;
	switch ( $imageStyle ) {
		case 'image': $mouseoverEffect = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_mouseover_effect', true); break;
		case 'image-text': $mouseoverEffect = 'no-effect'; break;
	}

	//mouseover effect on touch screen
	$touchTapOnce = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_touch_once', true);
	$touchTabClass = false;
	if ( $imageStyle == 'image' && ($whatThumb == 'open-the-portfolio-item' || $source == 'product') ) {
		if ( $mouseoverEffect == 'static-color-mask-text' || $mouseoverEffect == 'show-second-featured-image' || $mouseoverEffect == 'second-featured-image-text') {
			if ( $touchTapOnce === 'off' ) {
				$touchTabClass = 'bm-touch-tab';
			}
		}
	}
	
	//text align
	$textAlign = false;
	switch ( $imageStyle ) {
		case 'image': $textAlign = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_text_align', true); break;
		case 'image-text': $textAlign = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_text_text_align', true); break;
	}
	
	//show category and title and price
	$showCategory = false;
	$showTitle = false;
	$showPrice = false;
	$showText = false;
	switch (  $imageStyle ) {
		case 'image': 
			if ( $mouseoverEffect === 'static-color-mask-text' || $mouseoverEffect == 'second-featured-image-text' ) { 
				$showText = 'on';
			}
		break;
		case 'image-text':
			$showText = 'on';
		break;
	}

	$textGroup = array();
	if (  $source === 'post' || $source === 'ux-portfolio' ) {

		if ( $imageStyle === 'image-text' ) {

			$textGroup = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_style_image_text_text_group', true );

		} elseif ( $imageStyle === 'image' ) {

			$textGroup = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_style_image_text_group', true );
		}
		
	} elseif ( $source === 'product' ) {

		if ( $imageStyle === 'image-text' ) {

			$textGroup = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_product_style_image_text_text_group', true );

		} elseif ( $imageStyle === 'image' ) {

			$textGroup = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_product_style_image_text_group', true );
		}
		
	}
	
	if ( ! is_array( $textGroup ) ) { $textGroup = array( $textGroup ); }
	
	//fit image into grid
	$fit_img_into_grid = false; 
	$fit_img_into_grid_class = false;
	if ( $fit_img_into_grid = get_post_meta($post_id, '__ux_cb_module_masonry_grid_img_fit_grid', true) == 'on' ) {
		$fit_img_into_grid_class = 'image-fit-grid';
		
	}
	
	//image position
	$img_posi_grid = false; 
	$img_posi_grid_class = false;
	if ( $img_posi_grid = get_post_meta($post_id, '__ux_cb_module_masonry_grid_img_posi', true) == 'image_top' ) {
		$img_posi_grid_class = 'img-posi-grid-top';
	}
	
	if ( isset($module['ajax']) ) {
		if ( $source == 'attachment' ) {
			if ( $media_query ) {
				foreach ( $media_query as $layout ) {
					$html .= ux_cb_module_masonry_grid_templates_attachment($layout, $post_id, $module);
				}
			}
		}else{
			if ( $the_query->have_posts() ) {
				if ( $originalFields ) {
					if ( count( $layouts ) ) {
						$postNum = 0;
						while($the_query->have_posts() ) { $the_query->the_post();
							foreach ( $layouts as $num => $layout ) {
								if ( $num == $postNum ) {
									$layouts[$num]['post_id'] = get_the_ID();
								}
							}
							$postNum++;
						}
						$layout_array = $layouts;
						update_post_meta( $post_id, '_ux_cb_module_layouts_template', $layouts );
					}
				}
				
				while($the_query->have_posts() ) { $the_query->the_post();
					global $product;
					
					$loop_post_id = get_the_ID();
					
					//post class
					$postClass = 'post--' .$loop_post_id;
					
					//classes
					$classes = array();
					$postTerms = get_the_terms( $loop_post_id, $taxonomy );
					if ( $postTerms ) {
						foreach ( $postTerms as $term ) {
							$classes[] = sanitize_html_class( 'filter_' . $term->slug );
						}
					}
					
					$classes = array_unique( $classes );
					
					$x = 0;
					$y = 0;
					$width = 3;
					$height = 3;
					
					if ( count($layout_array) ) {
						foreach ( $layout_array as $layout ) {
							if ( $layout['post_id'] == $loop_post_id ) {
								$x = $layout['x'] * $layoutMultiple;
								$y = $layout['y'] * $layoutMultiple;
								$width = $layout['width'] * $layoutMultiple;
								$height = $layout['height'] * $layoutMultiple;
				
								// Image size for defferent size(width) Grid
								if ( has_post_thumbnail() ) {
									if (  $width > 3 && $width <= 9 ) {
										$thumb = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); 
									} elseif ( $width >= 10) {
										$thumb = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); 
									} else {
										$thumb = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
									}
									$thumbWidth = $thumb[1];
									$thumbHeight = $thumb[2];
									$thumbUrl = $thumb[0];
									$thumbCaption = isset(get_post(get_post_thumbnail_id())->post_excerpt) ? get_post(get_post_thumbnail_id())->post_excerpt : '';
								}
							}
						}
					}
					
					//lightbox
					$whatThumbData = '';
					if ( $whatThumb == 'open-lightbox' && has_post_thumbnail() ) {
						$whatThumbData = 'data-lightbox="true"';
					}
					
					//No effect
					$noEffect = '';
					if ( $mouseoverEffect == 'no-effect') {
						$noEffect = 'mouseover-no-effect';
					}
					
					//thumbnail
					$thumbWidth = 650;
					$thumbHeight = 490;
					$thumbBlank = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';
					$thumbUrl = $thumbBlank;
					$thumbSrcset = false;
					$thumbSizes = false;
					$thumbCaption = '';
					$imageSize = 'full';
					if ( has_post_thumbnail() ) {
						switch ( $width ) {
							default: $imageSize = 'ux-standard-thumb-big'; break;
							case '1': $imageSize = 'ux-standard-thumb-small'; break;
							case '2': $imageSize = 'ux-standard-thumb-small'; break;
							case '3': $imageSize = 'ux-standard-thumb-small'; break;
							case '4': $imageSize = 'ux-standard-thumb'; break;
							case '5': $imageSize = 'ux-standard-thumb-medium'; break;
							case '6': $imageSize = 'ux-standard-thumb-medium'; break; 
						}
						$thumb = wp_get_attachment_image_src(get_post_thumbnail_id(), $imageSize);
						$thumbSrcset = wp_get_attachment_image_srcset(get_post_thumbnail_id(), $imageSize);
						$thumbSizes = wp_get_attachment_image_sizes(get_post_thumbnail_id(), $imageSize);
						$thumbSizes = '(max-width: 480px) 320px,(max-width: 767px) 500px,'. $thumbSizes;
						if ( !$thumb ) {
							$thumb = wp_get_attachment_image_src(get_post_thumbnail_id(), $imageSize);
							$thumbSrcset = wp_get_attachment_image_srcset(get_post_thumbnail_id(), $imageSize);
							$thumbSizes = wp_get_attachment_image_sizes(get_post_thumbnail_id(), $imageSize);
						}
						$thumbWidth = $thumb[1];
						$thumbHeight = $thumb[2];
						$thumbUrl = $thumb[0];
						$thumbCaption = isset(get_post(get_post_thumbnail_id())->post_excerpt) ? get_post(get_post_thumbnail_id())->post_excerpt : '';
					}
	
					//thumb padding top
					$thumbPaddingTop = false;
					if ( $thumbHeight > 0 && $thumbWidth > 0 ) {
						$thumbPaddingTop = 'padding-top: ' . ( intval( $thumbHeight ) / intval( $thumbWidth ) ) * 100 . '%;';
					}

					//lightbox-click title
					$titleClick = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_click_title_open_item', true);

					//active title link classNmae
					$titleActiveLink = '';
					if ( $whatThumb == 'open-lightbox' &&  $titleClick === 'on' ) {
						if ( $mouseoverEffect == 'static-color-mask-text' ||  $mouseoverEffect == 'second-featured-image-text' ) {
							$titleActiveLink = 'grid-active-titlelink';
						}
					}
					
					//title link
					$titleLinkBefore = '<a href="'.esc_url( get_permalink() ).'" title="'.esc_attr( get_the_title() ).'" '.wp_kses_post( $openNewTabTarget ).' class="grid-item-tit-a" rel="'.esc_attr( $rel ).'">';
					$titleLinkAfter = '</a>';
					
					//lazyload
					$imageLazyload = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_image_lazy_load', true );
					
					//lazyload style
					$imageLazyloadClass = 'lazy';
					$imageLazyloadStyle = 'src="'.esc_attr( $thumbBlank ).'" data-src="'.esc_url( $thumbUrl ).'" data-srcset="'.wp_kses_post( $thumbSrcset ).'" data-sizes="'.wp_kses_post( $thumbSizes ).'" alt="'.esc_attr( $thumbCaption ).'" data-xx="'.esc_attr( $width ).'"';
					if ( $imageLazyload == 'off' ) {
						$imageLazyloadClass = '';
						$imageLazyloadStyle = 'src="'.esc_url( $thumbUrl ).'" srcset="'.wp_kses_post( $thumbSrcset ).'" sizes="'.wp_kses_post( $thumbSizes ).'" alt="'.esc_attr( $thumbCaption ).'" data-xy="'.esc_attr( $width ).'"';
					}
					if ( !$module['is_frontend'] ) {
						$imageLazyloadStyle = 'src="'.esc_url( $thumbUrl ).'"';
					}
	
					//2nd image
					$gridItem2ndClass = false;
					$thumbUrl2nd = false;
					$thumb2ndSrcset = false;
					$thumb2ndSizes = false;
					$uxBackgroundImg2nd = 'ux_background_img_hide';
					if ( $mouseoverEffect == 'show-second-featured-image' || $mouseoverEffect == 'second-featured-image-text' ) {
						$gridItem2ndClass = 'grid_item_2nd_class';
						$uxBackgroundImg2nd = 'ux-background-img-2nd';
						$thumb2ndId = get_post_meta( $loop_post_id, '_alternative_featured_image', true );
						
						if ( $source == 'product' ) {
							$productAttachmentIds = $product->get_gallery_image_ids();
							if ( $productAttachmentIds ) {
								$thumb2ndId = $productAttachmentIds[0];
							}
						}
						
						$thumb2nd = wp_get_attachment_image_src( $thumb2ndId, 'full' );
						$thumbUrl2nd = $thumb2nd[0];
						$thumb2ndSrcset = wp_get_attachment_image_srcset( $thumb2ndId, 'full' );
						$thumb2ndSizes = wp_get_attachment_image_sizes( $thumb2ndId, 'full' );
					}
					
					//2nd image lazyload style
					$imageLazyloadClass2nd = 'lazy';
					$imageLazyloadImgStyle2nd = 'src="' .esc_attr( $thumbBlank ). '" data-src="' .esc_url( $thumbUrl2nd ). '" data-srcset="'.wp_kses_post( $thumb2ndSrcset ).'" data-sizes="'.wp_kses_post( $thumb2ndSizes ).'" alt="'.esc_attr( $thumbCaption ).'"';
			
					if ( $imageLazyload == 'off' ) {
						$imageLazyloadClass2nd = '';
						$imageLazyloadImgStyle2nd = 'src="' .esc_url( $thumbUrl2nd ). '" srcset="'.wp_kses_post( $thumb2ndSrcset ).'" sizes="'.wp_kses_post( $thumb2ndSizes ).'" alt="'.esc_attr( $thumbCaption ).'"';
					}

					//Thumb video embeded
					$videoThumbType = '';
					$videoThumbType = ux_cb_get_theme_meta(get_the_ID(), 'theme_meta_portfolio_thumb_on_list');
					
					$videoThumbHideHoverClass = '';
					$videoThumb = '';
					$videoThumb = ux_cb_get_theme_meta(get_the_ID(), 'theme_meta_portfolio_thumb_embed_video');
					$videoThumbHowplay = '';
					$videoThumbRatio = ux_cb_get_theme_meta(get_the_ID(),'theme_meta_portfolio_video_ratio');
					if ( $videoThumbType == 'embeded-video' ) {
						$videoThumbHowplay = ux_cb_get_theme_meta(get_the_ID(), 'theme_meta_portfolio_video_howplay');
						if ( $videoThumbHowplay == 'autoplay' || $videoThumbHowplay == 'lightbox' ) {
							$videoThumbHideHoverClass = '';
						} else {
							$videoThumbHideHoverClass = 'thumb-type-video-hide-hover';
						}
					} elseif ( $videoThumbType == 'hosted-video' )  {
						$videoThumbHowplay = ux_cb_get_theme_meta(get_the_ID(), 'theme_meta_portfolio_video_howplay_hosted'); 
						if ( $videoThumbHowplay == 'autoplay' || $videoThumbHowplay == 'lightbox' ) {
							$videoThumbHideHoverClass = '';
						} else {
							$videoThumbHideHoverClass = 'thumb-type-video-hide-hover';
						}
					}
					
					$videoThumbRatio_key1 = $videoThumbRatio[1] && isset($videoThumbRatio[1]) ? intval( $videoThumbRatio[1] ) : 16;
					$videoThumbRatio_key2 = $videoThumbRatio[2] && isset($videoThumbRatio[2]) ? intval( $videoThumbRatio[2] ) : 9;
					$videoThumbVerDatasrc = $videoThumbHowplay === 'autoplay' ? true : false;
					$videoThumbVerAutopaly = $videoThumbHowplay === 'autoplay' ? true : false;
					$videoThumbTypeListClass = '';
					if ( $videoThumbType == 'embeded-video' || $videoThumbType == 'hosted-video' ) {
						if ( $videoThumbRatio[1] && $videoThumbRatio[2] ) {
							$videoThumbTypeListClass = 'with-video-ratio';
						}
					}
					//Thumb video hosted
					$videoThumbMp4 = ux_cb_get_theme_meta(get_the_ID(), 'theme_meta_portfolio_thumb_video_mp4');
					$videoThumbWebm = ux_cb_get_theme_meta(get_the_ID(), 'theme_meta_portfolio_thumb_video_webm');
					$videoThumbOgg = ux_cb_get_theme_meta(get_the_ID(), 'theme_meta_portfolio_thumb_video_ogg');
					if ( $videoThumbHowplay == 'autoplay' ) {
						$videoThumbVerHosted = 'loop autoplay muted playsinline';
					} else {
						$videoThumbVerHosted = 'controls';
					}
					$dataVideoSrc = 'data-src';
					if ( ! $module['is_frontend'] ) {
						$dataVideoSrc = 'src';
					}
					$videoThumbHtml = '';
					if ( $videoThumbType == 'hosted-video' ) {
						$videoThumbHtml .= '<div class="background-video"><video class="lazy" '.esc_attr( $videoThumbVerHosted ).'>';
						if ( $videoThumbMp4 ) {
							$videoThumbHtml .= '<source '.esc_attr($dataVideoSrc).'="'.esc_url($videoThumbMp4).'" type="video/mp4">';
						}
						if ( $videoThumbWebm ) {
							$videoThumbHtml .= '<source '.esc_attr($dataVideoSrc).'="'.esc_url($videoThumbWebm).'" type="video/webm">';
						}
						if ( $videoThumbOgg ) {
							$videoThumbHtml .= '<source '.esc_attr($dataVideoSrc).'="'.esc_url($videoThumbOgg).'" type="video/ogg">';
						}
						$videoThumbHtml .= '</video></div>';
					}

					//thumb padding top
					$thumbPaddingTop = false;
					if ( $thumbHeight > 0 && $thumbWidth > 0 ) {
						$thumbPaddingTop = 'padding-top: ' . (intval($thumbHeight) / intval($thumbWidth)) * 100 . '%;';
					}
					if ( $source =='ux-portfolio' ) {
						if ( $videoThumbType == 'embeded-video' || $videoThumbType == 'hosted-video' ) {
							$thumbPaddingTop = 'padding-top:'.(intval($videoThumbRatio_key2) / intval($videoThumbRatio_key1)) * 100 .'%';
						}
					}
					
					//animation
					$animation_class = ux_cb_module_field_animation_class($module);
					$animation_end = ux_cb_module_field_animation_end($module);
					
					//Caption text on image+text for attachment
					$textImageText = get_the_title($loop_post_id);
					if ( $source == 'attachment') {
						$textImageText = $thumbCaption ? $thumbCaption : get_the_title($loop_post_id);
					}

					$html .= '<div class="grid-stack-item '. sanitize_html_class ( $noEffect) .' '. sanitize_html_class ( $gridItem2ndClass ) .' '. esc_attr( join( ' ', $classes ) ). '" data-postid="' .esc_attr( $loop_post_id ). '" data-gs-x="' .esc_attr( $x ). '" data-gs-y="' .esc_attr( $y ). '" data-gs-width="' .esc_attr( $width ). '" data-gs-height="' .esc_attr( $height ). '">';
					$html .=   '<div class="grid-stack-item-content">';
					$html .=     '<div class="grid-item-inside ' .esc_attr( $animation_class ). ' '.esc_attr( $touchTabClass ).' '.sanitize_html_class( $titleActiveLink ).'" data-animationend="' .esc_attr( $animation_end ). '">';
					
					switch ( $source ) {

						//woo product
						case 'product':
							if ( $product->is_on_sale() ) {
								$html .= '<span class="onsale">' .esc_html__('Sale!','bm-builder'). '</span>';
							}
							$sold_out_text = apply_filters('ux-get-soldout-text', esc_html__( 'Sold Out', 'bm-builder' ));
							if ( !$product->is_in_stock() ) {
						        $html .= '<span class="sold-out"><span class="sold-out-inn">' . esc_html( $sold_out_text ) . '</span></span>';
						    }
							
							$html .= '<div class="grid-item-con post--' .esc_attr( $loop_post_id ). '">';
							//$html .=   '<a href="' .esc_url( get_permalink() ). '" class="grid-item-mask-link"></a>';
							if ( $imageStyle == 'image' ) {
							$html .=   '<div class="grid-item-con-text">';
							
							if ( $showText === 'on') {

								foreach ( $textGroup as $groupValue ) {

									if ( $groupValue === 'price' && $priceHtml = $product->get_price_html() ) {
										$html .= '<span class="price">' .wp_kses_post( $priceHtml ). '</span>';
									}
									
									if ( $groupValue === 'title'  ) {
										$html .= '<h2 class="grid-item-tit"><a href="' .esc_url( get_permalink() ). '" title="' .esc_attr( get_the_title() ). '" class="grid-item-tit-a">' .esc_html( get_the_title() ). '</a></h2>';
									}

								}
								
							}

							$html .=   '</div>';
							}
							$html .= '</div>';
							
							$html .= '<div class="brick-content ux-lazyload-wrap" style=" ' .esc_attr( $thumbPaddingTop ). '">';

							$html .=  '<img '.wp_kses_post( $imageLazyloadStyle ). ' class="grid-item-img ux-background-img-1st '.sanitize_html_class( $imageLazyloadClass ).'">';

							if ( $imageStyle === 'image-text' ) {

								$html .= '<div class="grid-item-con-text-show">';

								if ( $showText === 'on') {

									$html .= '<h2 class="grid-item-tit">';
									
									foreach ( $textGroup as $groupValue ) {

										if (  $groupValue === 'title' ) { 
											$html .= '<a href="' .esc_url( get_permalink() ). '" title="' .esc_attr( get_the_title() ). '" class="grid-item-tit-a">'. esc_html( get_the_title() ).'</a>'; 
										}

										if ( $groupValue === 'price'  && $priceHtml = $product->get_price_html() ) {
											$html .= '<span class="price">' .wp_kses_post( $priceHtml ). '</span>';
										}
									}

									$html .= '</h2>';
								}
									
								$html .= '</div>';

							} elseif ( $imageStyle === 'image' ) {
								
								$html .= '<img '.wp_kses_post( $imageLazyloadImgStyle2nd ).' class="grid-item-img '.sanitize_html_class( $uxBackgroundImg2nd ).' '.sanitize_html_class( $imageLazyloadClass2nd ).'">';
							
							}

							$html .= '</div>';
						
						break;

						//source portfolio or posts
						default:
							$html .= '<div class="grid-item-con ' .sanitize_html_class( $postClass ). '" ' .wp_kses_post( $whatThumbData ). '>';
								
								if ( $whatThumb == 'open-lightbox' ) {
									$thumbFull = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
									if (  ( $mouseoverEffect == 'show-second-featured-image' || $mouseoverEffect == 'second-featured-image-text' ) && $open2ndLightbox == 'on' && $thumb2ndId ) {
										$thumbFull = wp_get_attachment_image_src($thumb2ndId, 'full');
									}
									$thumbCaption = isset(get_post(get_post_thumbnail_id())->post_excerpt) ? get_post(get_post_thumbnail_id())->post_excerpt : '';
									$dataSize = $thumbFull[1]. 'x' .$thumbFull[2];

									$LightboxHtml = '';
									$video_embeded_code = '';
									$data_video = '';
									$video_playbtn = '';
									if ( $source == 'post') { 
										$video_embeded_code = ux_cb_get_theme_meta(get_the_ID(),'theme_meta_video_embeded_code');
										if ( has_post_format('video') && $video_embeded_code ) {
											$data_video ='video';
											$thumbCaption = get_the_title();
											$video_playbtn = '<span class="video-play-btn fa fa-play"></span>';
											$LightboxHtml .= '<div class="hidden"><div class="videoWrapper video-wrap video-post-wrap">';
											$LightboxHtml .= wp_kses( ux_cb_embed_html( $video_embeded_code, false, false ), ux_cb_kses_allowed_html() ); 
											$LightboxHtml .= '</div></div>';
										}
	
									} else if (  $source == 'ux-portfolio') {
										if ( $videoThumbType =='embeded-video' || $videoThumbType == 'hosted-video' ) {											
											$data_video ='video';
											$thumbCaption = get_the_title();
											$video_playbtn = '<span class="video-play-btn fa fa-play"></span>';
											if ( $videoThumbType =='embeded-video' ) {
												$LightboxHtml .= '<div class="hidden"><div class="videoWrapper video-wrap video-post-wrap">';
												$LightboxHtml .= wp_kses( ux_cb_embed_html( $videoThumb, false, true ), ux_cb_kses_allowed_html() );
												$LightboxHtml .= '</div></div>';
											} elseif ( $videoThumbType == 'hosted-video' ) {
												$LightboxHtml .= '<div class="hidden"><div class="videoWrapper">';
												$LightboxHtml .= '<video class="pswp__video" loop autoplay muted playsinline controls>';
												if ( $videoThumbMp4 ) {
													$LightboxHtml .= '<source src="'.esc_url($videoThumbMp4).'" type="video/mp4">';
												}
												if ( $videoThumbWebm ) {
													$LightboxHtml .= '<source src="'.esc_url($videoThumbWebm).'" type="video/webm">';
												}
												if ( $videoThumbOgg ) {
													$LightboxHtml .= '<source src="'.esc_url($videoThumbOgg).'" type="video/ogg">';
												}
												$LightboxHtml .= '</video>';
												$LightboxHtml .= '</div></div>';
											} 
										}
									}
									
									$html .= '<a data-title="' .esc_attr( $thumbCaption ). '" title="' .esc_attr( $thumbCaption ). '" class="lightbox-item grid-item-mask-link0" href="' .esc_url( $thumbFull[0] ). '" data-size="' .esc_attr( $dataSize ). '" data-type="'.esc_attr( $data_video ).'"><img class="lightbox-img-hide" width="' .esc_attr( $thumbWidth ). '" height="' .esc_attr( $thumbHeight ). '" src="' .esc_attr( $thumbBlank ). '" alt="' .esc_attr( get_the_title() ). '" />';
									$html .= wp_kses_post( $video_playbtn );
									$html .= wp_kses( $LightboxHtml, ux_cb_kses_allowed_html() );
									$html .= '</a>';
								} else {
									if ( has_post_format( 'link' ) ) {
										$image_link = ux_cb_get_theme_meta(get_the_ID(), 'theme_meta_link_item');
										
										if ( $image_link ) {
											$permalink = $image_link['url'][0];
										}
										$html .= '<a href="' .esc_url( $permalink ). '" title="' .esc_attr( get_the_title() ). '" class="grid-item-mask-link0" '.wp_kses_post( $openNewTabTarget ).' rel="'.esc_attr( $rel ).'"></a>';
									}else{
										$html .= '<a href="' .esc_url( get_permalink() ). '" title="' .esc_attr( get_the_title() ). '" '.wp_kses_post( $openNewTabTarget ).' class="grid-item-mask-link0"></a>';
									}
									
								}
								
								if ( $imageStyle == 'image' ) {

									$html .= '<div class="grid-item-con-text">';

										if (  $showText === 'on'  ) {

											foreach ( $textGroup as $groupValue ) {

												if ( $groupValue == 'title' ) {
													$html .= '<h2 class="grid-item-tit">' .wp_kses_post( $titleLinkBefore ). '' .esc_html( get_the_title() ). '' .wp_kses_post( $titleLinkAfter ). '</h2>'; 
												}
												if ( $groupValue == 'category' ) {
													$html .= '<span class="grid-item-cate">' .wp_kses_post( ux_cb_get_the_category( ' ', 'grid-item-cate-a', 'ux-portfolio-cat' ) ). '</span>';
												}
											}
										}

									$html .= '</div>';
								}
								
							$html .= '</div>';

							if (  $imageStyle === 'image' ) {

								$html .= '<div class="brick-content ux-lazyload-wrap '. sanitize_html_class( $videoThumbTypeListClass ) .' '. sanitize_html_class( $videoThumbHideHoverClass ) .'" style=" ' .esc_attr( $thumbPaddingTop ). '">';

								if ( $videoThumbType === 'embeded-video' && $videoThumbHowplay != 'lightbox' ) {
									$html .= '<div class="video-wrap" style=" ' .esc_attr( $thumbPaddingTop ). '">';
									$html .= wp_kses( ux_cb_embed_html( $videoThumb, $videoThumbVerDatasrc, $videoThumbVerAutopaly ), ux_cb_kses_allowed_html() );
									$html .= '</div>';
								} else if ( $videoThumbType === 'hosted-video' && $videoThumbHowplay != 'lightbox' ) {
									$html .= wp_kses( $videoThumbHtml, ux_cb_kses_allowed_html() );
								} 

								$html .= '<img '.wp_kses_post( $imageLazyloadStyle ).' class="grid-item-img ux-background-img-1st '.sanitize_html_class( $imageLazyloadClass ).'">';

								$html .= '<img '.wp_kses_post( $imageLazyloadImgStyle2nd ).' class="grid-item-img '.sanitize_html_class( $uxBackgroundImg2nd ).' '.sanitize_html_class( $imageLazyloadClass2nd ).'">';
								
								$html .= '</div>';
							}

							if ( $imageStyle === 'image-text' ) {
								
								$html .= '<div class="brick-content ux-lazyload-wrap '. sanitize_html_class( $videoThumbTypeListClass ) .' '. sanitize_html_class( $videoThumbHideHoverClass ) .'" style=" ' .esc_attr( $thumbPaddingTop ). '">';
								
								if ( $videoThumbType === 'embeded-video' && $videoThumbHowplay != 'lightbox' ) {
									$html .= '<div class="video-wrap" style=" ' .esc_attr( $thumbPaddingTop ). '">';
									$html .= wp_kses( ux_cb_embed_html( $videoThumb, $videoThumbVerDatasrc, $videoThumbVerAutopaly ), ux_cb_kses_allowed_html() );
									$html .= '</div>';
								} else if ( $videoThumbType === 'hosted-video' && $videoThumbHowplay != 'lightbox' ) {
									$html .= wp_kses( $videoThumbHtml, ux_cb_kses_allowed_html() );
								}

								$html .= '<img '.wp_kses_post( $imageLazyloadStyle ).' class="grid-item-img ux-background-img-1st '.sanitize_html_class( $imageLazyloadClass ).'">';
								
								if ( $showText === 'on' ) {

									$html .= '<div class="grid-item-con-text-show">';
									foreach ( $textGroup as $groupValue ) {
										
										if ( $groupValue == 'category' ) { 

											$html .= '<span class="grid-item-cate">' .wp_kses_post( ux_cb_get_the_category( ' ', 'grid-item-cate-a', 'ux-portfolio-cat' ) ). '</span>'; 
										
										}
										
										if ( $groupValue == 'title' ) { 

											$html .= '<h2 class="grid-item-tit">' .wp_kses_post( $textImageText ). '</h2>'; 

										}

									}
									$html .= '</div>';
								}
								$html .= '</div>';
								
								
							}
						break; 
					}
					
					$html .=     '</div>';
					$html .=   '</div>';
					$html .= '</div>';
				}

				wp_reset_postdata();
			}
		}
	}else{
		//list width
		$listWidthClass = 'ux-portfolio-full bm-masonry-grid';

		//Mobile layout
		$originLayoutMobileClass = false;
		if ( 'on' === get_post_meta( $post_id, '__ux_cb_module_masonry_grid_origin_layout_mobile', true ) ) {
			$originLayoutMobileClass = 'grid-stack-origin-layout-mobile';
		}
		
		//show filter
		$showFilter = false;
		if ( $showFilter = get_post_meta($post_id, '__ux_cb_module_masonry_grid_show_filter', true) === 'on' ) {
			$showFilter = true;
		}
		$filter_align = get_post_meta($post_id, '__ux_cb_module_masonry_grid_filter_align', true);
		$filter_align_class = false;
		if ( $showFilter ) {
			$showFilter = true;
			switch ($filter_align) {
				case 'filter_center':
					$filter_align_class = 'filter-center';
					break;
				case 'filter_right':
					$filter_align_class = 'filter-right';
					break;
			}
		}
		
		//what thumb class
		$whatThumbClass = '';
		if ( $whatThumb == 'open-lightbox' ) {
			$whatThumbClass = 'lightbox-photoswipe';
		}
		
		//text align class
		$textAlignClass = false;
		if ( $imageStyle ) {
			switch ( $imageStyle ) {
				case 'image':
					if ( $mouseoverEffect == 'static-color-mask-text' || $mouseoverEffect == 'second-featured-image-text' ) {
						$textAlignClass = 'grid-text-center';
						if ( $textAlign ) {
							$textAlignClass = $textAlign;
						}
					}
				break;
				case 'image-text':
					$textAlignClass = 'grid-text-center';
					if ( $textAlign ) {
						$textAlignClass = $textAlign;
					}
				break;
			}
		}
		
		//text class
		$showTextClass = false;
		if ( $imageStyle == 'image-text' ) {
			$showTextClass = 'masonry-grid-show-text';
		}
		
		//padding class (text_indent)
		$gridPaddingStyle = ''; 
		$gridPadding = intval( get_post_meta( $post_id, '__ux_cb_module_masonry_grid_style_image_text_show_text_left_right_padding', true ) );
		if ( $gridPadding) {
			$gridPaddingStyle = 'padding-left:'.esc_attr( $gridPadding ).'px;padding-right:'.esc_attr( $gridPadding ).'px;';
		}
		
		//spacing
		$getSpacing = get_post_meta( $post_id, '__ux_cb_module_masonry_grid_item_spacing', true );
		if ( ! is_array( $getSpacing ) ) { $getSpacing = array( $getSpacing, 0 ); }
		$spacing = intval( $getSpacing[0] );
		$spacing_mobile = intval( $getSpacing[1] );
		if (  ! $spacing ) {
			$spacing = 0;
		}
		if ( ! $spacing_mobile ) {
			$spacing_mobile = 0;
		}
		
		//animation
		$animationClass = ux_cb_module_field_animation_class($module);
		$animationEnd = ux_cb_module_field_animation_end($module);
		
		//style
		if ( !$module['is_frontend'] ) {
			$html .= '<style type="text/css">' .sanitize_text_field( ux_cb_module_masonry_grid_style($post_id, $moduleUnique, $html) ). '</style>';
		}
		
		$gridHiddenClass = '';
		if ( $module['is_frontend'] ) {
			$gridHiddenClass = 'hidden';
		}
		
		//filters
		if ( $showFilter ) {
			$html .= '<div class="clearfix grid-stack-filter filters '.sanitize_html_class( $filter_align_class ).'">';
			$html .=   '<ul class="filters-ul">';
			$html .=     '<li class="filters-li active"><a id="all" class="filters-a" href="#" data-filter="*">'.esc_html__('All','bm-builder').'<span class="filter-num">' .esc_html( $found_posts ). '</span></a></li>';
				$terms = get_terms(array('taxonomy' => $taxonomy, 'parent' => $category ));
				
				$post_status = 'publish';
				if ( $source == 'attachment' && $media_query ) {
					$post_status = 'inherit';
					$taxonomy = 'ux-attachment-cat';
					$termArray = array();
					foreach ( $media_query as $layout ) {
						array_push($termArray, $layout['post_id']);
					}
					
					$terms = wp_get_object_terms($termArray, $taxonomy);
					foreach ( $terms as $num => $category ) {
						if ( $category->parent != 0 ) {
							unset($terms[$num]);
						}
					}
				}
				if ( $terms ) { 
					foreach ( $terms as $num => $category ) {
						$get_posts = get_posts(array(
							'posts_per_page' => -1,
							'post_type' => $source,
							'post_status' => $post_status,
							'tax_query' => array(
								array(
									'taxonomy' => $taxonomy,
									'field' => 'term_id',
									'terms' => intval($category->term_id)
								),
							)
						));
						$category_count = count($get_posts);
						
						if ( $source == 'attachment' ) {
							$category_count = 0;
							foreach ( $media_query as $layout ) {
								$get_terms = get_the_terms( $layout['post_id'], $taxonomy );
								if ( $get_terms && ! is_wp_error( $terms ) ) {
									foreach ( $get_terms as $term ) {
										if ( $term->term_id == $category->term_id ) {
											$category_count++;
										}
									}
								}
							}
						}
						
						$html .= sprintf('<li class="filters-li"><a class="filters-a" data-filter=".filter_%1$s" href="%2$s" data-catid="%5$s" data-postid="%6$s">%3$s<span class="filter-num">%4$s</span></a></li>',
							esc_attr($category->slug),
							esc_url(get_category_link($category->term_id)),
							esc_html($category->name),
							esc_html($category_count),
							esc_attr($category->term_id),
							esc_attr($module['postID'])
						);
					}
				}
			$html .=   '</ul>';
			$html .= '</div>';
		}
		
		$html .= '<div class="' .esc_attr( $listWidthClass ). '">';
		
		$html .=   '<div class="grid-stack grid-stack-' .esc_attr( $moduleUnique ). ' ' .sanitize_html_class( $whatThumbClass ). ' ' .sanitize_html_class( $textAlignClass ). ' ' .sanitize_html_class( $showTextClass). '  '.sanitize_html_class( $fit_img_into_grid_class ).' '.sanitize_html_class( $img_posi_grid_class ).' '.sanitize_html_class( $originLayoutMobileClass ).' ' .sanitize_html_class( $gridHiddenClass ). '" data-spacing="' .esc_attr( $spacing ). '" data-spacing-mobile="' .esc_attr( $spacing_mobile ). '" data-item-style="' .esc_attr( $imageStyle ). '" data-number="' .esc_attr( $perPage ). '">';
			if ( $the_query->have_posts() || $media_query ) {
				$module['ajax'] = true;
				$html .= ux_cb_module_masonry_grid_container($module, $moduleUnique);
			}
		
		$html .=   '</div>';
		
		$html .= '</div>';
	}
	
	return $html;
	exit;
}
add_filter( 'ux_cb_module_container_masonry-grid', 'ux_cb_module_masonry_grid_container', 10, 2 );
add_action( 'wp_ajax_ux_cb_module_masonry_grid_container', 'ux_cb_module_masonry_grid_container', 10, 0 );
add_action( 'wp_ajax_nopriv_ux_cb_module_masonry_grid_container', 'ux_cb_module_masonry_grid_container', 10, 0 );

//Source Media Library
function ux_cb_module_masonry_grid_templates_attachment($layout, $post_id, $module ) {
	
	$loop_post_id = $layout['post_id'];

	//source
	$source = get_post_meta($post_id, '__ux_cb_module_masonry_grid_source', true);

	//post class
	$postClass = 'post--' .$loop_post_id;
	
	//what thumb
	$openNewTab = '';
	$openNewTabTarget = '';
	$rel = '';
	$whatThumb = get_post_meta($post_id, '__ux_cb_module_masonry_grid_attachment_what_thumb_does', true);
	$openNewTab = get_post_meta($post_id, '__ux_cb_module_masonry_grid_attachment_what_thumb_does_new_tab', true); 
	if ( $whatThumb === 'open-custom-url' && $openNewTab === 'on' ) {
		$openNewTabTarget = 'target="_blank"';
		$rel .= 'noopener noreferrer';
	}
	if ( get_post_meta($post_id, '__ux_cb_module_masonry_grid_attachment_what_thumb_does_nofollow', true) == 'on' ) {
		$rel .= ' nofollow';
	}
	
	//image style
	$imageStyle = get_post_meta($post_id, '__ux_cb_module_masonry_grid_item_style', true);
	
	//mouseover effect
	$mouseoverEffect = false;
	switch ( $imageStyle ) {
		case 'image': $mouseoverEffect = get_post_meta($post_id, '__ux_cb_module_masonry_grid_style_image_mouseover_effect-attachment', true); break;
		case 'image-text': $mouseoverEffect = 'no-effect'; break;
	}
	
	//No effect
	$noEffect = '';
	if ( $mouseoverEffect == 'no-effect') {
		$noEffect = 'mouseover-no-effect';
	}
	
	//mouseover effect on touch screen
	$touchTabClass = false;
	$touchTapOnce = get_post_meta($post_id, '__ux_cb_module_masonry_grid_attachment_touch_once', true);
	if ( $imageStyle == 'image' && $whatThumb == 'open-custom-url') {
		if ( $mouseoverEffect == 'static-color-mask-text'  ) {
			if ( $touchTapOnce === 'off' ){
				$touchTabClass = 'bm-touch-tab';
			}
		}
	}
	
	//lightbox
	$whatThumbData = '';
	if ( $whatThumb == 'open-lightbox' ) {
		$whatThumbData = 'data-lightbox="true"';
	}
	
	//show title
	$showTitle = false;
	switch ( $imageStyle ) {
		case 'image': 
			if ( $mouseoverEffect == 'static-color-mask-text' ) {
				$showTitle = 'on';
			}
		break;
		case 'image-text':
				$showTitle = 'on';
		break;
	}
	
	//animation
	$animation_class = ux_cb_module_field_animation_class($module);
	$animation_end = ux_cb_module_field_animation_end($module);
	
	$x = $layout['x'];
	$y = $layout['y'];
	$width = $layout['width'];
	$height = $layout['height'];

	$thumbBlank = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';
	$thumb = wp_get_attachment_image_src($loop_post_id, 'full'); 
	$thumbWidth = $thumb[1];
	$thumbHeight = $thumb[2];
	$thumbUrl = $thumb[0];
	$imageSize = 'full';
	$thumbCaption = isset(get_post($loop_post_id)->post_excerpt) ? get_post($loop_post_id)->post_excerpt : '';
	switch ( $width ) {
		default: $imageSize = 'ux-standard-thumb-big'; break;
		case '1': $imageSize = 'ux-standard-thumb-small'; break;
		case '2': $imageSize = 'ux-standard-thumb-small'; break;
		case '3': $imageSize = 'ux-standard-thumb-small'; break;
		case '4': $imageSize = 'ux-standard-thumb'; break;
		case '5': $imageSize = 'ux-standard-thumb-medium'; break;
		case '6': $imageSize = 'ux-standard-thumb-medium'; break; 
	}
	$thumbSrcset = wp_get_attachment_image_srcset($loop_post_id, $imageSize); 
	$thumbSizes = wp_get_attachment_image_sizes($loop_post_id, $imageSize); 
	$thumbSizes = '(max-width: 480px) 320px,(max-width: 767px) 500px,'. $thumbSizes;
	//thumb padding top
	$thumbPaddingTop = false;
	if ( $thumbHeight > 0 && $thumbWidth > 0 ) {
		$thumbPaddingTop = 'padding-top: ' . (intval($thumbHeight) / intval($thumbWidth)) * 100 . '%;';
	}
	
	//lazyload
	$imageLazyload = get_post_meta($post_id, '__ux_cb_module_masonry_grid_image_lazy_load', true);
	
	//lazyload style
	$imageLazyloadStyle = 'src="'.esc_attr( $thumbBlank ).'" data-xx="'.esc_attr( $width ).'" data-src="'.esc_url( $thumbUrl ).'" data-srcset="'.wp_kses_post( $thumbSrcset ).'" data-sizes="'.wp_kses_post( $thumbSizes ).'" alt="'.esc_attr($thumbCaption).'"';
	$imageLazyloadClass = 'lazy';
	if ( $imageLazyload == 'off' ) {
		$imageLazyloadClass = '';
		$imageLazyloadStyle = 'src="'.esc_url( $thumbUrl ).'"  data-xy="'.esc_attr( $width ).'" srcset="'.wp_kses_post( $thumbSrcset ).'" sizes="'.wp_kses_post( $thumbSizes ).'" alt="'.esc_attr( $thumbCaption ).'"';
	}
	if ( !$module['is_frontend'] ) {
		$imageLazyloadStyle = 'src="'.esc_url( $thumbUrl ).'"';
	}
	
	//title link
	$titleLinkBefore = false;
	$titleLinkAfter = false;
	$permalink = get_permalink($loop_post_id);
	if ( $whatThumb == 'open-custom-url' ) {
		$permalink = $thumb[0];
		
		$customUrl = get_post_meta($loop_post_id, 'what_thumbnail_does', true);
		if ( esc_url( $customUrl ) ) {
			$permalink = esc_url( $customUrl );
		}
		
		$titleLinkBefore = '<a href="'.esc_url( $permalink ).'" title="'.esc_attr( get_the_title( $loop_post_id ) ).'" class="grid-item-tit-a">';
		$titleLinkAfter = '</a>';
	}
	
	//classes
	$classes = array();
	$postTerms = get_the_terms($loop_post_id, 'ux-attachment-cat');
	if ( $postTerms ) {
		foreach ( $postTerms as $term ) {
			$parents = get_ancestors( $term->term_id, 'ux-attachment-cat', 'taxonomy' );
			if ( $parents ) {
				foreach ( $parents as $parent ) {
					$parent = get_term( $parent, 'ux-attachment-cat' );
					$classes[] = sanitize_html_class( 'filter_' . $parent->slug);
				}
			}
			$classes[] = sanitize_html_class( 'filter_' . $term->slug);
		}
	}
	
	//Caption text on image+text for attachment
	$textImageText = get_the_title($loop_post_id);
	if ( $source == 'attachment') {
		$textImageText = $thumbCaption ? $thumbCaption : get_the_title($loop_post_id);
	}

	$classes = array_unique($classes);
	
	$html = '<div class="grid-stack-item ' . sanitize_html_class( $noEffect) .' '. esc_attr( join( ' ', $classes ) ). '" data-postid="' .esc_attr( $loop_post_id ). '" data-gs-x="' .esc_attr( $x ). '" data-gs-y="' .esc_attr( $y ). '" data-gs-width="' .esc_attr( $width ). '" data-gs-height="' .esc_attr( $height ). '">';
	$html .=   '<div class="grid-stack-item-content">';
	$html .=     '<div class="grid-item-inside ' .esc_attr( $animation_class ). ' '.esc_attr( $touchTabClass ).'" ' .wp_kses_post( $whatThumbData ). ' data-animationend="' .esc_attr( $animation_end ). '">';
	$html .=       '<div class="grid-item-con ' .sanitize_html_class( $postClass). '">';
				
					  if ( $whatThumb == 'open-lightbox' ) {
						  $dataSize = $thumbWidth. 'x' .$thumbHeight;
						  $html .= '<a data-title="' .esc_attr( $thumbCaption ). '" title="' .esc_attr( $thumbCaption ). '" class="lightbox-item grid-item-mask-link0" href="' .esc_url( $thumbUrl ). '" data-size="' .esc_attr( $dataSize ). '"><img class="lightbox-img-hide" width="' .esc_attr( $thumbWidth ). '" height="' .esc_attr( $thumbHeight ). '" src="' .esc_attr( $thumbBlank ). '" alt="' .esc_attr( get_the_title( $loop_post_id ) ). '" /></a>';
					  }else{
						  $maskLink = 'grid-item-mask-link0';
						  if ( $whatThumb == 'none' ) {
							  $maskLink = false;
						  }
						  $html .= '<a href="' .esc_url( $permalink ). '" title="' .esc_attr( get_the_title( $loop_post_id ) ). '" class="' .sanitize_html_class( $maskLink). '" '.wp_kses_post( $openNewTabTarget ).' rel="'.esc_attr( $rel ).'"></a>';
					  }
					  
					  if ( $imageStyle == 'image' ) {
						  $html .= '<div class="grid-item-con-text">';
							  if ( $showTitle === 'on' ) { 
							  	$html .= '<h2 class="grid-item-tit">' .wp_kses_post( $titleLinkBefore ). '' .esc_html( get_the_title( $loop_post_id ) ). '' .wp_kses_post( $titleLinkAfter ). '</h2>'; 
							  }
						  $html .= '</div>';
					  }
				
	$html .=       '</div>';
	$html .=       '<div class="brick-content ux-lazyload-wrap" style=" ' .esc_attr( $thumbPaddingTop ). '">';
	$html .=			'<img '.wp_kses_post( $imageLazyloadStyle ).' class="grid-item-img ux-background-img-1st '.sanitize_html_class(  $imageLazyloadClass ).'">';
	
	if ( $imageStyle === 'image-text'  ) {
		$html .=           '<div class="grid-item-con-text-show"><h2 class="grid-item-tit">' .wp_kses_post( $titleLinkBefore ).wp_kses_post( $textImageText ).wp_kses_post( $titleLinkAfter ). '</h2></div>';
	}
	
	$html .=       '</div>';
	$html .=     '</div>';
	$html .=   '</div>';
	$html .= '</div>';
	
	return $html;
}
?>
