<?php
if ( ! function_exists( 'ux_cb_tools_import_process_options' ) ) {
	/**
	 * import process theme options
	 */
	function ux_cb_tools_import_process_options( $option, $importDir, $fileSlug ) {
		global $wp_filesystem;
		
		$return = array();
		$wp_upload_dir = wp_upload_dir();
		
		switch ( $fileSlug ) {
			case 'options.json':
				//show on front
				if ( isset( $option[ 'show_on_front' ] ) ) {
					if ( $option[ 'show_on_front' ] == '' ) {
						$updateShowFront = update_option( 'show_on_front', 'page' );
					} else {
						$updateShowFront = update_option( 'show_on_front', $option[ 'show_on_front' ] ); 
					}
					
					if ( ! $updateShowFront ) {
						$return[] = 'error can not update option show_on_front: options.json';
					}
				}
				
				//page on front
				if ( isset( $option[ 'page_on_front' ] ) ) {
					if ( $getNewPostID = ux_cb_tools_import_get_post( $option[ 'page_on_front' ], $importDir, 'page' ) ) {
						$updatePageFront = update_option( 'page_on_front', $getNewPostID ); 
					} else {
						$updatePageFront = update_option( 'page_on_front', $option[ 'page_on_front' ] ); 
					}
				} else {
					$updatePageFront = update_option( 'page_on_front', 0 ); 
				}
				
				if ( ! $updateShowFront ) {
					$return[] = 'error can not update option page_on_front: options.json';
				}
				
				//theme mods
				if ( isset( $option[ 'theme_mods' ] ) ) {
					$themeMods = $option[ 'theme_mods' ];
					if ( isset( $themeMods[ 'nav_menu_locations' ] ) ) {
						foreach ( $themeMods[ 'nav_menu_locations' ] as $name => $location ) {
							if ( $getNewTermID = ux_cb_tools_import_get_term( $location, $importDir ) ) {
								$themeMods[ 'nav_menu_locations' ][ $name ] = $getNewTermID;
							}
						}
						set_theme_mod( 'nav_menu_locations', $themeMods[ 'nav_menu_locations' ] );
					}
				}
				
				//replace theme config fields
				$themeConfigFields = ux_cb_theme_config_fields();
				if ( count( $themeConfigFields ) ) {
					foreach ( $themeConfigFields as $field ) {
						if ( isset( $field[ 'name' ] ) ) {
							switch ( $field[ 'type' ] ) {
								case 'upload':
									if ( isset( $option[ $field[ 'name' ] ] ) ) {
										$filename = basename( $option[ $field[ 'name' ] ] );
										if ( $wp_filesystem->get_contents( $wp_upload_dir[ 'path' ]. '/' .$filename ) ) {
											$option[ $field[ 'name' ] ] = $wp_upload_dir[ 'url' ]. '/' .$filename;
										}
									}
								break;
								
								case 'category':
									if ( isset( $option[ $field[ 'name' ] ] ) ) {
										if ( $getNewTermID = ux_cb_tools_import_get_term( $option[ $field[ 'name' ] ], $importDir ) ) {
											$option[ $field[ 'name' ] ] = $getNewTermID;
										}
									}
								break;
								
								case 'checkbox-group':
									if ( isset( $option[ $field[ 'name' ] ] ) ) {
										if ( is_array( $option[ $field[ 'name' ] ] ) ) {
											foreach ( $option[ $field[ 'name' ] ] as $num => $term_id ) {
												if ( $getNewTermID = ux_cb_tools_import_get_term( $term_id, $importDir ) ) {
													$option[ $field[ 'name' ] ][ $num ] = $getNewTermID;
												}
											}
										}
									}
								break;
								
								case 'page':
									if ( isset( $option[ $field[ 'name' ] ] ) ) {
										$pageID = $option[ $field[ 'name' ] ];
										if ( $targetPageID = ux_cb_tools_import_get_post( $pageID, $importDir, 'page' ) ) {
											$option[ $field[ 'name' ] ] = $targetPageID;
										}
									}
								break;
								
								case 'post':
									if ( isset( $option[ $field[ 'name' ] ] ) ) {
										$pageID = $option[ $field[ 'name' ] ];
										if ( $targetPageID = ux_cb_tools_import_get_post( $pageID, $importDir, $field[ 'pType' ] ) ) {
											$option[ $field[ 'name' ] ] = $targetPageID;
										}
									}
								break;
							}
						}
					}
				}
				
				if ( ! $updateOption = update_option( 'ux_theme_option', $option ) ) {
					$return[] = 'error can not update option ux_theme_option: options.json';
				}
			break;
			
			case 'icons.json':
				if ( ! $updateIconsCustoms = update_option( 'ux_theme_option_icons_custom', $option ) ) {
					$return[] = 'error can not update ux_theme_option_icons_custom: icons.json';
				}
			break;
			
			case 'widgets.json':
				foreach ( $option as $name => $widget ) {
					if ( ! $updateWidget = update_option( $name, $widget ) ) {
						$ux_cb_import_error[] = 'error can not update ' .$name. ': widgets.json';
					}
				}
			break;
			
			case 'googlefonts.json':
				if ( ! $updateGoogleFonts = update_option( 'ux_theme_googlefont', $option ) ) {
					$return[] = 'error can not update ux_theme_googlefont: googlefonts.json';
				}
			break;
			
			case 'font-lists.json':
				if ( ! $updateFontLists = update_option( 'ux-font-lists', $option ) ) {
					$return[] = 'error can not update ux-font-lists: font-lists.json';
				}
			break;
			
			case 'font-assignment.json':
				if ( ! $updateFontAssignment = update_option( 'ux-font-assignment', $option ) ) {
					$return[] = 'error can not update ux-font-assignment: font-assignment.json';
				}
			break;
		}
		
		return $return;
	}
}
?>