<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module Post Navigation Selector.
 */
if ( ! function_exists( 'ux_cb_module_post_navi_selector' ) ) {
	function ux_cb_module_post_navi_selector( $post ) {
		if ( $post->post_type == 'post' || $post->post_type == 'ux-portfolio' ) {
			echo '<button class="ux-cb-module-post-navi-selector" data-module-id="post-navi" type="button">' .esc_html__( 'Post Navigation', 'bm-builder' ). '</button>';
		}
	}
	add_action( 'ux_cb_customize_module_selector', 'ux_cb_module_post_navi_selector' );
}

/**
 * UX Content Builder Module Post Navigation Template.
 */
if ( ! function_exists( 'ux_cb_module_post_navi_template' ) ) {
	function ux_cb_module_post_navi_template() {
		ux_cb_include_template( 'modules/module-post-navi.php' );
	}
}

require_once ux_cb_path_dir( 'CONFIG_DIR', 'modules/config-post-navi.php' );
require_once ux_cb_path_dir( 'TEMPLATES_DIR', 'modules/module-post-navi.php' );  