<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}
global $post; 

$container = apply_filters( 'ux-get-container-width', 'container' );
$currentPost = $post;
?>

<div class="ux-cb-full-overlay">
    <div class="ux-cb-customize-preview no-sidebar">
        <div class="ux-cb-customize-tools">
            <button id="ux-cb-page-options-close" type="button"></button>
            <button id="ux-cb-page-options-save" type="button" data-saving="<?php echo esc_attr__( 'saving', 'bm-builder' ); ?>" data-saved="<?php echo esc_attr__( 'saved', 'bm-builder' ); ?>" data-save="<?php echo esc_attr__( 'save', 'bm-builder' ); ?>"><span class="fa fa-save"></span><div class="save-spinner"><div class="rect1"></div><div class="rect2"></div><div class="rect3"></div><div class="rect4"></div><div class="rect5"></div></div></button>
            <button id="ux-cb-page-options-preview" type="button"></button>
            <button id="ux-cb-page-options-add-module" type="button"></button>
            <?php do_action( 'ux_cb_customize_tools' ); ?>
            <div class="save-overlay"></div>
            <div class="ux-cb-customize-tools-setting">
                <?php do_action( 'ux_cb_customize_tools_setting' ); ?>
            </div>
        </div>
        <div class="ux-cb-module-loading">
            <div></div>
            <div></div>
        </div>
        <div class="ux-cb-customize-module-selector">
            <div class="ux-cb-customize-module-selector-main">
				<h1><?php echo esc_html__( 'Start Adding Content', 'bm-builder' ); ?></h1>
                <div class="ux-cb-customize-module-selector-container">
					<?php do_action( 'ux_cb_customize_module_selector', $post ); ?>
                </div>
            </div>
        </div>
        <div class="ux-cb-customize-preview-container <?php echo sanitize_html_class( $container ); ?>"></div>
        <div class="ux-cb-customize-templates">
			<?php $moduleFields = apply_filters( 'ux_cb_module_fields', array() );
            
            if ( count( $moduleFields ) ) {
				global $ux_cb_module_fields;
				foreach ( $moduleFields as $module ) {
					$atts = array(
						'unique' => false,
						'col' => '12',
						'width' => '12/12',
						'style' => ''
					);
					
					$module = wp_parse_args( $module, array(
						'disabled' => false
					) );
					
					$module['unique'] = $atts['unique'];
					$module['postID'] = $post->ID;
					
					if ( ! $module['disabled'] ) {
						echo $ux_cb_module_fields->templates( $module, $atts );
					} 
				}
			} ?>
            
            <?php
            global $ux_cb_module_theme_color;
			if ( count( $ux_cb_module_theme_color ) ) { ?>
				<div class="ux-cb-module-theme-color">
					<?php foreach ( $ux_cb_module_theme_color as $color ) { ?>
                        <span data-value="<?php echo esc_attr( $color['id'] ); ?>" data-rgb="<?php echo esc_attr( $color['rgb'] ); ?>"></span>
					<?php } ?>
                    <span data-value="none" data-rgb="transparent"></span>
				</div>
			<?php
            } ?>
            
            <div class="ux-cb-module-selector-tools">
                <div class="item selector">
                    <div class="item-border"></div>
                    <div class="module-selector-tools">
                        <?php do_action( 'ux_cb_customize_module_selector', $post ); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="ux-cb-customize-float-sidebar">
		<?php
		$post = get_post( $currentPost->ID );
		do_action( 'ux_cb_customize_float_sidebar', $currentPost ); ?>
    </div>
    <div class="ux-modal">
        <div class="ux-modal-dialog">
            <div class="ux-modal-content">
                <div class="ux-modal-header">
                    <button type="button" class="save" data-saving="<?php echo esc_attr__( 'saving', 'bm-builder' ); ?>" data-saved="<?php echo esc_attr__( 'saved', 'bm-builder' ); ?>" data-save="<?php echo esc_attr__( 'save', 'bm-builder' ); ?>"><?php echo esc_html__( 'Save', 'bm-builder' ); ?></button>
                    <button type="button" class="close"><span class="dashicons dashicons-no-alt"></span></button>
                    <?php do_action( 'ux_cb_customize_modal_header' ); ?>
                    <h4 class="ux-modal-title"></h4>
                </div>
                <div class="ux-modal-body">
                    <div class="ux-cb-module-loading">
                        <div></div>
                        <div></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>