<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * UX Content Builder Module Group shortcode.
 */
function ux_cb_module_group_shortcode( $atts, $content ) {
	$moduleID = 'group';
	
	$atts = shortcode_atts( array(
		'unique' => false,
		'col' => '12',
		'width' => '12/12',
		'style' => ''
	), $atts, 'ux_cb_group' );
	
	$html = ux_cb_get_module_template( $moduleID, $atts, $content );
	return $html;
}
add_shortcode( 'ux_cb_group', 'ux_cb_module_group_shortcode' );

/**
 * UX Content Builder Module Group container.
 */
function ux_cb_module_group_container( $module, $moduleUnique, $content ) {
	$html = '';
	
	//get post id
	$post_id = ux_cb_get_the_module_post_id( $moduleUnique );
	
	//blank thumb
	$thumbBlank = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';
	
	//background color style
	$bgStyle = array();
	
	//background
	$background = get_post_meta( $post_id, '__ux_cb_module_group_background', true );

	$bgVideoSrc = 'data-src';
	if ( ! $module['is_frontend'] ) {
		$bgVideoSrc = 'src';
	}
	
	//Mix Blend Mode
	$mixBlendMode = get_post_meta( $post_id, '__ux_cb_module_group_enable_mix_blend_mode', true );
	
	//Shadow
	$shadowStyle = false; 
	$shadowYoffsetStyle = '10';
	$shadowBlurStyle = '50';
	$shadowColorStyle = '#ccc';
	$shadow = get_post_meta($post_id, '__ux_cb_module_group_shadow', true);
	$shadowYoffset = intval( get_post_meta( $post_id, '__ux_cb_module_group_shadow_y', true ) );
	$shadowYoffsetStyle = $shadowYoffset;
	$shadowBlur = intval( get_post_meta( $post_id, '__ux_cb_module_group_shadow_blur', true ) );
	$shadowBlurStyle = $shadowBlur;
	if ( $shadowColor = esc_attr( get_post_meta( $post_id, '__ux_cb_module_group_shadow_color', true ) ) ) {
		$shadowColorStyle = $shadowColor;
	}
	$shadowStyleVideo = false; 
	if ( $shadow === 'on' ) {
		$shadowStyle = ' box-shadow:0 '.esc_attr($shadowYoffsetStyle).'px '.esc_attr($shadowBlurStyle).'px 0 '.esc_attr($shadowColorStyle).';';
		$shadowStyleVideo = $shadowStyle;
	}

	//Border Radius
	$radiusStyle = false;
	$radius = get_post_meta($post_id, '__ux_cb_module_group_border_radius', true);
	if( $radius === 'on' ) {
		$radiusNumber = intval( get_post_meta( $post_id, '__ux_cb_module_group_border_radius_bumber', true ) );
		$radiusStyle = ' border-radius:'.esc_attr($radiusNumber).'px;';
	}

	$contentHtml = false;
	if ( $module[ 'is_frontend' ] ) {
		$contentHtml = do_shortcode( $content );
	}

	//style backend 
	if ( ! $module['is_frontend'] ) {
		$groupPadingLRStyle = false; 
		$getGroupPadingLR = get_post_meta( $post_id, '__ux_cb_module_group_inner_padding_left_right', true );
		if ( ! is_array( $getGroupPadingLR ) ) { $getGroupPadingLR = array( $getGroupPadingLR, 0 ); }
		$groupPadingLR = intval( $getGroupPadingLR[0] );
		$groupPadingLRMobile = intval( $getGroupPadingLR[1] );
		if( $groupPadingLR ) { 
			$groupPadingLRStyle = 'padding-left:'.esc_attr( $groupPadingLR ).'px; padding-right:'.esc_attr( $groupPadingLR ).'px;';
			$groupPadingLRforBox = $groupPadingLR + 10;
		}
		 
		if ( $groupPadingLR ) {
			$html = '<style type="text/css">.module-id-' .esc_attr( $moduleUnique ). ' > .module-inside > .module-content {'.esc_attr($groupPadingLRStyle).'}';
			$html .= '.container-fluid.ux-cb-customize-preview-container .bm-builder .item.col-0.item[data-module-id="group"] > .module-inside > .module-content:not(.bm-force-full) { margin-right: '.esc_attr($groupPadingLR).'px;margin-left: '.esc_attr($groupPadingLR).'px; }';
			$html .= '.container.ux-cb-customize-preview-container .bm-builder .col-0.item[data-module-id="group"] > .module-inside > .module-content:not(.bm-force-full) {padding-right:'.esc_attr($groupPadingLRforBox).'px; padding-left:'.esc_attr($groupPadingLRforBox).'px;}';
			$html .= '</style>';
		}
	}

	if ( $background == 'background_color' ) {
		$bgColor = '';
		$bgColor = get_post_meta( $post_id, '__ux_cb_module_group_bg_color', true );
		$html .= '<div class="bm-background-color" style="background-color:'.esc_attr($bgColor).'; '.esc_attr($shadowStyle).esc_attr($radiusStyle).'"></div>';
	}
	
	if ( $background == 'background_image' || $background == 'hosted_video' ) {
		$bgImgStyle = false;
		$bgImgFixed = false;
		$bgImgFixedStyle = 'background-attachment:scroll;';
		//background image
		$bgImage = get_post_meta( $post_id, '__ux_cb_module_group_bg_image', true );
		$bgImgFixed = get_post_meta( $post_id, '__ux_cb_module_group_bg_image_fixed', true );
		$bgImageSrc = wp_get_attachment_image_src( $bgImage, 'full' );
		if ( $bgImageSrc ) {
			$thumbBlank = $bgImageSrc[0];
			$bgImgStyle = 'background-image:url(' .esc_url( $bgImageSrc[0] ). ');';
			if($bgImgFixed === 'on' && $background == 'background_image'){
				$bgImgFixedStyle = 'background-attachment:fixed;';
			}
		}
		
		$html .= '<div class="bm-background-img" style="' .esc_attr( $bgImgStyle ).esc_attr($bgImgFixedStyle).esc_attr($shadowStyle).esc_attr($radiusStyle). '"></div>';
	}
	
	if ( $background == 'hosted_video' ) {
		if($bgImageSrc) {
			$shadowStyleVideo = false;
		}
		$html .= '<div class="background-video" style="'.esc_attr($shadowStyleVideo).esc_attr($radiusStyle).'">';
		$html .=   '<video class="lazy" loop autoplay muted playsinline="" >';
		
			//mp4
			if( $mp4 = get_post_meta( $post_id, '__ux_cb_module_embed_video_mp4', true ) ) {
				$html .= '<source '.esc_attr($bgVideoSrc).'="' .esc_url( $mp4 ). '" type="video/mp4">';
			}
			//ogg ogv
			if( $ogg = get_post_meta( $post_id, '__ux_cb_module_embed_video_ogg', true ) ) {
				$html .= '<source '.esc_attr($bgVideoSrc).'="' .esc_url( $ogg ). '" type="video/ogg">';
			}
			//webm
			if( $webm = get_post_meta( $post_id, '__ux_cb_module_embed_video_webm', true ) ) {
				$html .= '<source '.esc_attr($bgVideoSrc).'="' .esc_url( $webm ). '" type="video/webm">';
			}
		
		$html .=   '</video>';
		$html .= '</div>';
		
		if ( $mixBlendMode == 'on' ) {
			//video color
			$videoColor = get_post_meta( $post_id, '__ux_cb_module_group_video_color', true );
			
			$html .= '<div class="background-blend" style="mix-blend-mode: screen; background-color: ' .esc_attr( $videoColor ). ';'.esc_attr($radiusStyle).' ">';
			if ( $module[ 'is_frontend' ] ) {
				$html .= $contentHtml;
			}
			$html .= '</div>';
		} else {
			$html .= $contentHtml;
		}
	} else {
		$html .= $contentHtml;
	}
	
	if ( ! $module[ 'is_frontend' ] ) {
		$html .= do_shortcode( $content );
	}
	
	return $html;
}
add_filter( 'ux_cb_module_container_group', 'ux_cb_module_group_container', 10, 3 );

/**
 * UX Content Builder Module Group frontend module class.
 */
function ux_cb_module_group_module_class( $moduleClass, $moduleID, $post_id ) {
	if ( $moduleID == 'group' ) {
		$moduleClass[] = 'bm-wrap';
		
		//Object Align
		if ( $objectAlign = get_post_meta( $post_id, '__ux_cb_module_group_object_align', true ) ) {
			switch ( $objectAlign ) {
				case 'top': $moduleClass[] = 'row-top'; break;
				case 'middle': $moduleClass[] = 'row-middle'; break;
				case 'bottom': $moduleClass[] = 'row-bottom'; break;
				case 'equal_spacing_v': $moduleClass[] = 'row-equal_spacing_v'; break;
			}
		}
		if ( $objectAlignH = get_post_meta( $post_id, '__ux_cb_module_group_object_align_h', true ) ) {
			switch ( $objectAlignH ) {
				case 'left': $moduleClass[] = 'row-left'; break;
				case 'center': $moduleClass[] = 'row-center'; break;
				case 'right': $moduleClass[] = 'row-right'; break;
				case 'equal_spacing_h': $moduleClass[] = 'row-equal_spacing_h'; break;
			}
		}
		
		//Force Content to fit Fullwidth
		$fullwidth = get_post_meta( $post_id, '__ux_cb_module_group_fullwidth', true );
		if ( $fullwidth == 'on' ) {
			$moduleClass[] = 'bm-force-full';
		}

		//Hide desktop
		$hideDesktop = get_post_meta( $post_id, '__ux_cb_module_group_hide_desktop', true );
		if ( $hideDesktop === 'on' ) {
			$moduleClass[] = 'hide-Desktop';
		}

		//Hide Mobile
		$hideMobile = get_post_meta( $post_id, '__ux_cb_module_group_hide_mobile', true );
		if ( $hideMobile === 'on' ) {
			$moduleClass[] = 'hidden-mobile';
		}

		//Keep Original Layout on Mobile
		$keepOriginLayoutMobile = get_post_meta( $post_id, '__ux_cb_module_group_keep_origin_on_mobile', true );
		if ( $keepOriginLayoutMobile === 'on' ) {
			$moduleClass[] = 'keep-origin-layout-mobile';
		}
	}
	return $moduleClass;
}
add_filter( 'ux_cb_module_template_frontend_module_class', 'ux_cb_module_group_module_class', 10, 3 );

/**
 * UX Content Builder Module Group module content class.
 */
function ux_cb_module_group_module_content_class( $moduleContentClass, $moduleID, $post_id ) {
	if ( $moduleID == 'group' ) {
		//Object Align
		if ( $objectAlign = get_post_meta( $post_id, '__ux_cb_module_group_object_align', true ) ) {
			switch ( $objectAlign ) {
				case 'top': $moduleContentClass[] = 'row-top'; break;
				case 'middle': $moduleContentClass[] = 'row-middle'; break;
				case 'bottom': $moduleContentClass[] = 'row-bottom'; break;
				case 'equal_spacing_v': $moduleContentClass[] = 'row-equal_spacing_v'; break;
			}
		}
		if ( $objectAlignH = get_post_meta( $post_id, '__ux_cb_module_group_object_align_h', true ) ) {
			switch ( $objectAlignH ) {
				case 'left': $moduleContentClass[] = 'row-left'; break;
				case 'center': $moduleContentClass[] = 'row-center'; break;
				case 'right': $moduleContentClass[] = 'row-right'; break;
				case 'equal_spacing_h': $moduleContentClass[] = 'row-equal_spacing_h'; break;
			}
		}
		
		//Force Content to fit Fullwidth
		$fullwidth = get_post_meta( $post_id, '__ux_cb_module_group_fullwidth', true );
		if ( $fullwidth === 'on' ) {
			$moduleContentClass[] = 'bm-force-full';
		}

	}
	return $moduleContentClass;
}
add_filter( 'ux_cb_module_template_module_content_class', 'ux_cb_module_group_module_content_class', 10, 3 );

/**
 * UX Content Builder Module Group frontend module data tag.
 */
function ux_cb_module_group_module_data_tag( $moduleDataTag, $moduleID, $post_id ) {
	if ( $moduleID == 'group' ) {
		//Change Universe Color when Scroll In
		$frontcolor = 'transparent';
		$backcolor = 'transparent';
		$logocolor = '';
		$fixed = 'off';
		$changeColor = get_post_meta( $post_id, '__ux_cb_module_group_change_color_scroll_in', true );
		if ( $changeColor == 'on' ) {
			$frontcolor = get_post_meta( $post_id, '__ux_cb_module_group_change_frontcolor', true );
			$backcolor = get_post_meta( $post_id, '__ux_cb_module_group_change_backcolor', true );
			$logocolor = get_post_meta( $post_id, '__ux_cb_module_group_change_logocolor', true );
		}
		$moduleDataTag[] = 'data-change-color="' .esc_attr( $changeColor ). '"';
		$moduleDataTag[] = 'data-backcolor="' .esc_attr( $backcolor ). '"';
		$moduleDataTag[] = 'data-frontcolor="' .esc_attr( $frontcolor ). '"';
		$moduleDataTag[] = 'data-logocolor="' .esc_attr( $logocolor ). '"';
		
		//Auto Goto Top When Scroll In
		$gotoTop = get_post_meta( $post_id, '__ux_cb_module_group_auto_goto_top', true );
		$moduleDataTag[] = 'data-goto-top="' .esc_attr( $gotoTop ). '"';
		
		//Top Spacing to The Edge
		$gotoTopSpacing = get_post_meta( $post_id, '__ux_cb_module_group_scroll_top_spacing', true );
		$moduleDataTag[] = 'data-goto-top-spacing="' .esc_attr( $gotoTopSpacing ). '"';

		//Make Groups Contour on The Current Row
		$groupsSameHeight = get_post_meta( $post_id, '__ux_cb_module_group_same_height_current_row', true );
		$moduleDataTag[] = 'data-groupsameheight="' .esc_attr( $groupsSameHeight ). '"';

	}
	return $moduleDataTag;
}
add_filter( 'ux_cb_module_template_frontend_module_data_tag', 'ux_cb_module_group_module_data_tag', 10, 3 );
add_filter( 'ux_cb_module_template_module_data_tag', 'ux_cb_module_group_module_data_tag', 10, 3 );

/**
 * UX Content Builder Module Group module content style.
 */
function ux_cb_module_group_module_content_style( $moduleContentStyle, $moduleID, $post_id ) {
	if ( $moduleID == 'group' ) {
		
		//module group custom height
		$heightStyle = false;
		$spacingForScreenHeight = '';
		
		//Custom height
		$heightCustom = get_post_meta( $post_id, '__ux_cb_module_group_height_type', true );
		// if ( $heightCustom == 'custom' ) {
		// 	$height = intval(get_post_meta( $post_id, '__ux_cb_module_group_custom_height', true ) );
		// 	$height = str_replace( 'px', '', $height );
		// 	$heightStyle = 'min-height: ' .esc_attr($height). 'px; ';
		// } else 
		$spacingForScreenHeight = 0;
		$heightCustomValue = false;
		if( $heightCustom == 'screen_height' ) {
			// if ( $spacingForScreenHeightGet = get_post_meta( $post_id, '__ux_cb_module_group_screen_height_spacing', true ) ) {
			// 	if ( ! is_array( $spacingForScreenHeightGet ) ) { $spacingForScreenHeightGet = array( $spacingForScreenHeightGet, 0 ); }
			// 	$spacingForScreenHeight = intval( $spacingForScreenHeightGet[0] );
			// }
			if ( $heightCustomValueGet = get_post_meta( $post_id, '__ux_cb_module_group_screen_height', true ) ) {
				if ( ! is_array( $heightCustomValueGet ) ) { $heightCustomValueGet = array( $heightCustomValueGet, 0 ); }
				$heightCustomValue = intval( $heightCustomValueGet[0] ).'vh';
			}
			if ( $heightCustomValue ) {
				// if ( $spacingForScreenHeight ) {
				// $spacingForScreenHeight = intval( $spacingForScreenHeight ) * 2;
				// 	$heightStyle = 'min-height: calc('.esc_attr( $heightCustomValue ).' - ' .esc_attr( $spacingForScreenHeight ). 'px);';
				// } else {
					$heightStyle = 'min-height: '.esc_attr( $heightCustomValue ).'; ';
				//}
			}
		}
		$moduleContentStyle[] = esc_attr( $heightStyle );
		
		//module group background color
		$background = get_post_meta( $post_id, '__ux_cb_module_group_background', true );
		if ( $background == 'background_color' ) {
			$bgColor = get_post_meta( $post_id, '__ux_cb_module_group_bg_color', true );
		}
	}
	return $moduleContentStyle;
}
add_filter( 'ux_cb_module_template_module_content_style', 'ux_cb_module_group_module_content_style', 10, 3 );
?>